//=============================================================================
// VisuStella MZ - Battle Core
// VisuMZ_1_BattleCore.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_1_BattleCore = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BattleCore = VisuMZ.BattleCore || {};
VisuMZ.BattleCore.version = 1.82;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 1] [Version 1.82] [BattleCore]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Battle_Core_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 *
 * The Battle Core plugin revamps the battle engine provided by RPG Maker MZ to
 * become more flexible, streamlined, and support a variety of features. The
 * updated battle engine allows for custom Action Sequences, battle layout
 * styles, and a lot of control over the battle mechanics, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * Action Sequence Plugin Commands to give you full control over what happens
 *   during the course of a skill or item.
 * * Animated Sideview Battler support for enemies!
 * * Auto Battle options for party-wide and actor-only instances.
 * * Base Troop Events to quickly streamline events for all Troop events.
 * * Battle Command control to let you change which commands appear for actors.
 * * Battle Layout styles to change the way the battle scene looks.
 * * Casting animation support for skills.
 * * Critical Hit control over the success rate formula and damage multipliers.
 * * Custom target scopes added for skills and items.
 * * Damage formula control, including Damage Styles.
 * * Damage caps, both hard caps and soft caps.
 * * Damage traits such Armor Penetration/Reduction to bypass defenses.
 * * Elements & Status Menu Core support for traits.
 * * Multitude of JavaScript notetags and global Plugin Parameters to let you
 *   make a variety of effects across various instances during battle.
 * * Party Command window can be skipped/disabled entirely.
 * * Weather effects now show in battle.
 * * Streamlined Battle Log to remove redundant information and improve the
 *   flow of battle.
 * * Visual HP Gauges can be displayed above the heads of actors and/or enemies
 *   with a possible requirement for enemies to be defeated at least once first
 *   in order for them to show.
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Tier 1 ------
 *
 * This plugin is a Tier 1 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * Major Changes
 * ============================================================================
 *
 * This plugin will overwrite some core parts of the RPG Maker MZ base code in
 * order to ensure the Battle Core plugin will work at full capacity. The
 * following are explanations of what has been changed.
 *
 * ---
 *
 * Action Sequences
 *
 * - Action sequences are now done either entirely by the Battle Log Window or
 * through common events if the <Custom Action Sequence> notetag is used.
 * In RPG Maker MZ by default, Action Sequences would be a mixture of using the
 * Battle Log Window, the Battle Manager, and the Battle Scene, making it hard
 * to fully grab control of the situation.
 *
 * ---
 *
 * Action Speed
 *
 * - Action speeds determine the turn order in the default battle system. The
 * AGI of a battle unit is also taken into consideration. However, the random
 * variance applied to the action speed system makes the turn order extremely
 * chaotic and hard for the player to determine. Thus, the random variance
 * aspect of it has been turned off. This can be reenabled by default through
 * Plugin Parameters => Mechanics Settings => Allow Random Speed?
 *
 * ---
 *
 * Animated Sideview Battler Support For Enemies
 *
 * - Enemies can now use Sideview Actor sprites for themselves! They will
 * behave like actors and can even carry their own set of weapons for physical
 * attacks. These must be set up using notetags. More information can be found
 * in the notetag section.
 *
 * - As the sprites are normally used for actors, some changes have been made
 * to Sprite_Actor to be able to support both actors and enemies. These changes
 * should have minimal impact on other plugins.
 *
 * ---
 *
 * Battle Sprite Updates
 *
 * - A lot of functions in Sprite_Battler, Sprite_Actor, and Sprite_Enemy have
 * been overwritten to make the new Action Sequence system added by this plugin
 * possible. These changes make it possible for the sprites to move anywhere on
 * the screen, jump, float, change visibility, and more.
 *
 * ---
 *
 * Change Battle Back in Battle
 * 
 * - By default, the Change Battle Back event command does not work in battle.
 * Any settings made to it will only reflect in the following battle. Now, if
 * the battle back event command is used during battle, it will reflect upon
 * any new changes immediately.
 *
 * ---
 *
 * Critical Hit - LUK Influence
 *
 * - The LUK Buffs now affect the critical hit rate based off how the formula
 * is now calculated. Each stack of a LUK Buff will double the critical hit
 * rate and compound upon that. That means a x1 LUK Buff stack will raise it by
 * x2, a x2 LUK Buff stack will raise the critical hit rate by x4, a x3 LUK
 * Buff Stack will raise the critical hit rate stack by x8, and so on.
 *
 * - LUK also plays a role in how much damage is dealt with critical hits. The
 * default critical hit multiplier has been reduced from x3 to x2. However, a
 * percentage of LUK will added on (based off the user's CRI rate) onto the
 * finalized critical damage. If the user's CRI rate is 4%, then 4% of the user
 * LUK value will also be added onto the damage.
 *
 * - This change can be altered through Plugin Parameters => Damage Settings =>
 * Critical Hits => JS: Rate Formula and JS: Damage Formula.
 *
 * ---
 * 
 * Damage Popups
 * 
 * - Damage popups are now formatted with + and - to determine healing and
 * damage. MP Damage will also include "MP" at the back. This is to make it
 * clearer what each colored variant of the damage popup means as well as help
 * color blind players read the on-screen data properly.
 * 
 * - Damage popups have also been rewritten to show all changed aspects instead
 * of just one. Previously with RPG Maker MZ, if an action would deal both HP
 * and MP damage, only one of them would show. Now, everything is separated and
 * both HP and MP changes will at a time.
 * 
 * ---
 * 
 * Dual Wielding
 * 
 * - Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 * animations at once, with the combined ATK of each weapon. It's confusing to
 * look at and does not portray the nature of "Dual Wielding".
 * 
 * - Dual Wielding, or in the case of users adding in third and fourth weapons,
 * Multi Wielding is now changed. Each weapon is displayed individually, each
 * producing its own attack animation, showing each weapon type, and applying
 * only that weapon's ATK, Traits, and related effects. It is no longer a
 * combined effect to display everything at once like RPG Maker MZ default.
 * 
 * - If an actor has multiple weapon slots but some of them are unequipped,
 * then the action will treat the attack as a single attack. There will be no
 * barehanded attack to add on top of it. This is to match RPG Maker MZ's
 * decision to omit a second animation if the same scenario is applied.
 * 
 * ---
 *
 * Force Action
 *
 * - Previously, Forced Actions would interrupt the middle of an event to
 * perform an action. However, with the addition of more flexible Action
 * Sequences, the pre-existing Force Action system would not be able to exist
 * and would require being remade.
 *
 * - Forced Actions now are instead, added to a separate queue from the action
 * battler list. Whenever an action and/or common event is completed, then if
 * there's a Forced Action battler queued, then the Forced Action battler will
 * have its turn. This is the cleanest method available and avoids the most
 * conflicts possible.
 *
 * - This means if you planned to make cinematic sequences with Forced Actions,
 * you will need to account for the queued Force Actions. However, in the case
 * of battle cinematics, we would highly recommend that you use the newly added
 * Action Sequence Plugin Commands instead as those give you more control than
 * any Force Action ever could.
 *
 * ---
 *
 * Random Scope
 *
 * - The skill and item targeting scopes for Random Enemy, 2 Random Enemies,
 * 3 Random Enemies, 4 Random Enemies will now ignore TGR and utilize true
 * randomness.
 *
 * ---
 *
 * Spriteset_Battle Update
 *
 * - The spriteset now has extra containers to separate battlers (actors and
 * enemies), animations, and damage. This is to make actors and enemy battler
 * sprites more efficient to sort (if enabled), so that animations won't
 * interfere with and cover damage sprites, and to make sure damage sprites are
 * unaffected by screen tints in order to ensure the player will always have a
 * clear read on the information relaying sprites.
 *
 * ---
 * 
 * TPB/ATB Active Battle Actor Shifting
 * 
 * - Pressing cancel on the Actor Command Window no longer switches between
 * actors with a full TPB/ATB gauge before reaching the Party Command Window.
 * This is to accomplish a couple of things: 1) reduce the number of button
 * presses to reach the Party Command Window and 2) to prevent motion resets
 * and disrupting action sequences. If this feature is vital to your battle
 * system, we recommend that you do not use this plugin or any of the Battle
 * Core-required plugins.
 * 
 * ---
 *
 * Weather Displayed in Battle
 *
 * - Previously, weather has not been displayed in battle. This means that any
 * weather effects placed on the map do not transfer over to battle and causes
 * a huge disconnect for players. The Battle Core plugin will add weather
 * effects to match the map's weather conditions. Any changes made to weather
 * through event commands midway through battle will also be reflected.
 *
 * ---
 *
 * ============================================================================
 * Base Troops
 * ============================================================================
 *
 * Base Troops can be found, declared, and modified in the Plugin Parameters =>
 * Mechanics Settings => Base Troop ID's. All of the listed Troop ID's here
 * will have their page events replicated and placed under all other troops
 * found in the database.
 *
 * ---
 *
 * This means that if you have an event that runs on Turn 1 of a Base Troop,
 * then for every troop out there, that same event will also run on Turn 1,
 * as well. This is useful for those who wish to customize their battle system
 * further and to reduce the amount of work needed to copy/paste said event
 * pages into every database troop object manually.
 *
 * ---
 *
 * ============================================================================
 * Damage Styles
 * ============================================================================
 *
 * Damage Styles are a new feature added through the Battle Core plugin. When
 * using certain Battle Styles, you can completely ignore typing in the whole
 * damage formula inside the damage formula input box, and instead, insert
 * either a power amount or a multiplier depending on the Damage Style. The
 * plugin will then automatically calculate damage using that value factoring
 * in ATK, DEF, MAT, MDF values.
 *
 * ---
 *
 * Here is a list of the Damage Styles that come with this plugin by default.
 * You can add in your own and even edit them to your liking.
 * Or just remove them if you want.
 *
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Style          Use Formula As   PH/MA Disparity   Stat Scale   Damage Scale
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Standard       Formula          No                Varies       Varies
 * ArmorScaling   Formula          No                Varies       Varies
 * CT             Multiplier       Yes               Low          Normal
 * D4             Multiplier       No                High         Normal
 * DQ             Multiplier       No                Low          Low
 * FF7            Power            Yes               Low          High
 * FF8            Power            Yes               Medium       Normal
 * FF9            Power            Yes               Low          Normal
 * FF10           Power            Yes               Medium       High
 * MK             Multiplier       No                Medium       Low
 * MOBA           Multiplier       No                Medium       Normal
 * PKMN           Power            No                Low          Normal
 *
 * Use the above chart to figure out which Damage Style best fits your game,
 * if you plan on using them.
 *
 * The 'Standard' style is the same as the 'Manual' formula input, except that
 * it allows for the support of <Armor Penetration> and <Armor Reduction>
 * notetags.
 *
 * The 'Armor Scaling' style allows you to type in the base damage calculation
 * without the need to type in any defending modifiers.
 *
 * NOTE: While these are based off the damage formulas found in other games,
 * not all of them are exact replicas. Many of them are adapted for use in
 * RPG Maker MZ since not all RPG's use the same set of parameters and not all
 * external multipliers function the same way as RPG Maker MZ.
 * 
 * ---
 *
 * Style:
 * - This is what the Damage Style is.
 *
 * Use Formula As:
 * - This is what you insert into the formula box.
 * - Formula: Type in the formula for the action just as you would normally.
 * - Multiplier: Type in the multiplier for the action.
 *     Use float values. This means 250% is typed out as 2.50
 * - Power: Type in the power constant for the action.
 *     Use whole numbers. Type in something like 16 for a power constant.
 * 
 * PH/MA Disparity:
 * - Is there a disparity between how Physical Attacks and Magical Attacks
 *   are calculated?
 * - If yes, then physical attacks and magical attacks will have different
 *   formulas used.
 * - If no, then physical attacks and magical attacks will share similar
 *   formulas for how they're calculated.
 *
 * Stat Scale:
 * - How much should stats scale throughout the game?
 * - Low: Keep them under 100 for the best results.
 * - Medium: Numbers work from low to mid 400's for best results.
 * - High: The numbers really shine once they're higher.
 *
 * Damage Scale:
 * - How much does damage vary depending on small parameter changes?
 * - Low: Very little increase from parameter changes.
 * - Normal: Damage scales close to proportionally with parameter changes.
 * - High: Damage can boost itself drastically with parameter changes.
 *
 * ---
 *
 * To determine what kind of parameters are used for the Damage Styles, they
 * will depend on two things: the action's 'Hit Type' (ie Physical Attack,
 * Magical Attack, and Certain Hit) and the action's 'Damage Type' (ie. Damage,
 * Recovery, or Drain).
 *
 * Certain Hit tends to use whichever value is higher: ATK or MAT, and then
 * ignores the target's defense values. Use Certain Hits for 'True Damage'.
 *
 * Use the chart below to figure out everything else:
 * 
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Hit Type      Damage Type   Attacker Parameter   Defender Parameter
 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
 * Physical      Damage        ATK                  DEF
 * Magical       Damage        MAT                  MDF
 * Certain Hit   Damage        Larger (ATK, MAT)    -Ignores-
 * Physical      Recover       DEF                  -Ignores-
 * Magical       Recover       MDF                  -Ignores-
 * Certain Hit   Recover       Larger (ATK, MAT)    -Ignores-
 * Physical      Drain         ATK                  DEF
 * Magical       Drain         MAT                  MDF
 * Certain Hit   Drain         Larger (ATK, MAT)    -Ignores-
 *
 * These can be modified within the Plugin Parameters in the individual
 * Damage Styles themselves.
 *
 * ---
 *
 * Skills and Items can use different Damage Styles from the setting you've
 * selected in the Plugin Parameters. They can be altered to have different
 * Damage Styles through the usage of a notetag:
 *
 * <Damage Style: name>
 *
 * This will use whichever style is found in the Plugin Parameters.
 *
 * If "Manual" is used, then no style will be used and all calculations will be
 * made strictly based off the formula found inside the formula box.
 *
 * ---
 *
 * ============================================================================
 * VisuStella MZ Compatibility
 * ============================================================================
 *
 * While this plugin is compatible with the majority of the VisuStella MZ
 * plugin library, it is not compatible with specific plugins or specific
 * features. This section will highlight the main plugins/features that will
 * not be compatible with this plugin or put focus on how the make certain
 * features compatible.
 *
 * ---
 * 
 * VisuMZ_1_BattleCore
 * 
 * When using Action Sequences, Boost effects for damage, turn extensions,
 * analyze, etc. will not occur for anything other than the Action Sequence:
 * "MECH: Action Effect" in order to maintain controlled effects. However, if
 * you do want to apply bonuses for Boosts, utilize "MECH: Boost Store Data" to
 * store inside a variable how many times Boosts were used. This can be used
 * however which way you want it to as long as it is manageable through events
 * and Common Events.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 * 
 * === HP Gauge-Related Notetags ===
 * 
 * The following notetags allow you to set whether or not HP Gauges can be
 * displayed by enemies regardless of Plugin Parameter settings.
 * 
 * ---
 *
 * <Show HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always show the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * - This does not bypass disabling enemy HP Gauges as a whole.
 * 
 * ---
 *
 * <Hide HP Gauge>
 *
 * - Used for: Enemy Notetags
 * - Will always hide the HP Gauge for the enemy regardless of the defeat
 *   requirement setting.
 * - This does not bypass the player's Options preferences.
 * 
 * ---
 * 
 * <Battle UI Offset: +x, +y>
 * <Battle UI Offset: -x, -y>
 * 
 * <Battle UI Offset X: +x>
 * <Battle UI Offset X: -x>
 * 
 * <Battle UI Offset Y: +y>
 * <Battle UI Offset Y: -y>
 * 
 * - Used for: Actor and Enemy Notetags
 * - Adjusts the offset of HP Gauges and State Icons above the heads of actors
 *   and enemies.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 *
 * === Animation-Related Notetags ===
 *
 * The following notetags allow you to set animations to play at certain
 * instances and/or conditions.
 *
 * ---
 *
 * <Slip Animation: x>
 *
 * - Requires VisuMZ_0_CoreEngine!
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - During the phase at which the user regenerates HP, MP, or TP, this
 *   animation will play as long as the user is alive and visible.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Cast Animation: x>
 *
 * - Used for: Skill Notetags
 * - Plays a battle animation at the start of the skill.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * <Attack Animation: x>
 *
 * - Used for: Enemy Notetags
 * - Gives an enemy an attack animation to play for its basic attack.
 * - Replace 'x' with a number value representing the Animation ID to play.
 *
 * ---
 *
 * === Battleback-Related Notetags ===
 *
 * You can apply these notetags to have some control over the battlebacks that
 * appear in different regions of the map for random or touch encounters.
 *
 * ---
 *
 * <Region x Battleback1: filename>
 * <Region x Battleback2: filename>
 * 
 * - Used for: Map Notetags
 * - If the player starts a battle while standing on 'x' region, then the
 *   'filename' battleback will be used.
 * - Replace 'x' with a number representing the region ID you wish to use.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Castle1.png' will be only inserted
 *   as 'Castle1' without the '.png' at the end.
 * - *NOTE: This will override any specified battleback settings.
 *
 * ---
 *
 * === Battle Command-Related Notetags ===
 *
 * You can use notetags to change how the battle commands of playable
 * characters appear in battle as well as whether or not they can be used.
 *
 * ---
 *
 * <Seal Attack>
 * <Seal Guard>
 * <Seal Item>
 *
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Prevents specific battle commands from being able to be used.
 *
 * ---
 *
 * <Battle Commands>
 *  Attack
 *  Skills
 *  SType: x
 *  SType: name
 *  All Skills
 *  Skill: x
 *  Skill: name
 *  Guard
 *  Item
 *  Party
 *  Escape
 *  Auto Battle
 *  Combat Log
 *  Talk
 *  Weapon Swap
 * </Battle Commands>
 *
 * - Used for: Class Notetags
 * - Changes which commands appear in the Actor Command Window in battle.
 *   If this notetag is not used, then the default commands determined in
 *   Plugin Parameters => Actor Command Window => Command List will be used.
 * - Add/remove/modify entries as needed.
 *
 * - Attack 
 *   - Adds the basic attack command.
 * 
 * - Skills
 *   - Displays all the skill types available to the actor.
 * 
 * - SType: x
 * - Stype: name
 *   - Adds in a specific skill type.
 *   - Replace 'x' with the ID of the skill type.
 *   - Replace 'name' with the name of the skill type (without text codes).
 *
 * - All Skills
 *   - Adds all usable battle skills as individual actions.
 * 
 * - Skill: x
 * - Skill: name
 *   - Adds in a specific skill as a usable action.
 *   - Replace 'x' with the ID of the skill.
 *   - Replace 'name' with the name of the skill.
 * 
 * - Guard
 *   - Adds the basic guard command.
 * 
 * - Item
 *   - Adds the basic item command.
 *
 * - Party
 *   - Requires VisuMZ_2_PartySystem.
 *   - Allows this actor to switch out with a different party member.
 * 
 * - Escape
 *   - Adds the escape command.
 * 
 * - Auto Battle
 *   - Adds the auto battle command.
 * 
 * - Combat Log
 *   - Requires VisuMZ_4_CombatLog.
 *   - Opens up the combat log.
 * 
 * - Talk
 *   - Requires VisuMZ_3_BattleCmdTalk!
 *   - Shows talk command if applicable.
 * 
 * - Weapon Swap
 *   - Requires VisuMZ_2_WeaponSwapSystem.
 *   - Swaps the current weapon.
 *
 * Example:
 *
 * <Battle Commands>
 *  Attack
 *  Skill: Heal
 *  Skills
 *  Guard
 *  Item
 *  Escape
 * </Battle Commands>
 *
 * ---
 *
 * <Command Text: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill name text that appears to something else.
 * - Replace 'x' with the skill's name you want to shown in the Actor Battle
 *   Command window.
 * - Recommended Usage: Shorten skill names that are otherwise too big to fit
 *   inside of the Actor Battle Command window.
 *
 * ---
 *
 * <Command Icon: x>
 *
 * - Used for: Skill Notetags
 * - When a skill is used in a <Battle Commands> notetag set, you can change
 *   the skill icon that appears to something else.
 * - Replace 'x' with the ID of icon you want shown in the Actor Battle Command
 *   window to represent the skill.
 * 
 * ---
 * 
 * <Command Require Learn>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   learned the skill.
 * - Learning the skill is a requirement. Acquiring the skill through traits
 *   does not count as learning the skill.
 * 
 * ---
 * 
 * <Command Require Access>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not by whether the actor has
 *   access to the skill.
 * - Having access to the skill can come through either learning the skill or
 *   temporarily acquiring it through trait objects.
 * 
 * ---
 * 
 * <Command Show Switch: x>
 * 
 * <Command Show All Switches: x,x,x>
 * <Command Show Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be hidden until all
 *   switches are ON. Then, it would be shown.
 * - If 'Any' notetag variant is used, item will be shown if any of the
 *   switches are ON. Otherwise, it would be hidden.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Command Hide Switch: x>
 * 
 * <Command Hide All Switches: x,x,x>
 * <Command Hide Any Switches: x,x,x>
 * 
 * - Used for: Skill Notetags
 * - Determines if a battle command is visible or not through switches.
 * - Replace 'x' with the switch ID to determine the skill's visibility.
 * - If 'All' notetag variant is used, item will be shown until all
 *   switches are ON. Then, it would be hidden.
 * - If 'Any' notetag variant is used, item will be hidden if any of the
 *   switches are ON. Otherwise, it would be shown.
 * - This can be applied to Attack and Guard commands, too.
 * 
 * ---
 * 
 * <Battle Portrait: filename>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" Battle Layout.
 * - Sets the battle portrait image for the actor to 'filename'.
 * - Replace 'filename' with a picture found within your game project's
 *   img/pictures/ folder. Filenames are case sensitive. Leave out the filename
 *   extension from the notetag.
 * - This will override any menu images used for battle only.
 * 
 * ---
 * 
 * <Battle Portrait Offset: +x, +y>
 * <Battle Portrait Offset: -x, -y>
 * 
 * <Battle Portrait Offset X: +x>
 * <Battle Portrait Offset X: -x>
 * 
 * <Battle Portrait Offset Y: +y>
 * <Battle Portrait Offset Y: -y>
 *
 * - Used for: Actor
 * - This is used with the "Portrait" and "Border" Battle Layouts.
 * - Offsets the X and Y coordinates for the battle portrait.
 * - Replace 'x' with a number value that offsets the x coordinate.
 * - Negative x values offset left. Positive x values offset right.
 * - Replace 'y' with a number value that offsets the y coordinate.
 * - Negative y values offset up. Positive x values offset down.
 * 
 * ---
 * 
 * === JavaScript Notetag: Battle Command-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine if skill-based battle commands are visible or hidden.
 * 
 * ---
 * 
 * <JS Command Visible>
 *  code
 *  code
 *  visible = code;
 * </JS Command Visible>
 * 
 * - Used for: Skill Notetags
 * - The 'visible' variable is the final returned variable to determine the
 *   skill's visibility in the Battle Command Window.
 * - Replace 'code' with JavaScript code to determine the skill's visibility in
 *   the Battle Command Window.
 * - The 'user' variable represents the user who will perform the skill.
 * - The 'skill' variable represents the skill to be used.
 * 
 * ---
 *
 * === Targeting-Related Notetags ===
 *
 * The following notetags are related to the targeting aspect of skills and
 * items and may adjust the scope of how certain skills/items work.
 *
 * ---
 *
 * <Always Hit>
 *
 * <Always Hit Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - Causes the action to always hit or to always have a hit rate of exactly
 *   the marked x%.
 * - Replace 'x' with a number value representing the hit success percentage.
 *
 * ---
 *
 * <Repeat Hits: x>
 *
 * - Used for: Skill, Item Notetags
 * - Changes the number of hits the action will produce.
 * - Replace 'x' with a number value representing the number of hits to incur.
 *
 * ---
 *
 * <Target: x Random Any>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - Targets can be both actors and enemies.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Enemies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only enemies.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: x Random Allies>
 *
 * - Used for: Skill, Item Notetags
 * - Makes the skill pick 'x' random targets when used.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Targets are only actors.
 * - Replace 'x' with a number value representing the number of random targets.
 *
 * ---
 *
 * <Target: All Allies But User>
 *
 * - Used for: Skill, Item Notetags
 * - Targets all allies with the exception of the user.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 *
 * ---
 * 
 * <Target: Ally or Enemy>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target allies or enemies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to allies first.
 * - Ignored when used by enemies and will be treated as an ally scope.
 * - Auto-battle actors will also treat this action as an ally scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Target: Enemy or Ally>
 * 
 * - Used for: Skill, Item Notetags
 * - Allows the player to target enemies or allies with the skill/item.
 *   - Keep in mind this does NOT allow you to select dead party members.
 * - This will overwrite the existing database scope and ignore the database's
 *   existing scope in favor of this.
 * - Target selection emphasis will go to enemies first.
 * - Ignored when used by enemies and will be treated as an enemy scope.
 * - Auto-battle actors will also treat this action as an enemy scope.
 * - For certain battle layouts in frontview, this will open the Actor Select
 *   window in order for Touch Input to be able to select actors.
 * 
 * ---
 * 
 * <Single or Multiple Select>
 * 
 * - Used for: Skill, Item Notetags
 * - Requires an original scope that can select individual targets.
 * - This will allow the skill/item to be able to select either single targets
 *   or multiple targets at once.
 *   - In order to select "all enemies", the player must press the "Page Up"
 *     keyboard button or the visual on screen "All Enemies" button.
 *   - In order to select "all allies", the player must press the "Page Down"
 *     keyboard button or the visual on screen "All Allies" button.
 *   - Those wondering why this isn't regulated to a command left or right of
 *     the enemies and actors is because mouse controls and touch controls
 *     would not be able to select all enemies or all allies that way.
 *   - This can NOT be used with single dead ally scopes.
 * - If there is an enemy with Taunt or Provoke, the option to select
 *   "All Enemies" does not become possible.
 * - The enemy AI and Auto-Battle actor AI will NOT make use of the ability to
 *   toggle between single and multiple target scopes. They will only use the
 *   single target versions of these skills.
 * 
 * ---
 * 
 * <Disperse Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause any damage dealt by this skill to be split equally amongst
 *   all targets of the skill including repeats.
 *   - For basic attacks, any damage reduction added attack trait totals will
 *     by reverted.
 * - This does NOT have to be used with <Single or Multiple Select> notetag and
 *   can be used by itself for an "All" scope, making the skill/item deal less
 *   damage if there's more enemies and more damage if there's less enemies.
 * 
 * ---
 * 
 * <Cannot Target User>
 * 
 * - Used for: Skill, Item Notetags
 * - This will cause the action to be unable to select the user as the target.
 * - This is not a targeting scope. Instead, it is used in addition to any
 *   other targeting scopes out there.
 * - When used with "All" scopes, the user is removed from the target pool.
 * - This is also applied outside of battle.
 * - If the user somehow enters the target pool, the user is then replaced by
 *   a random ally found in the party.
 * 
 * ---
 *
 * === JavaScript Notetag: Targeting-Related ===
 *
 * ---
 * 
 * <JS Targets>
 *  code
 *  code
 *  targets = [code];
 * </JS Targets>
 *
 * - Used for: Skill, Item Notetags
 * - The 'targets' variable is an array that is returned to be used as a
 *   container for all the valid action targets.
 * - The 'targets' variable will include the original set of targets determined
 *   by the skill/item's original scale.
 * - If you wish to clear it out, simply do 'targets = []' first.
 * - Replace 'code' with JavaScript code to determine valid targets.
 *
 * ---
 *
 * === Damage-Related Notetags ===
 *
 * ---
 *
 * <Damage Style: name>
 *
 * - Used for: Skill, Item Notetags
 * - Replace 'name' with a Damage Style name to change the way calculations are
 *   made using the damage formula input box.
 * - Names can be found in Plugin Parameters => Damage Settings => Style List
 *
 * ---
 *
 * <Armor Reduction: x>
 * <Armor Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Armor Penetration: x>
 * <Armor Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to physical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Magic Reduction: x>
 * <Magic Reduction: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   reduction properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor reduction properties
 *   when calculating one's own armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat reduction value.
 * - Use the 'x%' notetag variant to determine a percentile reduction value.
 *
 * ---
 *
 * <Magic Penetration: x>
 * <Magic Penetration: x%>
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, sets the current skill/item's armor
 *   penetration properties to 'x' and/or 'x%'.
 * - If used on trait objects, adds 'x' and/or 'x%' armor penetration
 *   properties when calculating a target's armor.
 * - This applies to magical attacks.
 * - Use the 'x' notetag variant to determine a flat penetration value.
 * - Use the 'x%' notetag variant to determine a percentile penetration value.
 *
 * ---
 *
 * <Bypass Damage Cap>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage capped.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage capped.
 *
 * ---
 *
 * <Damage Cap: x>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will declare the hard damage cap to
 *   be the 'x' value.
 * - If used on trait objects, this will raise the affect unit's hard damage
 *   cap to 'x' value. If another trait object has a higher value, use that
 *   value instead.
 *
 * ---
 *
 * <Bypass Soft Damage Cap>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will cause the action to never have
 *   its damage scaled downward to the soft cap.
 * - If used on trait objects, this will cause the affected unit to never have
 *   its damage scaled downward to the soft cap.
 *
 * ---
 *
 * <Soft Damage Cap: +x%>
 * <Soft Damage Cap: -x%>
 *
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - If used on skills and/or items, this will increase/decrease the action's
 *   soft cap by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 * - If used on trait objects, this will raise the affect unit's soft damage
 *   limit by x% where 'x' is a percentage value representing the increment
 *   changed by the hard cap value.
 *
 * ---
 *
 * <Unblockable>
 *
 * - Used for: Skill, Item Notetags
 * - Using "Guard" against this skill will not reduce any damage.
 *
 * ---
 *
 * === Critical-Related Notetags ===
 *
 * The following notetags affect skill and item critical hit rates and the
 * critical damage multiplier.
 *
 * ---
 *
 * <Always Critical>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always land a critical hit regardless of the
 *   user's CRI parameter value.
 *
 * ---
 *
 * <Set Critical Rate: x%>
 *
 * - Used for: Skill, Item Notetags
 * - This skill/item will always have a x% change to land a critical hit
 *   regardless of user's CRI parameter value.
 * - Replace 'x' with a percerntage value representing the success rate.
 *
 * ---
 *
 * <Modify Critical Rate: x%>
 * <Modify Critical Rate: +x%>
 * <Modify Critical Rate: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - Modifies the user's CRI parameter calculation for this skill/item.
 * - The 'x%' notetag variant will multiply the user's CRI parameter value
 *   for this skill/item.
 * - The '+x%' and '-x%' notetag variants will incremenetally increase/decrease
 *   the user's CRI parameter value for this skill/item.
 *
 * ---
 *
 * <Modify Critical Multiplier: x%>
 * <Modify Critical Multiplier: +x%>
 * <Modify Critical Multiplier: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the damage multiplier when a critical hit lands.
 * - The 'x%' notetag variant multiply the multiplier to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the multiplier with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * <Modify Critical Bonus Damage: x%>
 * <Modify Critical Bonus Damage: +x%>
 * <Modify Critical Bonus Damage: -x%>
 *
 * - Used for: Skill, Item Notetags
 * - These notetags determine the bonus damage added when a critical hit lands.
 * - The 'x%' notetag variant multiply the damage to that exact percentage.
 * - The '+x%' and '-x%' notetag variants will change the bonus damage with an
 *   incremenetal rate for this skill/item.
 *
 * ---
 *
 * === JavaScript Notetags: Critical-Related ===
 *
 * The following are notetags made for users with JavaScript knowledge to
 * determine how critical hit-related aspects are calculated.
 *
 * ---
 *
 * <JS Critical Rate>
 *  code
 *  code
 *  rate = code;
 * </JS Critical Rate>
 *
 * - Used for: Skill, Item Notetags
 * - The 'rate' variable is the final returned amount to determine the
 *   critical hit success rate.
 * - Replace 'code' with JavaScript code to determine the final 'rate' to be
 *   returned as the critical hit success rate.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Critical Damage>
 *  code
 *  code
 *  multiplier = code;
 *  bonusDamage = code;
 * </JS Critical Damage>
 *
 * - Used for: Skill, Item Notetags
 * - The 'multiplier' variable is returned later and used as the damage
 *   multiplier used to amplify the critical damage amount.
 * - The 'bonusDamage' variable is returned later and used as extra added
 *   damage for the critical damage amount.
 * - Replace 'code' with JavaScript code to determine how the 'multiplier' and
 *   'bonusDamage' variables are calculated.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 * 
 * === Life Steal-Related Notetags ===
 * 
 * ---
 * 
 * <HP Life Steal: x%>
 * <MP Life Steal: x%>
 * 
 * - Used for: Skill, Item Notetags
 * - Causes this skill/item to have Life Steal properties, allowing the user to
 *   take x% of the HP/MP Damage as recovered HP/MP.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take MP from dealt MP damage.
 * - Replace 'x' with a number representing the percentage of the dealt damage
 *   used as HP/MP recovery.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <HP Life Steal Certain Hit: +x%>
 * <HP Life Steal Physical Hit: +x%>
 * <HP Life Steal Magical Hit: +x%>
 * 
 * <HP Life Steal Certain Hit: -x%>
 * <HP Life Steal Physical Hit: -x%>
 * <HP Life Steal Magical Hit: -x%>
 * 
 * <MP Life Steal Certain Hit: +x%>
 * <MP Life Steal Physical Hit: +x%>
 * <MP Life Steal Magical Hit: +x%>
 * 
 * <MP Life Steal Certain Hit: -x%>
 * <MP Life Steal Physical Hit: -x%>
 * <MP Life Steal Magical Hit: -x%>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - The related battler's various trait properties can have passive life steal
 *   properties that will trigger upon using skills/items with matching hit
 *   types regardless of whether or not the skill/item innately has Life Steal.
 *   - Notetag variants with "Certain Hit" will only trigger from "Certain Hit"
 *     skill and item types. Same with "Physical" and "Magical" variants.
 *   - HP Life Steal can only take HP from dealt HP damage.
 *   - MP Life Steal can only take HP from dealt MP damage.
 * - Replace 'x' with a number representing the additive stacking percentage
 *   boost of the dealt damage used as HP/MP recovery. The effects will stack
 *   additively with other trait objects.
 * - This cannot be used with skills/items with HP Drain/MP Drain. Life Steal
 *   is a different mechanic from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Cancel Life Steal>
 * 
 * <Cancel HP Life Steal>
 * <Cancel MP Life Steal>
 * 
 * - Used for: Skill, Item Notetags
 * - Prevents this skill from allowing Life Steal effects to occur including
 *   the passive life steal calculators from the skill/item user.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Guard Life Steal>
 * 
 * <Guard HP Life Steal>
 * <Guard MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will prevent
 *   the Life Steal effects from taking effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Disarm Life Steal>
 * 
 * <Disarm HP Life Steal>
 * <Disarm MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - Makes the related battler unable to HP/MP Life Steal regardless of the
 *   skill/item and its related properties like equipment.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 * 
 * <Negative Life Steal>
 * 
 * <Negative HP Life Steal>
 * <Negative MP Life Steal>
 * 
 * - Used for: Used for: Actor, Class, Armor, Enemy, State Notetags
 * - If the related battler becomes the target of Life Steal, this will invert
 *   the healing properties of Life Steal, causing the Life Steal user to
 *   instead take HP/MP damage.
 *   - This does NOT heal the target related battler.
 * - This does not prevent skills/items with innate Life Steal from being used.
 *   Only the Life Steal part of the skill/item will have no effect.
 * - This does not affect HP Drain/MP Drain. Life Steal is a different mechanic
 *   from HP Drain/MP Drain.
 * 
 * ---
 *
 * === Action Sequence-Related Notetags ===
 *
 * Action Sequences allow you full control over how a skill and/or item plays
 * through its course. These notetags give you control over various aspects of
 * those Action Sequences. More information is found in the Action Sequences
 * help section.
 *
 * ---
 *
 * <Custom Action Sequence>
 *
 * - Used for: Skill, Item Notetags
 * - Removes all automated Action Sequence parts from the skill.
 * - Everything Action Sequence-related will be done by Common Events.
 * - Insert Common Event(s) into the skill/item's effects list to make use of
 *   the Custom Action Sequences.
 * - This will prevent common events from loading in the Item Scene and Skill
 *   Scene when used outside of battle.
 *
 * ---
 * 
 * <Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - If the Action Sequence Plugin Parameter "Auto Notetag" is enabled, this
 *   plugin will prevent custom action sequences from happening for the skill
 *   or item, and instead, use an Automatic Action Sequence instead.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Bypass Auto Action Sequence>
 * 
 * - Used for: Skill, Item Notetags
 * - This notetag is used for the game devs that have the Action Sequence
 *   Plugin Parameter "Auto Notetag" on for applying <Custom Action Sequence>
 *   to everything.
 * - This will allow items and skills to be able to launch their common
 *   events from the menu scene regardless of the inherent restriction to
 *   prevent action sequence based skills/items with common events from
 *   launching.
 * - Ignore this if you have "Auto Notetag" disabled or set to false. By
 *   default, this setting is set to false. Please be aware of the changes
 *   you've made to your game before using it.
 * 
 * ---
 * 
 * <Common Event: name>
 *
 * - Used for: Skill, Item Notetags
 * - Battle only: calls forth a Common Event of a matching name.
 * - Replace 'name' with the name of a Common Event to call from when this
 *   skill/item is used in battle.
 *   - Remove any \I[x] in the name.
 * - Insert multiple notetags to call multiple Common Events in succession.
 * - This will occur after any Common Event Trait Effects for the skill/item's
 *   database entry.
 * - This is primarily used for users who are reorganizing around their Common
 *   Events and would still like to have their skills/items perform the correct
 *   Action Sequences in case the ID's are different.
 * 
 * ---
 *
 * <Display Icon: x>
 * <Display Text: string>
 *
 * - Used for: Skill, Item Notetags
 * - When displaying the skill/item name in the Action Sequence, determine the
 *   icon and/or text displayed.
 * - Replace 'x' with a number value representing the icon ID to be displayed.
 * - Replace 'string' with a text value representing the displayed name.
 *
 * ---
 * 
 * <Common Event Key: name>
 * <Common Event Keys: name, name, name>
 * 
 * <Common Event Keys>
 *  key
 *  key
 *  key
 * </Common Event Keys>
 * 
 * - Used for: Skill, Item Notetags
 * - Will generate Common Events for the skill/item with a corresponding key.
 * - Replace 'name' with the name of the Common Event's key that you want to
 *   reference. That key will be converted into a Common Event effect for the
 *   skill/item and be treated as an action sequence.
 *   - The notetag variants that use multiple keys will have the keys added in
 *     the order they are listed.
 *   - If keys do not reference any Common Events, no Common Events will be
 *     added for that key.
 * - To mark a Common Event with a key, insert inside a Common Event's name the
 *   [ and ] brackets around the text that will be used as the Common Event's
 *   key text.
 *   - For example, if Common Event's name is "Penta Slash [PENTA]", then the
 *     key used is "PENTA" without the quotes.
 *   - This key could then be referenced by <Common Event Key: PENTA> notetag.
 *   - Do not use commas (,) inside the key text as it will be automatically
 *     removed for the sake of consistency.
 * - This feature is made for make the process of sharing Action Sequences to
 *   become easier without needing to line up Common Event ID's.
 * 
 * ---
 *
 * === Animated Sideview Battler-Related Notetags ===
 *
 * Enemies can use Animated Sideview Actor graphics thanks to this plugin.
 * These notetags give you control over that aspect. Some of these also affect
 * actors in addition to enemies.
 *
 * ---
 *
 * <Sideview Battler: filename>
 *
 * <Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Replaces the enemy's battler graphic with an animated Sideview Actor
 *   graphic found in the img/sv_actors/ folder.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Sideview Battlers>
 *
 * ---
 *
 * <Sideview Anchor: x, y>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets the sprite anchor positions for the sideview sprite.
 * - Replace 'x' and 'y' with numbers depicting where the anchors should be for
 *   the sideview sprite.
 * - By default, the x and y anchors are 0.5 and 1.0.
 *
 * ---
 * 
 * <Sideview Home Offset: +x, +y>
 * <Sideview Home Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, State Notetags
 * - Offsets the sideview actor sprite's home position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * - This notetag will not work if you remove it from the JavaScript code in
 *   Plugin Parameters > Actor > JS:  Home Position
 * 
 * ---
 * 
 * <Sideview Weapon Offset: +x, +y>
 * <Sideview Weapon Offset: -x, -y>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy State Notetags
 * - Offsets the sideview weapon sprite's position by +/-x, +/-y.
 * - Replace 'x' and 'y' with numbers depicting how much to offset each of the
 *   coordinates by. For '0' values, use +0 or -0.
 * 
 * ---
 *
 * <Sideview Show Shadow>
 * <Sideview Hide Shadow>
 *
 * - Used for: Actor, Enemy Notetags
 * - Sets it so the sideview battler's shadow will be visible or hidden.
 *
 * ---
 * 
 * <Sideview Shadow Scale: x%>
 * <Sideview Shadow Scale: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - This affects both the X and Y scale.
 * 
 * ---
 * 
 * <Sideview Shadow Scale X: x%>
 * <Sideview Shadow Scale X: x.y>
 * 
 * <Sideview Shadow Scale Y: x%>
 * <Sideview Shadow Scale Y: x.y>
 * 
 * - Used for: Actor, Enemy Notetags
 * - Adjusts the scaling size of the sideview battler's shadow.
 * - These affect their respective X and Y scales separately.
 * 
 * ---
 *
 * <Sideview Collapse>
 * <Sideview No Collapse>
 *
 * - Used for: Enemy Notetags
 * - Either shows the collapse graphic or does not show the collapse graphic.
 * - Collapse graphic means the enemy will 'fade away' once it's defeated.
 * - No collapse graphic means the enemy's corpse will remain on the screen.
 *
 * ---
 *
 * <Sideview Idle Motion: name>
 *
 * <Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Changes the default idle motion for the enemy.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Idle Motions>
 *  walk: 25
 *  wait: 50
 *  guard
 *  victory
 *  abnormal
 * </Sideview Idle Motions>
 *
 * ---
 *
 * <Sideview Size: width, height>
 *
 * - Used for: Enemy Notetags
 * - When using a sideview battler, its width and height will default to the
 *   setting made in Plugin Parameters => Enemy Settings => Size: Width/Height.
 * - This notetag lets you change that value to something else.
 * - Replace 'width' and 'height' with numbers representing how many pixels
 *   wide/tall the sprite will be treated as.
 * - This does NOT change the image size. This only changes the HITBOX size.
 *
 * ---
 *
 * <Sideview Weapon: weapontype>
 *
 * <Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Give your sideview enemies weapons to use.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Sideview Weapons>
 *
 * ---
 *
 * <traitname Sideview Battler: filename>
 *
 * <traitname Sideview Battlers>
 *  filename: weight
 *  filename: weight
 *  filename: weight
 * </traitname Sideview Battlers>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have a unique appearance.
 * - Replace 'filename' with the filename of the graphic to use. Do not insert
 *   any extensions. This means the file 'Actor1_1.png' will be only inserted
 *   as 'Actor1_1' without the '.png' at the end.
 * - If the multiple notetag vaiant is used, then a random filename is selected
 *   from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'filename'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'filename' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Battlers>
 *  Actor1_1: 25
 *  Actor1_3: 10
 *  Actor1_5
 *  Actor1_7
 * </Male Sideview Battlers>
 *
 * <Female Sideview Battlers>
 *  Actor1_2: 25
 *  Actor1_4: 10
 *  Actor1_6
 *  Actor1_8
 * </Female Sideview Battlers>
 *
 * ---
 *
 * <traitname Sideview Idle Motion: name>
 *
 * <traitname Sideview Idle Motions>
 *  name: weight
 *  name: weight
 *  name: weight
 * </traitname Sideview Idle Motions>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique idle motions.
 * - Replace 'name' with any of the following motion names:
 *   - 'walk', 'wait', 'chant', 'guard', 'damage', 'evade', 'thrust', 'swing',
 *     'missile', 'skill', 'spell', 'item', 'escape', 'victory', 'dying',
 *     'abnormal', 'sleep', 'dead'
 * - If the multiple notetag vaiant is used, then a random motion name is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Jolly Sideview Idle Motions>
 *  wait: 25
 *  victory: 10
 *  walk
 * </Jolly Sideview Idle Motions>
 *
 * <Serious Sideview Idle Motions>
 *  walk: 25
 *  guard: 10
 *  wait
 * </Jolly Sideview Idle Motions>
 *
 * ---
 *
 * <traitname Sideview Weapon: weapontype>
 *
 * <traitname Sideview Weapons>
 *  weapontype: weight
 *  weapontype: weight
 *  weapontype: weight
 * </traitname Sideview Weapons>
 *
 * - Used for: Enemy Notetags
 * - Requires VisuMZ_1_ElementStatusCore
 * - Allows certain Trait Sets to cause battlers to have unique weapons.
 * - Replace 'weapontype' with the name of the weapon type found under the
 *   Database => Types => Weapon Types list (without text codes).
 * - If the multiple notetag vaiant is used, then a random weapon type is
 *   selected from the list upon the enemy's creation.
 * - Replace 'weight' with a number value representing how often the weapontype
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'weapontype' instead.
 * - Add/remove lines as you see fit.
 *
 * Examples:
 *
 * <Male Sideview Weapons>
 *  Dagger: 25
 *  Sword: 25
 *  Axe
 * </Male Sideview Weapons>
 *
 * <Female Sideview Weapons>
 *  Dagger: 25
 *  Spear: 25
 *  Cane
 * </Female Sideview Weapons>
 *
 * ---
 *
 * === Enemy-Related Notetags ===
 *
 * ---
 *
 * <Battler Sprite Cannot Move>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to move, jump, and/or float due to
 *   Action Sequences. Useful for rooted enemies.
 *
 * ---
 * 
 * <Battler Sprite Grounded>
 *
 * - Used for: Enemy Notetags
 * - Prevents the enemy from being able to jumping and/or floating due to
 *   Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * ---
 *
 * <Swap Enemies>
 *  name: weight
 *  name: weight
 *  name: weight
 * </Swap Enemies>
 *
 * - Used for: Enemy Notetags
 * - Causes this enemy database object to function as a randomizer for any of
 *   the listed enemies inside the notetag. When the enemy is loaded into the
 *   battle scene, the enemy is immediately replaced with one of the enemies
 *   listed. The randomization is based off the 'weight' given to each of the
 *   enemy 'names'.
 * - Replace 'name' with the database enemy of the enemy you wish to replace
 *   the enemy with.
 * - Replace 'weight' with a number value representing how often the 'name'
 *   would come up. The higher the weight, the more often. You may omit this
 *   and the colon(:) and just type in the 'name' instead.
 * - Add/remove lines as you see fit.
 *
 * Example:
 *
 * <Swap Enemies>
 *  Bat: 50
 *  Slime: 25
 *  Orc
 *  Minotaur
 * </Swap Enemies>
 *
 * ---
 *
 * === JavaScript Notetags: Mechanics-Related ===
 *
 * These JavaScript notetags allow you to run code at specific instances during
 * battle provided that the unit has that code associated with them in a trait
 * object (actor, class, weapon, armor, enemy, or state). How you use these is
 * entirely up to you and will depend on your ability to understand the code
 * used and driven for each case.
 *
 * ---
 *
 * <JS Pre-Start Battle>
 *  code
 *  code
 *  code
 * </JS Pre-Start Battle>
 *
 * <JS Post-Start Battle>
 *  code
 *  code
 *  code
 * </JS Post-Start Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of battle aimed at the function:
 *   BattleManager.startBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Turn>
 *  code
 *  code
 *  code
 * </JS Pre-Start Turn>
 *
 * <JS Post-Start Turn>
 *  code
 *  code
 *  code
 * </JS Post-Start Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of a turn aimed at the function:
 *   BattleManager.startTurn()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Start Action>
 *  code
 *  code
 *  code
 * </JS Pre-Start Action>
 *
 * <JS Post-Start Action>
 *  code
 *  code
 *  code
 * </JS Post-Start Action>
 * 
 * - Used for: Actor, Class, Skill, Item, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action aimed at the function:
 *   BattleManager.startAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Apply>
 *  code
 *  code
 *  code
 * </JS Pre-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Apply as User>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as User>
 *
 * <JS Pre-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the start of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Pre-Damage>
 *  code
 *  code
 *  code
 * </JS Pre-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Pre-Damage as User>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as User>
 *
 * <JS Pre-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Pre-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code before damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Pre' runs before the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage being calculated up to this
 *   point (if any) and any changes made to the 'value' variable will reflect
 *   on the damage dealt/healed, too.
 *
 * ---
 *
 * <JS Post-Damage>
 *  code
 *  code
 *  code
 * </JS Post-Damage>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Damage as User>
 *  code
 *  code
 *  code
 * </JS Post-Damage as User>
 *
 * <JS Post-Damage as Target>
 *  code
 *  code
 *  code
 * </JS Post-Damage as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code after damage is dealt aimed at the function:
 *   Game_Action.prototype.executeDamage()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 * - The 'value' variable represents the damage/healing that has been last
 *   dealt through this action.
 *
 * ---
 *
 * <JS Post-Apply>
 *  code
 *  code
 *  code
 * </JS Post-Apply>
 * 
 * - Used for: Skill, Item Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on skills and/or items, this will only apply to the skill/item
 *   being used and does not affect other skills and items.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one using the skill/item.
 * - The 'target' variable represents the one receiving the skill/item hit.
 *
 * ---
 *
 * <JS Post-Apply as User>
 *  code
 *  code
 *  code
 * </JS Post-Apply as User>
 *
 * <JS Post-Apply as Target>
 *  code
 *  code
 *  code
 * </JS Post-Apply as Target>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action hit aimed at the function:
 *   Game_Action.prototype.apply()
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - If the 'as User' notetag variant is used, this code will be run as a
 *   response to the action from the action user end.
 * - If the 'as Target' notetag variant is used, this code will be run as a
 *   response to the action from the action target end.
 * - Replace 'code' with JavaScript code to run desired effects.
 *
 * ---
 *
 * <JS Pre-End Action>
 *  code
 *  code
 *  code
 * </JS Pre-End Action>
 *
 * <JS Post-End Action>
 *  code
 *  code
 *  code
 * </JS Post-End Action>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of an action aimed at the function:
 *   BattleManager.endAction()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - If used on trait objects, this will apply to any skills/items used as long
 *   as the unit affected by the trait object has access to the trait object.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Turn>
 *  code
 *  code
 *  code
 * </JS Pre-End Turn>
 *
 * <JS Post-End Turn>
 *  code
 *  code
 *  code
 * </JS Post-End Turn>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code at the end of a turn aimed at the function:
 *   Game_Battler.prototype.onTurnEnd()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-Regenerate>
 *  code
 *  code
 *  code
 * </JS Pre-Regenerate>
 *
 * <JS Post-Regenerate>
 *  code
 *  code
 *  code
 * </JS Post-Regenerate>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a unit regenerates HP/MP aimed at the function:
 *   Game_Battler.prototype.regenerateAll()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Victory>
 *  code
 *  code
 *  code
 * </JS Battle Victory>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is won aimed at the function:
 *   BattleManager.processVictory()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Success>
 *  code
 *  code
 *  code
 * </JS Escape Success>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping succeeds aimed at the function:
 *   BattleManager.onEscapeSuccess()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Escape Failure>
 *  code
 *  code
 *  code
 * </JS Escape Failure>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when escaping fails aimed at the function:
 *   BattleManager.onEscapeFailure()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Battle Defeat>
 *  code
 *  code
 *  code
 * </JS Battle Defeat>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when a battle is lost aimed at the function:
 *   BattleManager.processDefeat()
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 *
 * <JS Pre-End Battle>
 *  code
 *  code
 *  code
 * </JS Pre-End Battle>
 *
 * <JS Post-End Battle>
 *  code
 *  code
 *  code
 * </JS Post-End Battle>
 * 
 * - Used for: Actor, Class, Weapon, Armor, Enemy, State Notetags
 * - Runs JavaScript code when the battle is over aimed at the function:
 *   BattleManager.endBattle()
 *   - 'Pre' runs before the function runs.
 *   - 'Post' runs after the function runs.
 * - Replace 'code' with JavaScript code to run desired effects.
 * - The 'user' variable represents the one affected by the trait object.
 *
 * ---
 * 
 * === Battle Layout-Related Notetags ===
 * 
 * These tags will change the battle layout for a troop regardless of how the
 * plugin parameters are set up normally. Insert these tags in either the
 * noteboxes of maps or the names of troops for them to take effect. If both
 * are present for a specific battle, then priority goes to the setting found
 * in the troop name.
 * 
 * ---
 * 
 * <Layout: type>
 * <Battle Layout: type>
 * 
 * - Used for: Map Notetags, Troop Name Tags, and Troop Comment Tags
 * - Changes the battle layout style used for this specific map or battle.
 * - Replace 'type' with 'default', 'list', 'xp', 'portrait', or 'border'.
 * - Those with VisuMZ_3_FrontviewBattleUI can use 'frontview'.
 * - Those with VisuMZ_3_SideviewBattleUI can use 'sideview'.
 * - If using Troop Comment Tags, then as long as the tag appears in a comment
 *   found on any of the Troop's pages (even if they don't run), the tag will
 *   be considered in effect.
 * 
 * ---
 * 
 * === Troop Size Tags ===
 * 
 * ---
 * 
 * <Extend: x>
 * <Extend: x, x, x>
 * 
 * - Used for: Troop Name Tags and Troop Comment Tags
 * - Adds enemies from another troop to the current troop.
 * - Enemies from another troop will retain their database positions.
 * - Replace 'x' with the ID of the database troop entry you wish to add enemy
 *   members from.
 *   - Insert multiple x's to add from more troops.
 * - Extended troop members will be added in the order they're listed.
 * - Be cautious of how many enemies you add as too many will lag the battle
 *   system. We are not responsible for frame drops due to this.
 * 
 * ---
 * 
 * === Troop Comment Tags ===
 * 
 * Place these tags inside of a comment found in a troop page's event list.
 * 
 * ---
 * 
 * <Once Parallel When Start Battle>
 * 
 * - Used for: Troop Page Comment Tags
 * - Causes the troop page to immediately load the moment the battle scene
 *   begins to fade in (not after it fades in). This is faster than a turn 0
 *   condition troop page. Troop page conditions are ignored.
 * - This can be used for things like the Action Sequence Camera plugin, the
 *   Visual Battle Environment plugin, and/or initial battle poses and such in
 *   order to provide a near seamless battle transition experience.
 * - This does NOT trigger when coming out of the options menu or party menu.
 * - This WILL trigger when going from battle to battle nonstop via plugins
 *   like VisuStella MZ's Chain Battles.
 * - When actors are moving towards their home positions, it will take around
 *   30 frames by default. Use this information however you like.
 * 
 * ---
 *
 * ============================================================================
 * Action Sequence - Plugin Commands
 * ============================================================================
 *
 * Skills and items, when used in battle, have a pre-determined series of
 * actions to display to the player as a means of representing what's going on
 * with the action. For some game devs, this may not be enough and they would
 * like to get more involved with the actions themselves.
 *
 * Action Sequences, added through this plugin, enable this. To give a skill or
 * item a Custom Action Sequence, a couple of steps must be followed:
 *
 * ---
 *
 * 1. Insert the <Custom Action Sequence> notetag into the skill or item's
 *    notebox (or else this would not work as intended).
 * 2. Give that skill/item a Common Event through the Effects box. The selected
 *    Common Event will contain all the Action Sequence data.
 * 3. Create the Common Event with Action Sequence Plugin Commands and/or event
 *    commands to make the skill/item do what you want it to do.
 *
 * ---
 *
 * The Plugin Commands added through the Battle Core plugin focus entirely on
 * Action Sequences. However, despite the fact that they're made for skills and
 * items, some of these Action Sequence Plugin Commands can still be used for
 * regular Troop events and Common Events.
 *
 * ---
 *
 * === Action Sequence - Action Sets ===
 *
 * Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * ---
 *
 * ACSET: Setup Action Set
 * - The generic start to most actions.
 *
 *   Display Action:
 *   Immortal: On:
 *   Battle Step:
 *   Wait For Movement:
 *   Cast Animation:
 *   Wait For Animation:
 *   - Use this part of the action sequence?
 *
 * ---
 *
 * ACSET: All Targets Action Set
 * - Affects all targets simultaneously performing the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 * 
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait For Animation:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Each Target Action Set
 * - Goes through each target one by one to perform the following.
 *
 *   Dual/Multi Wield?
 *   - Add times struck based on weapon quantity equipped?
 *
 *   Perform Action:
 *   Wait Count:
 *   Action Animation:
 *   Wait Count:
 *   Action Effect:
 *   Immortal: Off:
 *   - Use this part of the action sequence?
 *   - Insert values for the Wait Count(s).
 *
 * ---
 *
 * ACSET: Finish Action
 * - The generic ending to most actions.
 *
 *   Wait For New Line:
 *   Wait For Effects:
 *   Clear Battle Log:
 *   Home Reset:
 *   Wait For Movement:
 *   - Use this part of the action sequence?
 *
 * ---
 * 
 * === Action Sequences - Angle ===
 * 
 * These action sequences allow you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * ANGLE: Change Angle
 * - Changes the camera angle.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Angle:
 *   - Change the camera angle to this many degrees.
 *
 *   Duration:
 *   - Duration in frames to change camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Reset Angle
 * - Reset any angle settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera angle.
 *
 *   Angle Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Angle?:
 *   - Wait for angle changes to complete before performing next command?
 *
 * ---
 *
 * ANGLE: Wait For Angle
 * - Waits for angle changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Animations ===
 *
 * These Action Sequences are related to the 'Animations' that can be found in
 * the Animations tab of the Database.
 *
 * ---
 *
 * ANIM: Action Animation
 * - Plays the animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation
 * - Plays the animation associated with the user's weapon.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Attack Animation 2+
 * - Plays the animation associated with the user's other weapons.
 * - Plays nothing if there is no other weapon equipped.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Slot:
 *   - Which weapon slot to get this data from?
 *   - Main-hand weapon is weapon slot 1.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 * 
 * ANIM: Balloon Animation
 * - Plays a balloon animation on target(s).
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Balloon Type:
 *   - What kind of balloon should be played on target(s)?
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Single)
 * - Plays a balloon animation using an icon on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Range)
 * - Plays a balloon animation an icon range on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Starting Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Ending Icon Index:
 *   - Insert the ID of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 * 
 * ANIM: Balloon Icon (Specific)
 * - Plays a balloon animation with specific icons on target(s).
 * - Requires VisuMZ_4_IconBalloons!
 * 
 *   Targets:
 *   - Select unit(s) to play the animation on.
 * 
 *   Icons:
 *   - Insert the ID(s) of the icon to show.
 *   - Tip: Right click > Insert Icon Index
 * 
 *   Wait for Completion:
 *   - Wait for balloon animation completion before continuing?
 * 
 * ---
 *
 * ANIM: Cast Animation
 * - Plays the cast animation associated with the action.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Change Battle Portrait
 * - Changes the battle portrait of the actor (if it's an actor).
 * - Can be used outside of battle/action sequences.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *   - Valid units can only be actors.
 *
 *   Filename:
 *   - Select the file to change the actor's portrait to.
 * 
 * ---
 *
 * ANIM: Guard Animation
 * - Plays the animation associated with the user's guard action (if any).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Item Animation
 * - Plays the animation associated with a specific item.
 * 
 *   Item ID:
 *   - Which item ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Play at Coordinate
 * - Plays an animation on the screen at a specific x, y coordinate.
 * - Requires VisuMZ_0_CoreEngine!
 * 
 *   Animation ID:
 *   - Plays this animation.
 * 
 *   Coordinates:
 * 
 *     X:
 *     Y:
 *     - X/Y coordinate used for the animation.
 *       You may use JavaScript code.
 * 
 *   Mirror Animation?:
 *   - Mirror the animation?
 * 
 *   Mute Animation?:
 *   - Mute the animation?
 * 
 *   Wait for Completion?:
 *   - Wait the animation to finish before continuing?
 *
 * ---
 *
 * ANIM: Show Animation
 * - Plays the a specific animation on unit(s).
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Animation ID:
 *   - Select which animation to play on unit(s).
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Show Animation JS
 * - Plays the a specific animation on unit(s).
 * - Uses JavaScript to determine animation ID.
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   JS: Animation ID:
 *   - Select which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Skill Animation
 * - Plays the animation associated with a specific skill.
 * 
 *   Skill ID:
 *   - Which skill ID will the animation come from?
 *
 *   Targets:
 *   - Select unit(s) to play the animation on.
 *
 *   Mirror Animation:
 *   - Mirror the animation?
 *
 *   Wait For Animation?:
 *   - Wait for animation to complete before performing next command?
 *
 * ---
 *
 * ANIM: Wait For Animation
 * - Causes the interpreter to wait for any animation(s) to finish.
 *
 * ---
 *
 * === Action Sequences - Battle Log ===
 *
 * These Action Sequences are related to the Battle Log Window, the window
 * found at the top of the battle screen.
 *
 * ---
 *
 * BTLOG: Add Text
 * - Adds a new line of text into the Battle Log.
 *
 *   Text:
 *   - Add this text into the Battle Log.
 *   - Text codes allowed.
 * 
 *   Copy to Combat Log?:
 *   - Copies text to the Combat Log.
 *   - Requires VisuMZ_4_CombatLog
 * 
 *     Combat Log Icon:
 *     - What icon would you like to bind to this entry?
 *     - Requires VisuMZ_4_CombatLog
 *
 * ---
 *
 * BTLOG: Clear Battle Log
 * - Clears all the text in the Battle Log.
 *
 * ---
 *
 * BTLOG: Display Action
 * - plays the current action in the Battle Log.
 *
 * ---
 *
 * BTLOG: Pop Base Line
 * - Removes the Battle Log's last added base line and  all text up to its
 *   former location.
 *
 * ---
 *
 * BTLOG: Push Base Line
 * - Adds a new base line to where the Battle Log currently is at.
 *
 * ---
 *
 * BTLOG: Refresh Battle Log
 * - Refreshes the Battle Log.
 *
 * ---
 *
 * BTLOG: UI Show/Hide
 * - Shows or hides the Battle UI (including the Battle Log).
 *
 *   Show/Hide?:
 *   - Shows/hides the Battle UI.
 *
 * ---
 *
 * BTLOG: Wait For Battle Log
 * - Causes the interpreter to wait for the Battle Log to finish.
 *
 * ---
 *
 * BTLOG: Wait For New Line
 * - Causes the interpreter to wait for a new line in the Battle Log.
 *
 * ---
 *
 * === Action Sequences - Camera ===
 *
 * These Action Sequences are battle camera-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * CAMERA: Clamp ON/OFF
 * - Turns battle camera clamping on/off.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Setting:
 *   - Turns camera clamping on/off.
 *
 * ---
 *
 * CAMERA: Focus Point
 * - Focus the battle camera on a certain point in the screen.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   X Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Y Coordinate:
 *   - Insert the point to focus the camera on.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Focus Target(s)
 * - Focus the battle camera on certain battler target(s).
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Targets:
 *   - Select unit(s) to focus the battle camera on.
 *
 *   Duration:
 *   - Duration in frames for camera focus change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Offset
 * - Offset the battle camera from the focus target.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Offset X:
 *   - How much to offset the camera X by.
 *   - Negative: left. Positive: right.
 *
 *   Offset Y:
 *   - How much to offset the camera Y by.
 *   - Negative: up. Positive: down.
 *
 *   Duration:
 *   - Duration in frames for offset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Reset
 * - Reset the battle camera settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Reset Focus?:
 *   - Reset the focus point?
 *
 *   Reset Offset?:
 *   - Reset the camera offset?
 *
 *   Duration:
 *   - Duration in frames for reset change.
 *
 *   Camera Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Camera?
 *   - Wait for camera changes to complete before performing next command?
 *
 * ---
 *
 * CAMERA: Wait For Camera
 * - Waits for camera changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 * 
 * === Action Sequences - Cutins ===
 * 
 * Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Add Visual Cutin Effect
 * - Adds the Visual Cutin Effect using these desired settings.
 * - Only one of each cutin-style type can be present at a time.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Basic Settings:
 * 
 *     Cutin Style Type:
 *     - What Visual Cutin Effect style type do you wish to use?
 *     - Only one of each cutin-style type can be present.
 *     - Refer to VisuMZ wiki for visuals on styles.
 * 
 *     Portrait Target:
 *     - Select unit(s) to grab the Visual Cutin Effect portrait data from.
 *     - First unit will be used to make portrait.
 * 
 *     Parallax Filename:
 *     - Pick a parallax to use for the Visual Cutin Effect.
 *     - Pick (None) to not use a parallax.
 * 
 *     Background Color:
 *     - Use #rrggbb for custom colors or regular numbers for text colors from
 *       the Window Skin.
 *
 *   Extra Settings:
 *   - Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 *   - An explanation for these settings are found in the Visual Cutin Effect
 *     help file and documentation.
 *   - Extra parameters are added for Parallax Scroll Inversion when the target
 *     is an enemy.
 * 
 *   Wait for Entrance:
 *   - Wait until cutin entrance is finished before performing the next
 *     event command?
 * 
 * ---
 *
 * CUTIN: End Visual Cutin Effect (All)
 * - Ends all Visual Cutin Effects currently present.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 *
 * CUTIN: End Visual Cutin Effect (Type)
 * - Ends the Visual Cutin Effect with the matching type.
 * - Requires VisuMZ_3_VisualCutinEffect!
 *
 *   Cutin Style Type:
 *   - What Visual Cutin Effect style type do you wish to end?
 * 
 *   Wait for Exit:
 *   - Wait until cutin exit is finished before performing the next
 *     event command?
 *
 * ---
 * 
 * CUTIN: Wait for Cutin Entrance
 * - Wait until all cutin entrances are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 * 
 * CUTIN: Wait for Cutin Exit
 * - Wait until all cutin exits are finished before performing the next
 *   event command.
 * - Requires VisuMZ_3_VisualCutinEffect!
 * 
 * ---
 *
 * === Action Sequences - Dragonbones ===
 *
 * These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * ---
 *
 * DB: Dragonbones Animation
 * - Causes the unit(s) to play a Dragonbones motion animation.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Motion Animation:
 *   - What is the name of the Dragonbones motion animation you wish to play?
 *
 * ---
 *
 * DB: Dragonbones Time Scale
 * - Causes the unit(s) to change their Dragonbones time scale.
 * - Requires VisuMZ_2_DragonbonesUnion!
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion animation.
 *
 *   Time Scale:
 *   - Change the value of the Dragonbones time scale to this.
 *
 * ---
 *
 * === Action Sequences - Elements ===
 *
 * These Action Sequences can change up the element(s) used for the action's
 * damage calculation midway through an action.
 *
 * They also require the VisuMZ_1_ElementStatusCore plugin to be present in
 * order for them to work.
 *
 * ---
 *
 * ELE: Add Elements
 * - Adds element(s) to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to add onto the action.
 *   - Insert multiple element ID's to add multiple at once.
 *
 * ---
 *
 * ELE: Clear Element Changes
 * - Clears all element changes made through Action Sequences.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 *
 * ELE: Force Elements
 * - Forces only specific element(s) when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 *   Elements:
 *   - Select which element ID to force in the action.
 *   - Insert multiple element ID's to force multiple at once.
 *
 * ---
 *
 * ELE: Null Element
 * - Forces no element to be used when calculating damage.
 * - Requires VisuMZ_1_ElementStatusCore!
 *
 * ---
 * 
 * === Action Sequences - Grid ===
 * 
 * These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * ---
 * 
 * GRID: Action Animation at Node
 * - Plays action animation at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * GRID: Add Passive State(s) to Node
 * - Adds Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to add as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to add the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Passive State(s) to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Passive State(s) to.
 *
 * ---
 * 
 * GRID: Add Trigger to Node
 * - Adds Trigger to target node.
 * - Target node cannot have battler.
 * - Each node can only contain ONE trigger! 
 * - Otherwise, newly placed triggers will overwrite the old ones.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Skill ID:
 *   - Select which Skill ID(s) to add as the trigger.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to add the Trigger Node effect for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to add a
 *       Trigger to.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to add a
 *       Trigger to.
 * 
 * ---
 * 
 * GRID: Animation ID at Node
 * - Plays specific animation ID at target node.
 * 
 *   Animation ID:
 *   - Play this animation at target node.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation JS at Node
 * - Uses JS to calculate which animation to play at target node.
 * 
 *   JS: Animation ID:
 *   - Calculate which animation to play on unit(s).
 *   - Uses JavaScript to determine animation ID.
 * 
 *     Mirror?:
 *     - Mirror this animation?
 * 
 *     Mute?:
 *     - Mute this animation?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Animation Type at Node
 * - Plays certain animation type at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Type:
 *   - What is the animation type you would like to play?
 *     - Attack
 *     - Guard
 *     - Item
 *     - Skill
 * 
 *     Slot (Attack Type):
 *     - Which weapon slot to get this data from?
 *     - Main-hand weapon is weapon slot 1.
 * 
 *     Item ID (Item Type):
 *     - Which item ID will the animation come from?
 * 
 *     Skill ID (Skill Type):
 *     - Which skill ID will the animation come from?
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit's Node do you want to play an animation on?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to play an
 *       animation on.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to play
 *       an animation on.
 * 
 *   Offset X:
 *   - Offsets the animation x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the animation y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 * 
 * GRID: Move Target(s) In Direction
 * - Moves target(s) in a specific direction to other Nodes.
 * - Requires VisuMZ_2_BattleGridSystem!
 * - This will bypass the "once per action" condition used for both the
 *   <rule Move User Node direction: x> & <rule Move Target Node direction: x>
 *   notetags as this is not a notetag effect.
 * 
 *   Targets:
 *   - Select unit(s) to move.
 * 
 *   Movement Type:
 *   - Select the Movement type rulings.
 *   - See VisuMZ_2_BattleGridSystem help file for details.
 * 
 *     Direction:
 *     - Select the movement direction.
 * 
 *     Distance:
 *     - The number of nodes to be moved.
 *     - You may use JavaScript code.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 *   Silent Change?:
 *   - Silent: Discreet changes shown. More apparent later.
 *   - Visual: Instant changes shown.
 * 
 * ---
 * 
 * GRID: Pull To Target Node
 * - Pulls battlers towards target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to pull on?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       pull to.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       pull to.
 * 
 *   Strength:
 *   - Input the strength level of the pull.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 * 
 * GRID: Push From Target Node
 * - Pushes battlers away from target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *
 *     Unit:
 *     - Which unit do you want to push from?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to
 *       push from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to
 *       push from.
 * 
 *   Strength:
 *   - Input the strength level of the push.
 * 
 *   Duration:
 *   - Input the number representing the frames used to move.
 * 
 * ---
 *
 * GRID: Remove All Passive States from Node
 * - Removes all Passive State effects at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to clear the Node for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Passive States from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Passive States from.
 *
 * ---
 *
 * GRID: Remove Passive State(s) from Node
 * - Remove Passive State(s) at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 *
 *   State ID(s):
 *   - Select which State ID(s) to remove as a Passive State.
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 *
 *     Unit:
 *     - Which unit do you want to remove the Passive State Node effect for?
 *
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to remove
 *       a Passive State(s) from.
 *
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to remove
 *       a Passive State(s) from.
 *
 * ---
 * 
 * GRID: Remove Trigger from Node
 * - Removes Trigger at target node.
 * - Requires VisuMZ_2_BattleGridSystem!
 * 
 *   Action-Selected Node?:
 *   - Use Action-Selected Node Coordinates if possible?
 *   - Requires "Empty" or "Any" for <Target: x Grid Node>
 *   - If the no action is in effect or the action doesn't use that target
 *     structure, use the node coordinates below:
 * 
 *     Unit:
 *     - Which unit do you want to clear Triggers for?
 * 
 *     Rank:
 *     - Input the number representing the Rank of the Node you want to clear
 *       Triggers from.
 * 
 *     Flank:
 *     - Input the number representing the Flank of the Node you want to clear
 *       Triggers from.
 * 
 * ---
 * 
 * === Action Sequences - Horror Effects ===
 * 
 * These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 * 
 * ---
 *
 * HORROR: Clear All Filters
 * - Clear all Horror Effects filters on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove Horror Effects for.
 *
 * ---
 *
 * HORROR: Glitch Create
 * - Creates the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Glitch Slices:
 *   - Glitch slices to be used with the target.
 *
 *   Glitch Offset:
 *   - Default offset value.
 *
 *   Glitch Animated?:
 *   - Animate the glitch effect?
 *
 *   Glitch Frequency:
 *   - If animated, how frequent to make the glitch effect?
 *   - Lower = often     Higher = rarer
 *
 *   Glitch Strength:
 *   - If animated, how strong is the glitch effect?
 *   - Lower = weaker     Higher = stronger
 *
 * ---
 *
 * HORROR: Glitch Remove
 * - Removes the glitch effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: Noise Create
 * - Creates the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   Noise Rate:
 *   - Noise rate to be used with the target.
 *
 *   Noise Animated:
 *   - Animate the noise for the target?
 *
 * ---
 *
 * HORROR: Noise Remove
 * - Removes the noise effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 *
 * HORROR: TV Create
 * - Creates the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to create the Horror Effect for.
 *
 *   TV Line Thickness:
 *   - Default TV line thickness
 *   - Lower = thinner     Higher = thicker
 *
 *   TV Corner Size:
 *   - Default TV line corner size
 *   - Lower = smaller     Higher = bigger
 *
 *   TV Animated:
 *   - Animate the TV?
 *
 *   TV Speed:
 *   - Speed used to animate the TV if animated
 *   - Lower = slower     Higher = faster
 *
 * ---
 *
 * HORROR: TV Remove
 * - Removes the TV effect on the target battler(s).
 *
 *   Targets:
 *   - Select unit(s) to remove the Horror Effect for.
 *
 * ---
 * 
 * === Action Sequences - Impact ===
 * 
 * These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * IMPACT: Bizarro Inversion
 * - Swaps blue/red colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Bizarro?:
 *   - Enable Bizarro Inversion effect?
 *
 * ---
 *
 * IMPACT: Color Break
 * - Breaks the colors on the screen before reassembling.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Intensity:
 *   - What is the intensity of the color break effect?
 *
 *   Duration:
 *   - What is the duration of the color break effect?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Desaturation
 * - Desaturates all colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Desaturate?:
 *   - Enable Desaturation effect?
 *
 * ---
 *
 * IMPACT: Motion Blur Screen
 * - Creates a motion blur on the whole screen.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Blur Target(s)
 * - Creates a motion blur on selected target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion blur effects for.
 *
 *   Angle:
 *   - Determine what angle to make the motion blur at.
 *
 *   Intensity Rate:
 *   - This determines intensity rate of the motion blur.
 *   - Use a number between 0 and 1.
 *
 *   Duration:
 *   - How many frames should the motion blur last?
 *   - What do you want to be its duration?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Motion Trail Create
 * - Creates a motion trail effect for the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to create motion trail effects for.
 *
 *   Delay:
 *   - How many frames to delay by when creating a motion trail?
 *   - The higher the delay, the less motion trails there are.
 *
 *   Duration:
 *   - How many frames should the motion trail last?
 *   - What do you want to be its duration?
 *
 *   Hue:
 *   - What do you want to be the hue for the motion trail?
 *
 *   Starting Opacity:
 *   - What starting opacity value do you want for the motion trail?
 *   - Opacity values decrease over time.
 *
 *   Tone:
 *   - What tone do you want for the motion trail?
 *   - Format: [Red, Green, Blue, Gray]
 *
 * ---
 *
 * IMPACT: Motion Trail Remove
 * - Removes the motion trail effect from the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to clear motion trail effects for.
 *
 * ---
 *
 * IMPACT: Negative Inversion
 * - Inverts all the colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Negative?:
 *   - Enable Negative Inversion effect?
 *
 * ---
 *
 * IMPACT: Oversaturation
 * - Oversaturates colors on the battlefield.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Oversaturate?:
 *   - Enable Oversaturation effect?
 *
 * ---
 *
 * IMPACT: Shockwave at Point
 * - Creates a shockwave at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to create a shockwave at?
 *   - You can use JavaScript code.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Each Target(s)
 * - Creates a shockwave at each of the target(s) location(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Shockwave from Target(s) Center
 * - Creates a shockwave from the center of the target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a shockwave from.
 *
 *   Target Location:
 *   - Select which part target group to start a shockwave from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the shockwave X/Y point by.
 *
 *   Amplitude:
 *   - What is the aplitude of the shockwave effect?
 *
 *   Wavelength:
 *   - What is the wavelength of the shockwave effect?
 *
 *   Duration:
 *   - What is the duration of the shockwave?
 *
 * ---
 *
 * IMPACT: Time Scale
 * - Adjust time to go faster or slower!
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Scale:
 *   - Adjusts how fast/slow time goes.
 *   - 1.00 is normal. Lower is slower. Higher is faster.
 *
 * ---
 *
 * IMPACT: Time Stop
 * - Stops time for a set amount of milliseconds.
 * - Requires VisuMZ_3_ActSeqImpact!
 * - Created by Manu Gaming!
 *
 *   Milliseconds:
 *   - How many milliseconds should time stop for?
 *   - 1000 milliseconds = 1 second.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Point
 * - Creates a zoom blur at the designated coordinates.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Point: X:
 *   Point: Y:
 *   - What x/y coordinate do you want to focus the zoom at?
 *   - You can use JavaScript code.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * IMPACT: Zoom Blur at Target(s) Center
 * - Creates a zoom blur at the center of targets.
 * - Requires VisuMZ_3_ActSeqImpact!
 *
 *   Targets:
 *   - Select unit(s) to start a zoom blur from.
 *
 *   Target Location:
 *   - Select which part target group to start a zoom blur from.
 * 
 *     Offset X:
 *     Offset Y:
 *     - How much to offset the zoom blur X/Y point by.
 *
 *   Zoom Strength:
 *   - What is the strength of the zoom effect?
 *   - Use a number between 0 and 1.
 *
 *   Visible Radius:
 *   - How much of a radius should be visible from the center?
 *
 *   Duration:
 *   - What is the duration of the zoom blur?
 *
 *   Easing Type:
 *   - Select which easing type you wish to apply.
 *
 * ---
 *
 * === Action Sequences - Inject ===
 *
 * These Action Sequences are related to injecting sprite animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * ---
 * 
 * INJECT: Animation Begin
 * - Injects and plays a whole spritesheet animation.
 * - The spritesheet animation will play over the battler until it is finished.
 * - The battler's original sprite will be invisible until finished.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to inject the animation on.
 * 
 *   Filename:
 *   - Select the animation spritesheet file.
 *   - Located in the /img/sv_actors/ folder.
 * 
 *     Horizontal Cells:
 *     - How many horizontal cells (or columns) are there?
 * 
 *     Vertical Cells:
 *     - How many vertical cells (or rows) are there?
 * 
 *     Frame Delay:
 *     - How many frames are played inbetween cells?
 * 
 *     Smooth Bitmap?:
 *     - Smooth the spritesheet graphic?
 * 
 *   Offset:
 * 
 *     Offset X:
 *     - Offsets the X position of the injected animation.
 *     - Negative: left. Positive: right.
 * 
 *     Offset Y:
 *     - Offsets the Y position of the injected animation.
 *     - Negative: up. Positive: down.
 * 
 * ---
 * 
 * INJECT: Animation End
 * - Stops and ends any injected animations on target(s).
 * - Any inject animation will be prematurely terminated.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to stop injected animation(s).
 * 
 * ---
 * 
 * INJECT: Animation Pause/Resume
 * - Pauses/resumes any injected animations on target(s).
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 *   Targets:
 *   - Select unit(s) to pause/resume injected animation(s).
 * 
 *   Pause?:
 *   - Pause the injected animation?
 * 
 * ---
 * 
 * INJECT: Wait For Injected Animation
 * - Waits for injected animations to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqImpact!
 * 
 * ---
 *
 * === Action Sequences - Mechanics ===
 *
 * These Action Sequences are related to various mechanics related to the
 * battle system.
 *
 * ---
 *
 * MECH: Action Effect
 * - Causes the unit(s) to take damage/healing from action and incurs any
 *   changes made such as buffs and states.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 * ---
 * 
 * MECH: Active Chain Input Disable
 * - Disables input for Active Chain Skills at this time.
 * - Requires VisuMZ_3_ActiveChainSkills!
 * 
 * ---
 *
 * MECH: Add Buff/Debuff
 * - Adds buff(s)/debuff(s) to unit(s). 
 * - Determine which parameters are affected and their durations.
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s) and/or debuff(s).
 *
 *   Buff Parameters:
 *   - Select which parameter(s) to buff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Debuff Parameters:
 *   - Select which parameter(s) to debuff.
 *   - Insert a parameter multiple times to raise its stacks.
 *
 *   Turns:
 *   - Number of turns to set the parameter(s) buffs to.
 *   - You may use JavaScript code.
 *
 * ---
 *
 * MECH: Add State
 * - Adds state(s) to unit(s).
 *
 *   Targets:
 *   - Select unit(s) to receive the buff(s).
 *
 *   States:
 *   - Select which state ID(s) to add to unit(s).
 *   - Insert multiple state ID's to add multiple at once.
 *
 * ---
 * 
 * MECH: Analyze Weakness
 * - Reveal elemental weakness(es) from target(s).
 * - Requires VisuMZ_3_WeaknessDisplay!
 * 
 *   Targets:
 *   - Select unit(s) to reveal elemental weaknesses for.
 * 
 *   Reveal:
 *   - How many elemental weaknesses do you wish to reveal?
 *   - You may use JavaScript code.
 * 
 * ---
 *
 * MECH: Armor Penetration
 * - Adds an extra layer of defensive penetration/reduction.
 * - You may use JavaScript code for any of these.
 *
 *   Armor/Magic Penetration:
 *
 *     Rate:
 *     - Penetrates an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Penetrates a flat amount of armor by this value.
 *
 *   Armor/Magic Reduction:
 *
 *     Rate:
 *     - Reduces an extra multiplier of armor by this value.
 *
 *     Flat:
 *     - Reduces a flat amount of armor by this value.
 *
 * ---
 * 
 * MECH: ATB Gauge
 * - Alters the ATB/TPB Gauges.
 * - Requires VisuMZ_2_BattleSystemATB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Charging:
 *   
 *     Charge Rate:
 *     - Changes made to the ATB Gauge if it is currently charging.
 * 
 *   Casting:
 *   
 *     Cast Rate:
 *     - Changes made to the ATB Gauge if it is currently casting.
 *   
 *     Interrupt?:
 *     - Interrupt the ATB Gauge if it is currently casting?
 * 
 * ---
 * 
 * MECH: Boost Points Change
 * - Changes Boost Points for target(s).
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Boost Points for.
 * 
 *   Alter Boost Points By:
 *   - Alters the unit(s) Boost Points.
 *   - Positive for gaining points. Negative for losing points.
 * 
 * ---
 * 
 * MECH: Boost Store Data
 * - Stores the number of Boosts used this action inside a variable.
 * - Requires VisuMZ_3_BoostAction!
 * 
 *   Variable ID:
 *   - Which variable do you want to store the data inside?
 * 
 * ---
 * 
 * MECH: Break Shield Change
 * - Changes Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to alter the Break Shields for.
 * 
 *   Alter Break Shields By:
 *   - Alters the unit(s) Break Shields.
 *   - Positive for gaining shields. Negative for losing shields.
 * 
 * ---
 * 
 * MECH: Break Shield Reset
 * - Resets Break Shields for target(s) if not Break Stunned.
 * - Requires VisuMZ_4_BreakShields!
 * 
 *   Targets:
 *   - Select unit(s) to reset the Break Shields for.
 * 
 * ---
 * 
 * MECH: BTB Brave Points
 * - Alters the target(s) Brave Points to an exact value.
 * - Requires VisuMZ_2_BattleSystemBTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the ATB/TPB Gauges for.
 * 
 *   Alter Brave Points By:
 *   - Alters the target(s) Brave Points.
 *   - Positive for gaining BP.
 *   - Negative for losing BP.
 * 
 * ---
 *
 * MECH: Collapse
 * - Causes the unit(s) to perform its collapse animation if the unit(s)
 *   has died.
 *
 *   Targets:
 *   - Select unit(s) to process a death collapse.
 *
 *   Force Death:
 *   - Force death even if the unit has not reached 0 HP?
 *   - This will remove immortality.
 *
 *   Wait For Effect?:
 *   - Wait for the collapse effect to complete before performing next command?
 *
 * ---
 * 
 * MECH: CTB Order
 * - Alters the CTB Turn Order.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Turn Order for.
 * 
 *   Change Order By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: CTB Speed
 * - Alters the CTB Speed.
 * - Requires VisuMZ_2_BattleSystemCTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the CTB Speed for.
 * 
 *   Charge Rate:
 *   - Changes made to the CTB Speed if it is currently charging.
 * 
 *   Cast Rate:
 *   - Changes made to the CTB Speed if it is currently casting.
 * 
 * ---
 * 
 * MECH: Custom Damage Formula
 * - Changes the current action's damage formula to custom.
 * - This will assume the MANUAL damage style.
 * 
 *   Formula:
 *   - Changes the current action's damage formula to custom.
 *   - Use 'default' to revert the damage formula.
 * 
 * ---
 *
 * MECH: Damage Popup
 * - Causes the unit(s) to display the current state of damage received
 *   or healed.
 *
 *   Targets:
 *   - Select unit(s) to prompt a damage popup.
 *
 * ---
 *
 * MECH: Dead Label Jump
 * - If the active battler is dead, jump to a specific label in the
 *   common event.
 *
 *   Jump To Label:
 *   - If the active battler is dead, jump to this specific label in the
 *     common event.
 *
 * ---
 * 
 * MECH: Emulate Attack Effect
 * - Emulate an "Action Effect" but using a the user's attack skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Guard Effect
 * - Emulate an "Action Effect" but using a the user's guard skill instead of
 *   the current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Item Effect
 * - Emulate an "Action Effect" but using a specific item instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Item ID:
 *   - Which item ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Cost
 * - Pick a skill for target(s) to emulate paying the cost of.
 * - Lets you cause characters to perform paying the costs of a specific skill
 *   without needing to actually use them.
 * - This will include Skill Cooldowns and Limited Skill Uses.
 * 
 *   Skill ID:
 *   - Which skill ID will have its cost paid for?
 *   - Use 0 for current action's skill.
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 * ---
 * 
 * MECH: Emulate Skill Effect
 * - Emulate an "Action Effect" but using a specific skill instead of the
 *   current action.
 * - Essentially lets you perform the mechanics of another action without
 *   having to use another action or needing to pay that action's costs.
 * 
 *   Skill ID:
 *   - Which skill ID will be emulated?
 * 
 *   User(s):
 *   - Select unit(s) to perform the action's effects.
 * 
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 * 
 * ---
 *
 * MECH: Enemy Escape
 * - Causes the enemy unit(s) to escape.
 *
 *   Targets:
 *   - Select unit(s) to escape.
 *
 * ---
 *
 * MECH: ETB Energy Count
 * - Alters the subject team's available Energy Count.
 * - Requires VisuMZ_2_BattleSystemETB!
 *
 *   Energy Count:
 *   - Alters the subject team's available Energy Count.
 *   - Positive for gaining energy. Negative for losing energy.
 *
 * ---
 *
 * MECH: FTB Action Count
 * - Alters the subject team's available Action Count.
 * - Requires VisuMZ_2_BattleSystemFTB!
 *
 *   Action Count:
 *   - Alters the subject team's available Action Count.
 *   - Positive for gaining actions. Negative for losing actions.
 *
 * ---
 *
 * MECH: HP, MP, TP
 * - Alters the HP, MP, and TP values for unit(s).
 * - Positive values for healing. Negative values for damage.
 *
 *   Targets:
 *   - Select unit(s) to receive the current action's effects.
 *
 *   HP, MP, TP:
 *
 *     Rate:
 *     - Changes made to the parameter based on rate.
 *     - Positive values for healing. Negative values for damage.
 *
 *     Flat:
 *     - Flat changes made to the parameter.
 *     - Positive values for healing. Negative values for damage.
 *
 *   Damage Popup?:
 *   - Display a damage popup after?
 *
 * ---
 *
 * MECH: Immortal
 * - Changes the immortal flag of targets. If immortal flag is removed and a
 *   unit would die, collapse that unit.
 *
 *   Targets:
 *   - Alter the immortal flag of these groups. If immortal flag is removed and
 *     a unit would die, collapse that unit.
 *
 *   Immortal:
 *   - Turn immortal flag for unit(s) on/off?
 *
 * ---
 *
 * MECH: Multipliers
 * - Changes the multipliers for the current action.
 * - You may use JavaScript code for any of these.
 *
 *   Critical Hit%:
 *
 *     Rate:
 *     - Affects chance to land a critical hit by this multiplier.
 *
 *     Flat:
 *     - Affects chance to land a critical hit by this flat bonus.
 *
 *   Critical Damage
 *
 *     Rate:
 *     - Affects critical damage by this multiplier.
 *
 *     Flat:
 *     - Affects critical damage by this flat bonus.
 *
 *   Damage/Healing
 *
 *     Rate:
 *     - Sets the damage/healing multiplier for current action.
 *
 *     Flat:
 *     - Sets the damage/healing bonus for current action.
 *
 *   Hit Rate
 *
 *     Rate:
 *     - Affects chance to connect attack by this multiplier.
 *
 *     Flat:
 *     - Affects chance to connect attack by this flat bonus.
 *
 * ---
 * 
 * MECH: Once Parallel
 * - Plays a Common Event parallel to the battle event once without repeating
 *   itself when done.
 * 
 *   Common Event ID:
 *   - The ID of the parallel Common Event to play.
 *   - Does NOT repeat itself when finished.
 *   - When exiting battle scene, all Once Parallels are cleared.
 *   - Once Parallels are not retained upon reentering the scene.
 *   - Once Parallels are not stored in memory and cannot be saved.
 * 
 * ---
 * 
 * MECH: OTB Order
 * - Alters the OTB Turn Order. Best used with single targets.
 * - Requires VisuMZ_2_BattleSystemOTB!
 * 
 *   Targets:
 *   - Select unit(s) to alter the OTB Turn Order for.
 * 
 *   Current Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Next Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 *   Follow Turn By:
 *   - Changes turn order for target(s) by this amount.
 *   - Positive increases wait. Negative decreases wait.
 * 
 * ---
 * 
 * MECH: PTB Alter Cost
 * - Alters the action's cost settings.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Override?:
 *   - Overrides any 'permanent' settings for Changeability?
 * 
 *   Alter Changeability:
 *   - Allow the cost type and value to be changeable?
 * 
 *   Alter Cost Type:
 *   - Change the cost type to this scenario.
 *   - Use 'Unchanged' for no changes.
 * 
 *   Alter Cost Value:
 *   - What is the default action cost for this scenario?
 * 
 *   Priority:
 *   - What is this scenario's priority? Scenario outcomes with equal or lower
 *     priorities cannot override types and costs.
 * 
 * ---
 * 
 * MECH: PTB Conversion
 * - Converts full actions into half actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Conversion Count:
 *   - Converts full actions into half actions.
 *   - If not enough, consume half actions.
 * 
 * ---
 * 
 * MECH: PTB Full/Half Action(s)
 * - Alters the subject team's available Full/Half Actions.
 * - Requires VisuMZ_2_BattleSystemPTB!
 * 
 *   Full Actions:
 *   - Alters the subject team's available Full Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 *   Half Actions:
 *   - Alters the subject team's available Half Actions.
 *   - Positive for gaining. Negative for losing.
 * 
 * ---
 *
 * MECH: Remove Buff/Debuff
 * - Removes buff(s)/debuff(s) from unit(s). 
 * - Determine which parameters are removed.
 *
 *   Targets:
 *   - Select unit(s) to have the buff(s) and/or debuff(s) removed.
 *
 *   Buff Parameters:
 *   - Select which buffed parameter(s) to remove.
 *
 *   Debuff Parameters:
 *   - Select which debuffed parameter(s) to remove.
 *
 * ---
 *
 * MECH: Remove State
 * - Remove state(s) from unit(s).
 *
 *   Targets:
 *   - Select unit(s) to have states removed from.
 *
 *   States:
 *   - Select which state ID(s) to remove from unit(s).
 *   - Insert multiple state ID's to remove multiple at once.
 *
 * ---
 * 
 * MECH: State Turns Change By
 * - Changes target(s) state turns by an amount.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns By:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if actor(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: State Turns Change To
 * - Changes target(s) state turns to a specific value.
 * - Requires VisuMZ_1_SkillsStatesCore!
 * 
 *   Targets:
 *   - Select unit(s) to affect state turns for.
 * 
 *   State ID:
 *   - What is the ID of the state you wish to change turns for?
 *   - Only works on states that can have turns.
 * 
 *   Change Turns To:
 *   - How many turns should the state be changed to?
 *   - You may use JavaScript code.
 * 
 *   Auto-Add State?:
 *   - Automatically adds state if target(s) does not have it applied?
 * 
 * ---
 * 
 * MECH: STB Exploit Effect
 * - Utilize the STB Exploitation mechanics!
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Target(s) Exploited?:
 *   - Exploit the below targets?
 * 
 *     Targets:
 *     - Select unit(s) to become exploited.
 * 
 *     Force Exploitation:
 *     - Force the exploited status?
 * 
 *   User Exploiter?:
 *   - Allow the user to become the exploiter?
 * 
 *     Force Exploitation:
 *     - Force the exploiter status?
 * 
 * ---
 * 
 * MECH: STB Extra Action
 * - Adds an extra action for the currently active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Extra Actions:
 *   - How many extra actions should the active battler gain?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: STB Remove Excess Actions
 * - Removes excess actions from the active battler.
 * - Requires VisuMZ_2_BattleSystemSTB!
 * 
 *   Remove Actions:
 *   - How many actions to remove from the active battler?
 *   - You may use JavaScript code.
 * 
 * ---
 * 
 * MECH: Swap Weapon
 * - Causes the unit(s) to swap their weapon for another.
 * - Requires VisuMZ_2_WeaponSwapSystem!
 * 
 *   Targets:
 *   - Select unit(s) to swap weapons for.
 * 
 *   Weapon Type ID:
 *   - Which weapon type to swap to?
 *   - This is NOT the weapon's ID.
 *   - It's the weapon TYPE.
 * 
 * ---
 * 
 * MECH: Text Popup
 * - Causes the unit(s) to display a text popup.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Text:
 *   - What text do you wish to display?
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 * 
 * MECH: Variable Popup
 * - Causes the unit(s) to display a popup using the data stored inside
 *   a variable.
 * 
 *   Targets:
 *   - Select unit(s) to prompt a text popup.
 * 
 *   Variable:
 *   - Get data from which variable to display as a popup?
 * 
 *   Digit Grouping:
 *   - Use digit grouping to separate numbers?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 *   Text Color:
 *   - Use #rrggbb for custom colors or regular numbers for text colors from
 *     the Window Skin.
 * 
 *   Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Flash Duration:
 *   - What is the frame duration of the flash effect?
 * 
 * ---
 *
 * MECH: Wait For Effect
 * - Waits for the effects to complete before performing next command.
 *
 * ---
 *
 * === Action Sequences - Motion ===
 *
 * These Action Sequences allow you the ability to control the motions of
 * sideview sprites.
 *
 * ---
 * 
 * MOTION: Clear Freeze Frame
 * - Clears any freeze frames from the unit(s).
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to clear freeze frames for.
 * 
 * ---
 * 
 * MOTION: Freeze Motion Frame
 * - Forces a freeze frame instantly at the selected motion.
 * - Automatically clears with a new motion.
 * - Only applies to sprite sheets.
 * - Does NOT work with Dragonbones.
 * - Use "DB: Dragonbones Time Scale" instead.
 * 
 *   Targets:
 *   - Select which unit(s) to freeze motions for.
 * 
 *   Motion Type:
 *   - Freeze this motion for the unit(s).
 * 
 *   Frame Index:
 *   - Which frame do you want to freeze the motion on?
 *   - Frame index values start at 0.
 * 
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 * 
 * ---
 *
 * MOTION: Motion Type
 * - Causes the unit(s) to play the selected motion.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 *   Motion Type:
 *   - Play this motion for the unit(s).
 *
 *   Show Weapon?:
 *   - If using 'attack', 'thrust', 'swing', or 'missile', display the
 *     weapon sprite?
 *
 * ---
 *
 * MOTION: Perform Action
 * - Causes the unit(s) to play the proper motion based on the current action.
 *
 *   Targets:
 *   - Select which unit(s) to perform a motion.
 *
 * ---
 *
 * MOTION: Refresh Motion
 * - Cancels any set motions unit(s) has to do and use their most natural
 *   motion at the moment.
 *
 *   Targets:
 *   - Select which unit(s) to refresh their motion state.
 *
 * ---
 *
 * MOTION: Wait By Motion Frame
 * - Creates a wait equal to the number of motion frames passing.
 * - Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 *   Motion Frames to Wait?:
 *   - Each "frame" is equal to the value found in 
 *     Plugin Parameters => Actors => Motion Speed
 *
 * ---
 *
 * === Action Sequences - Movement ===
 *
 * These Action Sequences allow you the ability to control the sprites of
 * actors and enemies in battle.
 *
 * ---
 *
 * MOVE: Battle Step
 * - Causes the unit(s) to move forward past their home position to prepare
 *   for action.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home By Distance
 * - Change unit(s)'s home position by a distance from their current home
 *   position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     change by.
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To JS Coordinates
 * - Change home position(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s)'s new home
 *     position.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Point
 * - Change home position(s) to a target point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Change Home To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to change home position(s) for.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to change home position to.
 *
 *     Target Location:
 *     - Select which part target group to change home position to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total change amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Face Direction
 * - Causes the unit(s) to face forward or backward.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Direction:
 *   - Select which direction to face.
 *
 * ---
 *
 * MOVE: Face JS Coordinates
 * - Causes the unit(s) to face specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to face
 *     towards.
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Point
 * - Causes the unit(s) to face a point on the screen.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change direction.
 *
 *   Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Face Away From?:
 *   - Face away from the point instead?
 *
 * ---
 *
 * MOVE: Face Target(s)
 * - Causes the unit(s) to face other targets on the screen.
 * - Sideview-only!
 *
 *   Targets (facing):
 *   - Select which unit(s) to change direction.
 *
 *   Targets (destination):
 *   - Select which unit(s) for the turning unit(s) to face.
 *
 *   Face Away From?:
 *   - Face away from the unit(s) instead?
 *
 * ---
 *
 * MOVE: Float
 * - Causes the unit(s) to float above the ground.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make float.
 *
 *   Desired Height:
 *   - Vertical distance to float upward.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total float amount.
 *
 *   Float Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Float?:
 *   - Wait for floating to complete before performing next command?
 *
 * ---
 *
 * MOVE: Home Reset
 * - Causes the unit(s) to move back to their home position(s) and face back to
 *   their original direction(s).
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Jump
 * - Causes the unit(s) to jump into the air.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to make jump.
 *
 *   Desired Height:
 *   - Max jump height to go above the ground
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total jump amount.
 *
 *   Wait For Jump?:
 *   - Wait for jumping to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move Distance
 * - Moves unit(s) by a distance from their current position(s).
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Distance Adjustment:
 *   - Makes adjustments to distance values to determine which direction to
 *     move unit(s).
 *     - Normal - No adjustments made
 *     - Horizontal - Actors adjust left, Enemies adjust right
 *     - Vertical - Actors adjust Up, Enemies adjust down
 *     - Both - Applies both Horizontal and Vertical
 *
 *     Distance: X:
 *     - Horizontal distance to move.
 *     - You may use JavaScript code.
 *
 *     Distance: Y:
 *     - Vertical distance to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To JS Coordinates
 * - Moves unit(s) to specified JS Coordinates.
 * - Sideview-only! Uses JavaScript!
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   JS: Coordinates:
 *   - Code used to determine the coordinates for the target(s) to move to.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Point
 * - Moves unit(s) to a designated point on the screen.
 * - Sideview-only! Points based off Graphics.boxWidth/Height.
 *
 *   Targets:
 *   - Select which unit(s) to move.
 *
 *   Destination Point:
 *   - Select which point to face.
 *     - Home
 *     - Center
 *     - Point X, Y
 *       - Replace 'x' and 'y' with coordinates
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Move To Target(s)
 * - Moves unit(s) to another unit(s) on the battle field.
 * - Sideview-only!
 *
 *   Targets (Moving):
 *   - Select which unit(s) to move.
 *
 *   Targets (Destination):
 *   - Select which unit(s) to move to.
 *
 *     Target Location:
 *     - Select which part target group to move to.
 *       - front head
 *       - front center
 *       - front base
 *       - middle head
 *       - middle center
 *       - middle base
 *       - back head
 *       - back center
 *       - back base
 *
 *     Melee Distance:
 *     - The melee distance away from the target location in addition to the
 *       battler's width.
 *
 *   Offset Adjustment:
 *   - Makes adjustments to offset values to determine which direction to
 *     adjust the destination by.
 *
 *     Offset: X:
 *     - Horizontal offset to move.
 *     - You may use JavaScript code.
 *
 *     Offset: Y:
 *     - Vertical offset to move.
 *     - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for total movement amount.
 *
 *   Face Destination?:
 *   - Turn and face the destination?
 *
 *   Movement Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Movement Motion:
 *   - Play this motion for the unit(s).
 *
 *   Wait For Movement?:
 *   - Wait for movement to complete before performing next command?
 *
 * ---
 *
 * MOVE: Opacity
 * - Causes the unit(s) to change opacity.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change opacity.
 *
 *   Desired Opacity:
 *   - Change to this opacity value.
 *   - You may use JavaScript code.
 *
 *   Duration:
 *   - Duration in frames for opacity change.
 *
 *   Opacity Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Opacity?:
 *   - Wait for opacity changes to complete before performing next command?
 *
 * ---
 *
 * MOVE: Scale/Grow/Shrink
 * - Causes the unit(s) to scale, grow, or shrink?.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to change the scale of.
 *
 *   Scale X:
 *   Scale Y:
 *   - What target scale value do you want?
 *   - 1.0 is normal size.
 *
 *   Duration:
 *   - Duration in frames to scale for.
 *
 *   Scale Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Scale?:
 *   - Wait for scaling to complete before performing next command?
 *
 * ---
 *
 * MOVE: Skew/Distort
 * - Causes the unit(s) to skew.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to skew.
 *
 *   Skew X:
 *   Skew Y:
 *   - What variance to skew?
 *   - Use small values for the best results.
 *
 *   Duration:
 *   - Duration in frames to skew for.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew to complete before performing next command?
 *
 * ---
 *
 * MOVE: Spin/Rotate
 * - Causes the unit(s) to spin.
 * - Sideview-only!
 *
 *   Targets:
 *   - Select which unit(s) to spin.
 *
 *   Angle:
 *   - How many degrees to spin?
 *
 *   Duration:
 *   - Duration in frames to spin for.
 *
 *   Spin Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 * 
 *   Revert Angle on Finish:
 *   - Upon finishing the spin, revert the angle back to 0.
 *
 *   Wait For Spin?:
 *   - Wait for spin to complete before performing next command?
 *
 * ---
 *
 * MOVE: Wait For Float
 * - Waits for floating to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Jump
 * - Waits for jumping to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Movement
 * - Waits for movement to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Opacity
 * - Waits for opacity changes to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Scale
 * - Waits for scaling to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Skew
 * - Waits for skewing to complete before performing next command.
 *
 * ---
 *
 * MOVE: Wait For Spin
 * - Waits for spinning to complete before performing next command.
 *
 * ---
 * 
 * === Action Sequences - Projectiles ===
 * 
 * Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * ---
 *
 * PROJECTILE: Animation
 * - Create an animation projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Animation ID:
 *     - Determine which animation to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 * 
 *     Wait For Animation?:
 *     - Wait for animation to finish before going to the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Icon
 * - Create an icon projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Icon:
 *     - Determine which icon to use as a projectile.
 *       - You may use JavaScript code.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 *
 * PROJECTILE: Picture
 * - Create a picture projectile and fire it at a target.
 * - Requires VisuMZ_3_ActSeqProjectiles!
 *
 *   Coordinates:
 *
 *     Start Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should start from.
 *         - Target - Start from battler target(s)
 *         - Point - Start from a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) to start the projectile from.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile from.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to start the projectile at.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *     Goal Location:
 *     - Settings to determine where the projectile(s) start from.
 *
 *       Type:
 *       - Select where the projectile should go to.
 *         - Target - Goal is battler target(s)
 *         - Point - Goal is a point on the screen
 *
 *         Target(s):
 *         - Select which unit(s) for projectile to go to.
 *
 *           Centralize:
 *           - Create one projectile at the center of the targets?
 *           - Or create a projectile for each target?
 * 
 *           Target Location:
 *           - Select which part of the target to send the projectile to.
 *           - front head
 *           - front center
 *           - front base
 *           - middle head
 *           - middle center
 *           - middle base
 *           - back head
 *           - back center
 *           - back base
 *
 *         Point X:
 *         Point Y:
 *         - Insert the X/Y coordinate to send the projectile to.
 *         - You may use JavaScript code.
 *
 *       Offset X:
 *       Offset Y:
 *       - Insert how many pixels to offset the X/Y coordinate by.
 *       - You may use JavaScript code.
 *
 *   Settings:
 *
 *     Picture Filename:
 *     - Determine which picture to use as a projectile.
 *
 *     Duration:
 *     - Duration for the projectile(s) to travel.
 *
 *     Wait For Projectile?:
 *     - Wait for projectile(s) to reach their destination before going onto
 *       the next command?
 *
 *     Extra Settings:
 *     - Add extra settings to the projectile?
 *
 *       Auto Angle?:
 *       - Automatically angle the projectile to tilt the direction
 *         it's moving?
 *
 *       Angle Offset:
 *       - Alter the projectile's tilt by this many degrees.
 *
 *       Arc Peak:
 *       - This is the height of the projectile's trajectory arc in pixels.
 *
 *       Blend Mode:
 *       - What kind of blend mode do you wish to apply to the projectile?
 *         - Normal
 *         - Additive
 *         - Multiply
 *         - Screen
 *
 *       Easing:
 *       - Select which easing type to apply to the projectile's trajectory.
 *
 *       Hue:
 *       - Adjust the hue of the projectile.
 *       - Insert a number between 0 and 360.
 *
 *       Scale:
 *       - Adjust the size scaling of the projectile.
 *       - Use decimals for exact control.
 *
 *       Spin Speed:
 *       - Determine how much angle the projectile spins per frame.
 *       - Does not work well with "Auto Angle".
 * 
 *     Effect Emulation:
 * 
 *       Action Effect?:
 *       - Emulate current Action Effect when projectile reaches target?
 *       - Only works with start and goal targets.
 * 
 *       Item Effect ID?:
 *       - Emulate an Item Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Skill Effect ID?:
 *       - Emulate a Skill Effect when projectile reaches target?
 *       - Use 0 to not use.
 *       - Only works with start and goal targets.
 * 
 *       Common Event ID:
 *       - Plays a Once Parallel Common Event upon reaching target.
 *       - Use 0 to not use.
 *       - Works regardless of start/goal targets.
 *
 * ---
 * 
 * === Action Sequences - Skew ===
 * 
 * These action sequences allow you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * ---
 *
 * SKEW: Change Skew
 * - Changes the camera skew.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Skew X:
 *   - Change the camera skew X to this value.
 *
 *   Skew Y:
 *   - Change the camera skew Y to this value.
 *
 *   Duration:
 *   - Duration in frames to change camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Reset Skew
 * - Reset any skew settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset camera skew.
 *
 *   Skew Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Skew?:
 *   - Wait for skew changes to complete before performing next command?
 *
 * ---
 *
 * SKEW: Wait For Skew
 * - Waits for skew changes to complete before performing next command.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * === Action Sequences - Target ===
 *
 * If using a manual target by target Action Sequence, these commands will give
 * you full control over its usage.
 *
 * ---
 *
 * TARGET: Current Index
 * - Sets the current index to this value.
 * - Then decide to jump to a label (optional).
 *
 *   Set Index To:
 *   - Sets current targeting index to this value.
 *   - 0 is the starting index of a target group.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Next Target
 * - Moves index forward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Previous Target
 * - Moves index backward by 1 to select a new current target.
 * - Then decide to jump to a label (optional).
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 *
 * TARGET: Random Target
 * - Sets index randomly to determine new currernt target.
 * - Then decide to jump to a label (optional).
 *
 *   Force Random?:
 *   - Index cannot be its previous index amount after random.
 *
 *   Jump To Label:
 *   - If a target is found after the index change, jump to this label in the
 *     Common Event.
 *
 * ---
 * 
 * === Action Sequences - Voice ==
 * 
 * ---
 *
 * VOICE: Common Line
 * - Plays a common voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line:
 *   - What voice line do you wish to play?
 *
 * ---
 *
 * VOICE: Play Special Line
 * - Plays a special voice line from target battler(s).
 * - Requires VisuMZ_3_BattleVoices!
 *
 *   Speaker Target(s):
 *   - Select unit(s) to play voice lines from.
 *
 *   Voice Line Type:
 *   - What voice line type do you wish to play?
 *     - Action Name
 *     - Chant Line
 *     - Item Name
 *     - Skill Name
 *     - Spell Name
 *     - Unique Lines
 *
 *   Name / Letter:
 *   - What voice letter/name do you want to play?
 *
 * ---
 *
 * === Action Sequences - Weapon ===
 *
 * Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * ---
 *
 * WEAPON: Clear Weapon Slot
 * - Clears the active weapon slot (making others valid again).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to clear the active weapon slot for.
 *
 * ---
 *
 * WEAPON: Next Weapon Slot
 * - Goes to next active weapon slot (making others invalid).
 * - If next slot is weaponless, don't label jump.
 *
 *   Targets:
 *   - Select unit(s) to change the next active weapon slot for.
 *
 * ---
 *
 * WEAPON: Set Weapon Slot
 * - Sets the active weapon slot (making others invalid).
 * - Only works for Actors.
 *
 *   Targets:
 *   - Select unit(s) to change the active weapon slot for.
 *
 *   Weapon Slot ID:
 *   - Select weapon slot to make active (making others invalid).
 *   - Use 0 to clear and normalize. You may use JavaScript code.
 *
 * ---
 *
 * === Action Sequences - Zoom ===
 *
 * These Action Sequences are zoom-related.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ZOOM: Change Scale
 * - Changes the zoom scale.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Scale:
 *   - The zoom scale to change to.
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Reset Zoom
 * - Reset any zoom settings.
 * - Requires VisuMZ_3_ActSeqCamera!
 *
 *   Duration:
 *   - Duration in frames to reset battle zoom.
 *
 *   Zoom Easing:
 *   - Select which easing type you wish to apply.
 *   - Requires VisuMZ_0_CoreEngine.
 *
 *   Wait For Zoom?
 *   - Wait for zoom changes to complete before performing next command?
 *
 * ---
 *
 * ZOOM: Wait For Zoom
 * - Waits for zoom changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Auto Battle Settings
 * ============================================================================
 *
 * These Plugin Parameter settings allow you to change the aspects added by
 * this plugin that support Auto Battle and the Auto Battle commands.
 *
 * Auto Battle commands can be added to the Party Command Window and/or Actor
 * Command Window. The one used by the Party Command Window will cause the
 * whole party to enter an Auto Battle state until stopped by a button input.
 * The command used by the Actor Command Window, however, will cause the actor
 * to select an action based off the Auto Battle A.I. once for the current turn
 * instead.
 *
 * ---
 *
 * Battle Display
 * 
 *   Message:
 *   - Message that's displayed when Auto Battle is on.
 *     Text codes allowed. %1 - OK button, %2 - Cancel button
 * 
 *   OK Button:
 *   - Text used to represent the OK button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Cancel Button:
 *   - Text used to represent the Cancel button.
 *   - If VisuMZ_0_CoreEngine is present, ignore this.
 * 
 *   Background Type:
 *   - Select background type for Auto Battle window.
 *     - 0 - Window
 *     - 1 - Dim
 *     - 2 - Transparent
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for this window.
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the Auto Battle options to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Startup Name:
 *   - Command name of the option.
 * 
 *   Style Name:
 *   - Command name of the option.
 * 
 *   OFF:
 *   - Text displayed when Auto Battle Style is OFF.
 * 
 *   ON:
 *   - Text displayed when Auto Battle Style is ON.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Damage Settings
 * ============================================================================
 *
 * These Plugin Parameters add a variety of things to how damage is handled in
 * battle. These range from hard damage caps to soft damage caps to how damage
 * popups appear, how the formulas for various aspects are handled and more.
 *
 * Damage Styles are also a feature added through this plugin. More information
 * can be found in the help section above labeled 'Damage Styles'.
 *
 * ---
 *
 * Damage Styles
 * 
 *   Default Style:
 *   - Which Damage Style do you want to set as default?
 *   - Use 'Manual' to not use any styles at all.
 *     - The 'Manual' style will not support <Armor Penetration> notetags.
 *     - The 'Manual' style will not support <Armor Reduction> notetags.
 * 
 *   Style List:
 *   - A list of the damage styles available.
 *   - These are used to calculate base damage.
 * 
 *     Name:
 *     - Name of this Damage Style.
 *     -Used for notetags and such.
 * 
 *     JS: Formula:
 *     - The base formula for this Damage Style.
 * 
 *     Items & Equips Core:
 * 
 *       HP Damage:
 *       MP Damage:
 *       HP Recovery:
 *       MP Recovery:
 *       HP Drain:
 *       MP Drain:
 *       - Vocabulary used for this data entry.
 * 
 *       JS: Damage Display:
 *       - Code used the data displayed for this category.
 *
 * ---
 *
 * Damage Cap
 * 
 *   Enable Damage Cap?:
 *   - Put a maximum hard damage cap on how far damage can go?
 *   - This can be broken through the usage of notetags.
 * 
 *   Default Hard Cap:
 *   - The default hard damage cap used before applying damage.
 * 
 *   Enable Soft Cap?:
 *   - Soft caps ease in the damage values leading up to the  hard damage cap.
 *   - Requires hard Damage Cap enabled.
 * 
 *     Base Soft Cap Rate:
 *     - The default soft damage cap used before applying damage.
 * 
 *     Soft Scale Constant:
 *     - The default soft damage cap used before applying damage.
 *
 * ---
 *
 * Popups
 * 
 *   Popup Duration:
 *   - Adjusts how many frames a popup stays visible.
 * 
 *   Newest Popups Bottom:
 *   - Puts the newest popups at the bottom.
 * 
 *   End Battle Show?:
 *   - Show or hide popups upon victory or escape?
 *   - Used to hide battle-state removal popups.
 * 
 *   Offset X:
 *   Offset Y:
 *   - Sets how much to offset the sprites by horizontally/vertically.
 * 
 *   Shift X:
 *   Shift Y:
 *   - Sets how much to shift the sprites by horizontally/vertically.
 * 
 *   Shift Y:
 * 
 *   Critical Flash Color:
 *   - Adjust the popup's flash color.
 *   - Format: [red, green, blue, alpha]
 * 
 *   Critical Duration:
 *   - Adjusts how many frames a the flash lasts.
 *
 * ---
 *
 * Formulas
 * 
 *   JS: Overall Formula:
 *   - The overall formula used when calculating damage.
 * 
 *   JS: Variance Formula:
 *   - The formula used when damage variance.
 * 
 *   JS: Guard Formula:
 *   - The formula used when damage is guarded.
 *
 * ---
 *
 * Critical Hits
 * 
 *   JS: Rate Formula:
 *   - The formula used to calculate Critical Hit Rates.
 * 
 *   JS: Damage Formula:
 *   - The formula used to calculate Critical Hit Damage modification.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Mechanics Settings
 * ============================================================================
 *
 * Some of the base settings for the various mechanics found in the battle
 * system can be altered here in these Plugin Parameters. Most of these will
 * involve JavaScript code and require you to have to good understanding of
 * how the RPG Maker MZ code works before tampering with it.
 *
 * ---
 *
 * Action Speed
 * 
 *   Allow Random Speed?:
 *   - Allow speed to be randomized base off the user's AGI?
 * 
 *   Turn End Buffs Expire?:
 *   - Normally, buffs expire after all actions end.
 *   - But here, you can have buffs expire on turn end.
 * 
 *   JS: Calculate:
 *   - Code used to calculate action speed.
 *
 * ---
 *
 * Base Troop
 * 
 *   Base Troop ID's:
 *   - Select the Troop ID(s) to duplicate page events from for all
 *     other troops.
 *   - More information can be found in the dedicated Help section above.
 *
 * ---
 * 
 * Common Events (on Map)
 * 
 *   Pre-Battle Event:
 *   Post-Battle Event:
 *   Victory Event:
 *   Defeat Event:
 *   Escape Success Event:
 *   Escape Fail Event:
 *   - Queued Common Event to run upon meeting the condition.
 *   - Use to 0 to not run any Common Event at all.
 *   - "Post-Battle Event" will always run regardless.
 *   - If any events are running before the battle, they will continue running
 *     to the end first before the queued Common Events will run.
 *   - These common events only run on the map scene. They're not meant to run
 *     in the battle scene.
 *   - If the "Defeat Event" has a common event attached to it, then random
 *     encounters will be changed to allow defeat without being sent to the
 *     Game Over scene. Instead, the game will send the player to the map scene
 *     where the Defeat Event will run.
 *
 * ---
 *
 * Escape
 * 
 *   JS: Calc Escape Ratio:
 *   - Code used to calculate the escape success ratio.
 * 
 *   JS: Calc Escape Raise:
 *   - Code used to calculate how much the escape success ratio raises upon
 *     each failure.
 * 
 * ---
 * 
 * Switches
 * 
 *   Switch: Critical:
 *   - Turns switch ON if the action performs a critical hit.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit lands a critical
 *     hit, then the switch will remain ON for the rest of the action.
 * 
 *   Switch: Miss/Evade:
 *   - Turns switch ON if the action misses/is evaded.
 *   - Switch reverts to OFF whenever an action starts.
 *   - If multiple targets/hits are struck, as long as one hit fails to land,
 *     then the switch will remain ON for the rest of the action.
 * 
 * ---
 * 
 * Variables
 * 
 *   Variable: Damage:
 *   - Variable records target damage during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of damage done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 *   Variable: Healing:
 *   - Variable records target healing during action.
 *   - Variable reverts to 0 whenever an action starts.
 *   - If multiple targets/hits are struck, the variable will record the total
 *     amount of healing done for the remainder of the action (unless manually
 *     reseting to 0 during an Action Sequence).
 * 
 * ---
 *
 * JS: Battle-Related
 * 
 *   JS: Pre-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Battle:
 *   - Target function: BattleManager.startBattle()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Battle Victory:
 *   - Target function: BattleManager.processVictory()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Success:
 *   - Target function: BattleManager.onEscapeSuccess()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Escape Failure:
 *   - Target function: BattleManager.onEscapeFailure()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Battle Defeat:
 *   - Target function: BattleManager.processDefeat()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Battle:
 *   - Target function: BattleManager.endBattle()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Turn-Related
 * 
 *   JS: Pre-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Turn:
 *   - Target function: BattleManager.startTurn()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Turn:
 *   - Target function: Game_Battler.prototype.onTurnEnd()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Regenerate:
 *   - Target function: Game_Battler.prototype.regenerateAll()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * JS: Action-Related
 * 
 *   JS: Pre-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Start Action:
 *   - Target function: BattleManager.startAction()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Pre-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-Damage:
 *   - Target function: Game_Action.prototype.executeDamage()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Post-Apply:
 *   - Target function: Game_Action.prototype.apply()
 *   - JavaScript code occurs after function is run.
 * 
 *   JS: Pre-End Action:
 *   - Target function: BattleManager.endAction()
 *   - JavaScript code occurs before function is run.
 * 
 *   JS: Post-End Action:
 *   - DescriTarget function: BattleManager.endAction()
 *   - JavaScript code occurs after function is run.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Layout Settings
 * ============================================================================
 *
 * The Battle Layout Settings Plugin Parameter gives you control over the look,
 * style, and appearance of certain UI elements. These range from the way the
 * Battle Status Window presents its information to the way certain windows
 * like the Party Command Window and Actor Command Window appear.
 *
 * ---
 *
 * Battle Layout Style
 * - The style used for the battle layout.
 * 
 *   Default:
 *   - Shows actor faces in Battle Status.
 * 
 *   List:
 *   - Lists actors in Battle Status.
 * 
 *   XP:
 *   - Shows actor battlers in a stretched Battle Status.
 * 
 *   Portrait:
 *   - Shows portraits in a stretched Battle Status.
 * 
 *   Border:
 *   - Displays windows around the screen border.
 *
 * ---
 *
 * List Style
 * 
 *   Show Faces:
 *   - Shows faces in List Style?
 * 
 *   Command Window Width:
 *   - Determine the window width for the Party and Actor Command Windows.
 *   - Affects Default and List Battle Layout styles.
 *
 * ---
 *
 * XP Style
 * 
 *   Command Lines:
 *   - Number of action lines in the Actor Command Window for the XP Style.
 * 
 *   Sprite Height:
 *   - Default sprite height used when if the sprite's height has not been
 *     determined yet.
 * 
 *   Sprite Base Location:
 *   - Determine where the sprite is located on the Battle Status Window.
 *     - Above Name - Sprite is located above the name.
 *     - Bottom - Sprite is located at the bottom of the window.
 *     - Centered - Sprite is centered in the window.
 *     - Top - Sprite is located at the top of the window.
 *
 * ---
 *
 * Portrait Style
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait instead of a face.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Border Style
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 * 
 *   Show Portraits?:
 *   - Requires VisuMZ_1_MainMenuCore.
 *   - Shows the actor's portrait at the edge of the screen.
 * 
 *   Portrait Scaling:
 *   - If portraits are used, scale them by this much.
 *
 * ---
 *
 * Skill & Item Windows
 * 
 *   Middle Layout:
 *   - Shows the Skill & Item Windows in mid-screen?
 * 
 *   Columns:
 *   - The total number of columns for Skill & Item Windows in the battle scene
 *
 * ---
 * 
 * Status Window Elements
 * 
 *   Battler Name:
 *   Gauge 1 (HP):
 *   Gauge 2 (MP):
 *   Gauge 3 (TP):
 *   State Icon:
 *   TPB/ATB Gauge:
 * 
 *     Offset: X/Y:
 *     - Offset this Battle Status Window element's X/Y.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Window Skin:
 * 
 *     Filename:
 *     - Filename used for the Battle Status Window skin.
 *     - Leave this empty to use the default window skin.
 * 
 *     Hide Window Skin?:
 *     - Hide the window skin for the Battle Status Window?
 * 
 *   Selectable Background:
 * 
 *     Hide Selectable BG?:
 *     - Show/Hide the selectable background box for the Battle Status Window?
 * 
 *   Attachments:
 * 
 *     Back Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the back of the Battle
 *         Status Window. Leave empty for none.
 * 
 *       Offset: X/Y:
 *       - Offset this Battle Status Window element's X/Y.
 *       - For X: Negative goes left. Positive goes right.
 *       - For Y: Negative goes up. Positive goes down.
 * 
 *     Front Attachment:
 * 
 *       Filename:
 *       - Filename used for an image to attach to the front of the Battle
 *         Status Window. Leave empty for none.
 * 
 * ---
 * 
 * UI Elements
 * 
 *   Anti-Tint UI?
 *   - Prevent UI Elements from being tinted?
 *   - This prevents UI Elements such as HP Gauges, Enemy Names, Battle Cursor,
 *     and Weakness Display from being affected by screen tint.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battle Log Settings
 * ============================================================================
 *
 * These Plugin Parameters give you control over how the Battle Log Window, the
 * window shown at the top of the screen in the battle layout, appears, its
 * various properties, and which text will be displayed.
 *
 * The majority of the text has been disabled by default with this plugin to
 * make the flow of battle progress faster.
 *
 * ---
 *
 * General
 * 
 *   Back Color:
 *   - Use #rrggbb for a hex color.
 * 
 *   Max Lines:
 *   - Maximum number of lines to be displayed.
 * 
 *   Message Wait:
 *   - Number of frames for a usual message wait.
 * 
 *   Text Align:
 *   - Text alignment for the Window_BattleLog.
 * 
 *   JS: X, Y, W, H:
 *   - Code used to determine the dimensions for the battle log.
 *
 * ---
 *
 * Start Turn
 * 
 *   Show Start Turn?:
 *   - Display turn changes at the start of the turn?
 * 
 *   Start Turn Message:
 *   - Message displayed at turn start.
 *   - %1 - Turn Count
 * 
 *   Start Turn Wait:
 *   - Number of frames to wait after a turn started.
 *
 * ---
 *
 * Display Action
 * 
 *   Show Centered Action?:
 *   - Display a centered text of the action name?
 * 
 *   Show Skill Message 1?:
 *   - Display the 1st skill message?
 * 
 *   Show Skill Message 2?:
 *   - Display the 2nd skill message?
 * 
 *   Show Item Message?:
 *   - Display the item use message?
 *
 * ---
 *
 * Action Changes
 * 
 *   Show Counter?:
 *   - Display counter text?
 * 
 *   Show Reflect?:
 *   - Display magic reflection text?
 * 
 *   Show Substitute?:
 *   - Display substitute text?
 *
 * ---
 *
 * Action Results
 * 
 *   Show No Effect?:
 *   - Display no effect text?
 * 
 *   Show Critical?:
 *   - Display critical text?
 * 
 *   Show Miss/Evasion?:
 *   - Display miss/evasion text?
 * 
 *   Show HP Damage?:
 *   - Display HP Damage text?
 * 
 *   Show MP Damage?:
 *   - Display MP Damage text?
 * 
 *   Show TP Damage?:
 *   - Display TP Damage text?
 *
 * ---
 *
 * Display States
 * 
 *   Show Added States?:
 *   - Display added states text?
 * 
 *   Show Removed States?:
 *   - Display removed states text?
 * 
 *   Show Current States?:
 *   - Display the currently affected state text?
 * 
 *   Show Added Buffs?:
 *   - Display added buffs text?
 * 
 *   Show Added Debuffs?:
 *   - Display added debuffs text?
 * 
 *   Show Removed Buffs?:
 *   - Display removed de/buffs text?
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Battleback Scaling Settings
 * ============================================================================
 *
 * By default, the battlebacks in RPG Maker MZ scale as if the screen size is
 * a static 816x624 resolution, which isn't always the case. These settings
 * here allow you to dictate how you want the battlebacks to scale for the
 * whole game. These settings CANNOT be changed midgame or per battle.
 *
 * ---
 *
 * Settings
 * 
 *   Default Style:
 *   - The default scaling style used for battlebacks.
 *   - MZ (MZ's default style)
 *   - 1:1 (No Scaling)
 *   - Scale To Fit (Scale to screen size)
 *   - Scale Down (Scale Downward if Larger than Screen)
 *   - Scale Up (Scale Upward if Smaller than Screen)
 * 
 *   JS: 1:1:
 *   JS: Scale To Fit:
 *   JS: Scale Down:
 *   JS: Scale Up:
 *   - This code gives you control over the scaling for this style.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Party Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you control over how the Party Command Window
 * operates in the battle scene. You can turn disable it from appearing or make
 * it so that it doesn't 
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Party Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Party Command Window.
 * 
 *   Fight Icon:
 *   - The icon used for the Fight command.
 * 
 *   Add Auto Battle?:
 *   - Add the "Auto Battle" command to the Command Window?
 * 
 *     Auto Battle Icon:
 *     - The icon used for the Auto Battle command.
 * 
 *     Auto Battle Text:
 *     - The text used for the Auto Battle command.
 * 
 *   Add Options?:
 *   - Add the "Options" command to the Command Window?
 * 
 *     Options Icon:
 *     - The icon used for the Options command.
 * 
 *     Active TPB Message:
 *     - Message that will be displayed when selecting options during the
 *       middle of an action.
 * 
 *   Escape Icon:
 *   - The icon used for the Escape command.
 *
 * ---
 *
 * Access
 * 
 *   Skip Party Command:
 *   - DTB: Skip Party Command selection on turn start.
 *   - TPB: Skip Party Command selection at battle start.
 * 
 *   Disable Party Command:
 *   - Disable the Party Command Window entirely?
 *
 * ---
 *
 * Help Window
 * 
 *   Fight:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 * 
 *   Options:
 *   - Text displayed when selecting the Options command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Command Window
 * ============================================================================
 *
 * These Plugin Parameters allow you to change various aspects regarding the
 * Actor Command Window and how it operates in the battle scene. This ranges
 * from how it appears to the default battle commands given to all players
 * without a custom <Battle Commands> notetag.
 *
 * ---
 *
 * Command Window
 * 
 *   Style:
 *   - How do you wish to draw commands in the Actor Command Window?
 *   - Text Only: Display only the text.
 *   - Icon Only: Display only the icon.
 *   - Icon + Text: Display the icon first, then the text.
 *   - Auto: Determine which is better to use based on the size of the cell.
 * 
 *   Text Align:
 *   - Text alignment for the Actor Command Window.
 * 
 *   Item Icon:
 *   - The icon used for the Item command.
 * 
 *   Normal SType Icon:
 *   - Icon used for normal skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * 
 *   Magic SType Icon:
 *   - Icon used for magic skill types that aren't assigned any icons.
 *   - Ignore if VisuMZ_1_SkillsStatesCore is installed.
 *
 * ---
 *
 * Battle Commands
 * 
 *   Command List:
 *   - List of battle commands that appear by default if the <Battle Commands>
 *     notetag isn't present.
 *
 *     - Attack 
 *       - Adds the basic attack command.
 * 
 *     - Skills
 *       - Displays all the skill types available to the actor.
 * 
 *     - SType: x
 *     - Stype: name
 *       - Adds in a specific skill type.
 *       - Replace 'x' with the ID of the skill type.
 *       - Replace 'name' with the name of the skill type (without text codes).
 *
 *     - All Skills
 *       - Adds all usable battle skills as individual actions.
 * 
 *     - Skill: x
 *     - Skill: name
 *       - Adds in a specific skill as a usable action.
 *       - Replace 'x' with the ID of the skill.
 *       - Replace 'name' with the name of the skill.
 * 
 *     - Guard
 *       - Adds the basic guard command.
 * 
 *     - Item
 *       - Adds the basic item command.
 * 
 *     - Escape
 *       - Adds the escape command.
 * 
 *     - Auto Battle
 *       - Adds the auto battle command.
 * 
 *     - Party
 *       - Requires VisuMZ_2_PartySystem!
 *       - Switches out the current actor for another.
 * 
 *     - Combat Log
 *       - Requires VisuMZ_4_CombatLog!
 *       - Shows combat log.
 * 
 *     - Talk
 *       - Requires VisuMZ_3_BattleCmdTalk!
 *       - Shows talk command if applicable.
 * 
 *     - Weapon Swap
 *       - Requires VisuMZ_2_WeaponSwapSystem!
 *       - Swaps current weapon for next one.
 * 
 *   Show Command Costs:
 *   - If a battle command has a resource cost, show it?
 *
 * ---
 *
 * Help Window
 * 
 *   Skill Types:
 *   - Text displayed when selecting a skill type.
 *   - %1 - Skill Type Name
 * 
 *   Items:
 *   - Text displayed when selecting the item command.
 * 
 *   Escape:
 *   - Text displayed when selecting the escape command.
 * 
 *   Auto Battle:
 *   - Text displayed when selecting the Auto Battle command.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Multi-Target Windows Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters adjust how the Multi-Target Windows appear
 * in battle. These windows are visible when selecting an enemy or actor while
 * using a skill/item that has the <Single or Multiple Select> notetag.
 * 
 * Those wondering why this isn't regulated to a command left or right of the
 * enemies and actors is because mouse controls and touch controls would not be
 * able to select all enemies or all allies that way.
 *
 * ---
 * 
 * Properties
 * 
 *   Window Width:
 *   - What is the width used for the Multi-Target Window?
 * 
 *   Background Type:
 *   - Select background type for these windows.
 * 
 *   Show Button:
 *   - Shows the keyboard/controller button to press?
 *   - Requires VisuMZ_0_CoreEngine!
 * 
 * ---
 * 
 * Vocab
 * 
 *   All Actors:
 *   - What is the text used for the "All Actors" button?
 * 
 *   All Enemies:
 *   - What is the text used for the "All Enemies" button?
 * 
 * ---
 * 
 * Offsets > Actor Offsets
 * Offsets > Enemy Offsets
 * 
 *   Offset X:
 *   - Offsets the button's x position.
 *   - Negative: left. Positive: right.
 * 
 *   Offset Y:
 *   - Offsets the button's y position.
 *   - Negative: up. Positive: down.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Actor Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how the sideview battlers behave for
 * the actor sprites. Some of these settings are shared with enemies if they
 * use sideview battler graphics.
 *
 * ---
 *
 * Flinch
 * 
 *   Flinch Distance X:
 *   - The normal X distance when flinching.
 * 
 *   Flinch Distance Y:
 *   - The normal Y distance when flinching.
 * 
 *   Flinch Duration:
 *   - The number of frames for a flinch to complete.
 * 
 *   Shake Flinch:
 *   - Perform a shake flinch when taking damage?
 * 
 *     Max Duration:
 *     - Maximum duration a shake flinch can have.
 *     - This is reduced relative to the amount of damage taken.
 * 
 *     Max Power:
 *     - The power rating of a shake flinch at full damage.
 *     - This is reduced relative to the amount of damage taken.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 * 
 *   Chant Style:
 *   - What determines the chant motion?
 *   - Hit type or skill type?
 * 
 *   Offset X:
 *   - Offsets X position where actor is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where actor is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Motion Speed:
 *   - The number of frames in between each motion.
 * 
 *   Priority: Active:
 *   - Place the active actor on top of actor and enemy sprites.
 * 
 *   Priority: Actors:
 *   - Prioritize actors over enemies when placing sprites on top of each other
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 * 
 *   JS: Home Position:
 *   - Code used to calculate the home position of actors.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Enemy Battler Settings
 * ============================================================================
 *
 * These Plugin Parameter settings adjust how enemies appear visually in the
 * battle scene. Some of these settings will override the settings used for
 * actors if used as sideview battlers. Other settings include changing up the
 * default attack animation for enemies, how the enemy select window functions,
 * and more.
 *
 * ---
 *
 * Visual
 * 
 *   Attack Animation:
 *   - Default attack animation used for enemies.
 *   - Use <Attack Animation: x> for custom animations.
 * 
 *   Emerge Text:
 *   - Show or hide the 'Enemy emerges!' text at the start of battle.
 * 
 *   Offset X:
 *   - Offsets X position where enemy is positioned.
 *   - Negative values go left. Positive values go right.
 * 
 *   Offset Y:
 *   - Offsets Y position where enemy is positioned.
 *   - Negative values go up. Positive values go down.
 * 
 *   Smooth Image:
 *   - Smooth out the battler images or pixelate them?
 *
 * ---
 *
 * Select Window
 * 
 *   Any: Last Selected:
 *   - Prioritize last selected enemy over front view or sideview settings?
 * 
 *   FV: Right Priority:
 *   - If using frontview, auto select the enemy furthest right.
 * 
 *   SV: Right Priority:
 *   - If using sideview, auto select the enemy furthest right.
 * 
 * ---
 * 
 * Name:
 * 
 *   Legacy Option:
 *   - Use the legacy version (window) or new version (sprite).
 *   - WARNING: Legacy version is no longer supported for bugs.
 *   - Not all settings available here in the Plugin Parameters will be
 *     available to the legacy version (ie Always Visible and Attach States).
 * 
 *   Font Size:
 *   - Font size used for enemy names.
 * 
 *   Name Position:
 * 
 *     Offset X:
 *     Offset Y:
 *     - Offset the enemy name's position by this much.
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name: Attach States:
 *   - Attach the enemy's state icon to the enemy name?
 * 
 *     Attach: Offset X:
 *     Attach: Offset Y:
 *     - How much to offset the attached icon's X/Y position by?
 *     - For X: Negative goes left. Positive goes right.
 *     - For Y: Negative goes up. Positive goes down.
 * 
 *   Name Visibility:
 * 
 *     Always Hidden:
 *     - Determines if the enemy name will always be visible.
 *     - Highest priority.
 * 
 *     Always Visible:
 *     - Determines if the enemy name will always be visible.
 *     - Medium priority.
 * 
 *     By Selection?:
 *     - Determines the conditions for enemy name visibility.
 *     - Lowest priority.
 *
 * ---
 *
 * Sideview Battlers
 * 
 *   Allow Collapse:
 *   - Causes defeated enemies with SV Battler graphics to "fade away"
 *     when defeated?
 * 
 *   Anchor: X:
 *   - Default X anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Anchor: Y:
 *   - Default Y anchor for Sideview Battlers.
 *   - Use values between 0 and 1 to be safe.
 * 
 *   Motion: Idle:
 *   - Sets default idle animation used by Sideview Battlers.
 * 
 *   Shadow Visible:
 *   - Show or hide the shadow for Sideview Battlers.
 * 
 *   Size: Width:
 *   - Default width for enemies that use Sideview Battlers.
 * 
 *   Size: Height:
 *   - Default height for enemies that use Sideview Battlers.
 * 
 *   Weapon Type:
 *   - Sets default weapon type used by Sideview Battlers.
 *   - Use 0 for Bare Hands.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: HP Gauge Settings
 * ============================================================================
 *
 * Settings that adjust the visual HP Gauge displayed in battle.
 *
 * ---
 *
 * Show Gauges For
 * 
 *   Actors:
 *   - Show HP Gauges over the actor sprites' heads?
 *   - Requires SV Actors to be visible.
 * 
 *   Enemies:
 *   - Show HP Gauges over the enemy sprites' heads?
 *   - Can be bypassed with <Hide HP Gauge> notetag.
 * 
 *     Requires Defeat?:
 *     - Requires defeating the enemy once to show HP Gauge?
 *     - Can be bypassed with <Show HP Gauge> notetag.
 * 
 *       Battle Test Bypass?:
 *       - Bypass the defeat requirement in battle test?
 *
 * ---
 *
 * Settings
 * 
 *   Animation Duration:
 *   - How many frames should gauges animate themselves?
 *   - Default: 20 frames.
 * 
 *   Anchor X:
 *   Anchor Y:
 *   - Where do you want the HP Gauge sprite's anchor X/Y to be?
 *     Use values between 0 and 1 to be safe.
 * 
 *   Scale:
 *   - How large/small do you want the HP Gauge to be scaled?
 * 
 *   Offset X:
 *   Offset Y:
 *   - How many pixels to offset the HP Gauge's X/Y by?
 *
 * ---
 *
 * Options
 * 
 *   Add Option?:
 *   - Add the 'Show HP Gauge' option to the Options menu?
 * 
 *   Adjust Window Height:
 *   - Automatically adjust the options window height?
 * 
 *   Option Name:
 *   - Command name of the option.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Action Sequence Settings
 * ============================================================================
 *
 * Action Sequence Plugin Parameters allow you to decide if you want automatic
 * Action Sequences to be used for physical attacks, the default casting
 * animations used, how counters and reflects appear visually, and what the
 * default stepping distances are.
 *
 * ---
 *
 * Automatic Sequences
 * 
 *   Melee Single Target:
 *   - Allow this auto sequence for physical, single target actions?
 * 
 *   Melee Multi Target:
 *   - Allow this auto sequence for physical, multi-target actions?
 *
 * ---
 * 
 * Quality of Life
 * 
 *   Auto Notetag:
 *   - Automatically apply the <Custom Action Sequence> notetag effect to any
 *     item or skill that has a Common Event?
 *   - Any item or skill without a Common Event attached to it will use the
 *     Automatic Action Sequences instead.
 *   - The <Auto Action Sequence> notetag will disable this effect for that
 *     particular skill or item.
 * 
 * ---
 *
 * Cast Animations
 * 
 *   Certain Hit:
 *   - Cast animation for Certain Hit skills.
 * 
 *   Physical:
 *   - Cast animation for Physical skills.
 * 
 *   Magical:
 *   - Cast animation for Magical skills.
 *
 * ---
 *
 * Counter/Reflect
 * 
 *   Counter Back:
 *   - Play back the attack animation used?
 * 
 *   Reflect Animation:
 *   - Animation played when an action is reflected.
 * 
 *   Reflect Back:
 *   - Play back the attack animation used?
 *
 * ---
 *
 * Stepping
 * 
 *   Melee Distance:
 *   - Minimum distance in pixels for Movement Action Sequences.
 * 
 *   Step Distance X:
 *   - The normal X distance when stepping forward.
 * 
 *   Step Distance Y:
 *   - The normal Y distance when stepping forward.
 * 
 *   Step Duration:
 *   - The number of frames for a stepping action to complete.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.82: March 14, 2024
 * * Bug Fixes!
 * ** Home movement changes did not acknowledge actor and enemy offset X/Y
 *    positions. This should now be reflected properly. Fix made by Irina.
 * ** Fixed a bug where in active TPB/ATB, revived actors may not resume normal
 *    motions after collapsing. Fix made by Olivia.
 * 
 * Version 1.81: February 15, 2024
 * * Bug Fixes!
 * ** Fixed a bug that would cause active TPB inputting actors to not show
 *    their damage or evasion motions. Fix made by Olivia.
 * ** Fixed a bug that would cause a crash upon motion changes. Fix by Olivia.
 * ** Fixed an incorrect spelling of "Anger" for "ANIM: Balloon Animation" that
 *    prevented it from working properly.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Show Animation JS
 * **** Plays the a specific animation on unit(s). Uses JavaScript to determine
 *      animation ID.
 * ** New Action Sequences added for future plugin: VisuMZ_2_BattleGridSystem
 * *** GRID: Action Animation at Node
 * *** GRID: Add Passive State(s) to Node
 * *** GRID: Add Trigger to Node
 * *** GRID: Animation ID at Node
 * *** GRID: Animation JS at Node
 * *** GRID: Animation Type at Node
 * *** GRID: Move Target(s) In Direction
 * *** GRID: Pull To Target Node
 * *** GRID: Push From Target Node
 * *** GRID: Remove All Passive States from Node
 * *** GRID: Remove Passive State(s) from Node
 * *** GRID: Remove Trigger from Node
 * *** GRID: Teleport To Node
 * *** GRID: Traverse To Node
 * **** Requires the future plugin VisuMZ_2_BattleGridSystem!
 * **** Read the help section for more information on these.
 * 
 * Version 1.80: January 18, 2024
 * * Bug Fixes!
 * ** Fixed a crash that would occur with <Disperse Damage> when used outside
 *    of battle. Fix made by Irina.
 * ** Fixed a crash that would occur with certain enemy graphics when images
 *    used for them would disappear. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia:
 * *** ANIM: Guard Animation
 * *** ANIM: Item Animation
 * *** ANIM: Skill Animation
 * **** Plays the animation associated with the user's guard action (if any),
 *      or a specific item/skill.
 * *** MECH: Emulate Attack Effect
 * *** MECH: Emulate Guard Effect
 * *** MECH: Emulate Item Effect
 * *** MECH: Emulate Skill Effect
 * **** Emulate an "Action Effect" but using a the user's attack skill, guard
 *      skill, specific item, or specific skill instead of the current action.
 * **** Essentially lets you perform the mechanics of another action without
 *      having to use another action or needing to pay that action's costs.
 * *** MECH: Emulate Skill Cost
 * **** Pick a skill for target(s) to emulate paying the cost of.
 * **** Includes cooldowns and limited uses.
 * *** MECH: State Turns Change By
 * *** MECH: State Turns Change To
 * **** Changes target(s) state turns by an amount/to a certain value.
 * **** Requires VisuMZ_1_SkillsStatesCore!
 * *** Projectile action sequences have new Extra Features!
 * **** See v1.08 changes for VisuMZ_3_ActSeqProjectiles.
 * 
 * Version 1.79: December 14, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Arisu:
 * *** ANIM: Balloon Animation
 * **** Plays a balloon animation on target(s).
 * *** ANIM: Balloon Icon (Single)
 * *** ANIM: Balloon Icon (Range)
 * *** ANIM: Balloon Icon (Specific)
 * **** Plays a balloon animation using an icon on target(s).
 * **** Requires VisuMZ_4_IconBalloons!
 * 
 * Version 1.78: October 12, 2023
 * * Bug Fixes!
 * ** Fixed a bug that is caused by using the actor escape command not escaping
 *    properly in battle and causing a freeze. Fix made by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Parameters > Mechanics > Turn End Buffs Expire?
 * **** Normally, buffs expire after all actions end.
 * **** But here, you can have buffs expire on turn end.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.77: August 17, 2023
 * * Bug Fixes!
 * ** Fixed a bug where for TPB, actions aimed at dead targets would not
 *    redirect to suitable targets. Fix made by Olivia.
 * ** Fixed a bug where dual wielding would not use a weapon if it was equipped
 *    in the second weapon slot if the first weapon slot was empty. Fix made
 *    by Olivia.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Added compatibility for VisuStella MZ Battle Voices Action Sequences.
 * * Documentation Update!
 * ** Help file updated for new features.
 * 
 * Version 1.76: July 13, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequences added by Olivia and sponsored by NSG:
 * *** MOVE: Change Home To JS Coordinates
 * **** Change home position(s) to specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Face JS Coordinates
 * **** Causes the unit(s) to face specified JS Coordinates. Sideview-only!
 *      Uses JS!
 * *** MOVE: Move To JS Coordinates
 * **** Moves unit(s) to specified JS Coordinates. Sideview-only! Uses JS!
 * 
 * Version 1.75: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia and sponsored by Anon:
 * *** <HP Life Steal: x%>
 * *** <MP Life Steal: x%>
 * *** <HP Life Steal hitType: +/-x%>
 * *** <MP Life Steal hitType: +/-x%>
 * *** <Cancel Life Steal>
 * *** <Guard Life Steal>
 * *** <Disarm Life Steal>
 * *** <Negative Life Steal>
 * **** Life Steal properties involving HP/MP are now added. They will restore
 *      a portion of the dealt HP/MP damage to the target.
 * **** This is a different mechanic from Drain HP/Drain MP and cannot be used
 *      together to prevent clashing.
 * **** Read the help file for more information.
 * 
 * Version 1.74: February 16, 2023
 * * Bug Fixes!
 * ** Fixed a bug that would cause a crash if your basic attack skill somehow
 *    manages to target neither an enemy nor an actor. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Auto-action sequence for jumping forward and attacking is now reinstated
 *    so that it's only disabled when the target and user are on the same side.
 *    If there is no target, a jump still occurs for visual player feedback.
 *    Update made by Olivia.
 * * New Features!
 * ** New notetag effect added by Olivia and sponsored by AndyL:
 * *** <Cannot Target User>
 * **** This will cause the action to be unable to select the user as target.
 * **** This is not a targeting scope. Instead, it is used in addition to any
 *      other targeting scopes out there.
 * 
 * Version 1.73: January 20, 2023
 * * Bug Fixes!
 * ** Active TPB custom action sequences will no longer play differently due to
 *    queued inputting actors causing motion refreshes. Fix made by Arisu.
 * ** Corrected and updated Anti-Tint UI animation offsets for MV animations.
 *    Fix made by Irina.
 * ** Fixed a problem with Sideview Battlers not working properly. Fix made
 *    by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for to add the following text to the <Target: x>
 *    notetag entries in order to avoid confusion.
 * *** This will overwrite the existing database scope and ignore the
 *     database's existing scope in favor of this.
 * * Feature Update!
 * ** <Extend: x> Troop Name Tag is now also usable as a Troop Comment Tag.
 * ** Action Sequence targeting has been updated with two new types "special"
 *    and "special x", to be used for future plugins.
 * * New Features!
 * ** New Notetags added by Irina and sponsored by AndyL:
 * *** <Target: Ally or Enemy>
 * *** <Target: Enemy or Ally>
 * **** Allows the player to target allies or enemies with the skill/item.
 * **** See help file for more information.
 * *** <Single or Multiple Select>
 * **** This will allow the skill/item to be able to select either single
 *      targets or multiple targets at once.
 * **** See help file for more information.
 * *** <Disperse Damage>
 * **** This will cause any damage dealt by this skill to be split equally
 *      amongst all targets of the skill including repeats.
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Multi-Target Windows
 * **** Settings that alter the Multi-Target Windows in battle.
 * 
 * Version 1.72: December 15, 2022
 * * Bug Fixes!
 * ** Fixed a transformation of a sideview enemy to a static enemy and back not
 *    working properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Feature!
 * ** New Plugin Parameter added by Irina!
 * *** Plugin Parameters > HP Gauges > Settings > Animation Duration
 * **** How many frames should gauges animate themselves? Default: 20 frames.
 * ** New Plugin Parameters added by Yanfly!
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Power
 * *** Plugin Parameters > Actor Battler Settings > Shake Flinch > Max Duration
 * **** These new plugin parameters will cause targets that take HP damage to
 *      shake (in addition to a regular flinch) to provide better visual
 *      feedback to the player.
 * **** Shake Flinch will be kept disabled by default and only turned on when
 *      you want it to be.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.71: November 10, 2022
 * ** Fixed a problem with repeating animations from Visual State Effects
 *    causing softlocks. Fix made by Olivia.
 * 
 * Version 1.70: October 6, 2022
 * * Bug Fixes!
 * ** Fixed a problem with the "Border" style where if a battle portrait
 *    changed midway through the battle, the portrait shown didn't actually
 *    update properly. Fix made by Irina.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Olivia:
 * *** MECH: Active Chain Input Disable
 * **** Disables input for Active Chain Skills at this time.
 * **** Requires VisuMZ_3_ActiveChainSkills!
 * ** New Plugin Parameter added by Olivia and sponsored by Anon:
 * *** Plugin Parameters > Damage Settings > Popups > End Battle Show?
 * **** Show or hide popups upon victory or escape?
 * **** Used to hide battle-state removal popups.
 * 
 * Version 1.69: September 7, 2022
 * * Compatibility Update!
 * ** Better compatibility with VisuMZ Active Chain Skills.
 * ** Compatibility will be seen with VisuMZ_3_ActiveChainSkills version 1.02.
 * * Documentation Update!
 * ** Added notes to the following Action Sequences:
 * *** MOTION: Clear Freeze Frame and MOTION: Freeze Motion Frame
 * **** Only applies to sprite sheets.
 * **** Does NOT work with Dragonbones.
 * **** Use "DB: Dragonbones Time Scale" instead.
 * * Feature Update!
 * ** Reduced MV Animation misalignment when Screen Resolution does not match
 *    the UI Area Resolution. Update by Arisu.
 * ** Command Remember will now remember the locations of single skills. Update
 *    made by Olivia.
 * 
 * Version 1.68: August 4, 2022
 * * Feature Update!
 * ** Damage popups are now automatically cleared upon starting battles. This
 *    is to ensure that, if for some reason, residual damage popup requests
 *    will not be retained. Update made by Olivia.
 * 
 * Version 1.67: July 28, 2022
 * * Feature Updates!
 * ** Rounding window coordinates have been added for for 'XP' and 'Portrait'
 *    styles when window sizes happen to land on non-divisible numbers. Update
 *    made by Irina.
 * ** Enemy name position rounding is now enforced. Update made by Irina.
 * 
 * Version 1.66: July 14, 2022
 * * Bug Fixes!
 * ** Fixed a bug that caused the various Battleback Scaling JS custom plugin
 *    parameters to not work properly. Fix made by Irina.
 * 
 * Version 1.65: July 7, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Automatic action motions for HP and MP Recovery (Certain Hit type) will
 *    now use the "skill" cast SV animation instead of attack animation to
 *    better match the default RPG Maker MZ cast animation. Update by Olivia.
 * * New Features!
 * ** New troop name tag added by Olivia:
 * *** <Extend: x> and <Extend: x, x, x>
 * **** Adds enemies from another troop to the current troop.
 * **** Enemies from another troop will retain their database positions.
 * **** Extended troop members will be added in the order they're listed.
 * **** Be cautious of how many enemies you add as too many will lag the battle
 *      system. We are not responsible for frame drops due to this.
 * 
 * Version 1.64: June 16, 2022
 * * Bug Fixes!
 * ** "All Skills" battle command should now work with the updated version of
 *    VisuMZ Skills & States Core. Fix madde by Olivia.
 * * Compatibility Update
 * ** Plugins should be more compatible with one another.
 * 
 * Version 1.63: May 26, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** HP Gauge sprite now properly synchs with battler location.
 * * New Features!
 * ** New Action Sequence Effects added by Irina and sponsored by MirageV:
 * *** INJECT action sequence series
 * **** See the Action Sequence Impact changelog for details.
 * 
 * Version 1.62: April 22, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Battle Forced End Action Crash
 * **** Depending on various circumstances, currently active battlers can be
 *      cleared from the battle system at will due to a number of reasons.
 *      However, if it just so happens that the targets are cleared, too, with
 *      actions remaining, then a crash will follow up. This plugin will
 *      prevent that change. Fix made by Olivia.
 * 
 * Version 1.61: April 14, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Impact Effects added by Irina and collaborating with Manu Gaming!
 * *** Impact: Bizarro Inversion
 * *** Impact: Desaturation
 * *** Impact: Negative Inversion
 * *** Impact: Oversaturation
 * *** Impact: Time Scale
 * *** Impact: Time Stop
 * 
 * Version 1.60: April 7, 2022
 * * Bug Fixes!
 * ** <Bypass Soft Damage Cap> notetag should no longer cause crashes. Fix made
 *    by Olivia.
 * * Feature Update!
 * ** Removed one of the forced log window clear events that have made log
 *    window messages impossible to utilize for certain settings. Update made
 *    by Olivia.
 * 
 * Version 1.59: March 31, 2022
 * * Bug Fixes!
 * ** Escape failure will no longer trigger Post-Battle Common Events. Fix
 *    made by Arisu.
 * 
 * Version 1.58: March 24, 2022
 * * Documentation Update:
 * ** Added extra clarity to <Sideview Size: width, height> notetag:
 * *** This does NOT change the image size. This only changes the HITBOX size.
 * * Feature Update!
 * ** Added failsafes to prevent battlers from moving to non-finite coordinates
 *    if calculations are made for non-existent targets. Updated by Olivia.
 * ** Regeneration timing for TPB-based battle systems will now occur based on
 *    individual turn counts instead of global turn counts for initial turn 0
 *    checks. Updated by Olivia.
 * 
 * Version 1.57: February 17, 2022
 * * Feature Update!
 * ** Adjusted the offset properties for the anti-tint UI container to properly
 *    match the UI offsets if the anti-tint were to be off. Update by Irina.
 * 
 * Version 1.56: February 10, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Once Parallels for battle now operate outside of the battle process.
 *    Update made by Olivia.
 * * New Features!
 * ** New Troop Page comment tag added by Olivia and sponsored by Puddor:
 * *** <Once Parallel When Start Battle>
 * **** Causes the troop page to immediately run the moment the battle scene
 *      begins to fade in (not after it fades in). This is faster than a turn 0
 *      condition troop page. Troop page conditions are ignored.
 * **** This can be used for things like the Action Sequence Camera plugin, the
 *      Visual Battle Environment plugin, and/or initial battle poses and such
 *      in order to provide a near seamless battle transition experience.
 * **** This does NOT trigger when coming out of the options menu or party
 *      menu screens.
 * **** This WILL trigger when going from battle to battle nonstop via plugins
 *      like VisuStella MZ's Chain Battles.
 * **** When actors are moving towards their home positions, it will take
 *      around 30 frames by default. Use this information however you like.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.55: January 27 2022
 * * Compatibility Update!
 * ** RPG Maker MV animations with front view should now play in the correct
 *    area against actor faces. Update made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Animations now play on top of all actor faces/portraits regardless of the
 *    battle layout style. Update made by Olivia.
 * * New Features!
 * ** New notetag added by Arisu.
 * *** <Bypass Auto Action Sequence>
 * **** This notetag is used for the game devs that have the Action Sequence
 *      Plugin Parameter "Auto Notetag" on for applying the notetag
 *      <Custom Action Sequence> to every skill and item with common events.
 * **** This will allow items and skills to be able to launch their common
 *      events from the menu scene regardless of the inherent restriction to
 *      prevent action sequence based skills/items with common events from
 *      launching.
 * **** Ignore this if you have "Auto Notetag" disabled or set to false. By
 *      default, this setting is set to false. Please be aware of the changes
 *      you've made to your game before using it.
 * 
 * Version 1.54: January 13, 2022
 * * Bug Fixes!
 * ** RPG Maker MZ Bug Fix!
 * *** Overly-Protective Substitute
 * *** When an ally with critical health is being targeted by a friendly non-
 *     Certain Hit skill (such as a heal or buff) and another ally has the
 *     substitute state, the other ally would "protect" the originally targeted
 *     ally and take the heal or buff.
 * *** The new changed behavior is that now, substitute will not trigger for
 *     any actions whose scope targets allies.
 * *** Fix made by Olivia.
 * 
 * Version 1.53: December 30, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Help file updated for updated features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Battle Layout > UI Elements > Anti-Tint UI?
 * **** Prevent UI Elements from being tinted?
 * **** This prevents UI Elements such as HP Gauges, Enemy Names, Battle
 *      Cursor, and Weakness Display from being affected by screen tint.
 * * Updated Feature!
 * ** Updated Plugin Command "PROJECTILE: Animation" by Arisu!
 * *** New Parameter: Wait For Animation?
 * **** Wait for animation to finish before going to the next command?
 * 
 * Version 1.52: December 16, 2021
 * * Compatibility Update!
 * ** RPG Maker MZ 1.4.0 compatibility update!
 * *** MV Animations played on screen level will now show up properly in the
 *     center of the screen.
 * 
 * Version 1.51: December 9, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence Plugin Commands added by Arisu:
 * *** MOVE: Change Home By Distance
 * *** MOVE: Change Home To Point
 * *** MOVE: Change Home To Target(s)
 * **** These Plugin Commands allow you to adjust the home position of
 *      battlers in sideview battle.
 * **** This is sideview only!
 * **** This does NOT work with front view!
 * **** For those wondering, going to the options screen, party screen, etc.
 *      won't reset the home positions like regular movement changes do.
 * **** Merry Christmas, Harold-gang!
 * 
 * Version 1.50: November 4, 2021
 * * Bug Fixes!
 * ** <Seal Attack> and <Seal Guard> should no longer be bypassed by
 *    auto-battle status. Fix made by Yanfly.
 * 
 * Version 1.49: October 28, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Action Sequence: MOTION: Freeze Motion Frame will now only show weapons
 *    when using a motion that is named either "attack", "thrust", "swing", or
 *    "missile". Update made by Irina.
 * ** Fail safe added to prevent Scene_Battle going into unsupported scenes
 *    like Scene_Equip and Scene_Skill. Update made by Olivia.
 * * New Feature!
 * ** New Action Sequence Plugin Command added by Arisu and sponsored by Anon:
 * *** MECH: Once Parallel
 * **** Plays a Common Event parallel to the battle event once without
 *      repeating itself when done.
 * **** When exiting battle scene, all Once Parallels are cleared.
 * **** Once Parallels are not retained upon reentering the scene.
 * **** Once Parallels are not stored in memory and cannot be saved.
 * 
 * Version 1.48: October 21, 2021
 * * Feature Update!
 * ** Animations are now played on top of battlers in the Front View XP Battle
 *    Layout appearance. Update made by Irina.
 * ** Battle Log, if decided to be shown, now updates faster. Update by Irina.
 * ** Default Critical Damage Bonus increase is now updated to account for
 *    HP Healing and MP Recovery. To update this, create a new project, with
 *    the newest version of Battle Core installed. Copy over the Plugin
 *    Parameters for the Damage Settings > Critical Hits > JS: Damage Formula
 *    to your own project's version. Update made by Irina.
 * 
 * Version 1.47: October 14, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Feature Update!
 * ** Back attachment sprites are now automatically updated with sprite
 *    battlers to be shifted towards the very back.
 * 
 * Version 1.46: September 23, 2021
 * * Bug Fixes!
 * ** Fixed problem with skills and items without action sequences preventing
 *    actions from occurring. Fix made by Yanfly.
 * 
 * Version 1.45: September 17, 2021
 * * Bug Fixes!
 * ** <JS Pre-End Action> and <JS Post-End Action> effects now have multiple
 *    checks to make sure that they don't launch multiple times when a battler
 *    without actions has a turn after one that does. Fix made by Olivia.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence notetags added by Yanfly and Arisu:
 * *** <Common Event Key: name>
 * *** <Common Event Keys: name, name, name>
 * *** <Common Event Keys>
 *      key
 *      key
 *      key
 *     </Common Event Keys>
 * **** Will generate Common Events for the skill/item with a corresponding
 *      key.
 * **** More information will be explained inside of the help file.
 * **** This feature is made for make the process of sharing Action Sequences
 *      to become easier without needing to line up Common Event ID's.
 * 
 * Version 1.44: August 20, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Action Sequence added by Irina and sponsored by Anon.
 * *** "ANIM: Play at Coordinate"
 * **** Plays an animation on the screen at a specific x, y coordinate even if
 *      there is no sprite attached.
 * **** Requires VisuMZ_0_CoreEngine!
 * 
 * Version 1.43: July 23, 2021
 * * Feature Update!
 * ** Immortality now works different with instant death mechanics. Skill
 *    effects that apply instant death or attack states that apply instant
 *    death will now trigger a flag instead of cancelling immortality. The
 *    flag will remain until immortality is manually cancelled via Action
 *    Sequence and then proc the death effect. This way, animations can remain
 *    to the end with instant death mechanics in mind. This does not affect
 *    script calls.
 * 
 * Version 1.42: July 16, 2021
 * * Bug Fixes!
 * ** Added another fail safe for empty common events used for pre-battle
 *    common events. Fix made by Olivia.
 * 
 * Version 1.41: July 2, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * ** Added entries to <Battle Command> notetags and Plugin Parameters for
 *    "Party", "Combat Log", and "Weapon Swap" which weren't updated before.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * * New Features!
 * ** New Action Sequence added by Arisu:
 * *** MECH: Enemy Escape
 * **** Causes the enemy unit(s) to escape.
 * 
 * Version 1.40: June 25, 2021
 * * Bug Fixes!
 * ** Transformations from static enemies to and from animated SV enemies
 *    should no longer show both sprites. Fix made by Irina.
 * * Compatibility Update
 * ** Compatibility update with RPG Maker MZ 1.3.0+.
 * 
 * Version 1.39: June 18, 2021
 * * Bug Fixes!
 * ** MOVE: Home Reset should no longer trigger an end action function and
 *    cause plugins such as "Boost Action" to malfunction. Fix made by Olivia.
 * * Compatibility Update
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <Battle Layout: x> Troop Name tags can now work with comment tags. Update
 *    made by Irina.
 * ** Random encounter lists are now better shuffled for more variety with how
 *    the RNG seed works. Update made by Arisu.
 * 
 * Version 1.38: June 11, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Updates!
 * ** Location calculations will now be based off the a battler's base position
 *    in order for animations, popups, and other aspects to line up properly
 *    when scaled. Update made by Irina.
 * ** Plugin Parameters for Enemy Battler Settings > Name have been rearranged
 *    for better organization. Update by Olivia.
 * * New Features!
 * ** New Notetags added by Olivia and sponsored by NSG:
 * *** <Sideview Shadow Scale X: x%>
 * *** <Sideview Shadow Scale X: x.y>
 * *** <Sideview Shadow Scale Y: x%>
 * *** <Sideview Shadow Scale Y: x.y>
 * **** These new notetags allow you to adjust the X and Y scale of the SV
 *      shadow sprite separately.
 * ** New Plugin Parameters added by Olivia and sponsored by NSG:
 * *** Enemy Battler Settings > Name > Name Visibility > Always Hidden
 * *** Enemy Battler Settings > Name > Name Visibility > By Selection?
 * **** Choose to have the names always hidden or by selection.
 * **** These are adjusted on a priority list.
 * 
 * Version 1.37: May 21, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia.
 * *** <Command Require Learn>
 * *** <Command Require Access>
 * **** These two commands determine the visibility of a battle command by
 *      whether or not the skill has been learned or accessible.
 * * Feature Update!
 * ** For those using TPB, each battler's regeneration phase will no longer
 *    tick multiple times in a single frame to prevent irregularities. Update
 *    made by Olivia.
 * 
 * Version 1.36: May 14, 2021
 * * Bug Fixes!
 * ** Reversed an HP/MP regeneration bug that was incorrectly reported for TPB.
 *    Fix made by Olivia.
 * * Documentation Update
 * ** Added "TPB/ATB Active Battle Actor Shifting" to Major Changes section:
 * *** This change has been active since the start of this plugin. It was not
 *     documented until now.
 * *** Pressing cancel on the Actor Command Window no longer switches between
 *     actors with a full TPB/ATB gauge before reaching the Party Command
 *     Window. This is to accomplish a couple of things: 1) reduce the number
 *     of button presses to reach the Party Command Window and 2) to prevent
 *     motion resets and disrupting action sequences. If this feature is vital
 *     to your battle system, we recommend that you do not use this plugin or
 *     any of the Battle Core-required plugins.
 * ** Feature Updates
 * *** Distortion sprite Y calculations will now be rounded upward for better
 *     visuals and prevent odd pixelation effects. Update made by Irina.
 * 
 * Version 1.35: May 7, 2021
 * * Bug Fixes!
 * ** Pre-Battle Common Events without a wait command at the end should no
 *    longer lock up by coincidentally pressing the menu key at the same time.
 *    Fix made by Olivia.
 * * Feature Update!
 * ** Added an extra check for TPB-based battle systems to not run turn end
 *    functions when it's not actually the actual turn end timing. Update made
 *    by Olivia.
 * ** "Damage Styles" plugin parameters are now moved to the top of the
 *    Damage Settings category. This should make it easier to acknowledge the
 *    existence of and not have it be an unknown entity. Update made by Irina.
 * 
 * Version 1.34: April 23, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** Uses a better algorithm for determining shadow positioning. Update made
 *    by Olivia.
 * * New Features!
 * ** New additions made for Projectile action sequences.
 * ** "Start Location" and "Goal Location" now have "Target Location" parameter
 *    to determine which part of the target's body to send the projectile from
 *    or towards. Added by Olivia.
 * ** Requires VisuMZ_1_BattleCore version 1.34 to have affect.
 * 
 * Version 1.33: April 9, 2021
 * * Bug Fixes!
 * ** Skill costs should now be displayed on battle commands again. Bug fix
 *    made by Olivia.
 * ** Pre-Battle Common Events should no longer cause stalling when used with
 *    specific event commands. Bug fix made by Olivia.
 * * Compatibility Update!
 * ** Added "Weapon Swap" to the list of battle commands that can be added.
 * * Documentation Update!
 * ** Added "Weapon Swap" and "Combat Log" to the list of <Battle Commands> in
 *    the notetags section.
 * ** Help file updated for new features.
 * * New Features!
 * ** New notetags added by Olivia:
 * *** <Sideview Shadow Scale: x%> and <Sideview Shadow Scale: x.y>
 * **** Used for: Actor, Enemy Notetags
 * **** Adjusts the scaling size of the sideview battler's shadow.
 * 
 * Version 1.32: April 2, 2021
 * * Feature Update!
 * ** Sideview battler sprites when using front view will now factor in the
 *    window padding and appear properly centered to their focus point. Update
 *    made by Olivia.
 * 
 * Version 1.31: March 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Added "VisuStella MZ Compatibility" section for detailed compatibility
 *    explanations with the VisuMZ_3_BoostAction plugin.
 * 
 * Version 1.30: March 19, 2021
 * * Documentation Update!
 * ** Help file updated for updated features.
 * * Feature Update!
 * ** <JS Targets> is now updated to include the default set of targets
 *    selected by the skill/item's original scope. Update made by Yanfly.
 * *** If you wish to clear it out, simply do 'targets = []' first.
 * 
 * Version 1.29: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameter added by Olivia:
 * *** Plugin Parameters > Enemy Battler Settings > Name > Legacy Option
 * **** Use the legacy version (window) or new version (sprite).
 * **** WARNING: Legacy version is no longer supported for bugs.
 * **** Not all settings available here in the Plugin Parameters will be
 *      available to the legacy version (ie Always Visible and Attach States).
 * 
 * Version 1.28: March 5, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Arisu:
 * *** Plugin Parameters > Actor Command > Show Command Costs
 * **** If you don't want to show skill costs for your commands in the Actor
 *      Command Window, you can now hide them.
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battle Layout Settings > Status Window Elements
 * *** Battle Layout Settings > Status Window Elements > Battler Name
 * *** Battle Layout Settings > Status Window Elements > Gauge 1 (HP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 2 (MP)
 * *** Battle Layout Settings > Status Window Elements > Gauge 3 (TP)
 * *** Battle Layout Settings > Status Window Elements > State Icon
 * *** Battle Layout Settings > Status Window Elements > TPB/ATB Gauge
 * **** These new Plugin Parameters allow you to offset the positions of the
 *      various Battle Status Window elements. Their base positions will be
 *      calculated by the Battle Layout used and then offset from there.
 * *** Battle Layout Settings > Status Window Elements > Window Skin
 * **** These settings allow you to set a specific window skin for the
 *      Battle Status Window or hide it from view completely.
 * *** Battle Layout Settings > Status Window Elements > Selectable Background
 * **** This option allows you to hide the black box that comes with the
 *      majority of selectable elements found in RPG Maker MZ in case it does
 *      not fit with how you want the Battle Status Window to look.
 * *** Battle Layout Settings > Status Window Elements > Back Attachment
 * *** Battle Layout Settings > Status Window Elements > Front Attachment
 * **** These settings allow you to attach images to the back/front of the
 *      Battle Status Window from the img/system/ folder.
 * **** You may offset X and Y positions for them as well.
 * ** New Plugin Parameters added by Olivia:
 * *** Plugin Parameters > Enemy Settings > Name: Always Visible
 * **** Determines if the enemy name will always be visible.
 * *** Plugin Parameters > Enemy Settings > Name: Attach States
 * **** Attach the enemy's state icon to the enemy name?
 * *** Plugin Parameters > Enemy Settings > Attach: Offset X/Y
 * **** Offset the attached state icon's position.
 * * Feature Update!
 * ** Switched drawing enemy names on the screen from window to sprite to
 *    reduce lag and for better screen positioning accuracy especially during
 *    screen zooming. Update by Olivia.
 * 
 * Version 1.27: February 26, 2021
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New Plugin Parameters added by Irina and sponsored by AndyL:
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Critical
 * *** Plugin Parameters > Mechanics Settings > Switches > Switch: Miss/Evade
 * **** Turns Switches ON if the action performs a critical hit, misses, or is
 *      evaded at any point.
 * **** Switch reverts to OFF whenever an action starts.
 * **** If multiple targets/hits are struck, as long as one hit respectively
 *      lands a critical hit, fails to land, then the switch will remain ON for
 *      the rest of the action.
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Damage
 * *** Plugin Parameters > Mechanics Settings > Variables > Variable: Healing
 * **** Variable records target damage/healing during action.
 * **** Variable reverts to 0 whenever an action starts.
 * **** If multiple targets/hits are struck, the variable will record the total
 *      amount of damage/healing done for the remainder of the action (unless
 *      manually reseting to 0 during an Action Sequence).
 * 
 * Version 1.26: February 19, 2021
 * * Bug Fixes!
 * ** Battles with branching event paths found within a conditional branch or
 *    choice tree will no longer be skipped over. Fix made by Arisu.
 * * Compatibility Update
 * ** Returning to the battle scene from the options scene in a Tpb-base battle
 *    system now links the current actor. Update by Irina.
 * 
 * Version 1.25: February 5, 2021
 * * Compatibility Update
 * ** Added compatibility update with VisuStella MZ Skills and States Core's
 *    Plugin Parameter > State Settings > Action End Update
 * * Feature Update!
 * ** <Common Event: name> notetag no longer requires <Custom Action Sequence>
 *    notetag if the Plugin Parameter: Auto Notetag is enabled.
 * 
 * Version 1.24: January 29, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** MOVE: Move To Point and MOVE: Move To Target(s) Action Sequences'
 *    "Offset Adjustment" normal setting will now factor in Offset X and
 *    Offset Y positions unlike before where it cancels them. Update by Irina.
 * * New Features!
 * ** New notetag added by Arisu:
 * *** <Common Event: name>
 * **** Battle only: calls forth a Common Event of a matching name.
 * **** This is primarily used for users who are reorganizing around their
 *      Common Events and would still like to have their skills/items perform
 *      the correct Action Sequences in case the ID's are different.
 * 
 * Version 1.23: January 22, 2021
 * * Documentation Update!
 * ** Help file updated for new features.
 * * Feature Update!
 * ** ACSET: All Targets Action Set and ACSET: Each Target Action Set updated
 * *** New parameter added: Dual/Multi Wield?
 * **** Add times struck based on weapon quantity equipped?
 * * New Features!
 * ** Dual Wielding now functions differently. Made by Olivia.
 * *** Previously, RPG Maker MZ had "Dual Wielding" attack using both weapon
 *     animations at once, with the combined ATK of each weapon. It's confusing
 *     to look at and does not portray the nature of "Dual Wielding".
 * *** Dual Wielding, or in the case of users adding in third and fourth
 *     weapons, Multi Wielding is now changed. Each weapon is displayed
 *     individually, each producing its own attack animation, showing each
 *     weapon type, and applying only that weapon's ATK, Traits, and related
 *     effects. It is no longer a combined effect to display everything at once
 *     like RPG Maker MZ default.
 * *** If an actor has multiple weapon slots but some of them are unequipped,
 *     then the action will treat the attack as a single attack. There will be
 *     no barehanded attack to add on top of it. This is to match RPG Maker
 *     MZ's decision to omit a second animation if the same scenario is
 *     applied.
 * ** New Action Sequence Plugin Commands added by Yanfly
 * *** ANIM: Attack Animation 2+
 * **** Plays the animation associated with the user's 2nd weapon.
 *      Plays nothing if there is no 2nd weapon equipped.
 * ** New Action Sequence Plugin Commands added by Olivia
 * *** WEAPON: Clear Weapon Slot
 * *** WEAPON: Next Weapon Slot
 * *** WEAPON: Set Weapon Slot
 * **** These are Action Sequence Plugin Commands for devs who want finer
 *      control over Dual/Multi Wielding weapons.
 * 
 * Version 1.22: January 15, 2021
 * * Compatibility Update
 * ** Compatibility with "All Skills" Actor Command should now work with the
 *    Skills & States Core hide skill notetags.
 * 
 * Version 1.21: January 8, 2021
 * * Bug Fixes!
 * ** "MOVE: Home Reset" Plugin Command Action Sequence should work properly.
 *    Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Notetag snuck in by Arisu
 * *** <Auto Action Sequence>
 * **** Used for those who have the "Auto Notetag" Plugin Parameter enabled and
 *      just want to use an automatic Action Sequence instead.
 * ** New Plugin Parameter snuck in by Arisu!
 * *** Plugin Parameters > Action Sequences > Quality of Life > Auto Notetag
 * **** Automatically apply the <Custom Action Sequence> notetag effect to any
 *      item or skill that has a Common Event?
 * **** Any item or skill without a Common Event attached to it will use the
 *      Automatic Action Sequences instead.
 * **** The <Auto Action Sequence> notetag will disable this effect for that
 *      particular skill or item.
 * ** Arisu, you're going to be responsible for any bugs these may cause.
 * *** Bring it!!!!
 * **** And handling any bug report emails that are sent because this was
 *      turned on by accident.
 * ***** Please read the documentation, guys!
 * 
 * Version 1.20: January 1, 2021
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors that have received damage
 *    will return back to place after flinching. Fix made by Yanfly.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New notetags added by Yanfly:
 * *** <Battle Portrait Offset: +x, +y>
 * *** <Battle Portrait Offset X: +x>
 * *** <Battle Portrait Offset Y: +y>
 * **** This is used with the "Portrait" and "Border" Battle Layouts.
 * **** Offsets the X and Y coordinates for the battle portrait.
 * 
 * Version 1.19: December 25, 2020
 * * Bug Fixes!
 * ** Removing a state from a Sideview Enemy during the middle of their a non-
 *    looping motion will no longer reset their motion to neutral.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for updated feature(s)!
 * * Feature Update!
 * ** Action Sequence "PROJECTILE: Icon" now supports code for the "Icon"
 *    parameter. Update made by Yanfly.
 * 
 * Version 1.18: December 18, 2020
 * * Bug Fixes!
 * ** For TPB Active or ATB Active, inputting actors will no longer step back
 *    after an enemy's action is finished. Fix made by Yanfly and Shiro.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** Action Sequence "BTLOG: Add Text" is updated for the convenience of a new
 *    option to quickly copy the displayed text to the VisuStella MZ Combat Log
 *    if that plugin is installed. Added by Yanfly.
 * 
 * Version 1.17: December 11, 2020
 * * Bug Fixes!
 * ** Common Events in TPB Active that cause forced actions will no longer
 *    cause currently inputting actors that match the forced action battler to
 *    crash the game. Fix made by Yanfly and Shiro.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins.
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * Feature Update!
 * ** Action Sequence Impact Action Sequences "Shockwave from Each Target(s)",
 *    "Shockwave from Target(s) Center", and "Zoom Blur at Target(s) Center"
 *    now have "Offset X" and "Offset Y" plugin parameters. Added by Yanfly.
 * ** Action Sequence "MOVE: Move To Target(s)" is now changed so that if the
 *    "Melee Distance" value is set to 0, battlers will no longer stand a half
 *    body distance away. Added by Yanfly.
 * 
 * Version 1.16: December 4, 2020
 * * Bug Fixes!
 * ** Bug fixes made for the RPG Maker MZ base code. If a battler has no
 *    actions, then their action speed will not be Infinity. Fix by Olivia.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.15: November 29, 2020
 * * Bug Fixes!
 * ** Completely replacing the whole party at once will no longer cause the
 *    battle system to crash. Fix made by Olivia.
 * ** Pre-Battle Common Events will no longer cancel out any win/lose branches.
 *    Fix made by Arisu.
 * * Feature Update!
 * ** Custom Action Sequences will no longer close the Actor Command Input
 *    window unless absolutely necessary (like for Show Message events) during
 *    Active TPB/ATB. Change made by Arisu.
 * 
 * Version 1.14: November 22, 2020
 * * Feature Update!
 * ** Natural Miss and Evasion motions now have flinch distance.
 *    Added by Yanfly.
 * 
 * Version 1.13: November 15, 2020
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.12: November 8, 2020
 * * Bug Fixes!
 * ** Failsafes added to prevent common events from running if they're empty.
 *    Fix made by Irina.
 * ** Skip Party Command will now work properly with TPB-based battle systems.
 *    Fix made by Yanfly.
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** In preparation for upcoming VisuStella MZ plugins.
 * 
 * Version 1.11: November 1, 2020
 * * Compatibility Update!
 * ** Plugins should be more compatible with one another.
 * * Documentation Update!
 * ** Added clarity for the Plugin Parameters for the Common Events settings
 *    found in the mechanics section. The common events are only meant to run
 *    in the map scene and not for the battle scene. Update made by Irina.
 * * Feature Update!
 * ** The Plugin Parameter for Mechanics, Common Events (on Map), Defeat Event
 *    now has updated functionality. If this has a common event attached to it,
 *    then losing to random encounters will no longer send the player to the
 *    Game Over scene, but instead, send the player back to the map scene,
 *    where the Defeat Common Event will run. Update made by Irina.
 * 
 * Version 1.10: October 25, 2020
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * * New Features!
 * ** New Action Sequence Plugin Command added by Olivia:
 * *** MECH: Custom Damage Formula
 * **** Changes the current action's damage formula to custom.
 *      This will assume the MANUAL damage style.
 * ** New Notetag added by Irina:
 * ** New Plugin Parameters added by Irina:
 * *** Plugin Parameters > Battleback Scaling Settings
 * **** These settings allow you to adjust how battlebacks scale to the screen
 *      in the game.
 * *** <Battler Sprite Grounded>
 * **** Prevents the enemy from being able to jumping and/or floating due to
 *      Action Sequences but still able to move. Useful for rooted enemies.
 * 
 * Version 1.09: October 18, 2020
 * * Bug Fixes!
 * ** Exiting out of the Options menu scene or Party menu scene will no longer
 *    cause party members to reset their starting position. Fix made by Arisu
 * * Documentation Update!
 * ** Added documentation for new feature(s)!
 * ** There was a documentation error with <JS Pre-Regenerate> and
 *    <JS Post-Regenerate>. Fix made by Yanfly.
 * *** Before, these were written as <JS Pre-Regenerate Turn> and
 *     <JS Post-Regenerate Turn>. The "Turn" part of the notetag has been
 *     removed in the documentation.
 * * Feature Update!
 * ** Damage sprites on actors are now centered relative to the actor's anchor.
 *    Change made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Command added by Yanfly:
 * *** MECH: Variable Popup
 * **** Causes the unit(s) to display a popup using the data stored inside
 *      a variable.
 * 
 * Version 1.08: October 11, 2020
 * * Bug Fixes!
 * ** Dead party members at the start of battle no longer start offscreen.
 *    Fix made by Arisu.
 * ** Removed party members from battle no longer count as moving battlers.
 *    Fix made by Yanfly.
 * ** Using specific motions should now have the weapons showing and not
 *    showing properly. Fix made by Yanfly.
 * 
 * Version 1.07: October 4, 2020
 * * Bug Fixes!
 * ** Adding and removing actors will now refresh the battle status display.
 *    Fix made by Irina.
 * ** Adding new states that would change the affected battler's state motion
 *    will automatically refresh the battler's motion. Fix made by Irina.
 * ** Boss Collapse animation fixed and will sink into the ground.
 *    Fix made by Irina.
 * ** Failsafes added for certain animation types. Fix made by Yanfly.
 * ** Freeze Motion for thrust, swing, and missile animations will now show the
 *    weapons properly. Fix made by Yanfly.
 * ** The Guard command will no longer display the costs of the Attack command.
 *    Fix made by Irina.
 * * Documentation Update!
 * ** Updated help file for newly added plugin parameters.
 * * Feature Updates!
 * ** When using the Change Battleback event command in battle, the game client
 *    will wait until both battlebacks are loaded before changing the both of
 *    them so that the appearance is synched together. Change made by Yanfly.
 * * New Features!
 * ** New plugin parameters added by Irina!
 * *** Plugin Parameters > Actor Battler Settings > Chant Style
 * **** What determines the chant motion? Hit type or skill type?
 * 
 * Version 1.06: September 27, 2020
 * * Bug Fixes!
 * ** Enemy Battler Plugin Parameter "Shadow Visible" should now work again.
 *    Fix made by Irina.
 * * Compatibility Update!
 * ** Added compatibility functionality for future plugins. Added by Yanfly.
 * * Documentation Update!
 * ** Updated the help file for all the new plugin parameters.
 * * Feature Update!
 * ** Action Sequence "MECH: HP, MP, TP" will now automatically collapse an
 *    enemy if it has been killed by the effect.
 * ** All battle systems for front view will now have damage popups appear
 *    in front of the status window instead of just the Portrait battle layout.
 *    Update made by Yanfly.
 * * New Features!
 * ** New Action Sequence Plugin Commands from Irina!
 * *** MOTION: Clear Freeze Frame
 * *** MOTION: Freeze Motion Frame
 * **** You can freeze a battler's sprite's motion with a specific frame.
 * ** New notetags for Maps and name tags for Troops added by Yanfly!
 * *** <Battle Layout: type> to change the battle layout style used for
 *     specific maps and/or troops.
 * ** New plugin parameters added by Yanfly!
 * *** Plugin Parameters > Battle Layout Settings > Command Window Width
 * **** This plugin parameter lets you adjust the window width for Party and
 *      Actor Command windows in the Default and List Battle Layout styles.
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset X
 * *** Plugin Parameters > Enemy Battler Settings > Name: Offset Y
 * **** These plugin parameters allow you to offset the position of the enemy
 *      name positions on the screen by a specific amount.
 * 
 * Version 1.05: September 20, 2020
 * * Bug Fixes!
 * ** Actors now use their casting or charging animations again during TPB/ATB.
 *    Fix made by Yanfly.
 * ** Defeat requirement for enemies will no longer crash the game if turned on
 *    after creating
 * ** Escaping animation no longer has actors stay in place. Fixed by Yanfly.
 * ** Failsafes added for newly added weapon types that have not been adjusted
 *    in the Database > System 2 tab. Fixed by Irina.
 * ** Shadows now appear under the actor sprites. Fix made by Yanfly.
 * ** Victory during TPB will no longer cancel the victory animations of
 *    actors that will have their turn after. Fixed by Yanfly.
 * * Documentation Update!
 * ** All Anchor Plugin Parameter descriptions now state to use values between
 *    0 and 1 to be safe. Update made by Yanfly.
 * * Feature Update!
 * ** During Active TPB / ATB, canceling out of the actor command window will
 *    go directly into the party window without having to sort through all of
 *    the available active actors.
 * ** Going from the Party Command Window's Fight command will immediately
 *    return back to the actor command window that was canceled from.
 * * New Features!
 * ** Action Sequence Plugin Command "MOVE: Spin/Rotate" has been updated.
 * *** A new parameter has been added: "Revert Angle on Finish"
 * *** Added by Yanfly.
 * ** New plugin parameters have been added to Damage Settings.
 * *** Appear Position: Selects where you want popups to appear relative to the
 *     battler. Head, Center, Base. Added by Yanfly.
 * *** Offset X: Sets how much to offset the sprites by vertically.
 *     Added by Yanfly.
 * *** Offset Y: Sets how much to offset the sprites by horizontally.
 *     Added by Yanfly.
 * ** New plugin parameters have been added to Actor Battler Settings.
 * *** Priority: Active - Place the active actor on top of actor and
 *     enemy sprites. Added by Yanfly.
 * *** Priority: Actors - Prioritize actors over enemies when placing 
 *     sprites on top of each other. Added by Yanfly.
 * 
 * Version 1.04: September 13, 2020
 * * Bug Fixes!
 * ** Active Battler Sprites now remain on top and won't be hidden behind
 *    other sprites for better visual clarity. Fix made by Arisu.
 * ** Collapsing battlers will now show the dead motion properly. Fix made by
 *    Olivia.
 * ** Dead battlers can no longer be given immortality. Fix made by Olivia.
 * ** Going into the Options menu with no battleback set will no longer set a
 *    battle snapshot.
 * ** HP Gauges for Sideview Enemies are no longer flipped! Fix made by Yanfly.
 * ** Moving a dead battler would no longer reset their animation. Fix made by
 *    Olivia.
 * ** Pre-Battle Common Events now work with events instead of just random
 *    encounters. Fix made by Yanfly.
 * ** Sideview Enemy shadows no longer twitch. Fix made by Irina.
 * * Documentation Updates!
 * ** Added further explanations for Anchor X and Anchor Y plugin parameters.
 *    This is because there's a lot of confusion for users who aren't familiar
 *    with how sprites work. Added by Irina.
 * ** <Magic Reduction: x> notetag updated to say magical damage instead of
 *    physical damage. Fix made by Yanfly.
 * * New Features!
 * ** Additional Action Sequence Plugin Commands have been added in preparation
 *    of upcoming plugins! Additions made by Irina.
 * *** Action Sequences - Angle (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Camera (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Skew (for VisuMZ_3_ActSeqCamera)
 * *** Action Sequences - Zoom (for VisuMZ_3_ActSeqCamera)
 * ** Additional Action Sequence Plugin Commands have been made available now
 *    and added to Battle Core! Additions made by Irina.
 * *** MOVE: Scale/Grow/Shrink
 * *** MOVE: Skew/Distort
 * *** MOVE: Spin/Rotate
 * *** MOVE: Wait For Scale
 * *** MOVE: Wait For Skew
 * *** MOVE: Wait For Spin
 * ** Plugin Parameters Additions. Additions made by Irina.
 * *** Plugin Params > Actor Battler Settings > Offset X
 * *** Plugin Params > Actor Battler Settings > Offset Y
 * *** Plugin Params > Actor Battler Settings > Smooth Image
 * *** Plugin Params > Enemy Battler Settings > Offset X
 * *** Plugin Params > Enemy Battler Settings > Offset Y
 * *** Plugin Params > Enemy Battler Settings > Smooth Image
 * 
 * Version 1.03: September 6, 2020
 * * Bug Fixes!
 * ** Animated Battlers will refresh their motions from the death motion once
 *    they're revived instead of waiting for their next input phase. Fix made
 *    by Yanfly.
 * ** Battle Log speed sometimes went by too fast for certain enabled messages.
 *    Wait timers are now added to them, like state results, buff results, and
 *    debuff results. Fix made by Yanfly.
 * ** Boss Collapse animation now works properly. Fix made by Yanfly.
 * ** Freeze fix for TPB (Wait) if multiple actors get a turn at the same time.
 *    Fix made by Olivia.
 * ** Pressing cancel on a target window after selecting a single skill no
 *    longer causes the status window to twitch.
 * ** Sideview Enemies had a split frame of being visible if they were to start
 *    off hidden in battle. Fix made by Shaz.
 * * Compatibility Update:
 * ** Battle Core's Sprite_Damage.setup() function is now separated fro the
 *    default to allow for better compatibility. Made by Yanfly.
 * * Documentation Update:
 * ** Inserted more information for "Damage Popups" under "Major Changes"
 * * New Features!
 * ** <Magic Penetration: x>, <Magic Penetration: x%> notetags added.
 * ** <Magic Reduction: x>, <Magic Reduction: x%> notetags added.
 * ** <Battle UI Offset: +x, +y>, <Battle UI Offset X: +x>, and
 *    <Battle UI Offset Y: +y> notetags added for adjusting the positions of
 *    HP Gauges and State Icons.
 * *** Notetags added by Yanfly.
 * 
 * Version 1.02: August 30, 2020
 * * Bug Fixes!
 * ** Failsafes added for parsing battle targets. Fix made by Yanfly.
 * ** Immortality is no longer ignored by skills/items with the Normal Attack
 *    state effect. Fix made by Yanfly.
 * ** Miss and Evasion sound effects work again! Fix made by Yanfly.
 * ** Selecting "Escape" from the Actor Command Window will now have the
 *    Inputting Battler show its escape motion. Fix made by Yanfly.
 * ** Wait for Movement now applies to SV Enemies. Fix made by Yanfly.
 * * New Features!
 * ** Plugin Command "ACSET: Finish Action" now has an option to turn off the
 *    Immortality of targets. Feature added by Yanfly.
 * * Optimization Update
 * ** Uses less resources when making checks for Pre-Battle Battle Start events
 * 
 * Version 1.01: August 23, 2020
 * * Bug Fixes!
 * ** Plugin Parameters > Damage Settings > Damage Formats are now fixed.
 *    Fix made by Olivia.
 * ** TPB Battle System with Disable Party Command fixed. Fix made by Olivia.
 * ** States now show in list format if faces are disabled. Fix made by Yanfly.
 * ** The default damage styles were missing the 'v' variable to allow for
 *    variable data input. These are back now. Fix made by Yanfly.
 * *** Users updating from version 1.00 will need to fix this problem by either
 *     removing the plugin from the Plugin Manager list and reinstalling it, or
 *     going to Plugin Parameters > Damage Settings > Style List > the style
 *     you want, and adding "const v = $gameVariables._data;" to JS: Formula
 * * New Notetags Added:
 * ** <Command Show Switch: x> added by Olivia
 * ** <Command Show All Switches: x,x,x> added by Olivia
 * ** <Command Show Any Switches: x,x,x> added by Olivia
 * ** <Command Hide Switch: x> added by Olivia
 * ** <Command Hide All Switches: x,x,x> added by Olivia
 * ** <Command Hide Any Switches: x,x,x> added by Olivia
 * ** <JS Command Visible> added by Olivia
 *
 * Version 1.00: August 20, 2020
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceStart
 * @text -
 * @desc The following are Action Sequences commands/sets.
 * These Plugin Commands only work in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSet
 * @text Action Sequence - Action Sets
 * @desc Action Sequence Action Sets are groups of commonly used
 * Action Sequence Commands put together for more efficient usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_SetupAction
 * @text ACSET: Setup Action Set
 * @desc The generic start to most actions.
 * 
 * @arg DisplayAction:eval
 * @text Display Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: On
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionStart:eval
 * @text Battle Step
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg CastAnimation:eval
 * @text Cast Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_WholeActionSet
 * @text ACSET: All Targets Action Set
 * @desc Affects all targets simultaneously performing the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_TargetActionSet
 * @text ACSET: Each Target Action Set
 * @desc Goes through each target one by one to perform the following.
 * 
 * @arg DualWield:eval
 * @text Dual/Multi Wield?
 * @type boolean
 * @on Apply
 * @off Don't
 * @desc Add times struck based on weapon quantity equipped?
 * @default false
 * 
 * @arg PerformAction:eval
 * @text Perform Action
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount1:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed
 * 
 * @arg ActionAnimation:eval
 * @text Action Animation
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitCount2:eval
 * @text Wait Count
 * @desc How many frames should the action sequence wait?
 * You may use JavaScript code.
 * @default Sprite_Battler._motionSpeed * 2
 * 
 * @arg ActionEffect:eval
 * @text Action Effect
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Set_FinishAction
 * @text ACSET: Finish Action
 * @desc The generic ending to most actions.
 * 
 * @arg ApplyImmortal:eval
 * @text Immortal: Off
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForNewLine:eval
 * @text Wait For New Line
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effects
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ClearBattleLog:eval
 * @text Clear Battle Log
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg ActionEnd:eval
 * @text Home Reset
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement
 * @type boolean
 * @on Use
 * @off Don't Use
 * @desc Use this part of the action sequence?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAngle
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAngle
 * @text Action Sequences - Angle
 * @desc Allows you to have control over the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeAngle
 * @text ANGLE: Change Angle
 * @desc Changes the camera angle.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc Change the camera angle to this many degrees.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_Reset
 * @text ANGLE: Reset Angle
 * @desc Reset any angle settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera angle.
 * @default 60
 *
 * @arg EasingType:str
 * @text Angle Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForAngle:eval
 * @text Wait For Angle?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for angle changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Angle_WaitForAngle
 * @text ANGLE: Wait For Angle
 * @desc Waits for angle changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceAnimation
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakAnimation
 * @text Action Sequences - Animations
 * @desc These Action Sequences are related to the 'Animations' that
 * can be found in the Animations tab of the Database.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ActionAnimation
 * @text ANIM: Action Animation
 * @desc Plays the animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation
 * @text ANIM: Attack Animation
 * @desc Plays the animation associated with the user's 1st weapon.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_AttackAnimation2
 * @text ANIM: Attack Animation 2+
 * @desc Plays the animation associated with the user's other weapons.
 * Plays nothing if there is no other weapon equipped.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Slot:eval
 * @text Slot
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 2
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonAnimation
 * @text ANIM: Balloon Animation
 * @desc Plays a balloon animation on target(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg Balloon:str
 * @text Balloon Type
 * @type select
 * @option Exclamation
 * @option Question
 * @option Music Note
 * @option Heart
 * @option Anger
 * @option Sweat
 * @option Frustration
 * @option Silence
 * @option Light Bulb
 * @option Zzz
 * @option User-defined 1
 * @option User-defined 2
 * @option User-defined 3
 * @option User-defined 4
 * @option User-defined 5
 * @desc What kind of balloon should be played on target(s)?
 * @default Exclamation
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIcon
 * @text ANIM: Balloon Icon (Single)
 * @desc Plays a balloon animation using an icon on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg IconIndex:num
 * @text Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconRange
 * @text ANIM: Balloon Icon (Range)
 * @desc Plays a balloon animation an icon range on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg startIcon:num
 * @text Starting Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg endIcon:num
 * @text Ending Icon Index
 * @desc Insert the ID of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default 0
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_BalloonIconSpecific
 * @text ANIM: Balloon Icon (Specific)
 * @desc Plays a balloon animation with specific icons on target(s).
 * Requires VisuMZ_4_IconBalloons!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 *
 * @arg icons:arraynum
 * @text Icons
 * @type string[]
 * @desc Insert the ID(s) of the icon to show.
 * Tip: Right click > Insert Icon Index
 * @default []
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait for balloon animation completion before continuing?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_CastAnimation
 * @text ANIM: Cast Animation
 * @desc Plays the cast animation associated with the action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["user"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ChangeBattlePortrait
 * @text ANIM: Change Battle Portrait
 * @desc Changes the battle portrait of the actor (if it's an actor).
 * Can be used outside of battle/action sequences.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to change the portraits for.
 * Valid units can only be actors.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/pictures/
 * @desc Select the file to change the actor's portrait to.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_GuardAnimation
 * @text ANIM: Guard Animation
 * @desc Plays the animation associated with the user's guard action (if any).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ItemAnimation
 * @text ANIM: Item Animation
 * @desc Plays the animation associated with a specific item.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_PlayAtCoordinate
 * @text ANIM: Play at Coordinate
 * @desc Plays an animation on the screen at a specific x, y coordinate.
 * Requires VisuMZ_0_CoreEngine!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Animation
 * @type animation
 * @desc Plays this animation.
 * @default 1
 * 
 * @arg Coordinates
 *
 * @arg pointX:eval
 * @text X
 * @parent Coordinates
 * @desc X coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 *
 * @arg pointY:eval
 * @text Y
 * @parent Coordinates
 * @desc Y coordinate used for the animation.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 *
 * @arg Mirror:eval
 * @text Mirror Animation?
 * @parent Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute Animation?
 * @parent Animation
 * @type boolean
 * @on Mute
 * @off Normal
 * @desc Mute the animation?
 * @default false
 *
 * @arg WaitComplete:eval
 * @text Wait for Completion?
 * @parent Animation
 * @type boolean
 * @on Wait
 * @off Normal
 * @desc Wait the animation to finish before continuing?
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimation
 * @text ANIM: Show Animation
 * @desc Plays the a specific animation on unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Select which animation to play on unit(s).
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_ShowAnimationJS
 * @text ANIM: Show Animation JS
 * @desc Plays the a specific animation on unit(s).
 * Uses JavaScript to determine animation ID.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Select which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_SkillAnimation
 * @text ANIM: Skill Animation
 * @desc Plays the animation associated with a specific skill.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play the animation on.
 * @default ["all targets"]
 * 
 * @arg Mirror:eval
 * @text Mirror Animation
 * @type boolean
 * @on Mirror
 * @off Normal
 * @desc Mirror the animation?
 * @default false
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Animation_WaitForAnimation
 * @text ANIM: Wait For Animation
 * @desc Causes the interpreter to wait for any animation(s) to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceBattleLog
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakBattleLog
 * @text Action Sequences - Battle Log
 * @desc These Action Sequences are related to the Battle Log Window,
 * the window found at the top of the battle screen.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_AddText
 * @text BTLOG: Add Text
 * @desc Adds a new line of text into the Battle Log.
 * 
 * @arg Text:str
 * @text Text
 * @desc Add this text into the Battle Log.
 * Text codes allowed.
 * @default Insert text here.
 * 
 * @arg CopyCombatLog:eval
 * @text Copy to Combat Log?
 * @type boolean
 * @on Copy Text
 * @off Don't Copy
 * @desc Copies text to the Combat Log.
 * Requires VisuMZ_4_CombatLog
 * @default true
 *
 * @arg CombatLogIcon:num
 * @text Combat Log Icon
 * @parent CopyCombatLog:eval
 * @desc What icon would you like to bind to this entry?
 * Requires VisuMZ_4_CombatLog
 * @default 87
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Clear
 * @text BTLOG: Clear Battle Log
 * @desc Clears all the text in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_DisplayAction
 * @text BTLOG: Display Action
 * @desc Displays the current action in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PopBaseLine
 * @text BTLOG: Pop Base Line
 * @desc Removes the Battle Log's last added base line and 
 * all text up to its former location.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_PushBaseLine
 * @text BTLOG: Push Base Line
 * @desc Adds a new base line to where the Battle Log currently is at.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_Refresh
 * @text BTLOG: Refresh Battle Log
 * @desc Refreshes the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_UI
 * @text BTLOG: UI Show/Hide
 * @desc Shows or hides the Battle UI (including the Battle Log).
 * 
 * @arg ShowHide:eval
 * @text Show/Hide?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows/hides the Battle UI.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForBattleLog
 * @text BTLOG: Wait For Battle Log
 * @desc Causes the interpreter to wait for the Battle Log to finish.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleLog_WaitForNewLine
 * @text BTLOG: Wait For New Line
 * @desc Causes the interpreter to wait for a new line in the Battle Log.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCamera
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCamera
 * @text Action Sequences - Camera
 * @desc Allows you to have control over the camera.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Clamp
 * @text CAMERA: Clamp ON/OFF
 * @desc Turns battle camera clamping on/off.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Setting:eval
 * @text ON/OFF
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Turns camera clamping on/off.
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusPoint
 * @text CAMERA: Focus Point
 * @desc Focus the battle camera on a certain point in the screen.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg FocusX:eval
 * @text X Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg FocusY:eval
 * @text Y Coordinate
 * @desc Insert the point to focus the camera on.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_FocusTarget
 * @text CAMERA: Focus Target(s)
 * @desc Focus the battle camera on certain battler target(s).
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to focus the battle camera on.
 * @default ["user"]
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for camera focus change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Offset
 * @text CAMERA: Offset
 * @desc Offset the battle camera from the focus target.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @desc How much to offset the camera X by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @desc How much to offset the camera Y by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for offset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_Reset
 * @text CAMERA: Reset
 * @desc Reset the battle camera settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg ResetFocus:eval
 * @text Reset Focus?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the focus point?
 * @default true
 * 
 * @arg ResetOffset:eval
 * @text Reset Offset?
 * @type boolean
 * @on On
 * @off Off
 * @desc Reset the camera offset?
 * @default true
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for reset change.
 * @default 60
 *
 * @arg EasingType:str
 * @text Camera Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForCamera:eval
 * @text Wait For Camera?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for camera changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Camera_WaitForCamera
 * @text CAMERA: Wait For Camera
 * @desc Waits for camera to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceCutin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakCutin
 * @text Action Sequences - Cutins
 * @desc Allows you to have control over Visual Cutin Effects.
 * Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_AddVisualCutinEffect
 * @text CUTIN: Add Visual Cutin Effect
 * @desc Adds the Visual Cutin Effect using these desired settings.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg Basic
 * @text Basic Settings
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @parent Basic
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to use?
 * Only one of each cutin-style type can be present.
 * @default CenterHorzSpan
 * 
 * @arg Targets:arraystr
 * @text Portrait Target
 * @parent Basic
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to grab the Visual Cutin Effect portrait
 * data from. First unit will be used to make portrait.
 * @default ["user"]
 *
 * @arg parallaxFilename:str
 * @text Parallax Filename
 * @parent Basic
 * @type file
 * @dir img/parallaxes/
 * @require 1
 * @desc Pick a parallax to use for the Visual Cutin Effect.
 * Pick (None) to not use a parallax.
 * @default >>>ATTENTION<<<
 *
 * @arg bgColor:str
 * @text Background Color
 * @parent Basic
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #888888
 *
 * @arg ExtraSettings:struct
 * @text Extra Settings
 * @type struct<VisualCutinEffect>
 * @desc Extra Plugin Command settings pertaining to this Visual Cutin Effect.
 * @default {}
 * 
 * @arg WaitForEntrance:eval
 * @text Wait For Entrance
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin entrance is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectAll
 * @text CUTIN: End Visual Cutin Effect (All)
 * @desc Ends all Visual Cutin Effects currently present.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_EndVisualCutinEffectType
 * @text CUTIN: End Visual Cutin Effect (Type)
 * @desc Ends the Visual Cutin Effect with the matching type.
 * Requires VisuMZ_3_VisualCutinEffect!
 * 
 * @arg type:str
 * @text Cutin Style Type
 * @type select
 * @option -
 * @option Whole
 * @option -
 * @option Showcase
 * @option -
 * @option LeftHorzSpan
 * @option CenterHorzSpan
 * @option RightHorzSpan
 * @option -
 * @option LeftHorzSlash
 * @option RightHorzSlash
 * @option -
 * @option LeftVertSlash
 * @option RightVertSlash
 * @option -
 * @option LeftMajor
 * @option RightMajor
 * @option -
 * @option LeftMinor
 * @option CenterMinor
 * @option RightMinor
 * @option -
 * @option LeftDiamond
 * @option CenterDiamond
 * @option RightDiamond
 * @option -
 * @option LeftGemstone
 * @option CenterGemstone
 * @option RightGemstone
 * @option -
 * @option TopLeftQuad
 * @option TopRightQuad
 * @option BottomLeftQuad
 * @option BottomRightQuad
 * @option -
 * @option TopLeftCorner
 * @option TopRightCorner
 * @option BottomLeftCorner
 * @option BottomRightCorner
 * @option -
 * @option Row1stThird
 * @option Row2ndThird
 * @option Row3rdThird
 * @option -
 * @option Row1stFourth
 * @option Row2ndFourth
 * @option Row3rdFourth
 * @option Row4thFourth
 * @option -
 * @option Row1stFifth
 * @option Row2ndFifth
 * @option Row3rdFifth
 * @option Row4thFifth
 * @option Row5thFifth
 * @option -
 * @option Col1stThird
 * @option Col2ndThird
 * @option Col3rdThird
 * @option -
 * @option Col1stFourth
 * @option Col2ndFourth
 * @option Col3rdFourth
 * @option Col4thFourth
 * @option -
 * @option Col1stFifth
 * @option Col2ndFifth
 * @option Col3rdFifth
 * @option Col4thFifth
 * @option Col5thFifth
 * @option -
 * @option SixPack1
 * @option SixPack2
 * @option SixPack3
 * @option SixPack4
 * @option SixPack5
 * @option SixPack6
 * @option -
 * @option EightPack1
 * @option EightPack2
 * @option EightPack3
 * @option EightPack4
 * @option EightPack5
 * @option EightPack6
 * @option EightPack7
 * @option EightPack8
 * @option -
 * @option TwelvePack1
 * @option TwelvePack2
 * @option TwelvePack3
 * @option TwelvePack4
 * @option TwelvePack5
 * @option TwelvePack6
 * @option TwelvePack7
 * @option TwelvePack8
 * @option TwelvePack9
 * @option TwelvePack10
 * @option TwelvePack11
 * @option TwelvePack12
 * @option -
 * @desc What Visual Cutin Effect style type do you wish to end?
 * @default CenterHorzSpan
 * 
 * @arg WaitForExit:eval
 * @text Wait For Exit
 * @type boolean
 * @on Wait
 * @off Don't Wait
 * @desc Wait until cutin exit is finished before performing
 * the next event command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForEntrance
 * @text CUTIN: Wait for Cutin Entrance
 * @desc Wait until all cutin entrances are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Cutin_WaitForExit
 * @text CUTIN: Wait for Cutin Exit
 * @desc Wait until all cutin exits are finished before performing the next event command. Requires VisuMZ_3_VisualCutinEffect!
 *
 * @ --------------------------------------------------------------------------
 *
 *
 * @command ActionSequenceSpaceDragonbones
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreaDragonbones
 * @text Action Sequences - Dragonbones
 * @desc These Action Sequences are Dragonbones-related.
 * Requires VisuMZ_2_DragonbonesUnion!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesMotionAni
 * @text DB: Dragonbones Animation
 * @desc Causes the unit(s) to play a Dragonbones motion animation.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg MotionAni:str
 * @text Motion Animation
 * @desc What is the name of the Dragonbones motion animation you wish to play?
 * @default attack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_DB_DragonbonesTimeScale
 * @text DB: Dragonbones Time Scale
 * @desc Causes the unit(s) to change their Dragonbones time scale.
 * Requires VisuMZ_2_DragonbonesUnion!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion animation.
 * @default ["user"]
 *
 * @arg TimeScale:num
 * @text Time Scale
 * @desc Change the value of the Dragonbones time scale to this.
 * @default 1.0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceElements
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakElements
 * @text Action Sequences - Elements
 * @desc These Action Sequences are related to elements.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_AddElements
 * @text ELE: Add Elements
 * @desc Adds element(s) to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to add onto the action.
 * Insert multiple element ID's to add multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_Clear
 * @text ELE: Clear Element Changes
 * @desc Clears all element changes made through Action Sequences.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_ForceElements
 * @text ELE: Force Elements
 * @desc Forces only specific element(s) when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @arg Elements:arraynum
 * @text Elements
 * @type number[]
 * @min 1
 * @max 99
 * @desc Select which element ID to force in the action.
 * Insert multiple element ID's to force multiple at once.
 * @default ["1"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Element_NullElements
 * @text ELE: Null Element
 * @desc Forces no element to be used when calculating damage.
 * Requires VisuMZ_1_ElementStatusCore!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceGrid
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakGrid
 * @text Action Sequences - Grid
 * @desc These Action Sequences are Battle Grid System-related.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ActionAnimationAtNode
 * @text GRID: Action Animation at Node
 * @desc Plays action animation at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddPassiveStatesToNode
 * @text GRID: Add Passive State(s) to Node
 * @desc Adds Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to add as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Passive State(s) to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AddTriggerToNode
 * @text GRID: Add Trigger to Node
 * @desc Adds Trigger to target node. Target node cannot have battler.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg SkillID:num
 * @text Skill ID
 * @type skill
 * @desc Select which Skill ID(s) to add as the trigger.
 * @default 1
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to add the Trigger Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to add a Trigger to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to add a Trigger to.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationIDAtNode
 * @text GRID: Animation ID at Node
 * @desc Plays specific animation ID at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @type animation
 * @desc Play this animation at target node.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:num
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:num
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationJsAtNode
 * @text GRID: Animation JS at Node
 * @desc Uses JS to calculate which animation to play at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg AnimationID:eval
 * @text JS: Animation ID
 * @desc Calculate which animation to play on unit(s).
 * Uses JavaScript to determine animation ID.
 * @default 1
 *
 * @arg Mirror:eval
 * @text Mirror?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mirror Animation
 * @off Don't Mirror
 * @desc Mirror this animation?
 * @default false
 *
 * @arg Mute:eval
 * @text Mute?
 * @parent AnimationID:eval
 * @type boolean
 * @on Mute Animation
 * @off Don't Mute
 * @desc Mute this animation?
 * @default false
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_AnimationTypeAtNode
 * @text GRID: Animation Type at Node
 * @desc Plays certain animation type at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg Type:str
 * @text Animation Type
 * @type select
 * @option Attack
 * @option Guard
 * @option Item
 * @option Skill
 * @desc What is the animation type you would like to play?
 * @default Attack
 * 
 * @arg Slot:eval
 * @text Slot (Attack Type)
 * @parent Type:str
 * @desc Which weapon slot to get this data from?
 * Main-hand weapon is weapon slot 1.
 * @default 1
 * 
 * @arg ItemID:num
 * @text Item ID (Item Type)
 * @parent Type:str
 * @type item
 * @desc Which item ID will the animation come from?
 * @default 7
 * 
 * @arg SkillID:num
 * @text Skill ID (Skill Type)
 * @parent Type:str
 * @type skill
 * @desc Which skill ID will the animation come from?
 * @default 99
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit's Node do you want to play an animation on?
 * @default Enemy
 *
 * @arg Rank:num
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Rank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg Flank:num
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @type number
 * @min 1
 * @max 10
 * @desc Input the number representing the Flank of the Node
 * you want to play an animation on.
 * @default 1
 *
 * @arg OffsetX:num
 * @text Offset X
 * @desc Offsets the animation x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg OffsetY:num
 * @text Offset Y
 * @desc Offsets the animation y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_MoveTargetsInDirection
 * @text GRID: Move Target(s) In Direction
 * @desc Moves target(s) in a specific direction to other Nodes.
 * Requires VisuMZ_2_BattleGridSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to move.
 * @default ["all targets"]
 * 
 * @arg MoveType:str
 * @text Movement Type
 * @type select
 * @option -
 * @option Exact
 * @option -
 * @option Mid
 * @option -
 * @option Switch
 * @option Switch Mid
 * @option -
 * @option Crash
 * @option Crash Mid
 * @option -
 * @desc Select the Movement type rulings.
 * See VisuMZ_2_BattleGridSystem help file for details.
 * @default Mid
 * 
 * @arg Direction:str
 * @text Direction
 * @parent MoveType:str
 * @type select
 * @option -
 * @option Upward
 * @option Downward
 * @option -
 * @option Up-Forward
 * @option Forward
 * @option Down-Forward
 * @option -
 * @option Up-Backward
 * @option Backward
 * @option Down-Backward
 * @option -
 * @option Up-Leftward
 * @option Leftward
 * @option Down-Leftward
 * @option -
 * @option Up-Rightward
 * @option Rightward
 * @option Down-Rightward
 * @option -
 * @desc Select the movement direction.
 * @default Backward
 *
 * @arg Distance:eval
 * @text Distance
 * @parent MoveType:str
 * @desc The number of nodes to be moved.
 * You may use JavaScript code.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 *
 * @arg SilentMove:eval
 * @text Silent Change?
 * @type boolean
 * @on Silent
 * @off Visual
 * @desc Silent: Discreet changes shown. More apparent later.
 * Visual: Instant changes shown.
 * @default false
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PullToTargetNode
 * @text GRID: Pull To Target Node
 * @desc Pulls battlers towards target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to pull on?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to pull to.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the pull.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_PushFromTargetNode
 * @text GRID: Push From Target Node
 * @desc Pushes battlers away from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to push from?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to push from.
 * @default 1
 *
 * @arg Strength:eval
 * @text Strength
 * @desc Input the strength level of the push.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_ClearPassiveStatesFromNode
 * @text GRID: Remove All Passive States from Node
 * @desc Removes all all Passive State effects at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear the Node for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Passive States from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Passive States from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemovePassiveStatesFromNode
 * @text GRID: Remove Passive State(s) from Node
 * @desc Remove Passive State(s) at target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg StateIDs:arraynum
 * @text State ID(s)
 * @type state[]
 * @desc Select which State ID(s) to remove as a Passive State.
 * @default []
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to remove the Passive State Node
 * effect for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to remove a Passive State(s) from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_RemoveTriggerFromNode
 * @text GRID: Remove Trigger from Node
 * @desc Removes Trigger from target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to clear Triggers for?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to clear Triggers from.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to clear Triggers from.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TeleportToNode
 * @text GRID: Teleport To Node
 * @desc Teleports user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to teleport to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to teleport to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to teleport.
 * @default 1
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Grid_TraverseToNode
 * @text GRID: Traverse To Node
 * @desc Traverses user/random opponent to target node.
 * Requires VisuMZ_2_BattleGridSystem!
 *
 * @arg UseActionSelectNode:eval
 * @text Action-Selected Node?
 * @type boolean
 * @on Action-Selected
 * @off Prioritize Custom
 * @desc Use Action-Selected Node Coordinates if possible?
 * Requires "Empty" or "Any" for <Target: x Grid Node>
 * @default true
 *
 * @arg Unit:str
 * @text Unit
 * @parent UseActionSelectNode:eval
 * @type select
 * @option Actor
 * @option Enemy
 * @option Friend
 * @option Opponent
 * @desc Which unit do you want to traverse to?
 * @default Actor
 *
 * @arg Rank:eval
 * @text Rank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Rank of the Node
 * you want to traverse to.
 * @default 1
 *
 * @arg Flank:eval
 * @text Flank
 * @parent UseActionSelectNode:eval
 * @desc Input the number representing the Flank of the Node
 * you want to traverse.
 * @default 1
 *
 * @arg Duration:eval
 * @text Duration
 * @desc Input the number representing the frames used to move.
 * @default 12
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceHorror
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakHorror
 * @text Action Sequences - Horror Effects
 * @desc These Action Sequences are Horror Effects-related.
 * Requires VisuMZ_2_HorrorEffects!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_Clear
 * @text HORROR: Clear All Filters
 * @desc Clear all Horror Effects filters on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove Horror Effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchCreate
 * @text HORROR: Glitch Create
 * @desc Creates the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg slices:num
 * @text Glitch Slices
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Glitch slices to be used with the target.
 * @default 10
 *
 * @arg offset:num
 * @text Glitch Offset
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc Default offset value.
 * @default 100
 *
 * @arg animated:eval
 * @text Glitch Animated?
 * @parent FilterGlitch
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the glitch effect?
 * @default true
 *
 * @arg aniFrequency:num
 * @text Glitch Frequency
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how frequent to make the glitch effect?
 * Lower = often     Higher = rarer
 * @default 300
 *
 * @arg aniStrength:num
 * @text Glitch Strength
 * @parent FilterGlitch
 * @type number
 * @min 1
 * @desc If animated, how strong is the glitch effect?
 * Lower = weaker     Higher = stronger
 * @default 30
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_GlitchRemove
 * @text HORROR: Glitch Remove
 * @desc Removes the glitch effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseCreate
 * @text HORROR: Noise Create
 * @desc Creates the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg noise:num
 * @text Noise Rate
 * @parent FilterNoise
 * @desc Noise rate to be used with the target.
 * @default 0.3
 *
 * @arg animated:eval
 * @text Noise Animated
 * @parent FilterNoise
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the noise for the target?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_NoiseRemove
 * @text HORROR: Noise Remove
 * @desc Removes the noise effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVCreate
 * @text HORROR: TV Create
 * @desc Creates the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create the Horror Effect for.
 * @default ["user"]
 *
 * @arg lineWidth:num
 * @text TV Line Thickness
 * @parent FilterTV
 * @type number
 * @min 1
 * @desc Default TV line thickness
 * Lower = thinner     Higher = thicker
 * @default 5
 *
 * @arg vignetting:num
 * @text TV Corner Size
 * @parent FilterTV
 * @desc Default TV line corner size
 * Lower = smaller     Higher = bigger
 * @default 0.3
 *
 * @arg animated:eval
 * @text TV Animated
 * @parent FilterTV
 * @type boolean
 * @on Animate
 * @off Static
 * @desc Animate the TV?
 * @default true
 *
 * @arg aniSpeed:num
 * @text TV Speed
 * @parent FilterTV
 * @desc Speed used to animate the TV if animated
 * Lower = slower     Higher = faster
 * @default 0.25
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Horror_TVRemove
 * @text HORROR: TV Remove
 * @desc Removes the TV effect on the target battler(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to remove the Horror Effect for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceImpact
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakImpact
 * @text Action Sequences - Impact
 * @desc These Action Sequences are related to creating impact.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_BlueRedInvert
 * @text IMPACT: Bizarro Inversion
 * @desc Swaps blue/red colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Bizarro?
 * @type boolean
 * @on Enable / Bizarro
 * @off Disable / Normal
 * @desc Enable Bizarro Inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ColorBreak
 * @text IMPACT: Color Break
 * @desc Breaks the colors on the screen before reassembling.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Intensity:eval
 * @text Intensity
 * @desc What is the intensity of the color break effect?
 * @default 60
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the color break effect?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutBack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Desaturate
 * @text IMPACT: Desaturation
 * @desc Desaturates all colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Desaturate?
 * @type boolean
 * @on Enable / Desaturate
 * @off Disable / Normal
 * @desc Enable Desaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurScreen
 * @text IMPACT: Motion Blur Screen
 * @desc Creates a motion blur on the whole screen.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.1
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionBlurTarget
 * @text IMPACT: Motion Blur Target(s)
 * @desc Creates a motion blur on selected target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion blur effects for.
 * @default ["user"]
 *
 * @arg Angle:eval
 * @text Angle
 * @desc Determine what angle to make the motion blur at.
 * @default Math.randomInt(360)
 *
 * @arg Rate:eval
 * @text Intensity Rate
 * @desc This determines intensity rate of the motion blur.
 * Use a number between 0 and 1.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion blur last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailCreate
 * @text IMPACT: Motion Trail Create
 * @desc Creates a motion trail effect for the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to create motion trail effects for.
 * @default ["user"]
 *
 * @arg delay:num
 * @text Delay
 * @type number
 * @min 1
 * @desc How many frames to delay by when creating a motion trail?
 * The higher the delay, the less after images there are.
 * @default 1
 *
 * @arg duration:num
 * @text Duration
 * @type number
 * @min 1
 * @desc How many frames should the motion trail last?
 * What do you want to be its duration?
 * @default 30
 *
 * @arg hue:num
 * @text Hue
 * @type number
 * @min 0
 * @max 360
 * @desc What do you want to be the hue for the motion trail?
 * @default 0
 *
 * @arg opacityStart:num
 * @text Starting Opacity
 * @type number
 * @min 0
 * @max 255
 * @desc What starting opacity value do you want for the motion
 * trail? Opacity values decrease over time.
 * @default 200
 *
 * @arg tone:eval
 * @text Tone
 * @desc What tone do you want for the motion trail?
 * Format: [Red, Green, Blue, Gray]
 * @default [0, 0, 0, 0]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_MotionTrailRemove
 * @text IMPACT: Motion Trail Remove
 * @desc Removes the motion trail effect from the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to clear motion trail effects for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Negative
 * @text IMPACT: Negative Inversion
 * @desc Inverts all the colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 *
 * @arg Enable:eval
 * @text Negative?
 * @type boolean
 * @on Enable / Negative
 * @off Disable / Normal
 * @desc Enable negative inversion effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_Oversaturate
 * @text IMPACT: Oversaturation
 * @desc Oversaturates colors on the battlefield.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @arg Enable:eval
 * @text Oversaturate?
 * @type boolean
 * @on Enable / Oversaturate
 * @off Disable / Normal
 * @desc Enable Oversaturation effect?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwavePoint
 * @text IMPACT: Shockwave at Point
 * @desc Creates a shockwave at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to create a shockwave at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveEachTargets
 * @text IMPACT: Shockwave from Each Target(s)
 * @desc Creates a shockwave at each of the target(s) location(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ShockwaveCenterTargets
 * @text IMPACT: Shockwave from Target(s) Center
 * @desc Creates a shockwave from the center of the target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a shockwave from.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a shockwave from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the shockwave Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Amp:eval
 * @text Amplitude
 * @desc What is the aplitude of the shockwave effect?
 * @default 30
 * 
 * @arg Wave:eval
 * @text Wavelength
 * @desc What is the wavelength of the shockwave effect?
 * @default 160
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the shockwave?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeScale
 * @text IMPACT: Time Scale
 * @desc Adjust time to go faster or slower!
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc Adjusts how fast/slow time goes.
 * 1.00 is normal. Lower is slower. Higher is faster.
 * @default 1.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_TimeStop
 * @text IMPACT: Time Stop
 * @desc Stops time for a set amount of milliseconds.
 * Requires VisuMZ_3_ActSeqImpact! Created by Manu Gaming!
 * 
 * @arg ms:eval
 * @text Milliseconds
 * @desc How many milliseconds should time stop for?
 * 1000 milliseconds = 1 second.
 * @default 1000
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurPoint
 * @text IMPACT: Zoom Blur at Point
 * @desc Creates a zoom blur at the designated coordinates.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Coordinates
 * 
 * @arg X:eval
 * @text Point: X
 * @parent Coordinates
 * @desc What x coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @arg Y:eval
 * @text Point: Y
 * @parent Coordinates
 * @desc What y coordinate do you want to focus the zoom at?
 * You can use JavaScript code.
 * @default (Graphics.height - 200) / 2
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Impact_ZoomBlurTargetCenter
 * @text IMPACT: Zoom Blur at Target(s) Center
 * @desc Creates a zoom blur at the center of targets.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to start a zoom blur from.
 * @default ["user"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to start a zoom blur from.
 * @default middle center
 * 
 * @arg OffsetX:eval
 * @text Offset X
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur X point by.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @arg OffsetY:eval
 * @text Offset Y
 * @parent TargetLocation:str
 * @desc How much to offset the zoom blur Y point by.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @arg Strength:eval
 * @text Zoom Strength
 * @desc What is the strength of the zoom effect?
 * Use a number between 0 and 1.
 * @default 0.5
 * 
 * @arg Radius:eval
 * @text Visible Radius
 * @desc How much of a radius should be visible from the center?
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc What is the duration of the zoom blur?
 * @default 60
 *
 * @arg EasingType:str
 * @text Easing Type
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default OutSine
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceInject
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakInject
 * @text Action Sequences - Inject
 * @desc These Action Sequences are related to injected animations.
 * Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationStart
 * @text INJECT: Animation Begin
 * @desc Injects and plays a whole spritesheet animation.
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to inject the animation on.
 * @default ["user"]
 * 
 * @arg Filename:str
 * @text Filename
 * @type file
 * @dir img/sv_actors/
 * @desc Select the animation spritesheet file.
 * Located in the /img/sv_actors/ folder.
 * @default Untitled
 *
 * @arg horzCells:num
 * @text Horizontal Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many horizontal cells (or columns) are there?
 * @default 1
 *
 * @arg vertCells:num
 * @text Vertical Cells
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many vertical cells (or rows) are there?
 * @default 1
 *
 * @arg frameDelay:num
 * @text Frame Delay
 * @parent Filename:str
 * @type number
 * @min 1
 * @desc How many frames are played inbetween cells?
 * @default 1
 *
 * @arg smooth:eval
 * @text Smooth Bitmap?
 * @parent Filename:str
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth the spritesheet graphic?
 * @default false
 * 
 * @arg Offset
 *
 * @arg offsetX:eval
 * @text Offset X
 * @parent Offset
 * @desc Offsets the X position of the injected animation.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @arg offsetY:eval
 * @text Offset Y
 * @parent Offset
 * @desc Offsets the Y position of the injected animation.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationEnd
 * @text INJECT: Animation End
 * @desc Stops and ends any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to stop injected animation(s).
 * @default ["user"]
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_AnimationPauseResume
 * @text INJECT: Animation Pause/Resume
 * @desc Pauses/resumes any injected animations on target(s).
 * Requires VisuMZ_3_ActSeqImpact!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to pause injected animation(s).
 * @default ["user"]
 *
 * @arg pause:eval
 * @text Pause?
 * @parent Filename:str
 * @type boolean
 * @on Pause
 * @off Resume
 * @desc Pause the injected animation?
 * @default true
 * 
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Inject_WaitForInjectAni
 * @text INJECT: Wait For Injected Animation
 * @desc Waits for injected animations to complete before performing
 * next command. Requires VisuMZ_3_ActSeqImpact!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMechanics
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMechanics
 * @text Action Sequences - Mechanics
 * @desc These Action Sequences are related to various mechanics
 * related to the battle system.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActionEffect
 * @text MECH: Action Effect
 * @desc Causes the unit(s) to take damage/healing from action and
 * incurs any changes made such as buffs and states.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ActiveChainInputDisable
 * @text MECH: Active Chain Input Disable
 * @desc Disables input for Active Chain Skills at this time.
 * Requires VisuMZ_3_ActiveChainSkills!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddBuffDebuff
 * @text MECH: Add Buff/Debuff
 * @desc Adds buff(s)/debuff(s) to unit(s). 
 * Determine which parameters are affected and their durations.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s) and/or debuff(s).
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to buff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["ATK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which parameter(s) to debuff.
 * Insert a parameter multiple times to raise its stacks.
 * @default ["DEF"]
 * 
 * @arg Turns:eval
 * @text Turns
 * @desc Number of turns to set the parameter(s) buffs to.
 * You may use JavaScript code.
 * @default 5
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AddState
 * @text MECH: Add State
 * @desc Adds state(s) to unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the buff(s).
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to add to unit(s).
 * Insert multiple state ID's to add multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AnalyzeWeakness
 * @text MECH: Analyze Weakness
 * @desc Reveal elemental weakness(es) from target(s).
 * Requires VisuMZ_3_WeaknessDisplay!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reveal elemental weaknesses for.
 * @default ["all targets"]
 * 
 * @arg Reveal:eval
 * @text Reveal
 * @desc How many elemental weaknesses do you wish to reveal?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_ArmorPenetration
 * @text MECH: Armor Penetration
 * @desc Adds an extra layer of defensive penetration/reduction.
 * You may use JavaScript code for any of these.
 *
 * @arg ArmorPenetration
 * @text Armor/Magic Penetration
 * 
 * @arg ArPenRate:eval
 * @text Rate
 * @parent ArmorPenetration
 * @desc Penetrates an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArPenFlat:eval
 * @text Flat
 * @parent ArmorPenetration
 * @desc Penetrates a flat amount of armor by this value.
 * @default 0
 *
 * @arg ArmorReduction
 * @text Armor/Magic Reduction
 * 
 * @arg ArRedRate:eval
 * @text Rate
 * @parent ArmorReduction
 * @desc Reduces an extra multiplier of armor by this value.
 * @default 0.00
 * 
 * @arg ArRedFlat:eval
 * @text Flat
 * @parent ArmorReduction
 * @desc Reduces a flat amount of armor by this value.
 * @default 0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_AtbGauge
 * @text MECH: ATB Gauge
 * @desc Alters the ATB/TPB Gauges.
 * Requires VisuMZ_2_BattleSystemATB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 *
 * @arg Charging
 * 
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the ATB Gauge if it is currently charging.
 * @default -0.00
 * 
 * @arg Casting
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the ATB Gauge if it is currently casting.
 * @default -0.00
 * 
 * @arg Interrupt:eval
 * @text Interrupt?
 * @parent Casting
 * @type boolean
 * @on Interrupt
 * @off Don't Interrupt
 * @desc Interrupt the ATB Gauge if it is currently casting?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsChange
 * @text MECH: Boost Points Change
 * @desc Changes Boost Points for target(s).
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Boost Points for.
 * @default ["user"]
 * 
 * @arg BoostPoints:eval
 * @text Alter Boost Points By
 * @desc Alters the unit(s) Boost Points.
 * Positive for gaining points. Negative for losing points.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BoostPointsStoreData
 * @text MECH: Boost Store Data
 * @desc Stores the number of Boosts used this action inside a variable.
 * Requires VisuMZ_3_BoostAction!
 * 
 * @arg VariableID:num
 * @text Variable ID
 * @type variable
 * @desc Which variable do you want to store the data inside?
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldChange
 * @text MECH: Break Shield Change
 * @desc Changes Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the Break Shields for.
 * @default ["all targets"]
 * 
 * @arg BreakShields:eval
 * @text Alter Break Shields By
 * @desc Alters the unit(s) Break Shields.
 * Positive for gaining shields. Negative for losing shields.
 * @default -1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BreakShieldReset
 * @text MECH: Break Shield Reset
 * @desc Resets Break Shields for target(s) if not Break Stunned.
 * Requires VisuMZ_4_BreakShields!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to reset the Break Shields for.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_BtbGain
 * @text MECH: BTB Brave Points
 * @desc Alters the target(s) Brave Points to an exact value.
 * Requires VisuMZ_2_BattleSystemBTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the ATB/TPB Gauges for.
 * @default ["all targets"]
 * 
 * @arg BravePoints:eval
 * @text Alter Brave Points By
 * @desc Alters the target(s) Brave Points.
 * Positive for gaining BP. Negative for losing BP.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Collapse
 * @text MECH: Collapse
 * @desc Causes the unit(s) to perform its collapse animation
 * if the unit(s) has died.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to process a death collapse.
 * @default ["all targets"]
 * 
 * @arg ForceDeath:eval
 * @text Force Death
 * @type boolean
 * @on On
 * @off Off
 * @desc Force death even if the unit has not reached 0 HP?
 * This will remove immortality.
 * @default false
 * 
 * @arg WaitForEffect:eval
 * @text Wait For Effect?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for the collapse effect to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbOrder
 * @text MECH: CTB Order
 * @desc Alters the CTB Turn Order.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg ChangeOrderBy:eval
 * @text Change Order By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CtbSpeed
 * @text MECH: CTB Speed
 * @desc Alters the CTB Speed.
 * Requires VisuMZ_2_BattleSystemCTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the CTB Speed for.
 * @default ["all targets"]
 *
 * @arg ChargeRate:eval
 * @text Charge Rate
 * @parent Charging
 * @desc Changes made to the CTB Speed if it is currently charging.
 * @default -0.00
 * 
 * @arg CastRate:eval
 * @text Cast Rate
 * @parent Casting
 * @desc Changes made to the CTB Speed if it is currently casting.
 * @default -0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_CustomDmgFormula
 * @text MECH: Custom Damage Formula
 * @desc Changes the current action's damage formula to custom.
 * This will assume the MANUAL damage style.
 * 
 * @arg Formula:str
 * @text Formula
 * @desc Changes the current action's damage formula to custom.
 * Use 'default' to revert the damage formula.
 * @default default
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DamagePopup
 * @text MECH: Damage Popup
 * @desc Causes the unit(s) to display the current state of
 * damage received or healed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a damage popup.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_DeathBreak
 * @text MECH: Dead Label Jump
 * @desc If the active battler is dead, jump to a specific label in the common event.
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If the active battler is dead, jump to this specific label in the common event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateAttackEffect
 * @text MECH: Emulate Attack Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * attack skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateGuardEffect
 * @text MECH: Emulate Guard Effect
 * @desc Emulate an "Action Effect" but using a the user's
 * guard skill instead of the current action.
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateItemEffect
 * @text MECH: Emulate Item Effect
 * @desc Emulate an "Action Effect" but using a specific item
 * instead of the current action.
 * 
 * @arg ItemID:eval
 * @text Item ID
 * @type item
 * @desc Which item ID will be emulated?
 * @default 7
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillCost
 * @text MECH: Emulate Skill Cost
 * @desc Pick a skill for target(s) to emulate paying the cost of.
 * Includes cooldowns and limited uses.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will have its cost paid for?
 * Use 0 for current action's skill.
 * @default 0
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EmulateSkillEffect
 * @text MECH: Emulate Skill Effect
 * @desc Emulate an "Action Effect" but using a specific skill
 * instead of the current action.
 * 
 * @arg SkillID:eval
 * @text Skill ID
 * @type skill
 * @desc Which skill ID will be emulated?
 * @default 99
 * 
 * @arg Users:arraystr
 * @text User(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to perform the action's effects.
 * @default ["user"]
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["all targets"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EnemyEscape
 * @text MECH: Enemy Escape
 * @desc Causes the enemy unit(s) to escape.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to escape.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_EtbAction
 * @text MECH: ETB Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Requires VisuMZ_2_BattleSystemETB!
 * 
 * @arg ActionCount:eval
 * @text Energy Count
 * @desc Alters the subject team's available Energy Count.
 * Positive for gaining energy. Negative for losing energy.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_FtbAction
 * @text MECH: FTB Action Count
 * @desc Alters the subject team's available Action Count.
 * Requires VisuMZ_2_BattleSystemFTB!
 * 
 * @arg ActionCount:eval
 * @text Action Count
 * @desc Alters the subject team's available Action Count.
 * Positive for gaining actions. Negative for losing actions.
 * @default +1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_HpMpTp
 * @text MECH: HP, MP, TP
 * @desc Alters the HP, MP, and TP values for unit(s).
 * Positive values for healing. Negative values for damage.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to receive the current action's effects.
 * @default ["user"]
 *
 * @arg HP
 * 
 * @arg HP_Rate:eval
 * @text HP Rate
 * @parent HP
 * @desc Changes made to HP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg HP_Flat:eval
 * @text HP Flat
 * @parent HP
 * @desc Flat changes made to HP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg MP
 * 
 * @arg MP_Rate:eval
 * @text MP Rate
 * @parent MP
 * @desc Changes made to MP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg MP_Flat:eval
 * @text MP Flat
 * @parent MP
 * @desc Flat changes made to MP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 *
 * @arg TP
 * 
 * @arg TP_Rate:eval
 * @text TP Rate
 * @parent TP
 * @desc Changes made to TP based on rate.
 * Positive values for healing. Negative values for damage.
 * @default +0.00
 * 
 * @arg TP_Flat:eval
 * @text TP Flat
 * @parent TP
 * @desc Flat changes made to TP.
 * Positive values for healing. Negative values for damage.
 * @default +0
 * 
 * @arg ShowPopup:eval
 * @text Damage Popup?
 * @type boolean
 * @on On
 * @off Off
 * @desc Display a damage popup after?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Immortal
 * @text MECH: Immortal
 * @desc Changes the immortal flag of targets. If immortal flag is
 * removed and a unit would die, collapse that unit.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Alter the immortal flag of these groups. If immortal flag
 * is removed and a unit would die, collapse that unit.
 * @default ["user","all targets"]
 * 
 * @arg Immortal:eval
 * @text Immortal
 * @type boolean
 * @on On
 * @off Off
 * @desc Turn immortal flag for unit(s) on/off?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_Multipliers
 * @text MECH: Multipliers
 * @desc Changes the multipliers for the current action.
 * You may use JavaScript code for any of these.
 *
 * @arg CriticalHit
 * @text Critical Hit%
 * 
 * @arg CriticalHitRate:eval
 * @text Rate
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalHitFlat:eval
 * @text Flat
 * @parent CriticalHit
 * @desc Affects chance to land a critical hit by this flat bonus.
 * @default +0.00
 *
 * @arg CriticalDmg
 * @text Critical Damage
 * 
 * @arg CriticalDmgRate:eval
 * @text Rate
 * @parent CriticalDmg
 * @desc Affects critical damage by this multiplier.
 * @default 1.00
 * 
 * @arg CriticalDmgFlat:eval
 * @text Flat
 * @parent CriticalDmg
 * @desc Affects critical damage by this flat bonus.
 * @default +0.00
 *
 * @arg Damage
 * @text Damage/Healing
 * 
 * @arg DamageRate:eval
 * @text Rate
 * @parent Damage
 * @desc Sets the damage/healing multiplier for current action.
 * @default 1.00
 * 
 * @arg DamageFlat:eval
 * @text Flat
 * @parent Damage
 * @desc Sets the damage/healing bonus for current action.
 * @default +0.00
 *
 * @arg HitRate
 * @text Hit Rate
 * 
 * @arg HitRate:eval
 * @text Rate
 * @parent HitRate
 * @desc Affects chance to connect attack by this multiplier.
 * @default 1.00
 * 
 * @arg HitFlat:eval
 * @text Flat
 * @parent HitRate
 * @desc Affects chance to connect attack by this flat bonus.
 * @default +0.00
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OnceParallel
 * @text MECH: Once Parallel
 * @desc Plays a Common Event parallel to the battle event once
 * without repeating itself when done.
 *
 * @arg CommonEventID:num
 * @text Common Event ID
 * @type common_event
 * @desc The ID of the parallel Common Event to play.
 * Does NOT repeat itself when finished.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_OtbOrder
 * @text MECH: OTB Order
 * @desc Alters the OTB Turn Order. Best used with single targets.
 * Requires VisuMZ_2_BattleSystemOTB!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to alter the OTB Turn Order for.
 * @default ["all targets"]
 *
 * @arg CurrentTurn:eval
 * @text Current Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @arg NextTurn:eval
 * @text Next Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +1
 *
 * @arg FollowTurn:eval
 * @text Follow Turn By
 * @parent Charging
 * @desc Changes turn order for target(s) by this amount.
 * Positive increases wait. Negative decreases wait.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbAlterCost
 * @text MECH: PTB Alter Cost
 * @desc Alters the action's cost settings.
 * Requires VisuMZ_2_BattleSystemPTB!
 *
 * @arg Override:eval
 * @text Override?
 * @type boolean
 * @on Override Permanent
 * @off Require Temporary
 * @desc Overrides any 'permanent' settings for Changeability?
 * @default false
 *
 * @arg alterChange:str
 * @text Alter Changeability
 * @type select
 * @option Unchanged - Cost type is unchanged after this effect
 * @value unchanged
 * @option Permanent - Cost type can no longer be changed after
 * @value permanent
 * @option Temporary - Cost type can still be changed after
 * @value temporary
 * @desc Allow the cost type and value to be changeable?
 * @default unchanged
 *
 * @arg alterType:str
 * @text Alter Cost Type
 * @type select
 * @option Unchanged - No changes are made
 * @value unchanged
 * @option Consume - Removes half, otherwise consumes full
 * @value consume
 * @option Convert - Converts full => half, otherwise consumes half
 * @value convert
 * @option Compress - Consumes half, otherwise converts full => half
 * @value compress
 * @desc Change the cost type to this scenario.
 * Use 'Unchanged' for no changes.
 * @default convert
 *
 * @arg alterCost:eval
 * @text Alter Cost Value
 * @desc What is the default action cost for this scenario?
 * @default +0
 *
 * @arg alterPriority:eval
 * @text Priority
 * @desc What is this scenario's priority? Scenario outcomes with
 * equal or lower priorities cannot override types and costs.
 * @default 50
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbConvert
 * @text MECH: PTB Conversion
 * @desc Converts full actions into half actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg ConvertCount:eval
 * @text Conversion Count
 * @desc Converts full actions into half actions.
 * If not enough, consume half actions.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_PtbFullHalfAction
 * @text MECH: PTB Full/Half Action(s)
 * @desc Alters the subject team's available Full/Half Actions.
 * Requires VisuMZ_2_BattleSystemPTB!
 * 
 * @arg FullActions:eval
 * @text Full Actions
 * @desc Alters the subject team's available Full Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 * 
 * @arg HalfActions:eval
 * @text Half Actions
 * @desc Alters the subject team's available Half Actions.
 * Positive for gaining. Negative for losing.
 * @default +0
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveBuffDebuff
 * @text MECH: Remove Buff/Debuff
 * @desc Removes buff(s)/debuff(s) from unit(s). 
 * Determine which parameters are removed.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have the buff(s) and/or debuff(s) removed.
 * @default ["user"]
 * 
 * @arg Buffs:arraystr
 * @text Buff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which buffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @arg Debuffs:arraystr
 * @text Debuff Parameters
 * @type combo[]
 * @option MaxHP
 * @option MaxMP
 * @option ATK
 * @option DEF
 * @option MAT
 * @option MDF
 * @option AGI
 * @option LUK
 * @desc Select which debuffed parameter(s) to remove.
 * @default ["MaxHP","MaxMP","ATK","DEF","MAT","MDF","AGI","LUK"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_RemoveState
 * @text MECH: Remove State
 * @desc Remove state(s) from unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to have states removed from.
 * @default ["user"]
 * 
 * @arg States:arraynum
 * @text States
 * @type state[]
 * @desc Select which state ID(s) to remove from unit(s).
 * Insert multiple state ID's to remove multiple at once.
 * @default ["4"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeBy
 * @text MECH: State Turns Change By
 * @desc Changes target(s) state turns by an amount.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns By
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default +1
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if actor(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StateTurnsChangeTo
 * @text MECH: State Turns Change To
 * @desc Changes target(s) state turns to a specific value.
 * Requires VisuMZ_1_SkillsStatesCore!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to affect state turns for.
 * @default ["all targets"]
 *
 * @arg StateID:num
 * @text State ID
 * @type state
 * @desc What is the ID of the state you wish to change turns for?
 * Only works on states that can have turns.
 * @default 5
 *
 * @arg Turns:eval
 * @text Change Turns To
 * @desc How many turns should the state be changed to?
 * You may use JavaScript code.
 * @default 10
 *
 * @arg AutoAddState:eval
 * @text Auto-Add State?
 * @type boolean
 * @on Auto-Add
 * @off Don't Add
 * @desc Automatically adds state if target(s) does not have it applied?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExploit
 * @text MECH: STB Exploit Effect
 * @desc Utilize the STB Exploitation mechanics!
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Exploited:eval
 * @text Target(s) Exploited?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Exploit the below targets?
 * @default true
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to become exploited.
 * @default ["all targets"]
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploited status?
 * @default false
 * 
 * @arg Exploiter:eval
 * @text User Exploiter?
 * @type boolean
 * @on Exploit
 * @off Don't
 * @desc Allow the user to become the exploiter?
 * @default true
 * 
 * @arg ForceExploited:eval
 * @text Force Exploitation
 * @type boolean
 * @on Force
 * @off Don't
 * @desc Force the exploiter status?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbExtraAction
 * @text MECH: STB Extra Action
 * @desc Adds an extra action for the currently active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Extra Actions
 * @parent Charging
 * @desc How many extra actions should the active battler gain?
 * You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_StbRemoveExcessActions
 * @text MECH: STB Remove Excess Actions
 * @desc Removes excess actions from the active battler.
 * Requires VisuMZ_2_BattleSystemSTB!
 * 
 * @arg Actions:eval
 * @text Remove Actions
 * @parent Charging
 * @desc How many actions to remove from the active battler?
 * You may use JavaScript code.
 * @default 99
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_SwapWeapon
 * @text MECH: Swap Weapon
 * @desc Causes the unit(s) to swap their weapon for another.
 * Requires VisuMZ_2_WeaponSwapSystem!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to swap weapons for.
 * @default ["user"]
 * 
 * @arg WeaponTypeID:eval
 * @text Weapon Type ID
 * @desc Which weapon type to swap to?
 * This is NOT the weapon's ID. It's the weapon TYPE.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_TextPopup
 * @text MECH: Text Popup
 * @desc Causes the unit(s) to display a text popup.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Text:str
 * @text Text
 * @desc What text do you wish to display?
 * @default Text
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Text:str
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_VariablePopup
 * @text MECH: Variable Popup
 * @desc Causes the unit(s) to display a popup using the data
 * stored inside a variable.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to prompt a text popup.
 * @default ["target"]
 * 
 * @arg Variable:num
 * @text Variable ID
 * @type variable
 * @desc Get data from which variable to display as a popup?
 * @default 1
 * 
 * @arg DigitGrouping:eval
 * @text Digit Grouping
 * @parent Variable:num
 * @type boolean
 * @on Group Digits
 * @off Don't Group
 * @desc Use digit grouping to separate numbers?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @arg TextColor:str
 * @text Text Color
 * @parent Variable:num
 * @desc Use #rrggbb for custom colors or regular numbers
 * for text colors from the Window Skin.
 * @default #ffffff
 *
 * @arg FlashColor:eval
 * @text Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [0, 0, 0, 0]
 * 
 * @arg FlashDuration:num
 * @text Flash Duration
 * @parent FlashColor:eval
 * @type number
 * @desc What is the frame duration of the flash effect?
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Mechanics_WaitForEffect
 * @text MECH: Wait For Effect
 * @desc Waits for the effects to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMotion
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMotion
 * @text Action Sequences - Motion
 * @desc These Action Sequences allow you the ability to control
 * the motions of sideview sprites.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_ClearFreezeFrame
 * @text MOTION: Clear Freeze Frame
 * @desc Clears any freeze frames from the unit(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to clear freeze frames for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_FreezeMotionFrame
 * @text MOTION: Freeze Motion Frame
 * @desc Forces a freeze frame instantly at the selected motion.
 * Automatically clears with a new motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to freeze motions for.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Freeze this motion for the unit(s).
 * @default attack
 * 
 * @arg Frame:num
 * @text Frame Index
 * @desc Which frame do you want to freeze the motion on?
 * Frame index values start at 0.
 * @default 2
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_MotionType
 * @text MOTION: Motion Type
 * @desc Causes the unit(s) to play the selected motion.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @arg MotionType:str
 * @text Motion Type
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option attack
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default attack
 *
 * @arg ShowWeapon:eval
 * @text Show Weapon?
 * @type combo
 * @type boolean
 * @on Show
 * @off Hide
 * @desc If using 'attack', 'thrust', 'swing', or 'missile',
 * display the weapon sprite?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_PerformAction
 * @text MOTION: Perform Action
 * @desc Causes the unit(s) to play the proper motion based
 * on the current action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to perform a motion.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_RefreshMotion
 * @text MOTION: Refresh Motion
 * @desc Cancels any set motions unit(s) has to do and use
 * their most natural motion at the moment.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to refresh their motion state.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Motion_WaitMotionFrame
 * @text MOTION: Wait By Motion Frame
 * @desc Creates a wait equal to the number of motion frames passing.
 * Time is based on Plugin Parameters => Actors => Motion Speed.
 *
 * @arg MotionFrameWait:num
 * @text Motion Frames to Wait?
 * @type number
 * @min 1
 * @desc Each "frame" is equal to the value found in
 * Plugin Parameters => Actors => Motion Speed
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceMovement
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakMovement
 * @text Action Sequences - Movement
 * @desc These Action Sequences allow you the ability to control
 * the sprites of actors and enemies in battle.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_BattleStep
 * @text MOVE: Battle Step
 * @desc Causes the unit(s) to move forward past their home position
 * to prepare for action.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveBy
 * @text MOVE: Change Home By Distance
 * @desc Change unit(s)'s home position by a distance from their
 * current home position(s). Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to change by.
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to change home by.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToJsPoint
 * @text MOVE: Change Home To JS Coordinates
 * @desc Change home position(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s)'s new home position.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToPoint
 * @text MOVE: Change Home To Point
 * @desc Change home position(s) to a target point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default center
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeMoveToTarget
 * @text MOVE: Change Home To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position(s) for.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change home position to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to change home position to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to change home by.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total change amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceDirection
 * @text MOVE: Face Direction
 * @desc Causes the unit(s) to face forward or backward.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Direction:str
 * @text Direction
 * @type combo
 * @option forward
 * @option backward
 * @option random
 * @desc Select which direction to face.
 * @default forward
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceJsPoint
 * @text MOVE: Face JS Coordinates
 * @desc Causes the unit(s) to face specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 *
 * @arg PointJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to face towards.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FacePoint
 * @text MOVE: Face Point
 * @desc Causes the unit(s) to face a point on the screen.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Point:str
 * @text Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the point instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_FaceTarget
 * @text MOVE: Face Target(s)
 * @desc Causes the unit(s) to face other targets on the screen.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (facing)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change direction.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for the turning unit(s) to face.
 * @default ["current target"]
 * 
 * @arg FaceAway:eval
 * @text Face Away From?
 * @type boolean
 * @on Turn Away
 * @off Face Directly
 * @desc Face away from the unit(s) instead?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Float
 * @text MOVE: Float
 * @desc Causes the unit(s) to float above the ground.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make float.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Vertical distance to float upward.
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total float amount.
 * @default 12
 *
 * @arg EasingType:str
 * @text Float Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForFloat:eval
 * @text Wait For Float?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for floating to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_HomeReset
 * @text MOVE: Home Reset
 * @desc Causes the unit(s) to move back to their home position(s)
 * and face back to their original direction(s).
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["alive battlers"]
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Jump
 * @text MOVE: Jump
 * @desc Causes the unit(s) to jump into the air.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to make jump.
 * @default ["user"]
 * 
 * @arg Height:eval
 * @text Desired Height
 * @desc Max jump height to go above the ground
 * You may use JavaScript code.
 * @default 100
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total jump amount.
 * @default 12
 * 
 * @arg WaitForJump:eval
 * @text Wait For Jump?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for jumping to complete before performing next command?
 * @default false
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveBy
 * @text MOVE: Move Distance
 * @desc Moves unit(s) by a distance from their current position(s).
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DistanceAdjust:str
 * @text Distance Adjustment
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to distance values to determine
 * which direction to move unit(s).
 * @default horz
 * 
 * @arg DistanceX:eval
 * @text Distance: X
 * @parent DistanceAdjust:str
 * @desc Horizontal distance to move.
 * You may use JavaScript code.
 * @default 48
 * 
 * @arg DistanceY:eval
 * @text Distance: Y
 * @parent DistanceAdjust:str
 * @desc Vertical distance to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToJsPoint
 * @text MOVE: Move To JS Coordinates
 * @desc Moves unit(s) to specified JS Coordinates.
 * Sideview-only! Uses JavaScript!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 *
 * @arg DestinationJS:func
 * @text JS: Coordinates
 * @type note
 * @desc Code used to determine the coordinates for the
 * target(s) to move to.
 * @default "// Declare Variables\nconst target = arguments[0];\nlet goalX = 0;\nlet goalY = 0;\n\n// Calculations\ngoalX = Graphics.width / 2;\ngoalY = Graphics.height / 2;\n\n// Return Data\nreturn new Point(goalX, goalY);"
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToPoint
 * @text MOVE: Move To Point
 * @desc Moves unit(s) to a designated point on the screen.
 * Sideview-only! Points based off Graphics.boxWidth/Height.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Destination:str
 * @text Destination Point
 * @type combo
 * @option home
 * @option center
 * @option point x, y
 * @desc Select which point to face.
 * Replace 'x' and 'y' with coordinates
 * @default home
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Destination:str
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_MoveToTarget
 * @text MOVE: Move To Target(s)
 * @desc Moves unit(s) to another unit(s) on the battle field.
 * Sideview-only!
 * 
 * @arg Targets1:arraystr
 * @text Targets (Moving)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move.
 * @default ["user"]
 * 
 * @arg Targets2:arraystr
 * @text Targets (Destination)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to move to.
 * @default ["all targets"]
 * 
 * @arg TargetLocation:str
 * @text Target Location
 * @parent Targets2:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part target group to move to.
 * @default front base
 * 
 * @arg MeleeDistance:eval
 * @text Melee Distance
 * @parent TargetLocation:str
 * @desc The melee distance away from the target location
 * in addition to the battler's width.
 * @default 24
 *
 * @arg OffsetAdjust:str
 * @text Offset Adjustment
 * @parent Targets2:arraystr
 * @type select
 * @option Normal - No adjustments made
 * @value none
 * @option Horizontal - Actors adjust left, Enemies adjust right
 * @value horz
 * @option Vertical - Actors adjust Up, Enemies adjust down
 * @value vert
 * @option Both - Applies both Horizontal and Vertical
 * @value horz + vert
 * @desc Makes adjustments to offset values to determine
 * which direction to adjust the destination by.
 * @default horz
 * 
 * @arg OffsetX:eval
 * @text Offset: X
 * @parent OffsetAdjust:str
 * @desc Horizontal offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg OffsetY:eval
 * @text Offset: Y
 * @parent OffsetAdjust:str
 * @desc Vertical offset to move.
 * You may use JavaScript code.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for total movement amount.
 * @default 12
 * 
 * @arg FaceDirection:eval
 * @text Face Destination?
 * @type boolean
 * @on Turn
 * @off Don't
 * @desc Turn and face the destination?
 * @default true
 *
 * @arg EasingType:str
 * @text Movement Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 *
 * @arg MotionType:str
 * @text Movement Motion
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Play this motion for the unit(s).
 * @default walk
 * 
 * @arg WaitForMovement:eval
 * @text Wait For Movement?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for movement to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Opacity
 * @text MOVE: Opacity
 * @desc Causes the unit(s) to change opacity.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change opacity.
 * @default ["user"]
 * 
 * @arg Opacity:eval
 * @text Desired Opacity
 * @desc Change to this opacity value.
 * You may use JavaScript code.
 * @default 255
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames for opacity change.
 * @default 12
 *
 * @arg EasingType:str
 * @text Opacity Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForOpacity:eval
 * @text Wait For Opacity?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for opacity changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Scale
 * @text MOVE: Scale/Grow/Shrink
 * @desc Causes the unit(s) to scale, grow, or shrink?.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to change the scale of.
 * @default ["user"]
 * 
 * @arg ScaleX:eval
 * @text Scale X
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg ScaleY:eval
 * @text Scale Y
 * @desc What target scale value do you want?
 * 1.0 is normal size.
 * @default 1.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to scale for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Scale Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForScale:eval
 * @text Wait For Scale?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for scaling to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Skew
 * @text MOVE: Skew/Distort
 * @desc Causes the unit(s) to skew.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to skew.
 * @default ["user"]
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc X variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Y variance to skew?
 * Use small values for the best results.
 * @default 0.00
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to skew for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_Spin
 * @text MOVE: Spin/Rotate
 * @desc Causes the unit(s) to spin.
 * Sideview-only!
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to spin.
 * @default ["user"]
 * 
 * @arg Angle:eval
 * @text Angle
 * @desc How many degrees to spin?
 * @default 360
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to spin for.
 * @default 12
 *
 * @arg EasingType:str
 * @text Spin Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default Linear
 * 
 * @arg RevertAngle:eval
 * @text Revert Angle on Finish
 * @type boolean
 * @on Revert
 * @off Don't
 * @desc Revert angle after spinning?
 * @default true
 * 
 * @arg WaitForSpin:eval
 * @text Wait For Spin?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for spin to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForFloat
 * @text MOVE: Wait For Float
 * @desc Waits for floating to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForJump
 * @text MOVE: Wait For Jump
 * @desc Waits for jumping to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForMovement
 * @text MOVE: Wait For Movement
 * @desc Waits for movement to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForOpacity
 * @text MOVE: Wait For Opacity
 * @desc Waits for opacity changes to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForScale
 * @text MOVE: Wait For Scale
 * @desc Waits for scaling to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSkew
 * @text MOVE: Wait For Skew
 * @desc Waits for skewing to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Movement_WaitForSpin
 * @text MOVE: Wait For Spin
 * @desc Waits for spinning to complete before performing next command.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceProjectile
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakProjectile
 * @text Action Sequences - Projectiles
 * @desc Create projectiles on the screen and fire them off at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Animation
 * @text PROJECTILE: Animation
 * @desc Create an animation projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg AnimationID:num
 * @text Animation ID
 * @parent Settings
 * @type animation
 * @desc Determine which animation to use as a projectile.
 * @default 77
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg WaitForAnimation:eval
 * @text Wait For Animation?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for animation to finish before going to the next command?
 * @default false
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExAni>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","EasingType:str":"Linear","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Icon
 * @text PROJECTILE: Icon
 * @desc Create an icon projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Icon:eval
 * @text Icon Index
 * @parent Settings
 * @desc Determine which icon to use as a projectile.
 * You may use JavaScript code.
 * @default 118
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Projectile_Picture
 * @text PROJECTILE: Picture
 * @desc Create a picture projectile and fire it at a target.
 * Requires VisuMZ_3_ActSeqProjectiles!
 * 
 * @arg Coordinates
 *
 * @arg Start:struct
 * @text Start Location
 * @parent Coordinates
 * @type struct<ProjectileStart>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"user\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 *
 * @arg Goal:struct
 * @text Goal Location
 * @parent Coordinates
 * @type struct<ProjectileGoal>
 * @desc Settings to determine where the projectile(s) start from.
 * @default {"Type:str":"target","Targets:arraystr":"[\"all targets\"]","TargetCenter:eval":"false","PointX:eval":"Graphics.width / 2","PointY:eval":"Graphics.height / 2","OffsetX:eval":"+0","OffsetY:eval":"+0"}
 * 
 * @arg Settings
 *
 * @arg Picture:str
 * @text Picture Filename
 * @parent Settings
 * @type file
 * @dir img/pictures/
 * @desc Determine which picture to use as a projectile.
 * @default Untitled
 * 
 * @arg Duration:eval
 * @text Duration
 * @parent Settings
 * @desc Duration for the projectile(s) to travel.
 * @default 20
 * 
 * @arg WaitForProjectile:eval
 * @text Wait For Projectile?
 * @parent Settings
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for projectile(s) to reach their destination before
 * going onto the next command?
 * @default true
 * 
 * @arg Extra:struct
 * @text Extra Settings
 * @type struct<ProjectileExtra>
 * @desc Add extra settings to the projectile?
 * @default {"AutoAngle:eval":"true","AngleOffset:eval":"+0","Arc:eval":"0","BlendMode:num":"0","EasingType:str":"Linear","Hue:eval":"0","Scale:eval":"1.0","Spin:eval":"+0.0"}
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceSkew
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakSkew
 * @text Action Sequences - Skew
 * @desc Allows you to have control over the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_ChangeSkew
 * @text SKEW: Change Skew
 * @desc Changes the camera skew.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg SkewX:eval
 * @text Skew X
 * @desc Change the camera skew X to this value.
 * @default 0
 * 
 * @arg SkewY:eval
 * @text Skew Y
 * @desc Change the camera skew Y to this value.
 * @default 0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_Reset
 * @text SKEW: Reset Skew
 * @desc Reset any skew settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset camera skew.
 * @default 60
 *
 * @arg EasingType:str
 * @text Skew Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForSkew:eval
 * @text Wait For Skew?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for skew changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Skew_WaitForSkew
 * @text SKEW: Wait For Skew
 * @desc Waits for skew changes to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceTarget
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakTarget
 * @text Action Sequences - Target
 * @desc If using a manual target by target Action Sequence,
 * these commands will give you full control over its usage.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_CurrentIndex
 * @text TARGET: Current Index
 * @desc Sets the current index to this value.
 * Then decide to jump to a label (optional).
 * 
 * @arg Index:eval
 * @text Set Index To
 * @desc Sets current targeting index to this value.
 * 0 is the starting index of a target group.
 * @default 0
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_NextTarget
 * @text TARGET: Next Target
 * @desc Moves index forward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_PrevTarget
 * @text TARGET: Previous Target
 * @desc Moves index backward by 1 to select a new current target.
 * Then decide to jump to a label (optional).
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Target_RandTarget
 * @text TARGET: Random Target
 * @desc Sets index randomly to determine new currernt target.
 * Then decide to jump to a label (optional).
 * 
 * @arg ForceRandom:eval
 * @text Force Random?
 * @type boolean
 * @on On
 * @off Off
 * @desc Index cannot be its previous index amount after random.
 * @default false
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a target is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceVoice
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakVoice
 * @text Action Sequences - Voice
 * @desc Allows you to play battle voices.
 * Requires VisuMZ_3_BattleVoices!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlayCommonLine
 * @text VOICE: Play Common Line
 * @desc Plays a common voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLine:str
 * @text Voice Line
 * @type select
 * @option -
 * @value -
 * @option ---Battle Phase---
 * @value -
 * @option On Battle Start
 * @value BattleStart
 * @option On Battle Input
 * @value BattleInput
 * @option On Battle Victory
 * @value BattleVictory
 * @option Victory => Level Up
 * @value BattleVictoryLevelUp
 * @option Escape => Success
 * @value BattleEscapeSuccess
 * @option Escape => Failure
 * @value BattleEscapeFailure
 * @option -
 * @value -
 * @option ---On Action Start---
 * @value -
 * @option Basic Action => Regular Attack
 * @value ActionStartBasicAttack
 * @option Basic Action => Regular Guard
 * @value ActionStartBasicGuard
 * @option Skill Usage For Allies => Certain Hit
 * @value ActionStartSkillAllyCertainHit
 * @option Skill Usage For Allies => Physical
 * @value ActionStartSkillAllyPhysical
 * @option Skill Usage For Allies => Magical
 * @value ActionStartSkillAllyMagical
 * @option Skill Usage For Enemies => Certain Hit
 * @value ActionStartSkillEnemyCertainHit
 * @option Skill Usage For Enemies => Physical
 * @value ActionStartSkillEnemyPhysical
 * @option Skill Usage For Enemies => Magical
 * @value ActionStartSkillEnemyMagical
 * @option Item Usage For Allies
 * @value ActionStartItemAlly
 * @option Item Usage For Enemies
 * @value ActionStartItemEnemy
 * @option -
 * @value -
 * @option ---Perform Action---
 * @value -
 * @option Basic Action => Attack Motion
 * @value PerformActionBasicAttack
 * @option Basic Action => Critical Action
 * @value PerformActionCritical
 * @option Basic Action => Defeat Opponent
 * @value PerformActionDefeatFoe
 * @option Basic Action => Missed Action
 * @value PerformActionMiss
 * @option Skill Usage => Certain Hit
 * @value PerformActionSkillCertainHit
 * @option Skill Usage => Physical
 * @value PerformActionSkillPhysical
 * @option Skill Usage => Magical
 * @value PerformActionSkillMagical
 * @option -
 * @value -
 * @option ---On HP Change---
 * @value -
 * @option Life State => On Death
 * @value HpChangeDeath
 * @option Life State => On Revive
 * @value HpChangeRevive
 * @option On Damage => Damage <= 0%
 * @value HpChangeDamageNone
 * @option On Damage => Damage < 25%
 * @value HpChangeDamageLight
 * @option On Damage => Damage < 50%
 * @value HpChangeDamageMedium
 * @option On Damage => Damage >= 50%
 * @value HpChangeDamageHeavy
 * @option On Damage => Guarding Damage
 * @value HpChangeDamageGuard
 * @option On Recovery => Recovery < 25%
 * @value HpChangeRecoverLight
 * @option On Recovery => Recovery < 50%
 * @value HpChangeRecoverMedium
 * @option On Recovery => Recovery >= 50%
 * @value HpChangeRecoverHeavy
 * @option -
 * @value -
 * @option ---On Action Result---
 * @value -
 * @option On Miss/Evasion
 * @value ActionResultEvasion
 * @option On Magic Evasion
 * @value ActionResultMagicEvasion
 * @option On Counter
 * @value ActionResultCounter
 * @option On Reflection
 * @value ActionResultReflection
 * @option On Substitute
 * @value ActionResultSubstitute
 * @option -
 * @value -
 * @option ---Buff/Debuff Related---
 * @value -
 * @option On Buff Apply
 * @value BuffAdd
 * @option On Buff Remove
 * @value BuffRemove
 * @option On Debuff Apply
 * @value DebuffAdd
 * @option On Debuff Remove
 * @value DebuffRemove
 * @option -
 * @value -
 * @option ---State Related---
 * @value -
 * @option Positive States => On State Apply
 * @value StatePositiveAdd
 * @option Positive States => text On State Remove
 * @value StatePositiveRemove
 * @option Negative States => On State Apply
 * @value StateNegativeAdd
 * @option Negative States => On State Remove
 * @value StateNegativeRemove
 * @option Neutral States => On State Apply
 * @value StateNeutralAdd
 * @option Neutral States => On State Remove
 * @value StateNeutralRemove
 * @option -
 * @value -
 * @option ---Miscellaneous---
 * @value -
 * @option Voice Preview
 * @value CharaCreatePreview
 * @option -
 * @value -
 * @desc What voice line do you wish to play?
 * @default ActionStartBasicAttack
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_BattleVoice_PlaySpecialLine
 * @text VOICE: Play Special Line
 * @desc Plays a special voice line from target battler(s).
 * Requires VisuMZ_3_BattleVoices!
 * 
 * @arg Targets:arraystr
 * @text Speaker Target(s)
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select unit(s) to play voice lines from.
 * @default ["user"]
 *
 * @arg VoiceLineType:str
 * @text Voice Line Type
 * @type select
 * @option Action Name
 * @value ActionName
 * @option Chant Line
 * @value ChantLine
 * @option Item Name
 * @value ItemName
 * @option Skill Name
 * @value SkillName
 * @option Spell Name
 * @value SpellName
 * @option Unique Lines
 * @value UniqueLine
 * @desc What voice line type do you wish to play?
 * @default ActionName
 *
 * @arg Letter:str
 * @text Name / Letter
 * @type select
 * @option A
 * @option B
 * @option C
 * @option D
 * @option E
 * @option F
 * @option G
 * @option H
 * @option I
 * @option J
 * @option K
 * @option L
 * @option M
 * @option N
 * @option O
 * @option P
 * @option Q
 * @option R
 * @option S
 * @option T
 * @option U
 * @option V
 * @option W
 * @option X
 * @option Y
 * @option Z
 * @desc What voice letter/name do you want to play?
 * @default A
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceWeapon
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakWeapon
 * @text Action Sequences - Weapon
 * @desc Allows for finer control over Dual/Multi Wielding actors.
 * Only works for Actors.
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_ClearActiveWeapon
 * @text WEAPON: Clear Weapon Slot
 * @desc Clears the active weapon slot (making others valid again).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to clear the active weapon slot for.
 * @default ["user"]
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_NextActiveWeapon
 * @text WEAPON: Next Weapon Slot
 * @desc Goes to next active weapon slot (making others invalid).
 * If next slot is weaponless, don't label jump.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the next active weapon slot for.
 * @default ["user"]
 * 
 * @arg JumpToLabel:str
 * @text Jump To Label
 * @desc If a weapon is found after the index change,
 * jump to this label in the Common Event.
 * @default Untitled
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Weapon_SetActiveWeapon
 * @text WEAPON: Set Weapon Slot
 * @desc Sets the active weapon slot (making others invalid).
 * Only works for Actors.
 * 
 * @arg Targets:arraystr
 * @text Targets
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @desc Select unit(s) to change the active weapon slot for.
 * @default ["user"]
 * 
 * @arg SlotID:eval
 * @text Weapon Slot ID
 * @desc Select weapon slot to make active (making others invalid).
 * Use 0 to clear and normalize. You may use JavaScript code.
 * @default 1
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceZoom
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceBreakZoom
 * @text Action Sequences - Zoom
 * @desc Allows you to have control over the screen zoom.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Scale
 * @text ZOOM: Change Scale
 * @desc Changes the zoom scale.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Scale:eval
 * @text Scale
 * @desc The zoom scale to change to.
 * @default 1.0
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to change battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_Reset
 * @text ZOOM: Reset Zoom
 * @desc Reset any zoom settings.
 * Requires VisuMZ_3_ActSeqCamera!
 * 
 * @arg Duration:eval
 * @text Duration
 * @desc Duration in frames to reset battle zoom.
 * @default 60
 *
 * @arg EasingType:str
 * @text Zoom Easing
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * Requires VisuMZ_0_CoreEngine.
 * @default InOutSine
 * 
 * @arg WaitForZoom:eval
 * @text Wait For Zoom?
 * @type boolean
 * @on On
 * @off Off
 * @desc Wait for zoom changes to complete before performing next command?
 * @default true
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActSeq_Zoom_WaitForZoom
 * @text ZOOM: Wait For Zoom
 * @desc Waits for zoom to complete before performing next command.
 * Requires VisuMZ_3_ActSeqCamera!
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ActionSequenceSpaceEnd
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleCore
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param AutoBattle:struct
 * @text Auto Battle Settings
 * @type struct<AutoBattle>
 * @desc Settings pertaining to Auto Battle.
 * @default {"BattleDisplay":"","AutoBattleMsg:str":"Press %1 or %2 to stop Auto Battle","AutoBattleOK:str":"OK","AutoBattleCancel:str":"Cancel","AutoBattleBgType:num":"1","AutoBattleRect:func":"\"const width = Graphics.width;\\nconst height = this.calcWindowHeight(1, false);\\nconst x = 0;\\nconst y = (Graphics.height - height) / 2;\\nreturn new Rectangle(x, y, width, height);\"","Options":"","AddOption:eval":"true","AdjustRect:eval":"true","StartName:str":"Auto Battle Start","StyleName:str":"Auto Battle Style","StyleOFF:str":"Attack","StyleON:str":"Skills"}
 *
 * @param Damage:struct
 * @text Damage Settings
 * @type struct<Damage>
 * @desc Settings pertaining to damage calculations.
 * @default {"DamageStyles":"","DefaultDamageStyle:str":"Standard","DamageStyleList:arraystruct":"[\"{\\\"Name:str\\\":\\\"Standard\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"Armor Scaling\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Declare Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Replace Formula\\\\\\\\nlet formula = item.damage.formula;\\\\\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = Math.max(eval(formula), 0);\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"return this.getItemDamageAmountTextOriginal();\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"CT\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\\\\\nvalue = attackStat * 4;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"D4\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nlet stat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n    armor = 0;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n    armor = 0;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"DQ\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Get Primary Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Check for Recovery\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    let value = stat * multiplier * sign;\\\\\\\\n    return isNaN(value) ? 0 : value;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nlet value = 0;\\\\\\\\nif (stat < ((2 + armor) / 2)) {\\\\\\\\n    // Plink Damage\\\\\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\\\\\n    value = baseline / 3;\\\\\\\\n} else {\\\\\\\\n    // Normal Damage\\\\\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\\\\\n    value = baseline / 2;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF7\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare base Damage\\\\\\\\nlet baseDamage = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    baseDamage = 6 * (a.mat + level);\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.def + level);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    baseDamage = 6 * (a.mdf + level);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Final Damage\\\\\\\\nlet value = baseDamage;\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isRecover()) {\\\\\\\\n    value += 22 * power;\\\\\\\\n} else {\\\\\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF8\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Damage\\\\\\\\nlet Value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\\\\\n    value *= power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = a.mat + power;\\\\\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\\\\\n    value *= power / 256;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = (power + a.def) * power / 2;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = (power + a.mdf) * power / 2;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF9\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Main Stats\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(b, armor);\\\\\\\\nlet stat = 1;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    stat = a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    stat = a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    stat = a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Base Damage\\\\\\\\nlet baseDamage = power;\\\\\\\\nif (this.isPhysical()) {\\\\\\\\n    baseDamage += stat;\\\\\\\\n}\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    baseDamage -= armor;\\\\\\\\n    baseDamage = Math.max(1, baseDamage);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Declare Bonus Damage\\\\\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\\\\\n\\\\\\\\n// Declare Final Damage\\\\\\\\nlet value = baseDamage * bonusDamage * sign;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"FF10\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Constant\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\nif (this.isCertainHit()) {\\\\\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Create Damage Offense Value\\\\\\\\nlet value = power;\\\\\\\\n\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.def + power) / 2);\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = power * ((a.mdf + power) / 2);\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Damage Defense Value\\\\\\\\nif (this.isDamage() || this.isDrain()) {\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\\\\\n    armor = Math.max(armor, 1);\\\\\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\\\\\n} else if (this.isRecover()) {\\\\\\\\n    value *= -1;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MK\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Multiplier\\\\\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = this.applyArmorModifiers(target, armor);\\\\\\\\nconst denominator = Math.max(200 + armor, 1);\\\\\\\\n\\\\\\\\n// Calculate Damage \\\\\\\\nlet value = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.atk / denominator;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value = 200 * a.mat / denominator;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.def / 200;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value = 200 * a.mdf / 200;\\\\\\\\n}\\\\\\\\nvalue *= multiplier;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"MOBA\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Damage Value\\\\\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\\\\\n\\\\\\\\n// Apply Attacker's Offense Parameter\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    value *= a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    value *= a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    value *= a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Apply Defender's Defense Parameter\\\\\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\\\\\n\\\\\\\\n    // Calculate Base Armor\\\\\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\\\\\n\\\\\\\\n    // Apply Armor to Damage\\\\\\\\n    if (armor >= 0) {\\\\\\\\n        value *= 100 / (100 + armor);\\\\\\\\n    } else {\\\\\\\\n        value *= 2 - (100 / (100 - armor));\\\\\\\\n    }\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn isNaN(value) ? 0 : value;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Multiplier\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Multiplier\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Multiplier\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    const value = Math.max(eval(formula), 0);\\\\\\\\n    return '%1%'.format(Math.round(value * 100));\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\",\"{\\\"Name:str\\\":\\\"PKMN\\\",\\\"Formula:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst user = this.subject();\\\\\\\\nconst target = arguments[0];\\\\\\\\nconst item = this.item();\\\\\\\\nconst a = this.subject();\\\\\\\\nconst b = target;\\\\\\\\nconst v = $gameVariables._data;\\\\\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\\\\\n\\\\\\\\n// Create Power\\\\\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\\\\\n\\\\\\\\n// Declare Values\\\\\\\\nlet value = 0;\\\\\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\\\\\nlet attackStat = 0;\\\\\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat = a.atk;\\\\\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\\\\\n    attackStat =  a.mat;\\\\\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.def;\\\\\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\\\\\n    attackStat =  a.mdf;\\\\\\\\n}\\\\\\\\n\\\\\\\\n// Calculate Damage\\\\\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\\\\\"\\\",\\\"ItemsEquipsCore\\\":\\\"\\\",\\\"DamageType\\\":\\\"\\\",\\\"DamageType1:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType2:str\\\":\\\"%1 Damage Power\\\",\\\"DamageType3:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType4:str\\\":\\\"%1 Recovery Power\\\",\\\"DamageType5:str\\\":\\\"%1 Drain Power\\\",\\\"DamageType6:str\\\":\\\"%1 Drain Power\\\",\\\"DamageDisplay:func\\\":\\\"\\\\\\\"// Define Constants\\\\\\\\nconst item = this._item;\\\\\\\\nconst formula = item.damage.formula;\\\\\\\\nconst a = this._tempActorA;\\\\\\\\nconst b = this._tempActorB;\\\\\\\\nconst user = a;\\\\\\\\nconst target = b;\\\\\\\\n\\\\\\\\n// Return Value\\\\\\\\ntry {\\\\\\\\n    return formula;\\\\\\\\n} catch (e) {\\\\\\\\n    if ($gameTemp.isPlaytest()) {\\\\\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\\\\\n    }\\\\\\\\n    return '?????';\\\\\\\\n}\\\\\\\"\\\"}\"]","Cap":"","EnableDamageCap:eval":"false","DefaultHardCap:num":"9999","EnableSoftCap:eval":"false","DefaultSoftCap:num":"0.80","DefaultSoftScaler:num":"0.1275","Popups":"","PopupDuration:num":"128","NewPopupBottom:eval":"true","PopupPosition:str":"base","PopupOffsetX:num":"0","PopupOffsetY:num":"0","PopupShiftX:num":"8","PopupShiftY:num":"-28","hpDamageFmt:str":"-%1","hpHealingFmt:str":"+%1","mpDamageFmt:str":"-%1 %2","mpHealingFmt:str":"+%1 %2","CriticalColor:eval":"[255, 0, 0, 160]","CriticalDuration:num":"128","Formulas":"","OverallFormulaJS:func":"\"// Declare Constants\\nconst target = arguments[0];\\nconst critical = arguments[1];\\nconst item = this.item();\\n\\n// Get Base Damage\\nconst baseValue = this.evalDamageFormula(target);\\n\\n// Calculate Element Modifiers\\nlet value = baseValue * this.calcElementRate(target);\\n\\n// Calculate Physical and Magical Modifiers\\nif (this.isPhysical()) {\\n    value *= target.pdr;\\n}\\nif (this.isMagical()) {\\n    value *= target.mdr;\\n}\\n\\n// Apply Healing Modifiers\\nif (baseValue < 0) {\\n    value *= target.rec;\\n}\\n\\n// Apply Critical Modifiers\\nif (critical) {\\n    value = this.applyCritical(value);\\n}\\n\\n// Apply Variance and Guard Modifiers\\nvalue = this.applyVariance(value, item.damage.variance);\\nvalue = this.applyGuard(value, target);\\n\\n// Finalize Damage\\nvalue = Math.round(value);\\nreturn value;\"","VarianceFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst variance = arguments[1];\\n\\n// Calculate Variance\\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\\n\\n// Return Damage\\nreturn damage >= 0 ? damage + v : damage - v;\"","GuardFormulaJS:func":"\"// Declare Constants\\nconst damage = arguments[0];\\nconst target = arguments[1];\\n\\n// Return Damage Early\\nconst note = this.item().note;\\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\\nif (!target.isGuard()) return damage;\\nif (damage < 0) return damage;\\n\\n// Declare Guard Rate\\nlet guardRate = 0.5;\\nguardRate /= target.grd;\\n\\n// Return Damage\\nreturn damage * guardRate;\"","Critical":"","CriticalHitRateJS:func":"\"// Declare Constants\\nconst user = this.subject();\\nconst target = arguments[0];\\n\\n// Create Base Critical Rate\\nlet rate = this.subject().cri * (1 - target.cev);\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<ALWAYS CRITICAL>/i)) {\\n    return 1;\\n}\\nif (note.match(/<SET CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    return Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\\\d+)([%％])>/i)) {\\n    rate *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    rate += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL RATE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL RATE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Apply LUK Buffs/Debuffs\\nconst lukStack = this.subject().buff(7);\\nrate *= 2 ** lukStack;\\n\\n// Return Rate\\nreturn rate;\"","CriticalHitMultiplier:func":"\"// Declare Constants\\nconst user = this.subject();\\nlet damage = arguments[0];\\nlet multiplier = 2.0;\\nlet bonusDamage = this.subject().luk * this.subject().cri;\\nif (this.isHpRecover() || this.isMpRecover()) {\\n    bonusDamage *= -1;\\n}\\n\\n// Apply Notetags\\nconst note = this.item().note;\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\\\d+)([%％])>/i)) {\\n    multiplier = Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    multiplier += Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\\\d+)([%％])>/i)) {\\n    bonusDamage *= Number(RegExp.$1) / 100;\\n}\\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\\\+\\\\-]\\\\d+)([%％])>/i)) {\\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\\n}\\nif (note.match(/<JS CRITICAL DAMAGE>\\\\s*([\\\\s\\\\S]*)\\\\s*<\\\\/JS CRITICAL DAMAGE>/i)) {\\n    const code = String(RegExp.$1);\\n    try {\\n        eval(code);\\n    } catch (e) {\\n        if ($gameTemp.isPlaytest()) console.log(e);\\n    }\\n}\\n\\n// Return Damage\\nreturn damage * multiplier + bonusDamage;\""}
 *
 * @param Mechanics:struct
 * @text Mechanics Settings
 * @type struct<Mechanics>
 * @desc Settings pertaining to various game mechanics.
 * @default {"ActionSpeed":"","AllowRandomSpeed:eval":"false","CalcActionSpeedJS:func":"\"// Declare Constants\\nconst agi = this.subject().agi;\\n\\n// Create Speed\\nlet speed = agi;\\nif (this.allowRandomSpeed()) {\\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\\n}\\nif (this.item()) {\\n    speed += this.item().speed;\\n}\\nif (this.isAttack()) {\\n    speed += this.subject().attackSpeed();\\n}\\n\\n// Return Speed\\nreturn speed;\"","BaseTroop":"","BaseTroopIDs:arraynum":"[\"1\"]","CommonEvents":"","BattleStartEvent:num":"0","BattleEndEvent:num":"0","VictoryEvent:num":"0","DefeatEvent:num":"0","EscapeSuccessEvent:num":"0","EscapeFailEvent:num":"0","Escape":"","CalcEscapeRatioJS:func":"\"// Calculate Escape Ratio\\nlet ratio = 0.5;\\nratio *= $gameParty.agility();\\nratio /= $gameTroop.agility();\\n\\n// Return Ratio\\nreturn ratio;\"","CalcEscapeRaiseJS:func":"\"// Calculate Escape Ratio\\nlet value = 0.1;\\nvalue += $gameParty.aliveMembers().length;\\n\\n// Return Value\\nreturn value;\"","BattleJS":"","PreStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleVictoryJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeSuccessJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","EscapeFailureJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","BattleDefeatJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndBattleJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","TurnJS":"","PreStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostStartTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostEndTurnJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PreRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","PostRegenerateJS:func":"\"// Declare Constants\\nconst user = this;\\nconst target = user;\\nconst a = user;\\nconst b = user;\\n\\n// Perform Actions\\n\"","ActionJS":"","PreStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostStartActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PreApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostDamageJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PostApplyJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst target = arguments[1];\\nconst user = this.subject();\\nconst a = user;\\nconst b = target;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\\n// Return Value\\nreturn value;\"","PreEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\"","PostEndActionJS:func":"\"// Declare Constants\\nconst value = arguments[0];\\nconst user = this.subject();\\nconst target = user;\\nconst a = user;\\nconst b = user;\\nconst action = this;\\nconst item = this.item();\\nconst skill = this.item();\\n\\n// Perform Actions\\n\""}
 *
 * @param CmdWindows
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BattleLayout:struct
 * @text Battle Layout Settings
 * @type struct<BattleLayout>
 * @desc Settings that adjust how the battle layout appears.
 * @default {"Style:str":"default","ListStyle":"","ShowFacesListStyle:eval":"true","CommandWidth:num":"192","XPStyle":"","XPActorCommandLines:num":"4","XPActorDefaultHeight:num":"64","XPSpriteYLocation:str":"name","PotraitStyle":"","ShowPortraits:eval":"true","PortraitScale:num":"0.5","BorderStyle":"","SkillItemBorderCols:num":"1","ShowPortraitsBorderStyle:eval":"true","PortraitScaleBorderStyle:num":"1.25","SkillItemWindows":"","SkillItemMiddleLayout:eval":"false","SkillItemStandardCols:num":"2"}
 *
 * @param BattleLog:struct
 * @text Battle Log Settings
 * @type struct<BattleLog>
 * @desc Settings that adjust how Window_BattleLog behaves.
 * @default {"General":"","BackColor:str":"#000000","MaxLines:num":"10","MessageWait:num":"16","TextAlign:str":"center","BattleLogRectJS:func":"\"const wx = 0;\\nconst wy = 0;\\nconst ww = Graphics.boxWidth;\\nconst wh = this.calcWindowHeight(10, false);\\nreturn new Rectangle(wx, wy, ww, wh);\"","StartTurn":"","StartTurnShow:eval":"true","StartTurnMsg:str":"Turn %1","StartTurnWait:num":"40","DisplayAction":"","ActionCenteredName:eval":"true","ActionSkillMsg1:eval":"false","ActionSkillMsg2:eval":"true","ActionItemMsg:eval":"false","ActionChanges":"","ShowCounter:eval":"true","ShowReflect:eval":"true","ShowSubstitute:eval":"true","ActionResults":"","ShowFailure:eval":"false","ShowCritical:eval":"false","ShowMissEvasion:eval":"false","ShowHpDmg:eval":"false","ShowMpDmg:eval":"false","ShowTpDmg:eval":"false","DisplayStates":"","ShowAddedState:eval":"false","ShowRemovedState:eval":"false","ShowCurrentState:eval":"false","ShowAddedBuff:eval":"false","ShowAddedDebuff:eval":"false","ShowRemovedBuff:eval":"false"}
 *
 * @param BattlebackScale:struct
 * @text Battleback Scaling
 * @type struct<Battleback>
 * @desc Settings that adjust how battlebacks scale.
 * @default {"DefaultStyle:str":"MZ","jsOneForOne:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst scale = 1.0;\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = 0;\\nthis.y = 0;\"","jsScaleToFit:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = this.width / this.bitmap.width;\\nconst ratioY = this.height / this.bitmap.height;\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScaleDown:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\"","jsScale Up:func":"\"// Adjust Size\\nthis.width = Graphics.width;\\nthis.height = Graphics.height;\\n\\n// Adjust Scale\\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\\nconst scale = Math.max(ratioX, ratioY);\\nthis.scale.x = scale;\\nthis.scale.y = scale;\\n\\n// Adjust Coordinates\\nthis.x = (Graphics.width - this.width) / 2;\\nthis.y = Graphics.height - this.height;\""}
 *
 * @param PartyCmd:struct
 * @text Party Command Window
 * @type struct<PartyCmd>
 * @desc Settings that alter the Party Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconFight:num":"76","CommandAddAutoBattle:eval":"true","CmdIconAutoBattle:num":"78","CmdTextAutoBattle:str":"Auto","CommandAddOptions:eval":"true","CmdIconOptions:num":"83","ActiveTpbOptionsMessage:str":"Options Menu queued after action is complete.","CmdIconEscape:num":"82","Access":"","SkipPartyCmd:eval":"true","DisablePartyCmd:eval":"false","HelpWindow":"","HelpFight:str":"Select actions to fight.","HelpAutoBattle:str":"Sets party to Auto Battle mode.","HelpOptions:str":"Opens up the Options Menu.","HelpEscape:str":"Attempt to escape the battle."}
 *
 * @param ActorCmd:struct
 * @text Actor Command Window
 * @type struct<ActorCmd>
 * @desc Settings that alter the Actor Command Window in battle.
 * @default {"Cmd":"","CmdStyle:str":"auto","CmdTextAlign:str":"left","CmdIconItem:num":"176","IconStypeNorm:num":"78","IconStypeMagic:num":"79","BattleCmd":"","BattleCmdList:arraystr":"[\"attack\",\"skills\",\"guard\",\"item\",\"escape\"]","HelpWindow":"","HelpSkillType:str":"Opens up a list of skills under the \\C[16]%1\\C[0] category.","HelpItem:str":"Opens up a list of items that you can use.","HelpEscape:str":"Attempt to escape the battle.","HelpAutoBattle:str":"Automatically choose an action suitable for combat."}
 * 
 * @param MultiTarget:struct
 * @text Multi-Target Windows
 * @type struct<MultiTarget>
 * @desc Settings that alter the Multi-Target Windows in battle.
 * @default {"Properties":"","WindowWidth:num":"280","BgType:num":"2","ShowButton:eval":"true","Vocab":"","AllActorsText:str":"All Allies","AllEnemiesText:str":"All Enemies","Offsets":"","ActorOffsets":"","ActorOffsetX:num":"+0","ActorOffsetY:num":"+0","EnemyOffsets":"","EnemyOffsetX:num":"+0","EnemyOffsetY:num":"+0"}
 *
 * @param VisualBreak
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param Actor:struct
 * @text Actor Battler Settings
 * @type struct<Actor>
 * @desc Settings that alter various properties for actors.
 * @default {"Flinch":"","FlinchDistanceX:num":"12","FlinchDistanceY:num":"0","FlinchDuration:num":"6","SvBattlers":"","AnchorX:num":"0.5","AnchorY:num":"1.0","ChantStyle:eval":"true","OffsetX:num":"0","OffsetY:num":"0","MotionSpeed:num":"12","PrioritySortActive:eval":"true","PrioritySortActors:eval":"false","Shadow:eval":"true","SmoothImage:eval":"true","HomePosJS:func":"\"// Declare Constants\\nconst sprite = this;\\nconst actor = this._actor;\\nconst index = arguments[0];\\n\\n// Make Calculations\\nlet x = Math.round((Graphics.width / 2) + 192)\\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\\nx += index * 32;\\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\\ny += index * 48;\\n\\n// Home Position Offsets\\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\\\+\\\\-]\\\\d+),[ ]([\\\\+\\\\-]\\\\d+)>/i;\\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\\nx = xOffsets.reduce((r, offset) => r + offset, x);\\ny = yOffsets.reduce((r, offset) => r + offset, y);\\n\\n// Set Home Position\\nthis.setHome(x, y);\""}
 *
 * @param Enemy:struct
 * @text Enemy Battler Settings
 * @type struct<Enemy>
 * @desc Settings that alter various properties for enemies.
 * @default {"Visual":"","AttackAnimation:num":"1","EmergeText:eval":"false","OffsetX:num":"0","OffsetY:num":"0","SmoothImage:eval":"true","SelectWindow":"","FrontViewSelect:eval":"false","SideviewSelect:eval":"true","NameFontSize:num":"22","SvBattlers":"","AllowCollapse:eval":"false","AnchorX:num":"0.5","AnchorY:num":"1.0","MotionIdle:str":"walk","Shadow:eval":"true","Width:num":"64","Height:num":"64","WtypeId:num":"0"}
 *
 * @param HpGauge:struct
 * @text HP Gauge Settings
 * @type struct<HpGauge>
 * @desc Settings that adjust the visual HP Gauge displayed in battle.
 * @default {"Display":"","ShowActorGauge:eval":"false","ShowEnemyGauge:eval":"true","RequiresDefeat:eval":"false","BTestBypass:eval":"true","Settings":"","AnchorX:num":"0.5","AnchorY:num":"1.0","Scale:num":"0.5","OffsetX:num":"0","OffsetY:num":"-3","Options":"","AddHpGaugeOption:eval":"true","AdjustRect:eval":"true","Name:str":"Show HP Gauge"}
 *
 * @param ActionSequence:struct
 * @text Action Sequence Settings
 * @type struct<ActionSequence>
 * @desc Settings that adjust how certain Action Sequences work.
 * @default {"AutoSequences":"","AutoMeleeSolo:eval":"true","AutoMeleeAoE:eval":"true","CastAnimations":"","CastCertain:num":"120","CastPhysical:num":"52","CastMagical:num":"51","CounterReflection":"","CounterPlayback:eval":"true","ReflectAnimation:num":"53","ReflectPlayback:eval":"true","Stepping":"","MeleeDistance:num":"24","StepDistanceX:num":"48","StepDistanceY:num":"0","StepDuration:num":"12"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Auto Battle Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~AutoBattle:
 *
 * @param BattleDisplay
 * @text Battle Display
 *
 * @param AutoBattleMsg:str
 * @text Message
 * @parent BattleDisplay
 * @desc Message that's displayed when Auto Battle is on.
 * Text codes allowed. %1 - OK button, %2 - Cancel button
 * @default Press %1 or %2 to stop Auto Battle
 *
 * @param AutoBattleOK:str
 * @text OK Button
 * @parent BattleDisplay
 * @desc Text used to represent the OK button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default OK
 *
 * @param AutoBattleCancel:str
 * @text Cancel Button
 * @parent BattleDisplay
 * @desc Text used to represent the Cancel button.
 * If VisuMZ_0_CoreEngine is present, ignore this.
 * @default Cancel
 *
 * @param AutoBattleBgType:num
 * @text Background Type
 * @parent BattleDisplay
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for Auto Battle window.
 * @default 1
 *
 * @param AutoBattleRect:func
 * @text JS: X, Y, W, H
 * @parent BattleDisplay
 * @type note
 * @desc Code used to determine the dimensions for this window.
 * @default "const width = Graphics.width;\nconst height = this.calcWindowHeight(1, false);\nconst x = 0;\nconst y = (Graphics.height - height) / 2;\nreturn new Rectangle(x, y, width, height);"
 *
 * @param Options
 *
 * @param AddOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the Auto Battle options to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param StartName:str
 * @text Startup Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Start
 *
 * @param StyleName:str
 * @text Style Name
 * @parent Options
 * @desc Command name of the option.
 * @default Auto Battle Style
 *
 * @param StyleOFF:str
 * @text OFF
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is OFF.
 * @default Attack
 *
 * @param StyleON:str
 * @text ON
 * @parent StyleName:str
 * @desc Text displayed when Auto Battle Style is ON.
 * @default Skills
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Damage:
 *
 * @param DamageStyles
 * @text Damage Styles
 *
 * @param DefaultDamageStyle:str
 * @text Default Style
 * @parent DamageStyles
 * @desc Which Damage Style do you want to set as default?
 * Use 'Manual' to not use any styles at all.
 * @default Standard
 *
 * @param DamageStyleList:arraystruct
 * @text Style List
 * @parent DamageStyles
 * @type struct<DamageStyle>[]
 * @desc A list of the damage styles available.
 * These are used to calculate base damage.
 * @default ["{\"Name:str\":\"Standard\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 0)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"Armor Scaling\",\"Formula:func\":\"\\\"// Declare Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Replace Formula\\\\nlet formula = item.damage.formula;\\\\nif (SceneManager.isSceneBattle() && !this.isCertainHit()) {\\\\n    const fmt = 'Math.max(this.applyArmorModifiers(b, %1), 1)';\\\\n    formula = formula.replace(/b.def/g, fmt.format('b.def'));\\\\n    formula = formula.replace(/b.mdf/g, fmt.format('b.mdf'));\\\\n    formula = formula.replace(/b.agi/g, fmt.format('b.agi'));\\\\n    formula = formula.replace(/b.luk/g, fmt.format('b.luk'));\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = Math.max(eval(formula), 0);\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"return this.getItemDamageAmountTextOriginal();\\\"\"}","{\"Name:str\":\"CT\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nattackStat = (attackStat * 1.75) + (level ** 2 / 45.5);\\\\nvalue = attackStat * 4;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(256 - armor, 0) / 256;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= Math.max(102.4 - armor, 0) / 128;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"D4\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nlet stat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n    armor = 0;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n    armor = 0;\\\\n}\\\\n\\\\n// Calculate Damage \\\\nlet value = 1.5 * Math.max(2 * stat * multiplier - armor, 1) * multiplier / 5;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"DQ\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nlet multiplier = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    let value = multiplier * Math.max(a.atk, a.mat);\\\\n    return (isNaN(value) ? 0 : value) * sign;\\\\n}\\\\n\\\\n// Get Primary Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Check for Recovery\\\\nif (this.isRecover()) {\\\\n    let value = stat * multiplier * sign;\\\\n    return isNaN(value) ? 0 : value;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nlet value = 0;\\\\nif (stat < ((2 + armor) / 2)) {\\\\n    // Plink Damage\\\\n    let baseline = Math.max(stat - ((12 * (armor - stat + 1)) / stat), 5);\\\\n    value = baseline / 3;\\\\n} else {\\\\n    // Normal Damage\\\\n    let baseline = Math.max(stat - (armor / 2), 1);\\\\n    value = baseline / 2;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF7\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare base Damage\\\\nlet baseDamage = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = a.atk + ((a.atk + level) / 32) * ((a.atk * level) / 32);\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    baseDamage = 6 * (a.mat + level);\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.def + level);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    baseDamage = 6 * (a.mdf + level);\\\\n}\\\\n\\\\n// Calculate Final Damage\\\\nlet value = baseDamage;\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isRecover()) {\\\\n    value += 22 * power;\\\\n} else {\\\\n    value = (power * Math.max(512 - armor, 1) * baseDamage) / (16 * 512);\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF8\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Damage\\\\nlet Value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.atk ** 2 / 16 + a.atk;\\\\n    value *= Math.max(265 - armor, 1) / 256;\\\\n    value *= power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = a.mat + power;\\\\n    value *= Math.max(265 - armor, 1) / 4;\\\\n    value *= power / 256;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = (power + a.def) * power / 2;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = (power + a.mdf) * power / 2;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF9\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Declare Main Stats\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(b, armor);\\\\nlet stat = 1;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    stat = a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    stat = a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    stat = a.mdf;\\\\n}\\\\n\\\\n// Declare Base Damage\\\\nlet baseDamage = power;\\\\nif (this.isPhysical()) {\\\\n    baseDamage += stat;\\\\n}\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    baseDamage -= armor;\\\\n    baseDamage = Math.max(1, baseDamage);\\\\n}\\\\n\\\\n// Declare Bonus Damage\\\\nlet bonusDamage = stat + (((a.level || a.luk) + stat) / 8);\\\\n\\\\n// Declare Final Damage\\\\nlet value = baseDamage * bonusDamage * sign;\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"FF10\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Constant\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\nif (this.isCertainHit()) {\\\\n    return (isNaN(power) ? 0 : power) * sign;\\\\n}\\\\n\\\\n// Create Damage Offense Value\\\\nlet value = power;\\\\n\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = (((a.atk ** 3) / 32) + 32) * power / 16;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = power * ((a.mat ** 2 / 6) + power) / 4;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = power * ((a.def + power) / 2);\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = power * ((a.mdf + power) / 2);\\\\n}\\\\n\\\\n// Apply Damage Defense Value\\\\nif (this.isDamage() || this.isDrain()) {\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(b, armor);\\\\n    armor = Math.max(armor, 1);\\\\n    value *= ((((armor - 280.4) ** 2) / 110) / 16) / 730;\\\\n    value *= (730 - (armor * 51 - (armor ** 2) / 11) / 10) / 730;\\\\n} else if (this.isRecover()) {\\\\n    value *= -1;\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MK\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Multiplier\\\\nconst multiplier = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = this.applyArmorModifiers(target, armor);\\\\nconst denominator = Math.max(200 + armor, 1);\\\\n\\\\n// Calculate Damage \\\\nlet value = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.atk / denominator;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value = 200 * a.mat / denominator;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value = 200 * a.def / 200;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value = 200 * a.mdf / 200;\\\\n}\\\\nvalue *= multiplier;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"MOBA\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Damage Value\\\\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\\\\n\\\\n// Apply Attacker's Offense Parameter\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    value *= a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    value *= a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    value *= a.mdf;\\\\n}\\\\n\\\\n// Apply Defender's Defense Parameter\\\\nif (this.isDamage() && !this.isCertainHit()) {\\\\n\\\\n    // Calculate Base Armor\\\\n    let armor = this.isPhysical() ? b.def : b.mdf;\\\\n    armor = this.applyArmorModifiers(target, armor);\\\\n\\\\n    // Apply Armor to Damage\\\\n    if (armor >= 0) {\\\\n        value *= 100 / (100 + armor);\\\\n    } else {\\\\n        value *= 2 - (100 / (100 - armor));\\\\n    }\\\\n}\\\\n\\\\n// Return Value\\\\nreturn isNaN(value) ? 0 : value;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Multiplier\",\"DamageType2:str\":\"%1 Damage Multiplier\",\"DamageType3:str\":\"%1 Recovery Multiplier\",\"DamageType4:str\":\"%1 Recovery Multiplier\",\"DamageType5:str\":\"%1 Drain Multiplier\",\"DamageType6:str\":\"%1 Drain Multiplier\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    const value = Math.max(eval(formula), 0);\\\\n    return '%1%'.format(Math.round(value * 100));\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}","{\"Name:str\":\"PKMN\",\"Formula:func\":\"\\\"// Define Constants\\\\nconst user = this.subject();\\\\nconst target = arguments[0];\\\\nconst item = this.item();\\\\nconst a = this.subject();\\\\nconst b = target;\\\\nconst v = $gameVariables._data;\\\\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\\\\n\\\\n// Create Power\\\\nconst power = Math.max(eval(item.damage.formula), 0);\\\\n\\\\n// Declare Values\\\\nlet value = 0;\\\\nlet level = Math.max(a.level || a.luk, 1);\\\\nlet armor = this.isPhysical() ? b.def : b.mdf;\\\\narmor = Math.max(this.applyArmorModifiers(target, armor), 0);\\\\nlet attackStat = 0;\\\\nif (this.isPhysical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat = a.atk;\\\\n} else if (this.isMagical() && (this.isDamage() || this.isDrain())) {\\\\n    attackStat =  a.mat;\\\\n} else if (this.isPhysical() && this.isRecover()) {\\\\n    attackStat =  a.def;\\\\n} else if (this.isMagical() && this.isRecover()) {\\\\n    attackStat =  a.mdf;\\\\n}\\\\n\\\\n// Calculate Damage\\\\nvalue = (((((2 * level) / 5) + 2) * power * (attackStat / armor)) / 50) + 2;\\\\n\\\\n// Return Value\\\\nreturn (isNaN(value) ? 0 : value) * sign;\\\"\",\"ItemsEquipsCore\":\"\",\"DamageType\":\"\",\"DamageType1:str\":\"%1 Damage Power\",\"DamageType2:str\":\"%1 Damage Power\",\"DamageType3:str\":\"%1 Recovery Power\",\"DamageType4:str\":\"%1 Recovery Power\",\"DamageType5:str\":\"%1 Drain Power\",\"DamageType6:str\":\"%1 Drain Power\",\"DamageDisplay:func\":\"\\\"// Define Constants\\\\nconst item = this._item;\\\\nconst formula = item.damage.formula;\\\\nconst a = this._tempActorA;\\\\nconst b = this._tempActorB;\\\\nconst user = a;\\\\nconst target = b;\\\\n\\\\n// Return Value\\\\ntry {\\\\n    return formula;\\\\n} catch (e) {\\\\n    if ($gameTemp.isPlaytest()) {\\\\n        console.log('Damage Formula Error for %1'.format(this._item.name));\\\\n    }\\\\n    return '?????';\\\\n}\\\"\"}"]
 *
 * @param Cap
 * @text Damage Cap
 *
 * @param EnableDamageCap:eval
 * @text Enable Damage Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Put a maximum hard damage cap on how far damage can go?
 * This can be broken through the usage of notetags.
 * @default false
 *
 * @param DefaultHardCap:num
 * @text Default Hard Cap
 * @parent EnableDamageCap:eval
 * @type number
 * @min 1
 * @desc The default hard damage cap used before applying damage.
 * @default 9999
 *
 * @param EnableSoftCap:eval
 * @text Enable Soft Cap?
 * @parent Cap
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Soft caps ease in the damage values leading up to the 
 * hard damage cap. Requires hard Damage Cap enabled.
 * @default false
 *
 * @param DefaultSoftCap:num
 * @text Base Soft Cap Rate
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.80
 *
 * @param DefaultSoftScaler:num
 * @text Soft Scale Constant
 * @parent EnableSoftCap:eval
 * @desc The default soft damage cap used before applying damage.
 * @default 0.1275
 *
 * @param Popups
 *
 * @param PopupDuration:num
 * @text Popup Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a popup stays visible.
 * @default 128
 *
 * @param NewPopupBottom:eval
 * @text Newest Popups Bottom
 * @parent Popups
 * @type boolean
 * @on Bottom
 * @off Top
 * @desc Puts the newest popups at the bottom.
 * @default true
 *
 * @param PopupPosition:str
 * @text Appear Position
 * @parent Popups
 * @type select
 * @option Head - At the top of the battler.
 * @value head
 * @option Center - At the center of the battler.
 * @value center
 * @option Base - At the foot of the battler.
 * @value base
 * @desc Selects where you want popups to appear relative to the battler.
 * @default base
 *
 * @param EndBattlePopups:eval
 * @text End Battle Show?
 * @parent Popups
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide popups upon victory or escape?
 * Used to hide battle-state removal popups.
 * @default true
 *
 * @param PopupOffsetX:num
 * @text Offset X
 * @parent Popups
 * @desc Sets how much to offset the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param PopupOffsetY:num
 * @text Offset Y
 * @parent Popups
 * @desc Sets how much to offset the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param PopupShiftX:num
 * @text Shift X
 * @parent Popups
 * @desc Sets how much to shift the sprites by horizontally.
 * Negative values go left. Positive values go right.
 * @default 8
 *
 * @param PopupShiftY:num
 * @text Shift Y
 * @parent Popups
 * @desc Sets how much to shift the sprites by vertically.
 * Negative values go up. Positive values go down.
 * @default -28
 *
 * @param hpDamageFmt:str
 * @text HP Damage Format
 * @parent Popups
 * @desc Determines HP damage format for popup.
 * %1 - Value, %2 - HP Text
 * @default -%1
 *
 * @param hpHealingFmt:str
 * @text HP Healing Format
 * @parent Popups
 * @desc Determines HP healing format for popup.
 * %1 - Value, %2 - HP Text
 * @default +%1
 *
 * @param mpDamageFmt:str
 * @text MP Damage Format
 * @parent Popups
 * @desc Determines MP damage format for popup.
 * %1 - Value, %2 - MP Text
 * @default -%1 %2
 *
 * @param mpHealingFmt:str
 * @text MP Healing Format
 * @parent Popups
 * @desc Determines MP healing format for popup.
 * %1 - Value, %2 - MP Text
 * @default +%1 %2
 *
 * @param CriticalColor:eval
 * @text Critical Flash Color
 * @parent Popups
 * @desc Adjust the popup's flash color.
 * Format: [red, green, blue, alpha]
 * @default [255, 0, 0, 160]
 *
 * @param CriticalDuration:num
 * @text Critical Duration
 * @parent Popups
 * @type number
 * @min 1
 * @desc Adjusts how many frames a the flash lasts.
 * @default 128
 *
 * @param Formulas
 *
 * @param OverallFormulaJS:func
 * @text JS: Overall Formula
 * @parent Formulas
 * @type note
 * @desc The overall formula used when calculating damage.
 * @default "// Declare Constants\nconst target = arguments[0];\nconst critical = arguments[1];\nconst item = this.item();\n\n// Get Base Damage\nconst baseValue = this.evalDamageFormula(target);\n\n// Calculate Element Modifiers\nlet value = baseValue * this.calcElementRate(target);\n\n// Calculate Physical and Magical Modifiers\nif (this.isPhysical()) {\n    value *= target.pdr;\n}\nif (this.isMagical()) {\n    value *= target.mdr;\n}\n\n// Apply Healing Modifiers\nif (baseValue < 0) {\n    value *= target.rec;\n}\n\n// Apply Critical Modifiers\nif (critical) {\n    value = this.applyCritical(value);\n}\n\n// Apply Variance and Guard Modifiers\nvalue = this.applyVariance(value, item.damage.variance);\nvalue = this.applyGuard(value, target);\n\n// Finalize Damage\nvalue = Math.round(value);\nreturn value;"
 *
 * @param VarianceFormulaJS:func
 * @text JS: Variance Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage variance.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst variance = arguments[1];\n\n// Calculate Variance\nconst amp = Math.floor(Math.max((Math.abs(damage) * variance) / 100, 0));\nconst v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;\n\n// Return Damage\nreturn damage >= 0 ? damage + v : damage - v;"
 *
 * @param GuardFormulaJS:func
 * @text JS: Guard Formula
 * @parent Formulas
 * @type note
 * @desc The formula used when damage is guarded.
 * @default "// Declare Constants\nconst damage = arguments[0];\nconst target = arguments[1];\n\n// Return Damage Early\nconst note = this.item().note;\nif (note.match(/<UNBLOCKABLE>/i)) return damage;\nif (!target.isGuard()) return damage;\nif (damage < 0) return damage;\n\n// Declare Guard Rate\nlet guardRate = 0.5;\nguardRate /= target.grd;\n\n// Return Damage\nreturn damage * guardRate;"
 *
 * @param Critical
 * @text Critical Hits
 *
 * @param CriticalHitRateJS:func
 * @text JS: Rate Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Rates.
 * @default "// Declare Constants\nconst user = this.subject();\nconst target = arguments[0];\n\n// Create Base Critical Rate\nlet rate = this.subject().cri * (1 - target.cev);\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<ALWAYS CRITICAL>/i)) {\n    return 1;\n}\nif (note.match(/<SET CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    return Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ](\\d+)([%％])>/i)) {\n    rate *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL RATE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    rate += Number(RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL RATE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL RATE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Apply LUK Buffs/Debuffs\nconst lukStack = this.subject().buff(7);\nrate *= 2 ** lukStack;\n\n// Return Rate\nreturn rate;"
 *
 * @param CriticalHitMultiplier:func
 * @text JS: Damage Formula
 * @parent Critical
 * @type note
 * @desc The formula used to calculate Critical Hit Damage modification.
 * @default "// Declare Constants\nconst user = this.subject();\nlet damage = arguments[0];\nlet multiplier = 2.0;\nlet bonusDamage = this.subject().luk * this.subject().cri;\n\n// Apply Notetags\nconst note = this.item().note;\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ](\\d+)([%％])>/i)) {\n    multiplier = Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL MULTIPLIER:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    multiplier += Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ](\\d+)([%％])>/i)) {\n    bonusDamage *= Number(RegExp.$1) / 100;\n}\nif (note.match(/<MODIFY CRITICAL BONUS DAMAGE:[ ]([\\+\\-]\\d+)([%％])>/i)) {\n    bonusDamage += bonusDamage * (RegExp.$1) / 100;\n}\nif (note.match(/<JS CRITICAL DAMAGE>\\s*([\\s\\S]*)\\s*<\\/JS CRITICAL DAMAGE>/i)) {\n    const code = String(RegExp.$1);\n    try {\n        eval(code);\n    } catch (e) {\n        if ($gameTemp.isPlaytest()) console.log(e);\n    }\n}\n\n// Return Damage\nreturn damage * multiplier + bonusDamage;"
 *
 */
/* ----------------------------------------------------------------------------
 * Damage Formula Style
 * ----------------------------------------------------------------------------
 */
/*~struct~DamageStyle:
 *
 * @param Name:str
 * @text Name
 * @desc Name of this Damage Style.
 * Used for notetags and such.
 * @default Untitled
 *
 * @param Formula:func
 * @text JS: Formula
 * @parent Name:str
 * @type note
 * @desc The base formula for this Damage Style.
 * @default "// Define Constants\nconst item = this.item();\nconst a = this.subject();\nconst b = target;\nconst sign = [3, 4].includes(item.damage.type) ? -1 : 1;\n\n// Create Damage Value\nlet value = Math.max(eval(item.damage.formula), 0) * sign;\n\n// Return Value\nreturn isNaN(value) ? 0 : value;"
 *
 * @param ItemsEquipsCore
 * @text Items & Equips Core
 *
 * @param DamageType
 * @text Damage Label
 * @parent ItemsEquipsCore
 *
 * @param DamageType1:str
 * @text HP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType2:str
 * @text MP Damage
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Damage Multiplier
 *
 * @param DamageType3:str
 * @text HP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType4:str
 * @text MP Recovery
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Recovery Multiplier
 *
 * @param DamageType5:str
 * @text HP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageType6:str
 * @text MP Drain
 * @parent DamageType
 * @desc Vocabulary used for this data entry.
 * @default %1 Drain Multiplier
 *
 * @param DamageDisplay:func
 * @text JS: Damage Display
 * @parent ItemsEquipsCore
 * @type note
 * @desc Code used the data displayed for this category.
 * @default "// Define Constants\nconst item = this._item;\nconst formula = item.damage.formula;\nconst a = this._tempActorA;\nconst b = this._tempActorB;\nconst user = a;\nconst target = b;\n\n// Return Value\ntry {\n    const value = Math.max(eval(formula), 0);\n    return '%1%'.format(Math.round(value * 100));\n} catch (e) {\n    if ($gameTemp.isPlaytest()) {\n        console.log('Damage Formula Error for %1'.format(this._item.name));\n    }\n    return '?????';\n}"
 *
 */
/* ----------------------------------------------------------------------------
 * Mechanics Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Mechanics:
 *
 * @param ActionSpeed
 * @text Action Speed
 *
 * @param AllowRandomSpeed:eval
 * @text Allow Random Speed?
 * @parent ActionSpeed
 * @type boolean
 * @on Allow
 * @off Disable
 * @desc Allow speed to be randomized base off the user's AGI?
 * @default false
 *
 * @param SyncBuffExpire:eval
 * @text Turn End Buffs Expire
 * @parent ActionSpeed
 * @type boolean
 * @on Expire
 * @off Don't Expire
 * @desc Normally, buffs expire after all actions end.
 * But here, you can have buffs expire on turn end.
 * @default false
 *
 * @param CalcActionSpeedJS:func
 * @text JS: Calculate
 * @parent ActionSpeed
 * @type note
 * @desc Code used to calculate action speed.
 * @default "// Declare Constants\nconst agi = this.subject().agi;\n\n// Create Speed\nlet speed = agi;\nif (this.allowRandomSpeed()) {\n    speed += Math.randomInt(Math.floor(5 + agi / 4));\n}\nif (this.item()) {\n    speed += this.item().speed;\n}\nif (this.isAttack()) {\n    speed += this.subject().attackSpeed();\n}\n\n// Return Speed\nreturn speed;"
 *
 * @param BaseTroop
 * @text Base Troop
 *
 * @param BaseTroopIDs:arraynum
 * @text Base Troop ID's
 * @parent BaseTroop
 * @type troop[]
 * @desc Select the Troop ID(s) to duplicate page events from for all other troops.
 * @default ["1"]
 *
 * @param CommonEvents
 * @text Common Events (on Map)
 *
 * @param BattleStartEvent:num
 * @text Pre-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Common Event to run before each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param BattleEndEvent:num
 * @text Post-Battle Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run after each battle on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param VictoryEvent:num
 * @text Victory Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon victory on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param DefeatEvent:num
 * @text Defeat Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon defeat on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeSuccessEvent:num
 * @text Escape Success Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape success on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param EscapeFailEvent:num
 * @text Escape Fail Event
 * @parent CommonEvents
 * @type common_event
 * @desc Queued Common Event to run upon escape failure on map.
 * Use to 0 to not run any Common Event at all.
 * @default 0
 *
 * @param Escape
 *
 * @param CalcEscapeRatioJS:func
 * @text JS: Calc Escape Ratio
 * @parent Escape
 * @type note
 * @desc Code used to calculate the escape success ratio.
 * @default "// Calculate Escape Ratio\nlet ratio = 0.5;\nratio *= $gameParty.agility();\nratio /= $gameTroop.agility();\n\n// Return Ratio\nreturn ratio;"
 *
 * @param CalcEscapeRaiseJS:func
 * @text JS: Calc Escape Raise
 * @parent Escape
 * @type note
 * @desc Code used to calculate how much the escape success ratio raises upon each failure.
 * @default "// Calculate Escape Ratio\nlet value = 0.1;\nvalue += $gameParty.aliveMembers().length;\n\n// Return Value\nreturn value;"
 *
 * @param Switches
 *
 * @param SwitchCritical:num
 * @text Switch: Critical
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action performs a critical hit.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param SwitchMissEvade:num
 * @text Switch: Miss/Evade
 * @parent Switches
 * @type switch
 * @desc Turns switch ON if the action misses/is evaded.
 * Switch reverts to OFF whenever an action starts.
 * @default 0
 *
 * @param Variables
 *
 * @param VariableDmg:num
 * @text Variable: Damage
 * @parent Variables
 * @type variable
 * @desc Variable records target damage during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param VariableHeal:num
 * @text Variable: Healing
 * @parent Variables
 * @type variable
 * @desc Variable records target healing during action.
 * Variable reverts to 0 whenever an action starts.
 * @default 0
 *
 * @param BattleJS
 * @text JS: Battle-Related
 * 
 * @param PreStartBattleJS:func
 * @text JS: Pre-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartBattleJS:func
 * @text JS: Post-Start Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.startBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleVictoryJS:func
 * @text JS: Battle Victory
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processVictory()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeSuccessJS:func
 * @text JS: Escape Success
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeSuccess()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param EscapeFailureJS:func
 * @text JS: Escape Failure
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.onEscapeFailure()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param BattleDefeatJS:func
 * @text JS: Battle Defeat
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.processDefeat()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 * 
 * @param PreEndBattleJS:func
 * @text JS: Pre-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndBattleJS:func
 * @text JS: Post-End Battle
 * @parent BattleJS
 * @type note
 * @desc Target function: BattleManager.endBattle()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param TurnJS
 * @text JS: Turn-Related
 *
 * @param PreStartTurnJS:func
 * @text JS: Pre-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostStartTurnJS:func
 * @text JS: Post-Start Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: BattleManager.startTurn()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreEndTurnJS:func
 * @text JS: Pre-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostEndTurnJS:func
 * @text JS: Post-End Turn
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.onTurnEnd()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PreRegenerateJS:func
 * @text JS: Pre-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param PostRegenerateJS:func
 * @text JS: Post-Regenerate
 * @parent TurnJS
 * @type note
 * @desc Target function: Game_Battler.prototype.regenerateAll()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst user = this;\nconst target = user;\nconst a = user;\nconst b = user;\n\n// Perform Actions\n"
 *
 * @param ActionJS
 * @text JS: Action-Related
 *
 * @param PreStartActionJS:func
 * @text JS: Pre-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostStartActionJS:func
 * @text JS: Post-Start Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.startAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PreApplyJS:func
 * @text JS: Pre-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreDamageJS:func
 * @text JS: Pre-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostDamageJS:func
 * @text JS: Post-Damage
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.executeDamage()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PostApplyJS:func
 * @text JS: Post-Apply
 * @parent ActionJS
 * @type note
 * @desc Target function: Game_Action.prototype.apply()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst target = arguments[1];\nconst user = this.subject();\nconst a = user;\nconst b = target;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n\n// Return Value\nreturn value;"
 *
 * @param PreEndActionJS:func
 * @text JS: Pre-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs before function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 * @param PostEndActionJS:func
 * @text JS: Post-End Action
 * @parent ActionJS
 * @type note
 * @desc Target function: BattleManager.endAction()
 * JavaScript code occurs after function is run.
 * @default "// Declare Constants\nconst value = arguments[0];\nconst user = this.subject();\nconst target = user;\nconst a = user;\nconst b = user;\nconst action = this;\nconst item = this.item();\nconst skill = this.item();\n\n// Perform Actions\n"
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Layout Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLayout:
 *
 * @param Style:str
 * @text Battle Layout Style
 * @type select
 * @option Default - Shows actor faces in Battle Status.
 * @value default
 * @option List - Lists actors in Battle Status.
 * @value list
 * @option XP - Shows actor battlers in a stretched Battle Status.
 * @value xp
 * @option Portrait - Shows portraits in a stretched Battle Status.
 * @value portrait
 * @option Border - Displays windows around the screen border.
 * @value border
 * @option Frontview Battle UI - Requires VisuMZ_3_FrontviewBattleUI
 * @value frontview_ui
 * @option Sideview Battle UI - Requires VisuMZ_3_SideviewBattleUI
 * @value sideview_ui
 * @desc The style used for the battle layout.
 * @default default
 *
 * @param ListStyle
 * @text List Style
 * @parent Style:str
 *
 * @param ShowFacesListStyle:eval
 * @text Show Faces
 * @parent ListStyle
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows faces in List Style?
 * @default true
 *
 * @param CommandWidth:num
 * @text Command Window Width
 * @parent ListStyle
 * @type number
 * @min 1
 * @desc Determine the window width for the Party and Actor Command
 * Windows. Affects Default and List Battle Layout styles.
 * @default 192
 *
 * @param XPStyle
 * @text XP Style
 * @parent Style:str
 *
 * @param XPActorCommandLines:num
 * @text Command Lines
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Number of action lines in the Actor Command Window for the XP Style.
 * @default 4
 *
 * @param XPActorDefaultHeight:num
 * @text Sprite Height
 * @parent XPStyle
 * @type number
 * @min 1
 * @desc Default sprite height used when if the sprite's height has not been determined yet.
 * @default 64
 *
 * @param XPSpriteYLocation:str
 * @text Sprite Base Location
 * @parent XPStyle
 * @type select
 * @option Above Name - Sprite is located above the name.
 * @value name
 * @option Bottom - Sprite is located at the bottom of the window.
 * @value bottom
 * @option Centered - Sprite is centered in the window.
 * @value center
 * @option Top - Sprite is located at the top of the window.
 * @value top
 * @desc Determine where the sprite is located on the Battle Status Window.
 * @default name
 *
 * @param PotraitStyle
 * @text Portrait Style
 * @parent Style:str
 *
 * @param ShowPortraits:eval
 * @text Show Portraits?
 * @parent PotraitStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait instead of a face.
 * @default true
 *
 * @param PortraitScale:num
 * @text Portrait Scaling
 * @parent PotraitStyle
 * @desc If portraits are used, scale them by this much.
 * @default 0.5
 *
 * @param BorderStyle
 * @text Border Style
 * @parent Style:str
 *
 * @param SkillItemBorderCols:num
 * @text Columns
 * @parent BorderStyle
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 1
 *
 * @param ShowPortraitsBorderStyle:eval
 * @text Show Portraits?
 * @parent BorderStyle
 * @type boolean
 * @on Portraits
 * @off Faces
 * @desc Requires VisuMZ_1_MainMenuCore.
 * Shows the actor's portrait at the edge of the screen.
 * @default true
 *
 * @param PortraitScaleBorderStyle:num
 * @text Portrait Scaling
 * @parent BorderStyle
 * @desc If portraits are used, scale them by this much.
 * @default 1.0
 *
 * @param SkillItemWindows
 * @text Skill & Item Windows
 *
 * @param SkillItemMiddleLayout:eval
 * @text Middle Layout
 * @parent SkillItemWindows
 * @type boolean
 * @on Middle
 * @off Bottom
 * @desc Shows the Skill & Item Windows in mid-screen?
 * @default false
 *
 * @param SkillItemStandardCols:num
 * @text Columns
 * @parent SkillItemWindows
 * @type number
 * @min 1
 * @desc The total number of columns for Skill & Item Windows
 * in the battle scene.
 * @default 2
 *
 * @param StatusWindow
 * @text Status Window Elements
 *
 * @param StatusWindowName
 * @text Battler Name
 * @parent StatusWindow
 *
 * @param NameOffsetX:num
 * @text Offset: X
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param NameOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowName
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowHpGauge
 * @text Gauge 1 (HP)
 * @parent StatusWindow
 *
 * @param HpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param HpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowHpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowMpGauge
 * @text Gauge 2 (MP)
 * @parent StatusWindow
 *
 * @param MpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param MpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowMpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpGauge
 * @text Gauge 3 (TP)
 * @parent StatusWindow
 *
 * @param TpGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowStateIcon
 * @text State Icon
 * @parent StatusWindow
 *
 * @param StateIconOffsetX:num
 * @text Offset: X
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StateIconOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowStateIcon
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowTpbGauge
 * @text TPB/ATB Gauge
 * @parent StatusWindow
 *
 * @param TpbGaugeOffsetX:num
 * @text Offset: X
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param TpbGaugeOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowTpbGauge
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowSkin
 * @text Window Skin
 * @parent StatusWindow
 *
 * @param StatusWindowSkinFilename:str
 * @text Filename
 * @parent StatusWindowSkin
 * @type file
 * @dir img/system/
 * @desc Filename used for the Battle Status Window skin.
 * Leave this empty to use the default window skin.
 * @default 
 *
 * @param StatusWindowSkinHide:eval
 * @text Hide Window Skin?
 * @parent StatusWindowSkin
 * @type boolean
 * @on No Window Skin
 * @off Default Skin
 * @desc Show/Hide the window skin for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowSelectBack
 * @text Selectable Background
 * @parent StatusWindow
 *
 * @param StatusWindowSelectableBackHide:eval
 * @text Hide Selectable BG?
 * @parent StatusWindowSelectBack
 * @type boolean
 * @on No Selectable BG
 * @off Default Selectable BG
 * @desc Show/Hide the selectable background box for the Battle Status Window?
 * @default false
 *
 * @param StatusWindowAttachments
 * @text Attachments
 * @parent StatusWindow
 *
 * @param StatusWindowBackAttachment
 * @text Back Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentBack:str
 * @text Filename
 * @parent StatusWindowBackAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the back of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentBackOffsetX:num
 * @text Offset: X
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentBackOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowBackAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param StatusWindowFrontAttachment
 * @text Front Attachment
 * @parent StatusWindowAttachments
 *
 * @param StatusWindowAttachmentFront:str
 * @text Filename
 * @parent StatusWindowFrontAttachment
 * @type file
 * @dir img/system/
 * @desc Filename used for an image to attach to the front of the
 * Battle Status Window. Leave empty for none.
 * @default 
 *
 * @param StatusWindowAttachmentFrontOffsetX:num
 * @text Offset: X
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's X.
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param StatusWindowAttachmentFrontOffsetY:num
 * @text Offset: Y
 * @parent StatusWindowFrontAttachment
 * @desc Offset this Battle Status Window element's Y.
 * Negative goes up. Positive goes down.
 * @default +0
 *
 * @param UiElements
 * @text UI Elements
 *
 * @param AntiTintUiElements:eval
 * @text Anti-Tint UI?
 * @parent UiElements
 * @type boolean
 * @on Prevent Tint
 * @off Allow Tint
 * @desc Prevent UI Elements from being tinted?
 * @default true
 *
 */
/* ----------------------------------------------------------------------------
 * Battle Log Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~BattleLog:
 *
 * @param General
 *
 * @param BackColor:str
 * @text Back Color
 * @parent General
 * @desc Use #rrggbb for a hex color.
 * @default #000000
 *
 * @param MaxLines:num
 * @text Max Lines
 * @parent General
 * @type number
 * @min 1
 * @desc Maximum number of lines to be displayed.
 * @default 10
 *
 * @param MessageWait:num
 * @text Message Wait
 * @parent General
 * @type number
 * @min 1
 * @desc Number of frames for a usual message wait.
 * @default 16
 *
 * @param TextAlign:str
 * @text Text Align
 * @parent General
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Window_BattleLog.
 * @default center
 *
 * @param BattleLogRectJS:func
 * @text JS: X, Y, W, H
 * @parent General
 * @type note
 * @desc Code used to determine the dimensions for the battle log.
 * @default "const wx = 0;\nconst wy = 0;\nconst ww = Graphics.boxWidth;\nconst wh = this.calcWindowHeight(10, false);\nreturn new Rectangle(wx, wy, ww, wh);"
 *
 * @param StartTurn
 * @text Start Turn
 *
 * @param StartTurnShow:eval
 * @text Show Start Turn?
 * @parent StartTurn
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display turn changes at the start of the turn?
 * @default false
 *
 * @param StartTurnMsg:str
 * @text Start Turn Message
 * @parent StartTurn
 * @desc Message displayed at turn start.
 * %1 - Turn Count
 * @default Turn %1
 *
 * @param StartTurnWait:num
 * @text Start Turn Wait
 * @parent StartTurn
 * @type number
 * @min 1
 * @desc Number of frames to wait after a turn started.
 * @default 40
 *
 * @param DisplayAction
 * @text Display Action
 *
 * @param ActionCenteredName:eval
 * @text Show Centered Action?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display a centered text of the action name?
 * @default true
 *
 * @param ActionSkillMsg1:eval
 * @text Show Skill Message 1?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 1st skill message?
 * @default false
 *
 * @param ActionSkillMsg2:eval
 * @text Show Skill Message 2?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the 2nd skill message?
 * @default true
 *
 * @param ActionItemMsg:eval
 * @text Show Item Message?
 * @parent DisplayAction
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the item use message?
 * @default false
 *
 * @param ActionChanges
 * @text Action Changes
 *
 * @param ShowCounter:eval
 * @text Show Counter?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display counter text?
 * @default true
 *
 * @param ShowReflect:eval
 * @text Show Reflect?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display magic reflection text?
 * @default true
 *
 * @param ShowSubstitute:eval
 * @text Show Substitute?
 * @parent ActionChanges
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display substitute text?
 * @default true
 *
 * @param ActionResults
 * @text Action Results
 *
 * @param ShowFailure:eval
 * @text Show No Effect?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display no effect text?
 * @default false
 *
 * @param ShowCritical:eval
 * @text Show Critical?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display critical text?
 * @default false
 *
 * @param ShowMissEvasion:eval
 * @text Show Miss/Evasion?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display miss/evasion text?
 * @default false
 *
 * @param ShowHpDmg:eval
 * @text Show HP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display HP Damage text?
 * @default false
 *
 * @param ShowMpDmg:eval
 * @text Show MP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display MP Damage text?
 * @default false
 *
 * @param ShowTpDmg:eval
 * @text Show TP Damage?
 * @parent ActionResults
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display TP Damage text?
 * @default false
 *
 * @param DisplayStates
 * @text Display States
 *
 * @param ShowAddedState:eval
 * @text Show Added States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added states text?
 * @default false
 *
 * @param ShowRemovedState:eval
 * @text Show Removed States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed states text?
 * @default false
 *
 * @param ShowCurrentState:eval
 * @text Show Current States?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display the currently affected state text?
 * @default false
 *
 * @param ShowAddedBuff:eval
 * @text Show Added Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added buffs text?
 * @default false
 *
 * @param ShowAddedDebuff:eval
 * @text Show Added Debuffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display added debuffs text?
 * @default false
 *
 * @param ShowRemovedBuff:eval
 * @text Show Removed Buffs?
 * @parent DisplayStates
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Display removed de/buffs text?
 * @default false
 *
 */
/* ----------------------------------------------------------------------------
 * Battleback Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Battleback:
 *
 * @param DefaultStyle:str
 * @text Default Style
 * @type select
 * @option MZ (MZ's default style)
 * @value MZ
 * @option 1:1 (No Scaling)
 * @value 1:1
 * @option Scale To Fit (Scale to screen size)
 * @value ScaleToFit
 * @option Scale Down (Scale Downward if Larger than Screen)
 * @value ScaleDown
 * @option Scale Up (Scale Upward if Smaller than Screen)
 * @value ScaleUp
 * @desc The default scaling style used for battlebacks.
 * @default MZ
 *
 * @param jsOneForOne:func
 * @text JS: 1:1
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst scale = 1.0;\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = 0;\nthis.y = 0;"
 *
 * @param jsScaleToFit:func
 * @text JS: Scale To Fit
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = this.width / this.bitmap.width;\nconst ratioY = this.height / this.bitmap.height;\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleDown:func
 * @text JS: Scale Down
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.min(1, this.width / this.bitmap.width);\nconst ratioY = Math.min(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 * @param jsScaleUp:func
 * @text JS: Scale Up
 * @type note
 * @desc This code gives you control over the scaling for this style.
 * @default "// Adjust Size\nthis.width = Graphics.width;\nthis.height = Graphics.height;\n\n// Adjust Scale\nconst ratioX = Math.max(1, this.width / this.bitmap.width);\nconst ratioY = Math.max(1, this.height / this.bitmap.height);\nconst scale = Math.max(ratioX, ratioY);\nthis.scale.x = scale;\nthis.scale.y = scale;\n\n// Adjust Coordinates\nthis.x = (Graphics.width - this.width) / 2;\nthis.y = Graphics.height - this.height;"
 *
 */
/* ----------------------------------------------------------------------------
 * Party Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~PartyCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Party Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Party Command Window.
 * @default left
 *
 * @param CmdIconFight:num
 * @text Fight Icon
 * @parent Cmd
 * @desc The icon used for the Fight command.
 * @default 76
 *
 * @param CommandAddAutoBattle:eval
 * @text Add Auto Battle?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Auto Battle" command to the Command Window?
 * @default true
 *
 * @param CmdIconAutoBattle:num
 * @text Auto Battle Icon
 * @parent CommandAddAutoBattle:eval
 * @desc The icon used for the Auto Battle command.
 * @default 78
 *
 * @param CmdTextAutoBattle:str
 * @text Auto Battle Text
 * @parent CommandAddAutoBattle:eval
 * @desc The text used for the Auto Battle command.
 * @default Auto
 *
 * @param CommandAddOptions:eval
 * @text Add Options?
 * @parent Cmd
 * @type boolean
 * @on Add
 * @off Don't
 * @desc Add the "Options" command to the Command Window?
 * @default true
 *
 * @param CmdIconOptions:num
 * @text Options Icon
 * @parent CommandAddOptions:eval
 * @desc The icon used for the Options command.
 * @default 83
 *
 * @param ActiveTpbOptionsMessage:str
 * @text Active TPB Message
 * @parent CommandAddOptions:eval
 * @desc Message that will be displayed when selecting options during the middle of an action.
 * @default Options Menu queued after action is complete.
 *
 * @param CmdIconEscape:num
 * @text Escape Icon
 * @parent Cmd
 * @desc The icon used for the Escape command.
 * @default 82
 *
 * @param Access
 *
 * @param SkipPartyCmd:eval
 * @text Skip Party Command
 * @parent Access
 * @type boolean
 * @on Skip
 * @off Don't
 * @desc DTB: Skip Party Command selection on turn start.
 * TPB: Skip Party Command selection at battle start.
 * @default true
 *
 * @param DisablePartyCmd:eval
 * @text Disable Party Command
 * @parent Access
 * @type boolean
 * @on Disable
 * @off Don't
 * @desc Disable the Party Command Window entirely?
 * @default false
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpFight:str
 * @text Fight
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Select actions to fight.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Sets party to Auto Battle mode.
 *
 * @param HelpOptions:str
 * @text Options
 * @parent HelpWindow
 * @desc Text displayed when selecting the Options command.
 * @default Opens up the Options Menu.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Command Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActorCmd:
 *
 * @param Cmd
 * @text Command Window
 *
 * @param CmdStyle:str
 * @text Style
 * @parent Cmd
 * @type select
 * @option Text Only
 * @value text
 * @option Icon Only
 * @value icon
 * @option Icon + Text
 * @value iconText
 * @option Automatic
 * @value auto
 * @desc How do you wish to draw commands in the Actor Command Window?
 * @default auto
 *
 * @param CmdTextAlign:str
 * @text Text Align
 * @parent Cmd
 * @type combo
 * @option left
 * @option center
 * @option right
 * @desc Text alignment for the Actor Command Window.
 * @default left
 *
 * @param CmdIconItem:num
 * @text Item Icon
 * @parent Cmd
 * @desc The icon used for the Item command.
 * @default 176
 *
 * @param IconStypeNorm:num
 * @text Normal SType Icon
 * @parent Cmd
 * @desc Icon used for normal skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 78
 *
 * @param IconStypeMagic:num
 * @text Magic SType Icon
 * @parent Cmd
 * @desc Icon used for magic skill types that aren't assigned any
 * icons. Ignore if VisuMZ_1_SkillsStatesCore is installed.
 * @default 79
 *
 * @param BattleCmd
 * @text Battle Commands
 *
 * @param BattleCmdList:arraystr
 * @text Command List
 * @parent BattleCmd
 * @type combo[]
 * @option attack
 * @option skills
 * @option guard
 * @option item
 * @option party
 * @option escape
 * @option auto battle
 * @option stypes
 * @option stype: x
 * @option stype: name
 * @option all skills
 * @option skill: x
 * @option skill: name
 * @option combat log
 * @option talk
 * @option weapon swap
 * @desc List of battle commands that appear by default
 * if the <Battle Commands> notetag isn't present.
 * @default ["attack","skills","guard","party","item"]
 *
 * @param ShowCosts:eval
 * @text Show Command Costs
 * @parent BattleCmd
 * @type boolean
 * @on Show Costs
 * @off Hide Costs
 * @desc If a battle command has a resource cost, show it?
 * @default true
 *
 * @param HelpWindow
 * @text Help Window
 *
 * @param HelpSkillType:str
 * @text Skill Types
 * @parent HelpWindow
 * @desc Text displayed when selecting a skill type.
 * %1 - Skill Type Name
 * @default Opens up a list of skills under the \C[16]%1\C[0] category.
 *
 * @param HelpItem:str
 * @text Items
 * @parent HelpWindow
 * @desc Text displayed when selecting the item command.
 * @default Opens up a list of items that you can use.
 *
 * @param HelpEscape:str
 * @text Escape
 * @parent HelpWindow
 * @desc Text displayed when selecting the escape command.
 * @default Attempt to escape the battle.
 *
 * @param HelpAutoBattle:str
 * @text Auto Battle
 * @parent HelpWindow
 * @desc Text displayed when selecting the Auto Battle command.
 * @default Automatically choose an action suitable for combat.
 *
 * @param HelpParty:str
 * @text Party
 * @parent HelpWindow
 * @desc Text displayed when selecting the Party command.
 * Requires 
 * @default Automatically choose an action suitable for combat.
 *
 */
/* ----------------------------------------------------------------------------
 * Multi-Target Window Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~MultiTarget:
 *
 * @param Properties
 * 
 * @param WindowWidth:num
 * @text Window Width
 * @parent Properties
 * @type number
 * @min 1
 * @desc What is the width used for the Multi-Target Window?
 * @default 280
 *
 * @param BgType:num
 * @text Background Type
 * @parent Properties
 * @type select
 * @option 0 - Window
 * @value 0
 * @option 1 - Dim
 * @value 1
 * @option 2 - Transparent
 * @value 2
 * @desc Select background type for these windows.
 * @default 2
 *
 * @param ShowButton:eval
 * @text Show Button
 * @parent Properties
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Shows the keyboard/controller button to press?
 * Requires VisuMZ_0_CoreEngine!
 * @default true
 * 
 * @param Vocab
 *
 * @param AllActorsText:str
 * @text All Actors
 * @parent Vocab
 * @desc What is the text used for the "All Actors" button?
 * @default All Allies
 *
 * @param AllEnemiesText:str
 * @text All Enemies
 * @parent Vocab
 * @desc What is the text used for the "All Enemies" button?
 * @default All Enemies
 * 
 * @param Offsets
 * 
 * @param ActorOffsets
 * @text Actor Offsets
 * @parent Offsets
 *
 * @param ActorOffsetX:num
 * @text Offset X
 * @parent ActorOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param ActorOffsetY:num
 * @text Offset Y
 * @parent ActorOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 * 
 * @param EnemyOffsets
 * @text Enemy Offsets
 * @parent Offsets
 *
 * @param EnemyOffsetX:num
 * @text Offset X
 * @parent EnemyOffsets
 * @desc Offsets the button's x position.
 * Negative: left. Positive: right.
 * @default +0
 *
 * @param EnemyOffsetY:num
 * @text Offset Y
 * @parent EnemyOffsets
 * @desc Offsets the button's y position.
 * Negative: up. Positive: down.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Actor Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Actor:
 *
 * @param Flinch
 *
 * @param FlinchDistanceX:num
 * @text Flinch Distance X
 * @parent Flinch
 * @desc The normal X distance when flinching.
 * @default 12
 *
 * @param FlinchDistanceY:num
 * @text Flinch Distance Y
 * @parent Flinch
 * @desc The normal Y distance when flinching.
 * @default 0
 *
 * @param FlinchDuration:num
 * @text Flinch Duration
 * @parent Flinch
 * @desc The number of frames for a flinch to complete.
 * @default 6
 *
 * @param ShakeFlinch:eval
 * @text Shake Flinch
 * @parent Flinch
 * @type boolean
 * @on Enable
 * @off Disable
 * @desc Perform a shake flinch when taking damage?
 * @default false
 *
 * @param ShakeFlinchDuration:num
 * @text Max Duration
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc Maximum duration a shake flinch can have.
 * This is reduced relative to the amount of damage taken.
 * @default 24
 *
 * @param ShakeFlinchPower:num
 * @text Max Power
 * @parent ShakeFlinch:eval
 * @type number
 * @min 1
 * @desc The power rating of a shake flinch at full damage.
 * This is reduced relative to the amount of damage taken.
 * @default 48
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param ChantStyle:eval
 * @text Chant Style
 * @parent SvBattlers
 * @type boolean
 * @on Magical Hit Type
 * @off Magical Skill Type
 * @desc What determines the chant motion?
 * Hit type or skill type?
 * @default true
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent SvBattlers
 * @desc Offsets X position where actor is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent SvBattlers
 * @desc Offsets Y position where actor is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param MotionSpeed:num
 * @text Motion Speed
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc The number of frames in between each motion.
 * @default 12
 *
 * @param PrioritySortActive:eval
 * @text Priority: Active
 * @parent SvBattlers
 * @type boolean
 * @on Active Actor over All Else
 * @off Active Actor is Sorted Normally
 * @desc Place the active actor on top of actor and enemy sprites.
 * @default false
 *
 * @param PrioritySortActors:eval
 * @text Priority: Actors
 * @parent SvBattlers
 * @type boolean
 * @on Actors over Enemies
 * @off Sort by Y Position
 * @desc Prioritize actors over enemies when placing sprites on top
 * of each other.
 * @default true
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent SvBattlers
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default false
 *
 * @param HomePosJS:func
 * @text JS: Home Position
 * @parent SvBattlers
 * @type note
 * @desc Code used to calculate the home position of actors.
 * @default "// Declare Constants\nconst sprite = this;\nconst actor = this._actor;\nconst index = arguments[0];\n\n// Make Calculations\nlet x = Math.round((Graphics.width / 2) + 192)\nx -= Math.floor((Graphics.width - Graphics.boxWidth) / 2);\nx += index * 32;\nlet y = (Graphics.height - 200) - ($gameParty.maxBattleMembers() * 48);\ny -= Math.floor((Graphics.height - Graphics.boxHeight) / 2);\ny += index * 48;\n\n// Home Position Offsets\nconst offsetNote = /<SIDEVIEW HOME OFFSET:[ ]([\\+\\-]\\d+),[ ]([\\+\\-]\\d+)>/i;\nconst xOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$1) : 0));\nconst yOffsets = actor.traitObjects().map((obj) => (obj && obj.note.match(offsetNote) ? Number(RegExp.$2) : 0));\nx = xOffsets.reduce((r, offset) => r + offset, x);\ny = yOffsets.reduce((r, offset) => r + offset, y);\n\n// Set Home Position\nthis.setHome(x, y);"
 *
 */
/* ----------------------------------------------------------------------------
 * Enemy Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Enemy:
 *
 * @param Visual
 *
 * @param AttackAnimation:num
 * @text Attack Animation
 * @parent Visual
 * @type animation
 * @desc Default attack animation used for enemies.
 * Use <Attack Animation: x> for custom animations.
 * @default 1
 *
 * @param EmergeText:eval
 * @text Emerge Text
 * @parent Visual
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show or hide the 'Enemy emerges!' text at the start of battle.
 * @default false
 *
 * @param OffsetX:num
 * @text Offset: X
 * @parent Visual
 * @desc Offsets X position where enemy is positioned.
 * Negative values go left. Positive values go right.
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset: Y
 * @parent Visual
 * @desc Offsets Y position where enemy is positioned.
 * Negative values go up. Positive values go down.
 * @default 0
 *
 * @param SmoothImage:eval
 * @text Smooth Image
 * @parent Visual
 * @type boolean
 * @on Smooth
 * @off Pixelated
 * @desc Smooth out the battler images or pixelate them?
 * @default true
 *
 * @param SelectWindow
 * @text Select Window
 *
 * @param LastSelected:eval
 * @text Any: Last Selected
 * @parent SelectWindow
 * @type boolean
 * @on Last Selected
 * @off FV/SV Priority
 * @desc Prioritize last selected enemy over front view or sideview settings?
 * @default true
 *
 * @param FrontViewSelect:eval
 * @text FV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using frontview, auto select the enemy furthest right.
 * @default false
 *
 * @param SideviewSelect:eval
 * @text SV: Right Priority
 * @parent SelectWindow
 * @type boolean
 * @on Right
 * @off Normal
 * @desc If using sideview, auto select the enemy furthest right.
 * @default true
 * 
 * @param Name
 *
 * @param NameLegacy:eval
 * @text Legacy Option
 * @parent Name
 * @type boolean
 * @on Legacy Version
 * @off New Version (Sprite)
 * @desc Use the legacy version (window) or new version (sprite).
 * WARNING: Legacy version is no longer supported for bugs.
 * @default false
 *
 * @param NameFontSize:num
 * @text Font Size
 * @parent Name
 * @desc Font size used for enemy names.
 * @default 22
 * 
 * @param NamePosition
 * @text Name Position
 * @parent Name
 *
 * @param NameOffsetX:num
 * @text Offset X
 * @parent NamePosition
 * @desc Offset the enemy name's X position by this much.
 * Negative goes left. Positive goes right.
 * @default 0
 *
 * @param NameOffsetY:num
 * @text Offset Y
 * @parent NamePosition
 * @desc Offset the enemy name's Y position by this much.
 * Negative goes up. Positive goes down.
 * @default 0
 *
 * @param NameAttachStateIcon:eval
 * @text Attach States
 * @parent Name
 * @type boolean
 * @on Attach
 * @off Normal Position
 * @desc Attach the enemy's state icon to the enemy name?
 * @default false
 *
 * @param AttachStateOffsetX:num
 * @text Attach: Offset X
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's X position by?
 * Negative goes left. Positive goes right.
 * @default +0
 *
 * @param AttachStateOffsetY:num
 * @text Attach: Offset Y
 * @parent NameAttachStateIcon:eval
 * @desc How much to offset the attached icon's Y position by?
 * Negative goes up. Positive goes down.
 * @default +0
 * 
 * @param NameVisibility
 * @text Name Visibility
 * @parent Name
 *
 * @param NameAlwaysHidden:eval
 * @text Always Hidden
 * @parent NameVisibility
 * @type boolean
 * @on Always Hidden
 * @off No Priority
 * @desc Determines if the enemy name will always be visible.
 * Highest priority.
 * @default false
 *
 * @param NameAlwaysVisible:eval
 * @text Always Visible
 * @parent NameVisibility
 * @type boolean
 * @on Always Visible
 * @off Hide when Unselected
 * @desc Determines if the enemy name will always be visible.
 * Medium priority.
 * @default false
 *
 * @param NameAlwaysSelectOnly:eval
 * @text By Selection?
 * @parent NameVisibility
 * @type boolean
 * @on Visible when Selected
 * @off Visible when Targeting
 * @desc Determines the conditions for enemy name visibility.
 * Lowest priority.
 * @default false
 *
 * @param SvBattlers
 * @text Sideview Battlers
 *
 * @param AllowCollapse:eval
 * @text Allow Collapse
 * @parent SvBattlers
 * @type boolean
 * @on Allow
 * @off Don't
 * @desc Causes defeated enemies with SV Battler graphics
 * to "fade away" when defeated?
 * @default false
 *
 * @param AnchorX:num
 * @text Anchor: X
 * @parent SvBattlers
 * @desc Default X anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor: Y
 * @parent SvBattlers
 * @desc Default Y anchor for Sideview Battlers.
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param MotionIdle:str
 * @text Motion: Idle
 * @parent SvBattlers
 * @type combo
 * @option walk
 * @option wait
 * @option chant
 * @option guard
 * @option damage
 * @option evade
 * @option thrust
 * @option swing
 * @option missile
 * @option skill
 * @option spell
 * @option item
 * @option escape
 * @option victory
 * @option dying
 * @option abnormal
 * @option sleep
 * @option dead
 * @desc Sets default idle animation used by Sideview Battlers.
 * @default walk
 *
 * @param Shadow:eval
 * @text Shadow Visible
 * @parent SvBattlers
 * @type boolean
 * @on Visible
 * @off Hidden
 * @desc Show or hide the shadow for Sideview Battlers.
 * @default true
 *
 * @param Width:num
 * @text Size: Width
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default width for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param Height:num
 * @text Size: Height
 * @parent SvBattlers
 * @type number
 * @min 1
 * @desc Default height for enemies that use Sideview Battlers.
 * @default 64
 *
 * @param WtypeId:num
 * @text Weapon Type
 * @parent SvBattlers
 * @type number
 * @min 0
 * @desc Sets default weapon type used by Sideview Battlers.
 * Use 0 for Bare Hands.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * HP Gauge Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~HpGauge:
 *
 * @param Display
 * @text Show Gauges For
 *
 * @param ShowActorGauge:eval
 * @text Actors
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the actor sprites' heads?
 * Requires SV Actors to be visible.
 * @default true
 *
 * @param ShowEnemyGauge:eval
 * @text Enemies
 * @parent Display
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show HP Gauges over the enemy sprites' heads?
 * Can be bypassed with <Hide HP Gauge> notetag.
 * @default true
 *
 * @param RequiresDefeat:eval
 * @text Requires Defeat?
 * @parent ShowEnemyGauge:eval
 * @type boolean
 * @on Require Defeat First
 * @off No Requirement
 * @desc Requires defeating the enemy once to show HP Gauge?
 * Can be bypassed with <Show HP Gauge> notetag.
 * @default true
 *
 * @param BTestBypass:eval
 * @text Battle Test Bypass?
 * @parent RequiresDefeat:eval
 * @type boolean
 * @on Bypass
 * @off Don't Bypass
 * @desc Bypass the defeat requirement in battle test?
 * @default true
 *
 * @param Settings
 *
 * @param AniDuration:num
 * @text Animation Duration
 * @parent Settings
 * @type number
 * @min 1
 * @desc How many frames should gauges animate themselves?
 * Default: 20 frames.
 * @default 20
 *
 * @param AnchorX:num
 * @text Anchor X
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor X to be?
 * Use values between 0 and 1 to be safe.
 * @default 0.5
 *
 * @param AnchorY:num
 * @text Anchor Y
 * @parent Settings
 * @desc Where do you want the HP Gauge sprite's anchor Y to be?
 * Use values between 0 and 1 to be safe.
 * @default 1.0
 *
 * @param Scale:num
 * @text Scale
 * @parent Settings
 * @desc How large/small do you want the HP Gauge to be scaled?
 * @default 0.5
 *
 * @param OffsetX:num
 * @text Offset X
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's X by?
 * @default 0
 *
 * @param OffsetY:num
 * @text Offset Y
 * @parent Settings
 * @desc How many pixels to offset the HP Gauge's Y by?
 * @default -3
 *
 * @param Options
 * @text Options
 *
 * @param AddHpGaugeOption:eval
 * @text Add Option?
 * @parent Options
 * @type boolean
 * @on Add
 * @off Don't Add
 * @desc Add the 'Show HP Gauge' option to the Options menu?
 * @default true
 *
 * @param AdjustRect:eval
 * @text Adjust Window Height
 * @parent Options
 * @type boolean
 * @on Adjust
 * @off Don't
 * @desc Automatically adjust the options window height?
 * @default true
 *
 * @param Name:str
 * @text Option Name
 * @parent Options
 * @desc Command name of the option.
 * @default Show HP Gauge
 *
 */
/* ----------------------------------------------------------------------------
 * Action Sequence Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ActionSequence:
 *
 * @param AutoSequences
 * @text Automatic Sequences
 *
 * @param AutoMeleeSolo:eval
 * @text Melee Single Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, single target actions?
 * @default true
 *
 * @param AutoMeleeAoE:eval
 * @text Melee Multi Target
 * @parent AutoSequences
 * @type boolean
 * @on Allow
 * @off Ignore
 * @desc Allow this auto sequence for physical, multi-target actions?
 * @default true
 *
 * @param QoL
 * @text Quality of Life
 *
 * @param AutoNotetag:eval
 * @text Auto Notetag
 * @parent QoL
 * @type boolean
 * @on Automatic
 * @off Manual
 * @desc Automatically apply the <Custom Action Sequence> notetag
 * effect to any item or skill that has a Common Event?
 * @default false
 *
 * @param CastAnimations
 * @text Cast Animations
 *
 * @param CastCertain:num
 * @text Certain Hit
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Certain Hit skills.
 * @default 120
 *
 * @param CastPhysical:num
 * @text Physical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Physical skills.
 * @default 52
 *
 * @param CastMagical:num
 * @text Magical
 * @parent CastAnimations
 * @type animation
 * @desc Cast animation for Magical skills.
 * @default 51
 *
 * @param CounterReflection
 * @text Counter/Reflect
 *
 * @param CounterPlayback:eval
 * @text Counter Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param ReflectAnimation:num
 * @text Reflect Animation
 * @parent CounterReflection
 * @type animation
 * @desc Animation played when an action is reflected.
 * @default 53
 *
 * @param ReflectPlayback:eval
 * @text Reflect Back
 * @parent CounterReflection
 * @type boolean
 * @on Play Back
 * @off Ignore
 * @desc Play back the attack animation used?
 * @default true
 *
 * @param Stepping
 *
 * @param MeleeDistance:num
 * @text Melee Distance
 * @parent Stepping
 * @desc Minimum distance in pixels for Movement Action Sequences.
 * @default 24
 *
 * @param StepDistanceX:num
 * @text Step Distance X
 * @parent Stepping
 * @desc The normal X distance when stepping forward.
 * @default 48
 *
 * @param StepDistanceY:num
 * @text Step Distance Y
 * @parent Stepping
 * @desc The normal Y distance when stepping forward.
 * @default 0
 *
 * @param StepDuration:num
 * @text Step Duration
 * @parent Stepping
 * @desc The number of frames for a stepping action to complete.
 * @default 12
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Start Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileStart:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Start from battler target(s)
 * @value target
 * @option Point - Start from a point on the screen
 * @value point
 * @desc Select where the projectile should start from.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) to start the projectile from.
 * @default ["user"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Create one projectile at the center of the targets?
 * Or create a projectile for each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile from.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to start the projectile at.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Goal Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileGoal:
 * 
 * @param Type:str
 * @text Type
 * @type select
 * @option Target - Goal is battler target(s)
 * @value target
 * @option Point - Goal is a point on the screen
 * @value point
 * @desc Select where the projectile should go to.
 * @default target
 * 
 * @param Targets:arraystr
 * @text Target(s)
 * @parent Type:str
 * @type combo[]
 * @option user
 * @option current target
 * @option prev target
 * @option next target
 * @option all targets
 * @option focus
 * @option not focus
 * @option
 * @option special
 * @option special x
 * @option 
 * @option alive friends
 * @option alive friends not user
 * @option alive friends not target
 * @option dead friends
 * @option friend index x
 * @option 
 * @option alive opponents
 * @option alive opponents not target
 * @option dead opponents
 * @option opponent index x
 * @option 
 * @option alive actors
 * @option alive actors not user
 * @option alive actors not target
 * @option dead actors
 * @option actor index x
 * @option actor ID x
 * @option 
 * @option alive enemies
 * @option alive enemies not user
 * @option alive enemies not target
 * @option dead enemies
 * @option enemy index x
 * @option enemy ID x
 * @option 
 * @option alive battlers
 * @option alive battlers not user
 * @option alive battlers not target
 * @option dead battlers
 * @option 
 * @desc Select which unit(s) for projectile to go to.
 * @default ["all targets"]
 * 
 * @param TargetCenter:eval
 * @text Centralize
 * @parent Targets:arraystr
 * @type boolean
 * @on Center Projectile
 * @off Create Each
 * @desc Set goal in the center of targets?
 * Or create a projectile to go to each target?
 * @default false
 * 
 * @param TargetLocation:str
 * @text Target Location
 * @parent Targets:arraystr
 * @type combo
 * @option front head
 * @option front center
 * @option front base
 * @option middle head
 * @option middle center
 * @option middle base
 * @option back head
 * @option back center
 * @option back base
 * @desc Select which part of the target to send the projectile at.
 * @default middle center
 * 
 * @param PointX:eval
 * @text Point X
 * @parent Type:str
 * @desc Insert the X coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.width / 2
 * 
 * @param PointY:eval
 * @text Point Y
 * @parent Type:str
 * @desc Insert the Y coordinate to send the projectile to.
 * You may use JavaScript code.
 * @default Graphics.height / 2
 * 
 * @param OffsetX:eval
 * @text Offset X
 * @desc Insert how many pixels to offset the X coordinate by.
 * You may use JavaScript code.
 * @default +0
 * 
 * @param OffsetY:eval
 * @text Offset Y
 * @desc Insert how many pixels to offset the Y coordinate by.
 * You may use JavaScript code.
 * @default +0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Animation Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExAni:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Projectile Extra Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ProjectileExtra:
 * 
 * @param AutoAngle:eval
 * @text Auto Angle?
 * @parent Settings
 * @type boolean
 * @on Automatically Angle
 * @off Normal
 * @desc Automatically angle the projectile to tilt the direction it's moving?
 * @default true
 * 
 * @param AngleOffset:eval
 * @text Angle Offset
 * @desc Alter the projectile's tilt by this many degrees.
 * @default +0
 * 
 * @param Arc:eval
 * @text Arc Peak
 * @parent Settings
 * @desc This is the height of the projectile's trajectory arc
 * in pixels.
 * @default 0
 *
 * @param BlendMode:num
 * @text Blend Mode
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the projectile?
 * @default 0
 *
 * @param EasingType:str
 * @text Easing
 * @parent Settings
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type to apply to the projectile's trajectory.
 * @default Linear
 * 
 * @param Hue:eval
 * @text Hue
 * @parent Settings
 * @desc Adjust the hue of the projectile.
 * Insert a number between 0 and 360.
 * @default 0
 * 
 * @param Scale:eval
 * @text Scale
 * @parent Settings
 * @desc Adjust the size scaling of the projectile.
 * Use decimals for exact control.
 * @default 1.0
 * 
 * @param Spin:eval
 * @text Spin Speed
 * @parent Settings
 * @desc Determine how much angle the projectile spins per frame.
 * Does not work well with "Auto Angle".
 * @default +0.0
 * 
 * @param Emulate
 * @text Effect Emulation
 * 
 * @param EmulateActionEffect:eval
 * @text Action Effect?
 * @parent Emulate
 * @type boolean
 * @on Emulate
 * @off Don't Emulate
 * @desc Emulate current Action Effect when projectile reaches
 * target? Only works with start/goal targets.
 * @default false
 * 
 * @param EmulateItemEffect:eval
 * @text Item Effect ID
 * @parent Emulate
 * @type item
 * @desc Emulate an Item Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 * 
 * @param EmulateSkillEffect:eval
 * @text Skill Effect ID
 * @parent Emulate
 * @type skill
 * @desc Emulate a Skill Effect when projectile reaches target?
 * Use 0 to not use. Only works with start/goal targets.
 * @default 0
 *
 * @param OnceParallel:num
 * @text Common Event ID
 * @parent Emulate
 * @type common_event
 * @desc Plays a Once Parallel Common Event upon reaching target.
 * Use 0 to not use. Works regardless of start/goal targets.
 * @default 0
 *
 */
/* ----------------------------------------------------------------------------
 * Visual Cutin Effect Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~VisualCutinEffect:
 *
 * @param Transition
 * 
 * @param enterDuration:num
 * @text Entrance Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully enter?
 * Used when a Visual Cutin Effect starts.
 * @default 12
 * 
 * @param exitDuration:num
 * @text Exit Duration
 * @parent Transition
 * @type number
 * @desc How many frames does it take to fully exit?
 * Used when a Visual Cutin Effect ends.
 * @default 12
 *
 * @param Cutin
 * @text Cutin Settings
 *
 * @param bgShow:eval
 * @text Show BG Color?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Add a background color for this cutin?
 * Background colors appear behind the parallax.
 * @default true
 *
 * @param outlineShow:eval
 * @text Show Outline?
 * @parent Cutin
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show the cutin outline?
 * @default true
 *
 * @param Portrait
 * @text Portrait Settings
 *
 * @param PortraitBase
 * @text Base Properties
 * @parent Portrait
 * 
 * @param portraitAnchorX:num
 * @text Anchor X
 * @parent PortraitBase
 * @desc Determines the sprite anchor X alignment.
 * 0.0: Left, 0.5: Center, 1.0: Right.
 * @default 0.5
 * 
 * @param portraitAnchorY:num
 * @text Anchor Y
 * @parent PortraitBase
 * @desc Determines the sprite anchor Y alignment.
 * 0.0: Top, 0.5: Middle, 1.0: Bottom.
 * @default 0.5
 *
 * @param portraitHue:num
 * @text Hue
 * @parent PortraitBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's portrait hue?
 * @default 0
 * 
 * @param portraitOpacity:num
 * @text Opacity
 * @parent PortraitBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's portrait?
 * @default 255
 * 
 * @param portraitOffsetX:num
 * @text Offset X
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's X location.
 * Negative: left. Positive: right.
 * @default +0
 * 
 * @param portraitOffsetY:num
 * @text Offset Y
 * @parent PortraitBase
 * @desc Offsets the cutin portrait's Y location.
 * Negative: up. Positive: down.
 * @default +0
 *
 * @param PortraitEnter
 * @text Entrance Properties
 * @parent Portrait
 * 
 * @param portraitEnterX:num
 * @text Entrance X
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's X entrance.
 * Negative: from left. Positive: from right.
 * @default +0
 * 
 * @param portraitEnterY:num
 * @text Entrance Y
 * @parent PortraitEnter
 * @desc Sets the cutin portrait's Y entrance.
 * Negative: from up. Positive: from down.
 * @default +0
 *
 * @param portraitEnterEasingType:str
 * @text Entrance Easing
 * @parent PortraitEnter
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitExit
 * @text Exit Properties
 * @parent Portrait
 * 
 * @param portraitExitX:num
 * @text Exit X
 * @parent PortraitExit
 * @desc Sets the cutin portrait's X exit.
 * Negative: to left. Positive: to right.
 * @default +0
 * 
 * @param portraitExitY:num
 * @text Exit Y
 * @parent PortraitExit
 * @desc Sets the cutin portrait's Y exit.
 * Negative: to up. Positive: to down.
 * @default +0
 *
 * @param portraitExitEasingType:str
 * @text Exit Easing
 * @parent PortraitExit
 * @type combo
 * @option Linear
 * @option InSine
 * @option OutSine
 * @option InOutSine
 * @option InQuad
 * @option OutQuad
 * @option InOutQuad
 * @option InCubic
 * @option OutCubic
 * @option InOutCubic
 * @option InQuart
 * @option OutQuart
 * @option InOutQuart
 * @option InQuint
 * @option OutQuint
 * @option InOutQuint
 * @option InExpo
 * @option OutExpo
 * @option InOutExpo
 * @option InCirc
 * @option OutCirc
 * @option InOutCirc
 * @option InBack
 * @option OutBack
 * @option InOutBack
 * @option InElastic
 * @option OutElastic
 * @option InOutElastic
 * @option InBounce
 * @option OutBounce
 * @option InOutBounce
 * @desc Select which easing type you wish to apply.
 * @default InOutSine
 *
 * @param PortraitFlip
 * @text Flip Properties
 * @parent Portrait
 *
 * @param portraitFlipHorz:eval
 * @text Flip Horizontally?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait horizontally?
 * @default false
 *
 * @param portraitFlipVert:eval
 * @text Flip Vertically?
 * @parent PortraitFlip
 * @type boolean
 * @on Flip
 * @off Don't Flip
 * @desc Flip the cutin portrait vertically?
 * @default false
 *
 * @param PortraitScale
 * @text Scaling Properties
 * @parent Portrait
 * 
 * @param portraitForcedScale:num
 * @text Forced Scaling
 * @parent PortraitScale
 * @desc Do you want to force a scaling ratio?
 * Leave as 0 for none. Disables "Fit to Scale?".
 * @default 0.0
 *
 * @param portraitScaleToFit:eval
 * @text Fit to Scale?
 * @parent PortraitScale
 * @type boolean
 * @on Fit to Scale
 * @off Don't Scale
 * @desc Scale the cutin portrait to fit the cutin style?
 * Cannot be used with "Forced Scaling".
 * @default true
 *
 * @param portraitScaleMax:eval
 * @text Scale Max?
 * @parent portraitScaleToFit:eval
 * @type boolean
 * @on Scale Maximum
 * @off Scale Minimum
 * @desc Scale the cutin portrait to the maximum fit or
 * scale the cutin portrait to the minimum fit.
 * @default false
 *
 * @param PortraitAni
 * @text Animated Portraits
 * @parent Portrait
 *
 * @param animatedPortraitLooping:eval
 * @text Loop?
 * @parent PortraitAni
 * @type boolean
 * @on ON
 * @off OFF
 * @desc Will loop back to beginning once ended.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default true
 *
 * @param animatedPortraitWaitFrames:num
 * @text Wait Frames
 * @parent PortraitAni
 * @type number
 * @min 1
 * @desc Frames to wait before moving to next cell.
 * Requires VisuMZ_4_AnimatedPictures!
 * @default 4
 *
 * @param Parallax
 * @text Parallax Settings
 *
 * @param ParallaxBase
 * @text Base Settings
 * @parent Parallax
 *
 * @param parallaxBlendMode:num
 * @text Blend Mode
 * @parent ParallaxBase
 * @type select
 * @option 0 - Normal
 * @value 0
 * @option 1 - Additive
 * @value 1
 * @option 2 - Multiply
 * @value 2
 * @option 3 - Screen
 * @value 3
 * @desc What kind of blend mode do you wish to apply to the cutin?
 * @default 0
 *
 * @param parallaxHue:num
 * @text Hue
 * @parent ParallaxBase
 * @type number
 * @min 0
 * @max 360
 * @desc Do you wish to adjust this cutin's parallax hue?
 * @default 0
 *
 * @param parallaxHueEnemyModifier:num
 * @text Enemy Modifier
 * @parent parallaxHue:num
 * @desc Adjust the hue value by this if the cutin target is an enemy.
 * @default +0
 * 
 * @param parallaxOpacity:num
 * @text Opacity
 * @parent ParallaxBase
 * @type number
 * @max 255
 * @desc What is the opacity level of this cutin's parallax?
 * @default 255
 *
 * @param ParallaxScroll
 * @text Scrolling Settings
 * @parent Parallax
 * 
 * @param parallaxOffsetX:num
 * @text Offset X
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's X location.
 * Negative: left. Positive: right.
 * @default +0.0
 * 
 * @param parallaxOffsetY:num
 * @text Offset Y
 * @parent ParallaxScroll
 * @desc Offsets the cutin parallax's Y location.
 * Negative: up. Positive: down.
 * @default +0.0
 * 
 * @param parallaxScrollX:num
 * @text Scroll X
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll horizontally?
 * Negative: Scroll to right. Positive: Scroll to left.
 * @default +0.0
 *
 * @param parallaxScrollXinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollX:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the X scroll direction if the cutin target is an enemy?
 * @default false
 * 
 * @param parallaxScrollY:num
 * @text Scroll Y
 * @parent ParallaxScroll
 * @desc How many pixels does the parallax scroll vertically?
 * Negative: Scroll to down. Positive: Scroll to up.
 * @default +0.0
 *
 * @param parallaxScrollYinvertEnemy:eval
 * @text Invert for Enemy?
 * @parent parallaxScrollY:num
 * @type boolean
 * @on Invert
 * @off Don't Invert
 * @desc Invert the Y scroll direction if the cutin target is an enemy?
 * @default false
 *
 */
//=============================================================================

const _0x208a24=_0x5c71;(function(_0x28e8a7,_0x57bb39){const _0x44252a=_0x5c71,_0x5a4905=_0x28e8a7();while(!![]){try{const _0x3b40a9=parseInt(_0x44252a(0x71a))/0x1*(parseInt(_0x44252a(0x292))/0x2)+parseInt(_0x44252a(0x385))/0x3*(parseInt(_0x44252a(0xa01))/0x4)+-parseInt(_0x44252a(0x5b5))/0x5+parseInt(_0x44252a(0x33e))/0x6+-parseInt(_0x44252a(0xba0))/0x7+parseInt(_0x44252a(0x91a))/0x8*(-parseInt(_0x44252a(0x89e))/0x9)+parseInt(_0x44252a(0xae6))/0xa*(parseInt(_0x44252a(0xb57))/0xb);if(_0x3b40a9===_0x57bb39)break;else _0x5a4905['push'](_0x5a4905['shift']());}catch(_0x39931f){_0x5a4905['push'](_0x5a4905['shift']());}}}(_0x3675,0x94cc5));var label=_0x208a24(0x759),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x208a24(0x5a8)](function(_0xb87bbc){const _0x1b4a50=_0x208a24;return _0xb87bbc[_0x1b4a50(0xd1b)]&&_0xb87bbc[_0x1b4a50(0x1ce)][_0x1b4a50(0xcaf)]('['+label+']');})[0x0];VisuMZ[label]['Settings']=VisuMZ[label][_0x208a24(0xc39)]||{},VisuMZ['ConvertParams']=function(_0x4ddc7d,_0x484947){const _0x1c146b=_0x208a24;for(const _0x497ae0 in _0x484947){if(_0x1c146b(0x9b3)!==_0x1c146b(0x9b3))_0x454f36[_0x1c146b(0xd28)]=!![],this[_0x1c146b(0x899)](_0x3c684a);else{if(_0x497ae0['match'](/(.*):(.*)/i)){const _0x3a11cf=String(RegExp['$1']),_0x34e0c1=String(RegExp['$2'])[_0x1c146b(0x4d6)]()[_0x1c146b(0x446)]();let _0x86947,_0x12e30b,_0xdd85b6;switch(_0x34e0c1){case _0x1c146b(0x18f):_0x86947=_0x484947[_0x497ae0]!==''?Number(_0x484947[_0x497ae0]):0x0;break;case _0x1c146b(0x6bf):_0x12e30b=_0x484947[_0x497ae0]!==''?JSON[_0x1c146b(0x794)](_0x484947[_0x497ae0]):[],_0x86947=_0x12e30b['map'](_0x4cabb9=>Number(_0x4cabb9));break;case _0x1c146b(0xad4):_0x86947=_0x484947[_0x497ae0]!==''?eval(_0x484947[_0x497ae0]):null;break;case _0x1c146b(0x860):_0x12e30b=_0x484947[_0x497ae0]!==''?JSON[_0x1c146b(0x794)](_0x484947[_0x497ae0]):[],_0x86947=_0x12e30b[_0x1c146b(0x58e)](_0x28b805=>eval(_0x28b805));break;case _0x1c146b(0x7b5):_0x86947=_0x484947[_0x497ae0]!==''?JSON[_0x1c146b(0x794)](_0x484947[_0x497ae0]):'';break;case _0x1c146b(0x736):_0x12e30b=_0x484947[_0x497ae0]!==''?JSON[_0x1c146b(0x794)](_0x484947[_0x497ae0]):[],_0x86947=_0x12e30b[_0x1c146b(0x58e)](_0x440ea3=>JSON[_0x1c146b(0x794)](_0x440ea3));break;case _0x1c146b(0xbe):_0x86947=_0x484947[_0x497ae0]!==''?new Function(JSON[_0x1c146b(0x794)](_0x484947[_0x497ae0])):new Function('return\x200');break;case'ARRAYFUNC':_0x12e30b=_0x484947[_0x497ae0]!==''?JSON[_0x1c146b(0x794)](_0x484947[_0x497ae0]):[],_0x86947=_0x12e30b[_0x1c146b(0x58e)](_0x5c7d13=>new Function(JSON[_0x1c146b(0x794)](_0x5c7d13)));break;case _0x1c146b(0xb56):_0x86947=_0x484947[_0x497ae0]!==''?String(_0x484947[_0x497ae0]):'';break;case _0x1c146b(0x588):_0x12e30b=_0x484947[_0x497ae0]!==''?JSON[_0x1c146b(0x794)](_0x484947[_0x497ae0]):[],_0x86947=_0x12e30b[_0x1c146b(0x58e)](_0x2e6307=>String(_0x2e6307));break;case _0x1c146b(0x226):_0xdd85b6=_0x484947[_0x497ae0]!==''?JSON['parse'](_0x484947[_0x497ae0]):{},_0x4ddc7d[_0x3a11cf]={},VisuMZ[_0x1c146b(0x4f4)](_0x4ddc7d[_0x3a11cf],_0xdd85b6);continue;case'ARRAYSTRUCT':_0x12e30b=_0x484947[_0x497ae0]!==''?JSON['parse'](_0x484947[_0x497ae0]):[],_0x86947=_0x12e30b[_0x1c146b(0x58e)](_0x333f69=>VisuMZ[_0x1c146b(0x4f4)]({},JSON[_0x1c146b(0x794)](_0x333f69)));break;default:continue;}_0x4ddc7d[_0x3a11cf]=_0x86947;}}}return _0x4ddc7d;},(_0x108fe5=>{const _0x9b0640=_0x208a24,_0x475813=_0x108fe5['name'];for(const _0x4ffe3f of dependencies){if(!Imported[_0x4ffe3f]){alert(_0x9b0640(0xae9)[_0x9b0640(0x75a)](_0x475813,_0x4ffe3f)),SceneManager[_0x9b0640(0x1b1)]();break;}}const _0x57c5af=_0x108fe5[_0x9b0640(0x1ce)];if(_0x57c5af[_0x9b0640(0x7fc)](/\[Version[ ](.*?)\]/i)){const _0x7988e4=Number(RegExp['$1']);_0x7988e4!==VisuMZ[label]['version']&&(alert('%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.'[_0x9b0640(0x75a)](_0x475813,_0x7988e4)),SceneManager[_0x9b0640(0x1b1)]());}if(_0x57c5af[_0x9b0640(0x7fc)](/\[Tier[ ](\d+)\]/i)){if(_0x9b0640(0xad)!=='qUEsg'){if(!_0x19d5c7[_0x9b0640(0x8c3)]())return;if(!_0x788ed7[_0x9b0640(0x4a6)])return;const _0x260b0e=_0x29a629['_scene'][_0x9b0640(0xa85)];if(!_0x260b0e)return;_0xdd3388[_0x9b0640(0x4f4)](_0x5b122e,_0xb8cd13);const _0x1c70e9=_0x1dd94f(_0x3f5823[_0x9b0640(0xbe2)])||0x0,_0xd5621c=_0x363e54(_0xb8d608[_0x9b0640(0xd5)]),_0x23f6da=_0x250603[_0x9b0640(0x2c6)]||0x1,_0x40d818=_0x1ea0fa[_0x9b0640(0x99b)]||'Linear';_0x260b0e[_0x9b0640(0x9f4)](_0x1c70e9,_0xd5621c,_0x23f6da,_0x40d818);}else{const _0xe0289e=Number(RegExp['$1']);_0xe0289e<tier?(alert(_0x9b0640(0xbd0)[_0x9b0640(0x75a)](_0x475813,_0xe0289e,tier)),SceneManager[_0x9b0640(0x1b1)]()):tier=Math[_0x9b0640(0x6db)](_0xe0289e,tier);}}VisuMZ[_0x9b0640(0x4f4)](VisuMZ[label][_0x9b0640(0xc39)],_0x108fe5['parameters']);})(pluginData),VisuMZ[_0x208a24(0x5bd)]=function(_0x9f9e66){const _0x23a34a=_0x208a24;let _0x2424b0=[];for(const _0x5c811b of _0x9f9e66){_0x2424b0=_0x2424b0[_0x23a34a(0x655)](VisuMZ[_0x23a34a(0xe0)](_0x5c811b));}return _0x2424b0[_0x23a34a(0x5a8)](_0xd0145b=>_0xd0145b);},VisuMZ[_0x208a24(0xe0)]=function(_0x5cf394){const _0x341063=_0x208a24,_0x25df84=BattleManager[_0x341063(0xbc8)]()[_0x341063(0x5a8)](_0x14e3f6=>_0x14e3f6&&_0x14e3f6[_0x341063(0x937)]()),_0x5832b3=BattleManager[_0x341063(0x64d)],_0x430f3b=BattleManager[_0x341063(0x29a)],_0x2c2aea=BattleManager[_0x341063(0xaea)]?BattleManager[_0x341063(0xaea)]['slice'](0x0):_0x25df84;_0x5cf394=_0x5cf394['toLowerCase']()[_0x341063(0x446)]();if(_0x5cf394===_0x341063(0x955)){if(_0x341063(0x577)!==_0x341063(0x1e9))return[_0x5832b3];else{if(this[_0x341063(0x570)]===_0x341063(0x330))return![];if(this['_targetBattlerKey']===_0x341063(0x4da))return![];if(!this[_0x341063(0x81b)]&&this[_0x341063(0x6a9)]()[_0x341063(0x82a)]())return![];if(this[_0x341063(0x8cb)]())return!![];if(!this[_0x341063(0x8bb)]())return![];return typeof this[_0x341063(0x8bb)]()['scope']===_0x341063(0x32d);}}else{if(_0x5cf394===_0x341063(0x2ff)){if('PNcHz'!=='lHiIj')return[_0x430f3b];else{const _0x1003fd=this[_0x341063(0x8bb)]()[_0x341063(0x6c4)];if(_0x1003fd[_0x341063(0x7fc)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x1003fd[_0x341063(0x7fc)](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return _0x210928(_0x510c52['$1'])/0x64;else{let _0x284fb9=_0x33c3ba[_0x341063(0x759)][_0x341063(0x74a)][_0x341063(0x783)](this,_0x61e4f2);return _0x284fb9=this['_multipliers'][_0x341063(0xa8f)]*_0x284fb9+this[_0x341063(0x27b)][_0x341063(0x2e5)],_0x284fb9;}}}}else{if(_0x5cf394===_0x341063(0xc6)){if(_0x430f3b){if(_0x341063(0x516)===_0x341063(0x516)){const _0x19485e=_0x2c2aea[_0x341063(0x6d1)](_0x430f3b);return _0x19485e>=0x0?[_0x2c2aea[_0x19485e-0x1]||_0x430f3b]:[_0x430f3b];}else _0x3d4703[_0x341063(0x759)]['Window_BattleLog_displayActionResults'][_0x341063(0x783)](this,_0x12f655,_0x1d852b);}}else{if(_0x5cf394===_0x341063(0xd32)){if(_0x430f3b){const _0x5ce44e=_0x2c2aea['indexOf'](_0x430f3b);return _0x5ce44e>=0x0?[_0x2c2aea[_0x5ce44e+0x1]||_0x430f3b]:[_0x430f3b];}}else{if(_0x5cf394===_0x341063(0x4ea))return _0x2c2aea;else{if(_0x5cf394===_0x341063(0xc8))return[_0x5832b3][_0x341063(0x655)](_0x2c2aea);else{if(_0x5cf394===_0x341063(0x3cd))return _0x25df84['filter'](_0x24f3e0=>_0x24f3e0!==_0x5832b3&&!_0x2c2aea[_0x341063(0xcaf)](_0x24f3e0)&&_0x24f3e0[_0x341063(0x67f)]());else{if(_0x5cf394===_0x341063(0xab9)){if(_0x341063(0x72e)===_0x341063(0x565))this[_0x341063(0x811)]=!![];else return[VisuMZ['GetActionSequenceSpecialTarget']()];}else{if(_0x5cf394[_0x341063(0x7fc)](/SPECIAL (.*)>/i)){const _0x4fae1b=String(RegExp['$1'])[_0x341063(0xc85)](',')['map'](_0x4ab2bd=>_0x4ab2bd[_0x341063(0x446)]());return[VisuMZ[_0x341063(0x4b2)](_0x4fae1b)];}}}}}}}}}if(_0x5832b3){if('FjHys'===_0x341063(0x2f0)){if(_0x5cf394===_0x341063(0x264))return _0x5832b3[_0x341063(0x281)]()[_0x341063(0x49a)]();else{if(_0x5cf394===_0x341063(0x790))return _0x5832b3[_0x341063(0x281)]()[_0x341063(0x49a)]()[_0x341063(0x5a8)](_0x36f9d5=>_0x36f9d5!==_0x5832b3);else{if(_0x5cf394===_0x341063(0x664))return _0x5832b3[_0x341063(0x281)]()[_0x341063(0x49a)]()[_0x341063(0x5a8)](_0x2cac89=>_0x2cac89!==_0x430f3b);else{if(_0x5cf394==='dead\x20friends')return _0x5832b3['friendsUnit']()[_0x341063(0xa29)]();else{if(_0x5cf394[_0x341063(0x7fc)](/FRIEND INDEX (\d+)/i)){const _0x470c43=Number(RegExp['$1']);return[_0x5832b3['friendsUnit']()[_0x341063(0x30f)]()[_0x470c43]];}}}}}if(_0x5cf394===_0x341063(0x7cb))return _0x5832b3['opponentsUnit']()[_0x341063(0x49a)]();else{if(_0x5cf394===_0x341063(0x5e7))return _0x5832b3[_0x341063(0x505)]()[_0x341063(0x49a)]()['filter'](_0x575aac=>_0x575aac!==_0x430f3b);else{if(_0x5cf394===_0x341063(0x29f))return _0x5832b3[_0x341063(0x505)]()[_0x341063(0xa29)]();else{if(_0x5cf394[_0x341063(0x7fc)](/OPPONENT INDEX (\d+)/i)){const _0x325791=Number(RegExp['$1']);return[_0x5832b3['opponentsUnit']()[_0x341063(0x30f)]()[_0x325791]];}}}}}else this[_0x341063(0x1c2)]=new _0x379862(),this[_0x341063(0x1c2)][_0x341063(0x63f)]=_0x4fe1cb[_0x341063(0x5a0)](_0x341063(0x310)),this[_0x341063(0x1c2)][_0x341063(0x63f)][_0x341063(0xfe)]=_0x3fa47a['BattleCore']['Settings'][_0x341063(0x5a5)][_0x341063(0x2eb)],this['_shadowSprite']['anchor']['x']=0.5,this[_0x341063(0x1c2)]['anchor']['y']=0.5,this[_0x341063(0x1c2)]['y']=-0x2,this[_0x341063(0x1c2)][_0x341063(0x3b3)]=![],this['addChild'](this[_0x341063(0x1c2)]);}if(_0x5cf394===_0x341063(0x663))return $gameParty[_0x341063(0x49a)]();else{if(_0x5cf394==='alive\x20actors\x20not\x20user')return $gameParty[_0x341063(0x49a)]()[_0x341063(0x5a8)](_0x1a84b8=>_0x1a84b8!==_0x5832b3);else{if(_0x5cf394===_0x341063(0x106)){if(_0x341063(0x4f7)!==_0x341063(0x4f7)){const _0x2b53cd=_0x537a14['_scene'][_0x341063(0xb92)];this[_0x341063(0x449)]()['isActor']()?_0x2b53cd[_0x341063(0x80c)](this[_0x341063(0x449)]()[_0x341063(0x22f)]()):_0x2b53cd[_0x341063(0x82d)]();}else return $gameParty[_0x341063(0x49a)]()[_0x341063(0x5a8)](_0xd0363b=>_0xd0363b!==_0x430f3b);}else{if(_0x5cf394===_0x341063(0x262))return $gameParty[_0x341063(0xa29)]();else{if(_0x5cf394[_0x341063(0x7fc)](/ACTOR INDEX (\d+)/i)){const _0x51b693=Number(RegExp['$1']);return[$gameParty[_0x341063(0x30f)]()[_0x51b693]];}else{if(_0x5cf394[_0x341063(0x7fc)](/ACTOR ID (\d+)/i)){if(_0x341063(0x17c)===_0x341063(0x17c)){const _0x4b63ca=Number(RegExp['$1']);return[$gameActors[_0x341063(0x178)](_0x4b63ca)];}else{const _0x5250b7=new _0x297507();_0x5250b7[_0x341063(0x63f)]=_0x101c9f[_0x341063(0x5a0)](_0xd1985f[_0x341063(0x5bc)]),_0x5250b7['x']=_0x48d619['StatusWindowAttachmentBackOffsetX']||0x0,_0x5250b7['y']=_0x2e7c78[_0x341063(0x11a)]||0x0,this[_0x341063(0x350)](_0x5250b7),this[_0x341063(0xd4d)]=_0x5250b7;}}}}}}}if(_0x5cf394===_0x341063(0x725)){if(_0x341063(0xae7)==='stUeB')return $gameTroop[_0x341063(0x49a)]();else _0x539017=!_0x18c3d4;}else{if(_0x5cf394==='alive\x20enemies\x20not\x20user'){if(_0x341063(0xd22)!=='txHHv'){if(!this[_0x341063(0x302)])return;const _0x1727af=this['_actor']['battleCommands']();for(const _0xc944ee of _0x1727af){this[_0x341063(0xca7)](_0xc944ee[_0x341063(0x4d6)]()[_0x341063(0x446)]());}}else return $gameTroop[_0x341063(0x49a)]()['filter'](_0x4808db=>_0x4808db!==_0x5832b3);}else{if(_0x5cf394===_0x341063(0x929))return $gameTroop[_0x341063(0x49a)]()[_0x341063(0x5a8)](_0x50079f=>_0x50079f!==_0x430f3b);else{if(_0x5cf394===_0x341063(0xc11))return $gameTroop[_0x341063(0xa29)]();else{if(_0x5cf394[_0x341063(0x7fc)](/ENEMY INDEX (\d+)/i)){if('jNPqm'!==_0x341063(0xf9)){const _0x53f6a8=Number(RegExp['$1']);return[$gameTroop[_0x341063(0x30f)]()[_0x53f6a8]];}else _0x222296['BattleCore'][_0x341063(0x976)][_0x341063(0x783)](this);}else{if(_0x5cf394[_0x341063(0x7fc)](/ENEMY ID (\d+)/i)){const _0x4a7f58=Number(RegExp['$1']);return $gameTroop['aliveMembers']()['filter'](_0x224235=>_0x224235[_0x341063(0xb09)]()===_0x4a7f58);}}}}}}if(_0x5cf394===_0x341063(0xbc))return _0x25df84[_0x341063(0x5a8)](_0x1c1270=>_0x1c1270['isAlive']());else{if(_0x5cf394===_0x341063(0x177)){if(_0x341063(0x50b)!==_0x341063(0xc5))return _0x25df84[_0x341063(0x5a8)](_0xff25f0=>_0xff25f0[_0x341063(0x97c)]()&&_0xff25f0!==_0x5832b3);else{if(_0x4596db[_0x341063(0x169)]>_0x4cdaf8)_0x470720+=_0x2ab1da[_0x341063(0x4fe)]/0x2+_0x522654;if(_0x1751fa[_0x341063(0x169)]<_0x5c5935)_0x4596e9-=_0xbb5cd1[_0x341063(0x4fe)]/0x2+_0x2f2fa1;}}else{if(_0x5cf394==='alive\x20battlers\x20not\x20target')return'JenBA'!==_0x341063(0x593)?_0x25df84['filter'](_0x2c6e8b=>_0x2c6e8b[_0x341063(0x97c)]()&&_0x2c6e8b!==_0x430f3b):this[_0x341063(0x558)]===_0x341063(0x6ef)?this[_0x341063(0x21a)]():_0x530f8c[_0x341063(0x759)][_0x341063(0xa90)][_0x341063(0x783)](this);else{if(_0x5cf394===_0x341063(0x15a))return'gThtz'!==_0x341063(0x773)?_0x25df84[_0x341063(0x5a8)](_0x58f7ab=>_0x58f7ab[_0x341063(0x248)]()):this[_0x341063(0x3c0)]();}}}return[];},VisuMZ[_0x208a24(0x35d)]=function(){const _0x3de981=_0x208a24;return BattleManager[_0x3de981(0x29a)];},VisuMZ[_0x208a24(0x4b2)]=function(_0x3c3f23){const _0x563605=_0x208a24;return BattleManager[_0x563605(0x29a)];},PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Set_SetupAction',_0x57efdb=>{const _0x47267d=_0x208a24;if(!SceneManager[_0x47267d(0x8c3)]())return;VisuMZ[_0x47267d(0x4f4)](_0x57efdb,_0x57efdb);const _0x4beb16=$gameTemp[_0x47267d(0xcc)](),_0x2ebbfc=BattleManager[_0x47267d(0x8fb)],_0x3021f2=BattleManager[_0x47267d(0x64d)],_0xcd60f=BattleManager[_0x47267d(0xaea)]?BattleManager[_0x47267d(0xaea)][_0x47267d(0xa3f)](0x0):[],_0x1269e2=BattleManager[_0x47267d(0x46b)];if(!_0x4beb16||!_0x2ebbfc||!_0x3021f2)return;if(!_0x2ebbfc[_0x47267d(0x8bb)]())return;if(_0x57efdb[_0x47267d(0x5f1)])_0x1269e2['displayAction'](_0x3021f2,_0x2ebbfc[_0x47267d(0x8bb)]());_0x57efdb[_0x47267d(0x3f0)]&&_0x1269e2['push'](_0x47267d(0x731),_0x3021f2,_0xcd60f,!![]);if(_0x57efdb[_0x47267d(0x892)])_0x1269e2[_0x47267d(0x7c3)](_0x47267d(0x997),_0x3021f2,_0x2ebbfc);if(_0x57efdb[_0x47267d(0x2ba)])_0x1269e2[_0x47267d(0x7c3)](_0x47267d(0x28d));if(_0x57efdb['CastAnimation'])_0x1269e2[_0x47267d(0x7c3)](_0x47267d(0xb17),_0x3021f2,_0x2ebbfc);if(_0x57efdb['WaitForAnimation'])_0x1269e2[_0x47267d(0x7c3)](_0x47267d(0x32a));_0x4beb16[_0x47267d(0x3dc)](_0x47267d(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Set_WholeActionSet',_0x58322f=>{const _0x1f380f=_0x208a24;if(!SceneManager[_0x1f380f(0x8c3)]())return;VisuMZ['ConvertParams'](_0x58322f,_0x58322f);const _0x315dac=$gameTemp[_0x1f380f(0xcc)](),_0x9d6993=BattleManager[_0x1f380f(0x8fb)],_0x30f393=BattleManager[_0x1f380f(0x64d)],_0x21b054=BattleManager[_0x1f380f(0xaea)]?BattleManager['_allTargets'][_0x1f380f(0xa3f)](0x0):[],_0x2b138f=BattleManager['_logWindow'],_0x473dec=_0x58322f[_0x1f380f(0x437)]??![];if(!_0x315dac||!_0x9d6993||!_0x30f393)return;if(!_0x9d6993[_0x1f380f(0x8bb)]())return;let _0x28284c=_0x473dec?_0x2b138f[_0x1f380f(0xa72)](_0x30f393):0x1;for(let _0x49b42b=0x0;_0x49b42b<_0x28284c;_0x49b42b++){_0x473dec&&_0x30f393[_0x1f380f(0x9bf)]()&&_0x2b138f[_0x1f380f(0x7c3)](_0x1f380f(0x907),_0x30f393,_0x49b42b);if(_0x58322f[_0x1f380f(0xc78)])_0x2b138f[_0x1f380f(0x7c3)]('performAction',_0x30f393,_0x9d6993);if(_0x58322f[_0x1f380f(0x7f4)]>0x0)_0x2b138f[_0x1f380f(0x7c3)](_0x1f380f(0xd59),_0x58322f[_0x1f380f(0x7f4)]);if(_0x58322f[_0x1f380f(0x6bc)])_0x2b138f['push'](_0x1f380f(0x215),_0x30f393,_0x21b054,_0x9d6993[_0x1f380f(0x8bb)]()['animationId']);if(_0x58322f[_0x1f380f(0x610)])_0x2b138f[_0x1f380f(0x7c3)]('waitForAnimation');for(const _0x761a99 of _0x21b054){if(!_0x761a99)continue;if(_0x58322f[_0x1f380f(0xd11)])_0x2b138f[_0x1f380f(0x7c3)](_0x1f380f(0x29e),_0x30f393,_0x761a99);}}_0x473dec&&_0x30f393['isActor']()&&(_0x1f380f(0xb3c)===_0x1f380f(0x774)?this[_0x1f380f(0x130)]():_0x2b138f['push'](_0x1f380f(0xd4a),_0x30f393));if(_0x58322f[_0x1f380f(0x3f0)])_0x2b138f['push'](_0x1f380f(0x731),_0x30f393,_0x21b054,![]);_0x315dac[_0x1f380f(0x3dc)](_0x1f380f(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x5ef),_0x52e0c2=>{const _0x5a01b1=_0x208a24;if(!SceneManager[_0x5a01b1(0x8c3)]())return;VisuMZ['ConvertParams'](_0x52e0c2,_0x52e0c2);const _0x433605=$gameTemp['getLastPluginCommandInterpreter'](),_0x3770a0=BattleManager[_0x5a01b1(0x8fb)],_0xdcffb=BattleManager['_subject'],_0x292d9d=BattleManager['_allTargets']?BattleManager[_0x5a01b1(0xaea)][_0x5a01b1(0xa3f)](0x0):[],_0x4eac9f=BattleManager[_0x5a01b1(0x46b)],_0x45f98f=_0x52e0c2[_0x5a01b1(0x437)]??![];if(!_0x433605||!_0x3770a0||!_0xdcffb)return;if(!_0x3770a0[_0x5a01b1(0x8bb)]())return;let _0x161d5d=_0x45f98f?_0x4eac9f['getDualWieldTimes'](_0xdcffb):0x1;for(let _0x514532=0x0;_0x514532<_0x161d5d;_0x514532++){for(const _0x24269f of _0x292d9d){if(!_0x24269f)continue;_0x45f98f&&_0xdcffb['isActor']()&&_0x4eac9f['push'](_0x5a01b1(0x907),_0xdcffb,_0x514532);if(_0x52e0c2[_0x5a01b1(0xc78)])_0x4eac9f['push'](_0x5a01b1(0x3f6),_0xdcffb,_0x3770a0);if(_0x52e0c2[_0x5a01b1(0x603)]>0x0)_0x4eac9f[_0x5a01b1(0x7c3)](_0x5a01b1(0xd59),_0x52e0c2['WaitCount1']);if(_0x52e0c2[_0x5a01b1(0x6bc)])_0x4eac9f[_0x5a01b1(0x7c3)](_0x5a01b1(0x215),_0xdcffb,[_0x24269f],_0x3770a0[_0x5a01b1(0x8bb)]()[_0x5a01b1(0x465)]);if(_0x52e0c2[_0x5a01b1(0x98f)]>0x0)_0x4eac9f[_0x5a01b1(0x7c3)](_0x5a01b1(0xd59),_0x52e0c2[_0x5a01b1(0x98f)]);if(_0x52e0c2[_0x5a01b1(0xd11)])_0x4eac9f[_0x5a01b1(0x7c3)](_0x5a01b1(0x29e),_0xdcffb,_0x24269f);}}_0x45f98f&&_0xdcffb[_0x5a01b1(0x9bf)]()&&(_0x5a01b1(0x3de)!==_0x5a01b1(0xa5)?_0x4eac9f[_0x5a01b1(0x7c3)](_0x5a01b1(0xd4a),_0xdcffb):(_0x589218[_0x5a01b1(0xbd8)][_0x5a01b1(0x86c)]['call'](this),this[_0x5a01b1(0xb3f)]()));if(_0x52e0c2[_0x5a01b1(0x3f0)])_0x4eac9f[_0x5a01b1(0x7c3)](_0x5a01b1(0x731),_0xdcffb,_0x292d9d,![]);_0x433605['setWaitMode'](_0x5a01b1(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x233),_0xdc285c=>{const _0x2dcc92=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2dcc92(0x4f4)](_0xdc285c,_0xdc285c);const _0x57d548=$gameTemp['getLastPluginCommandInterpreter'](),_0x2c3cdb=BattleManager[_0x2dcc92(0x8fb)],_0x25f1c5=BattleManager[_0x2dcc92(0x64d)],_0x42cc9d=BattleManager[_0x2dcc92(0xaea)]?BattleManager[_0x2dcc92(0xaea)][_0x2dcc92(0xa3f)](0x0):[],_0x3769f9=BattleManager[_0x2dcc92(0x46b)];if(!_0x57d548||!_0x2c3cdb||!_0x25f1c5)return;if(!_0x2c3cdb['item']())return;if(_0xdc285c[_0x2dcc92(0x3f0)])_0x3769f9[_0x2dcc92(0x7c3)](_0x2dcc92(0x731),_0x25f1c5,_0x42cc9d,![]);if(_0xdc285c[_0x2dcc92(0x992)])_0x3769f9[_0x2dcc92(0x7c3)]('waitForNewLine');if(_0xdc285c['WaitForEffect'])_0x3769f9['push'](_0x2dcc92(0x2d3));if(_0xdc285c[_0x2dcc92(0xa0d)])_0x3769f9[_0x2dcc92(0x7c3)]('clear');if(_0xdc285c['ActionEnd'])_0x3769f9[_0x2dcc92(0x7c3)](_0x2dcc92(0x749),_0x25f1c5);if(_0xdc285c['WaitForMovement'])_0x3769f9['push'](_0x2dcc92(0x28d));_0x57d548['setWaitMode'](_0x2dcc92(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x567),_0x3e8bfc=>{const _0x234c27=_0x208a24;if(!SceneManager[_0x234c27(0x8c3)]())return;if(!Imported[_0x234c27(0x355)])return;VisuMZ[_0x234c27(0x4f4)](_0x3e8bfc,_0x3e8bfc);const _0x45d714=$gameTemp[_0x234c27(0xcc)](),_0x3aaa4e=_0x3e8bfc[_0x234c27(0xbca)];if(!_0x45d714)return;$gameScreen[_0x234c27(0x2d0)](_0x3e8bfc[_0x234c27(0xbe2)],_0x3e8bfc[_0x234c27(0x2c6)],_0x3e8bfc[_0x234c27(0x99b)]);if(_0x3aaa4e)_0x45d714[_0x234c27(0x3dc)](_0x234c27(0xd52));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Angle_Reset',_0x387ac6=>{const _0x5e7e4a=_0x208a24;if(!SceneManager[_0x5e7e4a(0x8c3)]())return;if(!Imported[_0x5e7e4a(0x355)])return;VisuMZ[_0x5e7e4a(0x4f4)](_0x387ac6,_0x387ac6);const _0x27a7e4=$gameTemp['getLastPluginCommandInterpreter'](),_0x55f8a6=_0x387ac6[_0x5e7e4a(0xbca)];if(!_0x27a7e4)return;$gameScreen['setBattleAngle'](0x0,_0x387ac6[_0x5e7e4a(0x2c6)],_0x387ac6[_0x5e7e4a(0x99b)]);if(_0x55f8a6)_0x27a7e4[_0x5e7e4a(0x3dc)](_0x5e7e4a(0xd52));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Angle_WaitForAngle',_0x5c0c62=>{const _0x5b1671=_0x208a24;if(!SceneManager[_0x5b1671(0x8c3)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;const _0x3a2c91=$gameTemp[_0x5b1671(0xcc)]();if(!_0x3a2c91)return;_0x3a2c91[_0x5b1671(0x3dc)](_0x5b1671(0xd52));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0xc76),_0x16410c=>{const _0x5337b8=_0x208a24;if(!SceneManager[_0x5337b8(0x8c3)]())return;VisuMZ[_0x5337b8(0x4f4)](_0x16410c,_0x16410c);const _0x48cb52=$gameTemp[_0x5337b8(0xcc)](),_0x478062=BattleManager[_0x5337b8(0x8fb)],_0x29e1e9=BattleManager['_subject'],_0x459fad=VisuMZ[_0x5337b8(0x5bd)](_0x16410c['Targets']),_0x46d49c=_0x16410c['Mirror'],_0x36dc71=BattleManager[_0x5337b8(0x46b)];if(!_0x48cb52||!_0x478062||!_0x29e1e9)return;if(!_0x478062[_0x5337b8(0x8bb)]())return;let _0x256d15=_0x478062['item']()['animationId'];if(_0x256d15<0x0)_0x256d15=_0x29e1e9[_0x5337b8(0x36a)]();$gameTemp['requestAnimation'](_0x459fad,_0x256d15,_0x46d49c);if(_0x16410c[_0x5337b8(0x610)]){if(_0x5337b8(0x63e)!==_0x5337b8(0x63e)){let _0x4606af='battleUIOffsetX';if(this['checkCacheKey'](_0x4606af))return this[_0x5337b8(0x3b0)][_0x4606af];return this['_cache'][_0x4606af]=this[_0x5337b8(0x5a1)](this[_0x5337b8(0x449)]()),this[_0x5337b8(0x3b0)][_0x4606af];}else _0x48cb52[_0x5337b8(0x3dc)](_0x5337b8(0x7d6));}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0xb18),_0x3cd005=>{const _0x209025=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3cd005,_0x3cd005);const _0x239374=$gameTemp[_0x209025(0xcc)](),_0x251c09=BattleManager[_0x209025(0x64d)],_0x45e5b0=VisuMZ[_0x209025(0x5bd)](_0x3cd005[_0x209025(0x83d)]),_0x12352a=_0x3cd005[_0x209025(0x6f6)],_0x5e0f36=BattleManager[_0x209025(0x46b)];if(!_0x239374||!_0x251c09)return;const _0x324b98=_0x251c09[_0x209025(0x36a)]();$gameTemp[_0x209025(0x2d8)](_0x45e5b0,_0x324b98,_0x12352a),_0x3cd005[_0x209025(0x610)]&&_0x239374[_0x209025(0x3dc)](_0x209025(0x7d6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x851),_0x3f67e2=>{const _0xf66cb4=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3f67e2,_0x3f67e2);const _0x1ee41c=_0x187a16['attackAnimationIdSlot'](_0x3f67e2[_0xf66cb4(0xc10)]);if(_0x1ee41c<=0x0)return;const _0x16311b=$gameTemp[_0xf66cb4(0xcc)](),_0x187a16=BattleManager[_0xf66cb4(0x64d)],_0x1df8b6=VisuMZ[_0xf66cb4(0x5bd)](_0x3f67e2[_0xf66cb4(0x83d)]),_0x458d03=_0x3f67e2[_0xf66cb4(0x6f6)],_0xa15a6e=BattleManager[_0xf66cb4(0x46b)];if(!_0x16311b||!_0x187a16)return;$gameTemp[_0xf66cb4(0x2d8)](_0x1df8b6,_0x1ee41c,_0x458d03),_0x3f67e2['WaitForAnimation']&&_0x16311b[_0xf66cb4(0x3dc)]('battleAnimation');}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0xc14),_0xe81257=>{const _0x1e37f0=_0x208a24;if(!SceneManager[_0x1e37f0(0x8c3)]())return;VisuMZ['ConvertParams'](_0xe81257,_0xe81257);const _0xd95088=$gameTemp[_0x1e37f0(0xcc)](),_0x5b0631=VisuMZ['CreateActionSequenceTargets'](_0xe81257[_0x1e37f0(0x83d)]),_0xadaab1=_0xe81257[_0x1e37f0(0x5a2)];let _0x167947=0x0;switch(_0xadaab1[_0x1e37f0(0x4d6)]()[_0x1e37f0(0x446)]()){case'!':case _0x1e37f0(0x3aa):_0x167947=0x1;break;case'?':case'QUESTION':_0x167947=0x2;break;case _0x1e37f0(0x7c8):case _0x1e37f0(0x33a):case _0x1e37f0(0x6ab):case'MUSIC-NOTE':case _0x1e37f0(0x846):_0x167947=0x3;break;case'HEART':case'LOVE':_0x167947=0x4;break;case'ANGLE':case _0x1e37f0(0xdf):_0x167947=0x5;break;case _0x1e37f0(0xe6):_0x167947=0x6;break;case'COBWEB':case _0x1e37f0(0x71e):case _0x1e37f0(0x9ee):_0x167947=0x7;break;case _0x1e37f0(0x9c7):case _0x1e37f0(0xc8a):_0x167947=0x8;break;case'LIGHT':case _0x1e37f0(0xb64):case _0x1e37f0(0xcbe):case _0x1e37f0(0x493):case'LIGHTBULB':_0x167947=0x9;break;case'Z':case'ZZ':case'ZZZ':case _0x1e37f0(0x901):_0x167947=0xa;break;case _0x1e37f0(0xc5f):_0x167947=0xb;break;case'USER-DEFINED\x202':_0x167947=0xc;break;case _0x1e37f0(0xb44):_0x167947=0xd;break;case _0x1e37f0(0xa9d):_0x167947=0xe;break;case _0x1e37f0(0x7fe):_0x167947=0xf;break;}for(const _0x38d505 of _0x5b0631){if('HCZmm'!==_0x1e37f0(0xf5))this['_weaponImageId']=_0x2d13ac,this['_animationCount']=-_0x4f945b,this[_0x1e37f0(0x25d)]=_0x5b5f37,this[_0x1e37f0(0x845)](),this[_0x1e37f0(0xbd1)]();else{if(!_0x38d505)continue;$gameTemp['requestBattleBalloon'](_0x38d505,_0x167947);}}_0xe81257['WaitComplete']&&_0xd95088&&(_0xd95088['wait'](0x1),_0xd95088[_0x1e37f0(0x3dc)](_0x1e37f0(0xa89)));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Animation_BalloonIcon',_0x3de00c=>{const _0x4034cc=_0x208a24;if(!SceneManager[_0x4034cc(0x8c3)]())return;if(!Imported[_0x4034cc(0x88a)])return;VisuMZ[_0x4034cc(0x4f4)](_0x3de00c,_0x3de00c);const _0x112ac2=$gameTemp['getLastPluginCommandInterpreter'](),_0x4cdd44=VisuMZ[_0x4034cc(0x5bd)](_0x3de00c[_0x4034cc(0x83d)]),_0x24b544=_0x3de00c[_0x4034cc(0xb40)];for(const _0x3e525b of _0x4cdd44){if(!_0x3e525b)continue;$gameTemp['requestBattleBalloon'](_0x3e525b,[_0x24b544]);}if(_0x3de00c[_0x4034cc(0xaa2)]&&_0x112ac2){if('AVfVp'===_0x4034cc(0x8b8))_0x112ac2[_0x4034cc(0xac0)](0x1),_0x112ac2[_0x4034cc(0x3dc)](_0x4034cc(0xa89));else{if(!_0x3039f7[_0x4034cc(0x8c3)]())return;_0x24711c[_0x4034cc(0x4f4)](_0x4f65ff,_0x10c742);const _0x440982=_0x8c6153[_0x4034cc(0x6df)](_0x1c70da['Slot']);if(_0x440982<=0x0)return;const _0x19a34c=_0x3387e7['getLastPluginCommandInterpreter'](),_0x8c6153=_0x483724[_0x4034cc(0x64d)],_0x3a61fc=_0x3c155e[_0x4034cc(0x5bd)](_0x2a311e[_0x4034cc(0x83d)]),_0x83fb4f=_0x9d54be[_0x4034cc(0x6f6)],_0x4a0354=_0x5901d7[_0x4034cc(0x46b)];if(!_0x19a34c||!_0x8c6153)return;_0x15a7bf['requestAnimation'](_0x3a61fc,_0x440982,_0x83fb4f),_0x75597e[_0x4034cc(0x610)]&&_0x19a34c[_0x4034cc(0x3dc)](_0x4034cc(0x7d6));}}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0xe5),_0x346313=>{const _0x572b60=_0x208a24;if(!SceneManager[_0x572b60(0x8c3)]())return;if(!Imported['VisuMZ_4_IconBalloons'])return;VisuMZ['ConvertParams'](_0x346313,_0x346313);const _0x463223=$gameTemp[_0x572b60(0xcc)](),_0x3f3227=VisuMZ['CreateActionSequenceTargets'](_0x346313[_0x572b60(0x83d)]),_0x1eeba1=Math[_0x572b60(0x618)](Number(_0x346313[_0x572b60(0x76e)]||0x0),Number(_0x346313['endIcon']||0x0)),_0x1a8192=Math[_0x572b60(0x6db)](Number(_0x346313[_0x572b60(0x76e)]||0x0),Number(_0x346313[_0x572b60(0xa47)]||0x0)),_0xc3bec8=[];for(let _0xcf0c79=_0x1eeba1;_0xcf0c79<=_0x1a8192;_0xcf0c79++){if(_0x572b60(0xd2a)===_0x572b60(0xd2a))_0xc3bec8[_0x572b60(0x7c3)](_0xcf0c79);else{if(_0x36f786[_0x572b60(0x759)][_0x572b60(0xc39)][_0x572b60(0x98d)][_0x572b60(0x8f5)])return _0xb21a1a[_0x572b60(0x759)][_0x572b60(0xc39)][_0x572b60(0x98d)][_0x572b60(0x8f5)][_0x572b60(0x783)](this);return _0x173059['BattleCore'][_0x572b60(0x85b)][_0x572b60(0x783)](this);}}for(const _0x35f259 of _0x3f3227){if(!_0x35f259)continue;$gameTemp['requestBattleBalloon'](_0x35f259,_0xc3bec8);}_0x346313[_0x572b60(0xaa2)]&&_0x463223&&(_0x572b60(0x33c)!==_0x572b60(0x8be)?(_0x463223[_0x572b60(0xac0)](0x1),_0x463223[_0x572b60(0x3dc)]('battleBalloon')):_0x3cf693['Actor']['PrioritySortActors']=!![]);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x2e2),_0x37999a=>{const _0x47d532=_0x208a24;if(!SceneManager[_0x47d532(0x8c3)]())return;if(!Imported[_0x47d532(0x88a)])return;VisuMZ[_0x47d532(0x4f4)](_0x37999a,_0x37999a);const _0x2b0abc=$gameTemp[_0x47d532(0xcc)](),_0x27cb51=VisuMZ[_0x47d532(0x5bd)](_0x37999a['Targets']),_0x3dd1c0=_0x37999a[_0x47d532(0xbae)];for(const _0x55f2f7 of _0x27cb51){if(!_0x55f2f7)continue;$gameTemp[_0x47d532(0x752)](_0x55f2f7,_0x3dd1c0);}_0x37999a['WaitComplete']&&_0x2b0abc&&('xHCAJ'!==_0x47d532(0x6c1)?(_0x2b0abc[_0x47d532(0xac0)](0x1),_0x2b0abc[_0x47d532(0x3dc)]('battleBalloon')):(this[_0x47d532(0xb11)]=this[_0x47d532(0x449)]()[_0x47d532(0x278)](),this['refresh']()));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x58c),_0x55abfd=>{const _0x56d0f6=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x56d0f6(0x4f4)](_0x55abfd,_0x55abfd);const _0x5062be=$gameTemp[_0x56d0f6(0xcc)](),_0x1c9735=BattleManager[_0x56d0f6(0x8fb)],_0x1ad079=_0x55abfd['Mirror'],_0x3d2a0d=VisuMZ[_0x56d0f6(0x5bd)](_0x55abfd[_0x56d0f6(0x83d)]);if(!_0x5062be||!_0x1c9735)return;if(!_0x1c9735[_0x56d0f6(0x8bb)]())return;for(const _0x306853 of _0x3d2a0d){if(!_0x306853)continue;_0x306853[_0x56d0f6(0xb17)](_0x1c9735,_0x1ad079);}if(_0x55abfd[_0x56d0f6(0x610)])_0x5062be[_0x56d0f6(0x3dc)](_0x56d0f6(0x7d6));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x32e),_0x21825b=>{const _0x3a7d62=_0x208a24;VisuMZ[_0x3a7d62(0x4f4)](_0x21825b,_0x21825b);const _0x4e8955=$gameTemp[_0x3a7d62(0xcc)](),_0x3380ae=VisuMZ[_0x3a7d62(0x5bd)](_0x21825b[_0x3a7d62(0x83d)]),_0x5bb010=_0x21825b[_0x3a7d62(0x6e9)];if(!_0x5bb010)return;for(const _0x284325 of _0x3380ae){if('nnISP'!=='KvYPB'){if(!_0x284325)continue;if(!_0x284325[_0x3a7d62(0x9bf)]())continue;_0x284325[_0x3a7d62(0x365)](_0x5bb010);}else this['_actorCommandWindow']['open']();}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Animation_GuardAnimation',_0xed7a7a=>{const _0x9acf87=_0x208a24;if(!SceneManager[_0x9acf87(0x8c3)]())return;VisuMZ['ConvertParams'](_0xed7a7a,_0xed7a7a);const _0x5782d3=$gameTemp['getLastPluginCommandInterpreter'](),_0x48d146=BattleManager[_0x9acf87(0x64d)],_0x119bbd=VisuMZ['CreateActionSequenceTargets'](_0xed7a7a['Targets']),_0x293285=_0xed7a7a[_0x9acf87(0x6f6)];if(!_0x5782d3||!_0x48d146)return;const _0x3a298d=$dataSkilles[_0x48d146[_0x9acf87(0x152)]()],_0x16133f=_0x3a298d[_0x9acf87(0x465)];$gameTemp[_0x9acf87(0x2d8)](_0x119bbd,_0x16133f,_0x293285),_0xed7a7a[_0x9acf87(0x610)]&&_0x5782d3[_0x9acf87(0x3dc)](_0x9acf87(0x7d6));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x4e9),_0x485aed=>{const _0x3f1ff2=_0x208a24;if(!SceneManager[_0x3f1ff2(0x8c3)]())return;VisuMZ[_0x3f1ff2(0x4f4)](_0x485aed,_0x485aed);const _0x2895e7=$gameTemp['getLastPluginCommandInterpreter'](),_0x4b84e0=VisuMZ[_0x3f1ff2(0x5bd)](_0x485aed[_0x3f1ff2(0x83d)]),_0x49b50a=Number(_0x485aed[_0x3f1ff2(0xc68)]||0x1),_0x23c099=$dataItems[_0x49b50a],_0x3184bc=_0x485aed[_0x3f1ff2(0x6f6)];if(!_0x2895e7)return;if(!_0x23c099)return;let _0x250c08=_0x23c099[_0x3f1ff2(0x465)];$gameTemp['requestAnimation'](_0x4b84e0,_0x250c08,_0x3184bc);if(_0x485aed[_0x3f1ff2(0x610)]){if(_0x3f1ff2(0x8e4)!=='Euwpi')_0x2895e7[_0x3f1ff2(0x3dc)](_0x3f1ff2(0x7d6));else{if(_0x5c2a81[_0x3f1ff2(0x32f)][_0x3f1ff2(0x738)]<1.12){let _0x6f22d3='';_0x6f22d3+=_0x3f1ff2(0x426),_0x6f22d3+=_0x3f1ff2(0xd19),_0x6f22d3+=_0x3f1ff2(0x513),_0x563a54(_0x6f22d3),_0x5155fa[_0x3f1ff2(0x1b1)]();}}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x136),_0x59a44d=>{const _0x54015e=_0x208a24;if(!SceneManager[_0x54015e(0xc1b)])return;if(!SceneManager[_0x54015e(0xc1b)][_0x54015e(0xa85)])return;if(!Imported[_0x54015e(0x496)])return;VisuMZ['ConvertParams'](_0x59a44d,_0x59a44d);const _0x54108a=$gameTemp[_0x54015e(0xcc)](),_0x555ecb=Math[_0x54015e(0xd50)](_0x59a44d[_0x54015e(0x393)]),_0x41f7e1=Math['round'](_0x59a44d[_0x54015e(0x167)]);$gameTemp['requestPointAnimation'](_0x555ecb,_0x41f7e1,_0x59a44d[_0x54015e(0x100)],_0x59a44d[_0x54015e(0x6f6)],_0x59a44d[_0x54015e(0xa2e)]);if(_0x59a44d['WaitComplete']&&_0x54108a){if(_0x54015e(0xae2)!=='pBqsR')return this[_0x54015e(0x2bc)];else SceneManager[_0x54015e(0xc1b)][_0x54015e(0xa85)][_0x54015e(0xc61)](),_0x54108a[_0x54015e(0x3dc)](_0x54015e(0x7d6));}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Animation_ShowAnimation',_0x2ac239=>{const _0x4a6c3a=_0x208a24;if(!SceneManager[_0x4a6c3a(0x8c3)]())return;VisuMZ[_0x4a6c3a(0x4f4)](_0x2ac239,_0x2ac239);const _0x4ddbb4=$gameTemp[_0x4a6c3a(0xcc)](),_0xd7f424=VisuMZ[_0x4a6c3a(0x5bd)](_0x2ac239['Targets']),_0x33d3fd=_0x2ac239[_0x4a6c3a(0x100)],_0x28b178=_0x2ac239[_0x4a6c3a(0x6f6)];if(!_0x4ddbb4)return;$gameTemp[_0x4a6c3a(0x2d8)](_0xd7f424,_0x33d3fd,_0x28b178);if(_0x2ac239['WaitForAnimation'])_0x4ddbb4['setWaitMode'](_0x4a6c3a(0x7d6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Animation_ShowAnimationJS',_0xccc659=>{const _0x5edc5b=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x5edc5b(0x4f4)](_0xccc659,_0xccc659);const _0x536012=$gameTemp[_0x5edc5b(0xcc)](),_0x213979=VisuMZ[_0x5edc5b(0x5bd)](_0xccc659[_0x5edc5b(0x83d)]),_0x5bfb61=Number(_0xccc659['AnimationID'])||0x1,_0x33f9b3=_0xccc659[_0x5edc5b(0x6f6)];if(!_0x536012)return;$gameTemp['requestAnimation'](_0x213979,_0x5bfb61,_0x33f9b3);if(_0xccc659[_0x5edc5b(0x610)])_0x536012[_0x5edc5b(0x3dc)](_0x5edc5b(0x7d6));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x22b),_0x2ace01=>{const _0x1b46c7=_0x208a24;if(!SceneManager[_0x1b46c7(0x8c3)]())return;VisuMZ['ConvertParams'](_0x2ace01,_0x2ace01);const _0x2333f8=$gameTemp[_0x1b46c7(0xcc)](),_0x197abd=VisuMZ[_0x1b46c7(0x5bd)](_0x2ace01[_0x1b46c7(0x83d)]),_0x346efc=Number(_0x2ace01[_0x1b46c7(0x82c)]||0x1),_0x42138b=$dataSkills[_0x346efc],_0x47c3d1=_0x2ace01['Mirror'];if(!_0x2333f8)return;if(!_0x42138b)return;let _0x55b49a=_0x42138b[_0x1b46c7(0x465)];$gameTemp[_0x1b46c7(0x2d8)](_0x197abd,_0x55b49a,_0x47c3d1),_0x2ace01['WaitForAnimation']&&_0x2333f8[_0x1b46c7(0x3dc)]('battleAnimation');}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x3f9),_0x532a06=>{const _0x24ae13=_0x208a24;if(!SceneManager['isSceneBattle']())return;const _0x581bb8=$gameTemp[_0x24ae13(0xcc)]();if(!_0x581bb8)return;_0x581bb8[_0x24ae13(0x3dc)](_0x24ae13(0x7d6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x95c),_0x32e39f=>{const _0x5bc43f=_0x208a24;if(!SceneManager[_0x5bc43f(0x8c3)]())return;VisuMZ[_0x5bc43f(0x4f4)](_0x32e39f,_0x32e39f);const _0xf0d1c0=BattleManager[_0x5bc43f(0x46b)],_0x325d54=_0x32e39f[_0x5bc43f(0x6fe)]&&Imported[_0x5bc43f(0xc69)];_0xf0d1c0['addText'](_0x32e39f[_0x5bc43f(0x2bd)]),_0x325d54&&Imported[_0x5bc43f(0xc69)]&&$gameSystem['addTextToCombatLog'](_0x32e39f[_0x5bc43f(0x2bd)]||'',_0x32e39f['CombatLogIcon']||0x0);}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_BattleLog_Clear',_0x1cbab3=>{const _0x5c932b=_0x208a24;if(!SceneManager[_0x5c932b(0x8c3)]())return;const _0x49f89b=BattleManager['_logWindow'];_0x49f89b[_0x5c932b(0xb03)]();}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0xcfe),_0x47178e=>{const _0x43c5bc=_0x208a24;if(!SceneManager[_0x43c5bc(0x8c3)]())return;const _0xc10394=$gameTemp[_0x43c5bc(0xcc)](),_0x508c21=BattleManager[_0x43c5bc(0x8fb)],_0x435c12=BattleManager['_subject'],_0x22e727=BattleManager[_0x43c5bc(0x46b)];if(!_0xc10394||!_0x508c21||!_0x435c12)return;if(!_0x508c21[_0x43c5bc(0x8bb)]())return;_0x22e727[_0x43c5bc(0x734)](_0x435c12,_0x508c21[_0x43c5bc(0x8bb)]()),_0xc10394[_0x43c5bc(0x3dc)](_0x43c5bc(0x4c6));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_BattleLog_PopBaseLine',_0x3c790e=>{const _0x1d9f87=_0x208a24;if(!SceneManager[_0x1d9f87(0x8c3)]())return;const _0x3f9950=BattleManager[_0x1d9f87(0x46b)];_0x3f9950['popBaseLine']();}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x28a),_0x95543b=>{const _0x34af9a=_0x208a24;if(!SceneManager[_0x34af9a(0x8c3)]())return;const _0xe6ce14=BattleManager['_logWindow'];_0xe6ce14[_0x34af9a(0x6dd)]();}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x408),_0x2bc882=>{const _0x3ae771=_0x208a24;if(!SceneManager['isSceneBattle']())return;const _0x457e8f=BattleManager[_0x3ae771(0x46b)];_0x457e8f[_0x3ae771(0xa22)]();}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0xb15),_0xd4ef1=>{const _0x5be7f8=_0x208a24;if(!SceneManager[_0x5be7f8(0x8c3)]())return;VisuMZ[_0x5be7f8(0x4f4)](_0xd4ef1,_0xd4ef1),SceneManager['_scene'][_0x5be7f8(0x19f)](_0xd4ef1[_0x5be7f8(0xa25)]);}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0x8d1),_0x4802de=>{const _0x4011a4=_0x208a24;if(!SceneManager['isSceneBattle']())return;const _0x3007b0=$gameTemp[_0x4011a4(0xcc)]();_0x3007b0['setWaitMode'](_0x4011a4(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x36f),_0x62299d=>{const _0x3633d7=_0x208a24;if(!SceneManager['isSceneBattle']())return;const _0x217d04=$gameTemp[_0x3633d7(0xcc)](),_0x8d71ae=BattleManager[_0x3633d7(0x46b)];_0x8d71ae[_0x3633d7(0xa5d)](),_0x217d04[_0x3633d7(0x3dc)](_0x3633d7(0x4c6));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Camera_Clamp',_0x224326=>{const _0x1b15bd=_0x208a24;if(!SceneManager[_0x1b15bd(0x8c3)]())return;if(!Imported[_0x1b15bd(0x355)])return;VisuMZ['ConvertParams'](_0x224326,_0x224326);const _0x3efb4a=$gameScreen['battleCameraData']();_0x3efb4a[_0x1b15bd(0x97d)]=_0x224326[_0x1b15bd(0xace)];}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xb1c),_0x59a857=>{const _0x31a952=_0x208a24;if(!SceneManager[_0x31a952(0x8c3)]())return;if(!Imported[_0x31a952(0x355)])return;VisuMZ[_0x31a952(0x4f4)](_0x59a857,_0x59a857);const _0x5312ed=$gameTemp[_0x31a952(0xcc)](),_0x95d559=_0x59a857[_0x31a952(0x7fd)];$gameScreen['setBattleCameraPoint'](_0x59a857[_0x31a952(0x926)],_0x59a857[_0x31a952(0xc67)],_0x59a857['Duration'],_0x59a857['EasingType']);if(_0x95d559)_0x5312ed[_0x31a952(0x3dc)](_0x31a952(0xc05));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x384),_0x413e3f=>{const _0x426e91=_0x208a24;if(!SceneManager[_0x426e91(0x8c3)]())return;if(!Imported[_0x426e91(0x355)])return;VisuMZ[_0x426e91(0x4f4)](_0x413e3f,_0x413e3f);const _0x281a85=$gameTemp['getLastPluginCommandInterpreter'](),_0x31f1c7=VisuMZ[_0x426e91(0x5bd)](_0x413e3f[_0x426e91(0x83d)]),_0x184cbf=_0x413e3f[_0x426e91(0x7fd)];$gameScreen[_0x426e91(0x708)](_0x31f1c7,_0x413e3f[_0x426e91(0x2c6)],_0x413e3f[_0x426e91(0x99b)]);if(_0x184cbf)_0x281a85['setWaitMode'](_0x426e91(0xc05));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x9f9),_0x3b5a9c=>{const _0x3cf75a=_0x208a24;if(!SceneManager[_0x3cf75a(0x8c3)]())return;if(!Imported[_0x3cf75a(0x355)])return;VisuMZ[_0x3cf75a(0x4f4)](_0x3b5a9c,_0x3b5a9c);const _0xc5957d=$gameTemp['getLastPluginCommandInterpreter'](),_0x1dffd2=_0x3b5a9c['WaitForCamera'];$gameScreen[_0x3cf75a(0x8d8)](_0x3b5a9c[_0x3cf75a(0x7ae)],_0x3b5a9c[_0x3cf75a(0x153)],_0x3b5a9c[_0x3cf75a(0x2c6)],_0x3b5a9c[_0x3cf75a(0x99b)]);if(_0x1dffd2)_0xc5957d[_0x3cf75a(0x3dc)](_0x3cf75a(0xc05));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Camera_Reset',_0x160419=>{const _0x5907f0=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x5907f0(0x355)])return;VisuMZ['ConvertParams'](_0x160419,_0x160419);const _0x267135=$gameTemp['getLastPluginCommandInterpreter'](),_0xdd9e69=_0x160419['ResetFocus'],_0x4b9e61=_0x160419[_0x5907f0(0x771)],_0x312b02=_0x160419[_0x5907f0(0x7fd)];if(_0xdd9e69){if(_0x5907f0(0x5de)!==_0x5907f0(0x41f)){const _0x407de8=Math[_0x5907f0(0xd50)](Graphics[_0x5907f0(0x4fe)]/0x2),_0x545078=Math[_0x5907f0(0xd50)](Graphics[_0x5907f0(0x1fa)]/0x2);$gameScreen[_0x5907f0(0xcd)](_0x407de8,_0x545078,_0x160419[_0x5907f0(0x2c6)],_0x160419[_0x5907f0(0x99b)]);}else{const _0x1c1f09=this[_0x5907f0(0x4b5)][_0x5907f0(0x867)]['y'];_0x3f61ef-=(_0x1c1f09-0x1)*this[_0x5907f0(0x1fa)];}}_0x4b9e61&&$gameScreen[_0x5907f0(0x8d8)](0x0,0x0,_0x160419['Duration'],_0x160419[_0x5907f0(0x99b)]);if(_0x312b02)_0x267135[_0x5907f0(0x3dc)](_0x5907f0(0xc05));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Camera_WaitForCamera',_0x11a7e7=>{const _0x28621f=_0x208a24;if(!SceneManager[_0x28621f(0x8c3)]())return;if(!Imported[_0x28621f(0x355)])return;const _0x481972=$gameTemp[_0x28621f(0xcc)]();if(!_0x481972)return;_0x481972[_0x28621f(0x3dc)]('battleCamera');}),VisuMZ[_0x208a24(0x759)]['CreateCutinSettings']=function(_0x441829){const _0x39a2d2=_0x208a24;_0x441829['portraitFilename']='';const _0x2b4def=VisuMZ[_0x39a2d2(0x38e)][_0x39a2d2(0x15f)](_0x441829),_0x58545f=VisuMZ[_0x39a2d2(0x5bd)](_0x441829[_0x39a2d2(0x83d)])[0x0]||null;if(_0x58545f){_0x2b4def[_0x39a2d2(0x48d)]=_0x58545f['visualCutinPortraitFilename'](),_0x2b4def[_0x39a2d2(0x316)]=_0x58545f['visualCutinPortraitIndex'](),_0x2b4def[_0x39a2d2(0x656)]=_0x58545f[_0x39a2d2(0xc6c)](),_0x2b4def[_0x39a2d2(0x57a)]=_0x58545f[_0x39a2d2(0xa54)]();if(_0x58545f[_0x39a2d2(0x27a)]()){if(_0x39a2d2(0x6e3)==='TBWui'){const _0x1d40a4=this['_subject'][_0x39a2d2(0xa7b)](),_0x597f0f=this[_0x39a2d2(0x64d)];_0x1d40a4&&_0x1d40a4[_0x39a2d2(0x6a9)]()===_0x597f0f&&_0x1d40a4[_0x39a2d2(0x84e)](_0x39a2d2(0xd5a)),_0x4e94b5[_0x39a2d2(0x759)][_0x39a2d2(0xa9f)]['call'](this),_0x1d40a4&&_0x1d40a4[_0x39a2d2(0x6a9)]()===_0x597f0f&&_0x1d40a4['actionBattleCoreJS'](_0x39a2d2(0xba3));}else _0x58545f['flipVisualCutinHorz']()&&(_0x2b4def['portraitFlipHorz']=!_0x2b4def[_0x39a2d2(0x6d5)]),_0x58545f[_0x39a2d2(0x6c3)]()&&('SEpFR'!==_0x39a2d2(0x896)?(_0x587321['BattleCore'][_0x39a2d2(0x48a)][_0x39a2d2(0x783)](this,_0x30cb6a),this[_0x39a2d2(0x79f)]()):_0x2b4def[_0x39a2d2(0xb7a)]=!_0x2b4def['portraitFlipVert']),_0x2b4def[_0x39a2d2(0x57a)]===_0x39a2d2(0x27c)&&(_0x2b4def['portraitFlipHorz']=!_0x2b4def['portraitFlipHorz']),_0x441829['ExtraSettings'][_0x39a2d2(0x273)]&&(_0x2b4def['parallaxScrollX']*=-0x1),_0x441829[_0x39a2d2(0x4eb)][_0x39a2d2(0x73c)]&&('dZatl'===_0x39a2d2(0xd42)?this[_0x39a2d2(0x8d2)]():_0x2b4def[_0x39a2d2(0x61d)]*=-0x1),_0x2b4def[_0x39a2d2(0x912)]+=_0x441829[_0x39a2d2(0x4eb)][_0x39a2d2(0x45b)]??0x0;}}return _0x2b4def;},PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Cutin_AddVisualCutinEffect',_0x137887=>{const _0x6e281=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x6e281(0x598)])return;VisuMZ[_0x6e281(0x4f4)](_0x137887,_0x137887);const _0x576103=VisuMZ[_0x6e281(0x759)]['CreateCutinSettings'](_0x137887);SceneManager[_0x6e281(0xc1b)][_0x6e281(0x4af)](_0x576103);const _0x156829=$gameTemp[_0x6e281(0xcc)]();if(_0x156829&&_0x137887[_0x6e281(0x35a)]){if(_0x6e281(0x2ea)===_0x6e281(0x4b6))return this[_0x6e281(0xb41)](_0x3a6ca3[0x0],_0x5a0dcc[0x1],_0x3d34b8=>{const _0x2e359d=_0x6e281;!_0x3d34b8[_0x2e359d(0xc47)]()&&(_0x3d34b8[_0x2e359d(0x2be)](_0xa3da4b[0x2],_0x587aca[0x3]),_0x1d8f5d[_0x2e359d(0x2be)](_0x3d34b8));}),!![];else _0x156829[_0x6e281(0x3dc)](_0x6e281(0x68d));}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Cutin_EndVisualCutinEffectAll',_0x133bac=>{const _0x699889=_0x208a24;if(!SceneManager[_0x699889(0x8c3)]())return;if(!Imported[_0x699889(0x598)])return;VisuMZ[_0x699889(0x4f4)](_0x133bac,_0x133bac),SceneManager[_0x699889(0xc1b)]['clearAllVisualCutins']();const _0x1f3133=$gameTemp[_0x699889(0xcc)]();_0x1f3133&&_0x133bac[_0x699889(0x147)]&&_0x1f3133[_0x699889(0x3dc)](_0x699889(0x8b0));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x336),_0x3060b4=>{const _0x26c024=_0x208a24;if(!SceneManager[_0x26c024(0x8c3)]())return;if(!Imported['VisuMZ_3_VisualCutinEffect'])return;VisuMZ['ConvertParams'](_0x3060b4,_0x3060b4);const _0x2f2137=_0x3060b4[_0x26c024(0x4f8)][_0x26c024(0x717)]()[_0x26c024(0x446)]();SceneManager[_0x26c024(0xc1b)][_0x26c024(0x960)](_0x2f2137);const _0x162284=$gameTemp[_0x26c024(0xcc)]();if(_0x162284&&_0x3060b4['WaitForExit']){if('TJdrC'!==_0x26c024(0xaac)){if(this['_battlePortrait']===_0x2d1fe0)this[_0x26c024(0x6e5)]();this[_0x26c024(0xc90)]=_0x1d3816;if(_0x579e2d[_0x26c024(0x8c3)]()&&_0xeb467b[_0x26c024(0x3d9)]()[_0x26c024(0xcaf)](this)){const _0x4deab7=_0x105ade[_0x26c024(0xc1b)]['_statusWindow'];_0x4deab7&&_0x4deab7['refreshActorPortrait'](this);}}else _0x162284['setWaitMode'](_0x26c024(0x8b0));}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Cutin_WaitForEntrance',_0x518a51=>{const _0x142965=_0x208a24;if(!SceneManager[_0x142965(0x8c3)]())return;if(!Imported[_0x142965(0x598)])return;const _0x5170c0=$gameTemp[_0x142965(0xcc)]();_0x5170c0[_0x142965(0x3dc)]('cutinEnter');}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x94e),_0x3de192=>{const _0xf3125c=_0x208a24;if(!SceneManager[_0xf3125c(0x8c3)]())return;if(!Imported['VisuMZ_3_VisualCutinEffect'])return;const _0x507642=$gameTemp[_0xf3125c(0xcc)]();_0x507642[_0xf3125c(0x3dc)]('cutinExit');}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x6c9),_0x36402c=>{const _0x573744=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x573744(0x56a)])return;VisuMZ[_0x573744(0x4f4)](_0x36402c,_0x36402c);const _0x520dbe=VisuMZ[_0x573744(0x5bd)](_0x36402c[_0x573744(0x83d)]),_0x1e550a=_0x36402c[_0x573744(0x45d)][_0x573744(0x717)]()[_0x573744(0x446)]();for(const _0x5971bc of _0x520dbe){if(_0x573744(0x2af)===_0x573744(0x2af)){if(!_0x5971bc)continue;_0x5971bc[_0x573744(0xaf0)](_0x1e550a);}else _0x1337e6=_0x150f7c[_0x573744(0x40a)](_0x3728d7);}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0xc7c),_0x682903=>{const _0x5e7bed=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x5e7bed(0x56a)])return;VisuMZ[_0x5e7bed(0x4f4)](_0x682903,_0x682903);const _0x4a438d=VisuMZ[_0x5e7bed(0x5bd)](_0x682903[_0x5e7bed(0x83d)]),_0x20767f=_0x682903[_0x5e7bed(0x217)];for(const _0x2d73c4 of _0x4a438d){if(!_0x2d73c4)continue;_0x2d73c4[_0x5e7bed(0x6b7)]()[_0x5e7bed(0x4cb)]=_0x20767f;}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0xcdd),_0x1d462d=>{const _0x41d8d9=_0x208a24;if(!SceneManager[_0x41d8d9(0x8c3)]())return;if(!Imported[_0x41d8d9(0x218)])return;VisuMZ[_0x41d8d9(0x4f4)](_0x1d462d,_0x1d462d);const _0x24b44b=BattleManager[_0x41d8d9(0x8fb)],_0x3cfe22=_0x1d462d[_0x41d8d9(0x480)];if(!_0x24b44b)return;_0x24b44b['_battleCoreAddedElements']=_0x3cfe22;}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0x234),_0x4fb518=>{const _0x2bab31=_0x208a24;if(!SceneManager[_0x2bab31(0x8c3)]())return;if(!Imported[_0x2bab31(0x218)])return;const _0x5e05a8=BattleManager[_0x2bab31(0x8fb)];if(!_0x5e05a8)return;_0x5e05a8['clearElementChanges']();}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x187),_0x30af38=>{const _0x46f88c=_0x208a24;if(!SceneManager[_0x46f88c(0x8c3)]())return;if(!Imported[_0x46f88c(0x218)])return;VisuMZ['ConvertParams'](_0x30af38,_0x30af38);const _0x41a07c=BattleManager[_0x46f88c(0x8fb)],_0x4d2cc9=_0x30af38[_0x46f88c(0x480)];if(!_0x41a07c)return;_0x41a07c['_battleCoreForcedElements']=_0x4d2cc9;}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xa20),_0xe94aaf=>{const _0x113438=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x113438(0x218)])return;const _0x1c766a=BattleManager['_action'];if(!_0x1c766a)return;_0x1c766a[_0x113438(0xcd3)]=!![];}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x247),_0x3f50a6=>{const _0x29dfb9=_0x208a24;VisuMZ[_0x29dfb9(0x74e)][_0x29dfb9(0x247)](_0x3f50a6);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Grid_AddPassiveStatesToNode',_0x1c5988=>{const _0xabb006=_0x208a24;VisuMZ['BattleGridSystem'][_0xabb006(0x24d)](_0x1c5988);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xce1),_0x34f74f=>{const _0x236c8e=_0x208a24;VisuMZ[_0x236c8e(0x74e)][_0x236c8e(0xce1)](_0x34f74f);}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x33f),_0x5cba50=>{const _0x1b21c2=_0x208a24;VisuMZ['BattleGridSystem'][_0x1b21c2(0x33f)](_0x5cba50);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Grid_AnimationJsAtNode',_0x12c7b7=>{const _0x33d9b1=_0x208a24;VisuMZ[_0x33d9b1(0x74e)][_0x33d9b1(0x5bb)](_0x12c7b7);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x5ed),_0x52446b=>{const _0x571c97=_0x208a24;VisuMZ[_0x571c97(0x74e)]['ActSeq_Grid_AnimationTypeAtNode'](_0x52446b);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xb65),_0x74f5b3=>{const _0x3819cd=_0x208a24;VisuMZ[_0x3819cd(0x74e)][_0x3819cd(0xb65)](_0x74f5b3);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Grid_MoveTargetsInDirection',_0x426c2f=>{const _0x314fcf=_0x208a24;VisuMZ['BattleGridSystem'][_0x314fcf(0x50a)](_0x426c2f);}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Grid_PullToTargetNode',_0x4259a1=>{const _0x451c72=_0x208a24;VisuMZ[_0x451c72(0x74e)][_0x451c72(0x589)](_0x4259a1);}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x186),_0x404450=>{const _0x4dcfc6=_0x208a24;VisuMZ[_0x4dcfc6(0x74e)][_0x4dcfc6(0x186)](_0x404450);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x507),_0x3bf660=>{const _0x2b3641=_0x208a24;VisuMZ[_0x2b3641(0x74e)][_0x2b3641(0x507)](_0x3bf660);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x388),_0x47a0f6=>{const _0x54a2b1=_0x208a24;VisuMZ[_0x54a2b1(0x74e)]['ActSeq_Grid_RemoveTriggerFromNode'](_0x47a0f6);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x14e),_0x492332=>{VisuMZ['BattleGridSystem']['ActSeq_Grid_TeleportToNode'](_0x492332);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x4b9),_0x27bc5a=>{const _0x13604a=_0x208a24;VisuMZ[_0x13604a(0x74e)][_0x13604a(0x4b9)](_0x27bc5a);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Horror_Clear',_0x26591a=>{const _0x247d7f=_0x208a24;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager[_0x247d7f(0x8c3)]())return;VisuMZ[_0x247d7f(0x4f4)](_0x26591a,_0x26591a);const _0x444c42=VisuMZ[_0x247d7f(0x5bd)](_0x26591a[_0x247d7f(0x83d)]);for(const _0x2226db of _0x444c42){if(!_0x2226db)continue;_0x2226db[_0x247d7f(0xcd4)](_0x247d7f(0x550)),_0x2226db[_0x247d7f(0xcd4)](_0x247d7f(0x7f2)),_0x2226db[_0x247d7f(0xcd4)]('tv'),_0x2226db[_0x247d7f(0xa05)]();}$gamePlayer[_0x247d7f(0xa22)]();}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x951),_0x1c20ce=>{const _0x57f2ac=_0x208a24;if(!Imported[_0x57f2ac(0xa8d)])return;if(!SceneManager[_0x57f2ac(0x8c3)]())return;VisuMZ[_0x57f2ac(0x4f4)](_0x1c20ce,_0x1c20ce);const _0x597992=VisuMZ['CreateActionSequenceTargets'](_0x1c20ce[_0x57f2ac(0x83d)]),_0xac6d51=_0x57f2ac(0x7f2);_0x1c20ce[_0x57f2ac(0xc4a)]=Math['ceil'](_0x1c20ce['slices']/0x2),_0x1c20ce['sliceMax']=_0x1c20ce[_0x57f2ac(0x4b4)],_0x1c20ce[_0x57f2ac(0x557)]=!![];for(const _0x4478d9 of _0x597992){if(!_0x4478d9)continue;_0x4478d9[_0x57f2ac(0x193)](_0xac6d51,_0x1c20ce);}$gamePlayer['refresh']();}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x9f3),_0x11c67b=>{const _0x1b3e75=_0x208a24;if(!Imported[_0x1b3e75(0xa8d)])return;if(!SceneManager[_0x1b3e75(0x8c3)]())return;VisuMZ[_0x1b3e75(0x4f4)](_0x11c67b,_0x11c67b);const _0x40503e=VisuMZ[_0x1b3e75(0x5bd)](_0x11c67b[_0x1b3e75(0x83d)]);for(const _0x516766 of _0x40503e){if(!_0x516766)continue;_0x516766[_0x1b3e75(0xcd4)](_0x1b3e75(0x7f2));}$gamePlayer[_0x1b3e75(0xa22)]();}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x150),_0x2e250d=>{const _0x380045=_0x208a24;if(!Imported[_0x380045(0xa8d)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x380045(0x4f4)](_0x2e250d,_0x2e250d);const _0x52fdbe=VisuMZ['CreateActionSequenceTargets'](_0x2e250d['Targets']),_0x3cc7a0='noise';for(const _0x121bdf of _0x52fdbe){if('PeWfL'!=='lcsbp'){if(!_0x121bdf)continue;_0x121bdf[_0x380045(0x193)](_0x3cc7a0,_0x2e250d);}else{let _0x5e8d9c=_0x276208(_0x366415['$1'])[_0x380045(0x51f)](/,/g,'')['toUpperCase']()[_0x380045(0x446)]();_0x2b3e45[_0x380045(0x759)]['_commonEventKey'][_0x5e8d9c]=_0xa0d025['id'];}}$gamePlayer['refresh']();}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0xa8c),_0x11fc04=>{const _0x14f16e=_0x208a24;if(!Imported[_0x14f16e(0xa8d)])return;if(!SceneManager[_0x14f16e(0x8c3)]())return;VisuMZ[_0x14f16e(0x4f4)](_0x11fc04,_0x11fc04);const _0x179a7a=VisuMZ['CreateActionSequenceTargets'](_0x11fc04[_0x14f16e(0x83d)]);for(const _0x10e7d4 of _0x179a7a){if(!_0x10e7d4)continue;_0x10e7d4[_0x14f16e(0xcd4)](_0x14f16e(0x550));}$gamePlayer[_0x14f16e(0xa22)]();}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x8d5),_0x17ef9b=>{const _0x746926=_0x208a24;if(!Imported[_0x746926(0xa8d)])return;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x746926(0x4f4)](_0x17ef9b,_0x17ef9b);const _0x1dc8fc=VisuMZ[_0x746926(0x5bd)](_0x17ef9b[_0x746926(0x83d)]),_0x2f35b0='tv';for(const _0x30726c of _0x1dc8fc){if(!_0x30726c)continue;_0x30726c[_0x746926(0x193)](_0x2f35b0,_0x17ef9b);}$gamePlayer[_0x746926(0xa22)]();}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Horror_TVRemove',_0x3266f6=>{const _0x19d5af=_0x208a24;if(!Imported['VisuMZ_2_HorrorEffects'])return;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x3266f6,_0x3266f6);const _0x5f07b6=VisuMZ[_0x19d5af(0x5bd)](_0x3266f6['Targets']);for(const _0x5bb255 of _0x5f07b6){if(!_0x5bb255)continue;_0x5bb255[_0x19d5af(0xcd4)]('tv');}$gamePlayer[_0x19d5af(0xa22)]();}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Impact_BlueRedInvert',_0x430a1b=>{const _0x4c4d5d=_0x208a24;if(!Imported[_0x4c4d5d(0x4a6)])return;const _0x5f214a=SceneManager[_0x4c4d5d(0xc1b)]['_spriteset'];if(!_0x5f214a)return;if(VisuMZ['ActSeqImpact'][_0x4c4d5d(0x738)]<=1.04){if('OAJpi'==='gRWuJ')this[_0x4c4d5d(0xca)][_0x4c4d5d(0x3b3)]=![];else{alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager[_0x4c4d5d(0x1b1)]();return;}}VisuMZ[_0x4c4d5d(0x4f4)](_0x430a1b,_0x430a1b);const _0x8198f=_0x430a1b[_0x4c4d5d(0x397)];_0x5f214a[_0x4c4d5d(0xb50)](_0x8198f);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Impact_ColorBreak',_0xe4276e=>{const _0x575761=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x575761(0x4a6)])return;const _0x1dd0c5=SceneManager[_0x575761(0xc1b)][_0x575761(0xa85)];if(!_0x1dd0c5)return;VisuMZ[_0x575761(0x4f4)](_0xe4276e,_0xe4276e);const _0x1c087c=_0xe4276e[_0x575761(0x207)]||0x1,_0x5e92a3=_0xe4276e[_0x575761(0x2c6)]||0x1,_0x910485=_0xe4276e['EasingType']||_0x575761(0xc0e);_0x1dd0c5[_0x575761(0xba2)](_0x1c087c,_0x5e92a3,_0x910485);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Impact_Desaturate',_0x26ecad=>{const _0x3f2140=_0x208a24;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x29cd36=SceneManager[_0x3f2140(0xc1b)][_0x3f2140(0xa85)];if(!_0x29cd36)return;if(VisuMZ[_0x3f2140(0x826)][_0x3f2140(0x738)]<=1.04){if(_0x3f2140(0x237)!==_0x3f2140(0x237))_0x48e86a[_0x3f2140(0x70e)](_0x4d6f19,_0x3c6f60,_0x1aa7ed,_0x34bda2,_0x4be21d,-0x1),this[_0x3f2140(0xd9)]();else{alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager[_0x3f2140(0x1b1)]();return;}}VisuMZ[_0x3f2140(0x4f4)](_0x26ecad,_0x26ecad);const _0x1a1693=_0x26ecad['Enable'];_0x29cd36[_0x3f2140(0xbf3)](_0x1a1693);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xb7e),_0x35f7f6=>{const _0x599c91=_0x208a24;if(!SceneManager[_0x599c91(0x8c3)]())return;if(!Imported[_0x599c91(0x4a6)])return;const _0x9e6f37=SceneManager[_0x599c91(0xc1b)][_0x599c91(0xa85)];if(!_0x9e6f37)return;VisuMZ['ConvertParams'](_0x35f7f6,_0x35f7f6);const _0x1b4bd9=Number(_0x35f7f6['Angle'])||0x0,_0x2793ea=Number(_0x35f7f6[_0x599c91(0xd5)]),_0x210db0=_0x35f7f6['Duration']||0x1,_0x74f1b9=_0x35f7f6[_0x599c91(0x99b)]||_0x599c91(0xc0e);_0x9e6f37[_0x599c91(0x9f4)](_0x1b4bd9,_0x2793ea,_0x210db0,_0x74f1b9);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x3c8),_0x557cbd=>{const _0x2ecb6c=_0x208a24;if(!SceneManager[_0x2ecb6c(0x8c3)]())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x17e0d4=SceneManager[_0x2ecb6c(0xc1b)][_0x2ecb6c(0xa85)];if(!_0x17e0d4)return;VisuMZ['ConvertParams'](_0x557cbd,_0x557cbd);const _0xcc8b4=Number(_0x557cbd[_0x2ecb6c(0xbe2)])||0x0,_0x2104ed=Number(_0x557cbd['Rate']),_0x3e426d=_0x557cbd[_0x2ecb6c(0x2c6)]||0x1,_0x40022f=_0x557cbd[_0x2ecb6c(0x99b)]||_0x2ecb6c(0xc0e),_0x25daa3=VisuMZ[_0x2ecb6c(0x5bd)](_0x557cbd['Targets']);for(const _0x259ec9 of _0x25daa3){if('dLSmn'===_0x2ecb6c(0xae3)){if(!_0x259ec9)continue;if(!_0x259ec9[_0x2ecb6c(0xd08)]())continue;_0x259ec9[_0x2ecb6c(0xd08)]()['setupMotionBlurImpactFilter'](_0xcc8b4,_0x2104ed,_0x3e426d,_0x40022f);}else{_0x14204a['prototype'][_0x2ecb6c(0x3f6)]['call'](this,_0x1681b2);if(this[_0x2ecb6c(0x814)]())this[_0x2ecb6c(0x797)](_0x3a7ad5);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x2c8),_0x18dddb=>{const _0x42ecd6=_0x208a24;if(!SceneManager[_0x42ecd6(0x8c3)]())return;if(!Imported[_0x42ecd6(0x4a6)])return;VisuMZ[_0x42ecd6(0x4f4)](_0x18dddb,_0x18dddb);const _0x283e0f={'delay':_0x18dddb[_0x42ecd6(0x2d7)],'duration':_0x18dddb['duration'],'hue':_0x18dddb[_0x42ecd6(0xd41)],'opacityStart':_0x18dddb['opacityStart'],'tone':_0x18dddb[_0x42ecd6(0xa92)],'visible':!![]},_0xc2c54c=VisuMZ['CreateActionSequenceTargets'](_0x18dddb[_0x42ecd6(0x83d)]);for(const _0xf4b596 of _0xc2c54c){if(!_0xf4b596)continue;_0xf4b596[_0x42ecd6(0x723)](_0x283e0f);}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Impact_MotionTrailRemove',_0x3a4a85=>{const _0x2ff8b9=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqImpact'])return;VisuMZ['ConvertParams'](_0x3a4a85,_0x3a4a85);const _0x7b1a9f=VisuMZ[_0x2ff8b9(0x5bd)](_0x3a4a85[_0x2ff8b9(0x83d)]);for(const _0x575da4 of _0x7b1a9f){if(_0x2ff8b9(0x48c)!==_0x2ff8b9(0xa3b)){if(!_0x575da4)continue;_0x575da4[_0x2ff8b9(0xb60)]();}else _0x47f2ba[_0x2ff8b9(0x759)][_0x2ff8b9(0xb49)][_0x2ff8b9(0x783)](this),this[_0x2ff8b9(0x17f)]();}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xd47),_0x1feffa=>{const _0x5bddaf=_0x208a24;if(!Imported[_0x5bddaf(0x4a6)])return;const _0x568d5a=SceneManager['_scene'][_0x5bddaf(0xa85)];if(!_0x568d5a)return;if(VisuMZ[_0x5bddaf(0x826)]['version']<=1.04){alert(_0x5bddaf(0xb94)),SceneManager[_0x5bddaf(0x1b1)]();return;}VisuMZ[_0x5bddaf(0x4f4)](_0x1feffa,_0x1feffa);const _0x19d1a6=_0x1feffa[_0x5bddaf(0x397)];_0x568d5a[_0x5bddaf(0x224)](_0x19d1a6);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x3e4),_0x406e1f=>{const _0x490755=_0x208a24;if(!Imported[_0x490755(0x4a6)])return;const _0x3b5b01=SceneManager['_scene'][_0x490755(0xa85)];if(!_0x3b5b01)return;if(VisuMZ[_0x490755(0x826)]['version']<=1.04){alert(_0x490755(0xb94)),SceneManager['exit']();return;}VisuMZ[_0x490755(0x4f4)](_0x406e1f,_0x406e1f);const _0x106b27=_0x406e1f['Enable'];_0x3b5b01[_0x490755(0x14a)](_0x106b27);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xc74),_0x3510c5=>{const _0x344c5d=_0x208a24;if(!Imported[_0x344c5d(0x4a6)])return;const _0x31be57=SceneManager[_0x344c5d(0xc1b)][_0x344c5d(0xa85)];if(!_0x31be57)return;VisuMZ[_0x344c5d(0x4f4)](_0x3510c5,_0x3510c5);const _0x3d1ebf=_0x3510c5['X']||0x0,_0x14b858=_0x3510c5['Y']||0x0,_0x53bff5=_0x3510c5[_0x344c5d(0x299)]||0x0,_0x30c869=_0x3510c5[_0x344c5d(0x201)]||0x0,_0x186c96=_0x3510c5[_0x344c5d(0x2c6)]||0x1;_0x31be57[_0x344c5d(0xc38)](_0x3d1ebf,_0x14b858,_0x53bff5,_0x30c869,_0x186c96);}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x47b),_0x1f8dd4=>{const _0x348126=_0x208a24;if(!SceneManager[_0x348126(0x8c3)]())return;if(!Imported[_0x348126(0x4a6)])return;const _0x33098c=SceneManager[_0x348126(0xc1b)][_0x348126(0xa85)];if(!_0x33098c)return;VisuMZ[_0x348126(0x4f4)](_0x1f8dd4,_0x1f8dd4);const _0x3f128e=VisuMZ[_0x348126(0x5bd)](_0x1f8dd4[_0x348126(0x83d)]),_0x57a48c=_0x1f8dd4[_0x348126(0x427)],_0x23d546=_0x1f8dd4[_0x348126(0x7ae)]||0x0,_0x6691e9=_0x1f8dd4[_0x348126(0x153)]||0x0,_0xf9f36e=_0x1f8dd4[_0x348126(0x299)]||0x0,_0x5f1952=_0x1f8dd4[_0x348126(0x201)]||0x0,_0x225990=_0x1f8dd4[_0x348126(0x2c6)]||0x1;for(const _0x410dfd of _0x3f128e){if(!_0x410dfd)continue;if(!_0x410dfd['battler']())continue;const _0x3d7b4e=_0x410dfd[_0x348126(0xd08)]();let _0x4fc953=_0x3d7b4e['_baseX'],_0x55b313=_0x3d7b4e['_baseY'];_0x4fc953+=(Graphics[_0x348126(0x4fe)]-Graphics[_0x348126(0xa53)])/0x2,_0x55b313+=(Graphics[_0x348126(0x1fa)]-Graphics[_0x348126(0x833)])/0x2;if(_0x57a48c[_0x348126(0x7fc)](/front/i))_0x348126(0xc94)===_0x348126(0xc7f)?(_0x73e521['width']=_0x2ddeaa(_0xd73fad['$1']),_0x1879fd[_0x348126(0x1fa)]=_0x9be3c5(_0x27a485['$2'])):_0x4fc953+=(_0x410dfd[_0x348126(0x27a)]()?0x1:-0x1)*_0x3d7b4e[_0x348126(0x68b)]()/0x2;else _0x57a48c[_0x348126(0x7fc)](/back/i)&&(_0x4fc953+=(_0x410dfd[_0x348126(0x27a)]()?-0x1:0x1)*_0x3d7b4e['mainSpriteWidth']()/0x2);if(_0x57a48c[_0x348126(0x7fc)](/head/i))_0x55b313-=_0x3d7b4e[_0x348126(0x536)]();else _0x57a48c['match'](/center/i)&&(_0x55b313-=_0x3d7b4e[_0x348126(0x536)]()/0x2);_0x4fc953+=_0x23d546,_0x55b313+=_0x6691e9,_0x33098c[_0x348126(0xc38)](_0x4fc953,_0x55b313,_0xf9f36e,_0x5f1952,_0x225990);}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x6e2),_0x3cb589=>{const _0x53f3f4=_0x208a24;if(!SceneManager[_0x53f3f4(0x8c3)]())return;if(!Imported[_0x53f3f4(0x4a6)])return;const _0x52b311=SceneManager[_0x53f3f4(0xc1b)][_0x53f3f4(0xa85)];if(!_0x52b311)return;VisuMZ[_0x53f3f4(0x4f4)](_0x3cb589,_0x3cb589);const _0x3decbd=VisuMZ[_0x53f3f4(0x5bd)](_0x3cb589[_0x53f3f4(0x83d)]),_0x5523a7=_0x3cb589[_0x53f3f4(0x427)],_0xcac682=_0x3cb589[_0x53f3f4(0x7ae)]||0x0,_0x4135bf=_0x3cb589[_0x53f3f4(0x153)]||0x0,_0x1250fb=_0x3cb589[_0x53f3f4(0x299)]||0x0,_0x5144b3=_0x3cb589[_0x53f3f4(0x201)]||0x0,_0x102ad5=_0x3cb589[_0x53f3f4(0x2c6)]||0x1,_0x3872bc=Math[_0x53f3f4(0x618)](..._0x3decbd[_0x53f3f4(0x58e)](_0xaf69e3=>_0xaf69e3[_0x53f3f4(0xd08)]()[_0x53f3f4(0x169)]-_0xaf69e3[_0x53f3f4(0xd08)]()[_0x53f3f4(0x68b)]()/0x2)),_0x37a603=Math[_0x53f3f4(0x6db)](..._0x3decbd['map'](_0x446401=>_0x446401[_0x53f3f4(0xd08)]()[_0x53f3f4(0x169)]+_0x446401[_0x53f3f4(0xd08)]()[_0x53f3f4(0x68b)]()/0x2)),_0x2c25a6=Math[_0x53f3f4(0x618)](..._0x3decbd['map'](_0x2ee894=>_0x2ee894[_0x53f3f4(0xd08)]()[_0x53f3f4(0x832)]-_0x2ee894[_0x53f3f4(0xd08)]()[_0x53f3f4(0x536)]())),_0x32b2cb=Math[_0x53f3f4(0x6db)](..._0x3decbd[_0x53f3f4(0x58e)](_0xdddb2d=>_0xdddb2d[_0x53f3f4(0xd08)]()[_0x53f3f4(0x832)])),_0x554f3f=_0x3decbd[_0x53f3f4(0x5a8)](_0x2c4254=>_0x2c4254['isActor']())[_0x53f3f4(0x1ba)],_0x51ddb1=_0x3decbd[_0x53f3f4(0x5a8)](_0x1ee8fc=>_0x1ee8fc[_0x53f3f4(0x27a)]())[_0x53f3f4(0x1ba)];let _0x1929cd=0x0,_0x38a7d7=0x0;if(_0x5523a7['match'](/front/i))_0x1929cd=_0x554f3f>=_0x51ddb1?_0x3872bc:_0x37a603;else{if(_0x5523a7['match'](/middle/i))_0x53f3f4(0xb6)!=='Gjwil'?(_0x1929cd=(_0x3872bc+_0x37a603)/0x2,melee=-0x1):_0x1bb7bc[_0x53f3f4(0x176)]&&(this[_0x53f3f4(0x7c3)](_0x53f3f4(0x85c)),this['push'](_0x53f3f4(0x7c9)),this['push'](_0x53f3f4(0x6dd)),this[_0x53f3f4(0x7c3)](_0x53f3f4(0x9a1),_0x32f817[_0x53f3f4(0x176)][_0x53f3f4(0x75a)](_0x4d8b95[_0x53f3f4(0x278)]())),this[_0x53f3f4(0x7c3)](_0x53f3f4(0xac0)));else _0x5523a7[_0x53f3f4(0x7fc)](/back/i)&&(_0x1929cd=_0x554f3f>=_0x51ddb1?_0x37a603:_0x3872bc);}if(_0x5523a7[_0x53f3f4(0x7fc)](/head/i))_0x38a7d7=_0x2c25a6;else{if(_0x5523a7[_0x53f3f4(0x7fc)](/center/i)){if(_0x53f3f4(0x2d6)==='DLEDQ')return this[_0x53f3f4(0x62e)]()[_0x53f3f4(0x6c4)]['match'](/<BATTLE COMMANDS>\s*([\s\S]*)\s*<\/BATTLE COMMANDS>/i)?_0x19e7ba(_0x36ddf0['$1'])[_0x53f3f4(0xc85)](/[\r\n]+/):_0x191bd4[_0x53f3f4(0x759)][_0x53f3f4(0xc39)]['ActorCmd'][_0x53f3f4(0x949)];else _0x38a7d7=(_0x2c25a6+_0x32b2cb)/0x2;}else{if(_0x5523a7[_0x53f3f4(0x7fc)](/base/i)){if(_0x53f3f4(0xa60)===_0x53f3f4(0xd37)){const _0x39cd8f=[];for(const _0x3d74aa of this[_0x53f3f4(0x449)]()['actions']){const _0x2b4eef=_0x1b0fd8[_0x3d74aa['skillId']];if(_0x2b4eef&&!_0x39cd8f[_0x53f3f4(0xcaf)](_0x2b4eef))_0x39cd8f['push'](_0x2b4eef);}return _0x39cd8f;}else _0x38a7d7=_0x32b2cb;}}}_0x1929cd+=(Graphics['width']-Graphics[_0x53f3f4(0xa53)])/0x2,_0x38a7d7+=(Graphics['height']-Graphics[_0x53f3f4(0x833)])/0x2,_0x1929cd+=_0xcac682,_0x38a7d7+=_0x4135bf,_0x52b311[_0x53f3f4(0xc38)](_0x1929cd,_0x38a7d7,_0x1250fb,_0x5144b3,_0x102ad5);}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0x4fb),_0x2a9258=>{const _0x5256f9=_0x208a24;if(!Imported[_0x5256f9(0x4a6)])return;const _0x143ac2=SceneManager['_scene'][_0x5256f9(0xa85)];if(!_0x143ac2)return;if(VisuMZ[_0x5256f9(0x826)][_0x5256f9(0x738)]<=1.04){alert(_0x5256f9(0xb94)),SceneManager[_0x5256f9(0x1b1)]();return;}VisuMZ[_0x5256f9(0x4f4)](_0x2a9258,_0x2a9258);const _0x28ca96=$gameTemp['getLastPluginCommandInterpreter'](),_0x1f0424=Math['max'](0.01,_0x2a9258[_0x5256f9(0xab2)]);$gameTemp[_0x5256f9(0x982)](_0x1f0424,_0x28ca96);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x82e),_0xd27f3a=>{const _0x1a96fb=_0x208a24;if(!Imported['VisuMZ_3_ActSeqImpact'])return;const _0x5b2f12=SceneManager['_scene']['_spriteset'];if(!_0x5b2f12)return;if(VisuMZ[_0x1a96fb(0x826)][_0x1a96fb(0x738)]<=1.04){if(_0x1a96fb(0x485)===_0x1a96fb(0x940))this[_0x1a96fb(0x7c3)](_0x1a96fb(0xd4a),_0x46707d);else{alert(_0x1a96fb(0xb94)),SceneManager[_0x1a96fb(0x1b1)]();return;}}VisuMZ[_0x1a96fb(0x4f4)](_0xd27f3a,_0xd27f3a);const _0x54ffa2=$gameTemp[_0x1a96fb(0xcc)](),_0x4b5280=_0xd27f3a['ms']||0x1;VisuMZ[_0x1a96fb(0x826)][_0x1a96fb(0xd4f)](_0x4b5280,_0x54ffa2);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xc31),_0x1acc8f=>{const _0x4b933e=_0x208a24;if(!Imported[_0x4b933e(0x4a6)])return;const _0x155580=SceneManager[_0x4b933e(0xc1b)]['_spriteset'];if(!_0x155580)return;VisuMZ[_0x4b933e(0x4f4)](_0x1acc8f,_0x1acc8f);const _0x375d0e=_0x1acc8f['X']||0x0,_0x22d3a3=_0x1acc8f['Y']||0x0,_0x3c111d=_0x1acc8f[_0x4b933e(0x34b)]||0x0,_0x4fd20b=_0x1acc8f['Radius']||0x0,_0x43b6a4=_0x1acc8f[_0x4b933e(0x2c6)]||0x1,_0x24dd49=_0x1acc8f[_0x4b933e(0x99b)]||_0x4b933e(0xc0e);_0x155580[_0x4b933e(0xc55)](_0x3c111d,_0x375d0e,_0x22d3a3,_0x4fd20b,_0x43b6a4,_0x24dd49);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x8e7),_0x30205e=>{const _0x2888f2=_0x208a24;if(!Imported[_0x2888f2(0x4a6)])return;const _0x5869cb=SceneManager[_0x2888f2(0xc1b)][_0x2888f2(0xa85)];if(!_0x5869cb)return;VisuMZ[_0x2888f2(0x4f4)](_0x30205e,_0x30205e);const _0x1c63b8=VisuMZ[_0x2888f2(0x5bd)](_0x30205e[_0x2888f2(0x83d)]),_0x244f5d=_0x30205e['TargetLocation'],_0x570f1d=_0x30205e[_0x2888f2(0x7ae)]||0x0,_0x2130b8=_0x30205e[_0x2888f2(0x153)]||0x0,_0x1eb30f=_0x30205e[_0x2888f2(0x34b)]||0x0,_0x4dc773=_0x30205e[_0x2888f2(0x3b7)]||0x0,_0x23b6c5=_0x30205e[_0x2888f2(0x2c6)]||0x1,_0x4659c5=_0x30205e[_0x2888f2(0x99b)]||_0x2888f2(0xc0e),_0x5624ec=Math['min'](..._0x1c63b8['map'](_0x2e2a00=>_0x2e2a00[_0x2888f2(0xd08)]()[_0x2888f2(0x169)]-_0x2e2a00['battler']()[_0x2888f2(0x68b)]()/0x2)),_0x397119=Math[_0x2888f2(0x6db)](..._0x1c63b8[_0x2888f2(0x58e)](_0x1bb736=>_0x1bb736['battler']()[_0x2888f2(0x169)]+_0x1bb736['battler']()[_0x2888f2(0x68b)]()/0x2)),_0x28dfb7=Math[_0x2888f2(0x618)](..._0x1c63b8[_0x2888f2(0x58e)](_0x6afc52=>_0x6afc52['battler']()[_0x2888f2(0x832)]-_0x6afc52['battler']()['mainSpriteHeight']())),_0x4f05bd=Math[_0x2888f2(0x6db)](..._0x1c63b8[_0x2888f2(0x58e)](_0x5b0d44=>_0x5b0d44[_0x2888f2(0xd08)]()['_baseY'])),_0x546776=_0x1c63b8[_0x2888f2(0x5a8)](_0x262dac=>_0x262dac[_0x2888f2(0x9bf)]())[_0x2888f2(0x1ba)],_0x36af18=_0x1c63b8[_0x2888f2(0x5a8)](_0x564d26=>_0x564d26[_0x2888f2(0x27a)]())[_0x2888f2(0x1ba)];let _0x206013=0x0,_0x406437=0x0;if(_0x244f5d[_0x2888f2(0x7fc)](/front/i))_0x206013=_0x546776>=_0x36af18?_0x5624ec:_0x397119;else{if(_0x244f5d[_0x2888f2(0x7fc)](/middle/i))_0x206013=(_0x5624ec+_0x397119)/0x2,melee=-0x1;else _0x244f5d[_0x2888f2(0x7fc)](/back/i)&&(_0x206013=_0x546776>=_0x36af18?_0x397119:_0x5624ec);}if(_0x244f5d[_0x2888f2(0x7fc)](/head/i))_0x406437=_0x28dfb7;else{if(_0x244f5d['match'](/center/i)){if(_0x2888f2(0xb58)!==_0x2888f2(0xb58)){_0x2ab409[_0x2888f2(0x759)]['Game_Action_itemEffectAddNormalState'][_0x2888f2(0x783)](this,_0x2b6374,_0x548641);if(!_0x2808e4[_0x2888f2(0x9cd)]())return;if(_0x62f5e2[_0x2888f2(0x28e)]!==_0x1d69c4[_0x2888f2(0xcb5)]())return;let _0x425d0e=_0x16bb07[_0x2888f2(0x615)];!this['isCertainHit']()&&(_0x425d0e*=_0x417376['stateRate'](_0x1f00f9['dataId']),_0x425d0e*=this['lukEffectRate'](_0x4afa2c)),_0x29c2f6['random']()<_0x425d0e&&(_0x44db98[_0x2888f2(0xd28)]=!![],this[_0x2888f2(0x899)](_0x26cbcf));}else _0x406437=(_0x28dfb7+_0x4f05bd)/0x2;}else _0x244f5d[_0x2888f2(0x7fc)](/base/i)&&(_0x406437=_0x4f05bd);}_0x206013+=(Graphics[_0x2888f2(0x4fe)]-Graphics[_0x2888f2(0xa53)])/0x2,_0x406437+=(Graphics[_0x2888f2(0x1fa)]-Graphics[_0x2888f2(0x833)])/0x2,_0x206013+=_0x570f1d,_0x406437+=_0x2130b8,_0x5869cb['setupZoomBlurImpactFilter'](_0x1eb30f,_0x206013,_0x406437,_0x4dc773,_0x23b6c5,_0x4659c5);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Inject_AnimationStart',_0x53c784=>{const _0xcdf676=_0x208a24;if(!Imported[_0xcdf676(0x4a6)])return;const _0x300dc8=SceneManager['_scene'][_0xcdf676(0xa85)];if(!_0x300dc8)return;if(VisuMZ[_0xcdf676(0x826)]['version']<=1.05){alert('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),SceneManager['exit']();return;}VisuMZ[_0xcdf676(0x4f4)](_0x53c784,_0x53c784);const _0xc9f547=VisuMZ[_0xcdf676(0x5bd)](_0x53c784[_0xcdf676(0x83d)]),_0x4e74ba={'filename':_0x53c784[_0xcdf676(0x6e9)],'horzCells':_0x53c784[_0xcdf676(0x184)]||0x1,'vertCells':_0x53c784[_0xcdf676(0x222)]||0x1,'frameDelay':_0x53c784[_0xcdf676(0x5ac)]||0x1,'smooth':_0x53c784[_0xcdf676(0xfe)]||![],'anchorX':_0x53c784[_0xcdf676(0x73d)]||0x0,'anchorY':_0x53c784[_0xcdf676(0x5b3)]||0x0,'offsetX':_0x53c784['offsetX']||0x0,'offsetY':_0x53c784['offsetY']||0x0};for(const _0x304145 of _0xc9f547){if(!_0x304145)continue;if(!_0x304145[_0xcdf676(0xd08)]())continue;_0x304145[_0xcdf676(0xd08)]()[_0xcdf676(0x9b1)](_0x4e74ba);}const _0x46476a=$gameTemp['getLastPluginCommandInterpreter']();_0x46476a&&(_0xcdf676(0x3ff)===_0xcdf676(0x3ff)?_0x46476a[_0xcdf676(0x3dc)](_0xcdf676(0x658)):(_0x38325f['BattleCore'][_0xcdf676(0x104)][_0xcdf676(0x783)](this),_0x5525c1[_0xcdf676(0x841)]&&(this[_0xcdf676(0xd4)]=!![],_0x59e25f['_battleCoreBattleResumeAfter']=_0xb7e0c6)));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0xad0),_0x3164e5=>{const _0x49c13c=_0x208a24;if(!Imported[_0x49c13c(0x4a6)])return;const _0x20c0e4=SceneManager[_0x49c13c(0xc1b)]['_spriteset'];if(!_0x20c0e4)return;if(VisuMZ[_0x49c13c(0x826)][_0x49c13c(0x738)]<=1.05){alert(_0x49c13c(0xb94)),SceneManager[_0x49c13c(0x1b1)]();return;}VisuMZ[_0x49c13c(0x4f4)](_0x3164e5,_0x3164e5);const _0x27e918=VisuMZ[_0x49c13c(0x5bd)](_0x3164e5['Targets']);for(const _0x37f1d4 of _0x27e918){if(_0x49c13c(0x8d6)===_0x49c13c(0x8d6)){if(!_0x37f1d4)continue;if(!_0x37f1d4[_0x49c13c(0xd08)]())continue;_0x37f1d4[_0x49c13c(0xd08)]()[_0x49c13c(0x791)]();}else{const _0x1b4281=_0x49c13c(0xe3)['format'](_0x11da4b[_0x49c13c(0xcf4)]()),_0x23e4a0=this['createInnerPortrait'](_0x1b4281,_0x37ac47),_0x5e6783=_0x403272[_0x49c13c(0xaaf)]();_0x5e6783!==''?_0x23e4a0[_0x49c13c(0x63f)]=_0x2749e0[_0x49c13c(0x474)](_0x5e6783):_0x23e4a0['bitmap']=_0x142a04[_0x49c13c(0xd06)];const _0x607ab5=this[_0x49c13c(0x69a)](_0x3a9a8d);_0x23e4a0[_0x49c13c(0x7ec)]['x']=0.5,_0x23e4a0[_0x49c13c(0x7ec)]['y']=0x1;let _0x2c934f=_0x41f359['round'](_0x607ab5['x']+_0x607ab5[_0x49c13c(0x4fe)]/0x2)+this[_0x49c13c(0x11b)];_0x2c934f+=_0x4d853b['getBattlePortraitOffsetX']();let _0x2a4a49=_0x347156[_0x49c13c(0xd50)](this[_0x49c13c(0x1fa)]);_0x2a4a49+=_0x3d9e15[_0x49c13c(0xcb9)](),_0x23e4a0['move'](_0x2c934f,_0x2a4a49);const _0x44c15c=_0x2120b9[_0x49c13c(0x759)]['Settings'][_0x49c13c(0x148)][_0x49c13c(0x934)];_0x23e4a0[_0x49c13c(0x867)]['x']=_0x44c15c,_0x23e4a0[_0x49c13c(0x867)]['y']=_0x44c15c,_0x23e4a0[_0x49c13c(0xb3e)]();}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x96b),_0xf33251=>{const _0x5c86cd=_0x208a24;if(!Imported[_0x5c86cd(0x4a6)])return;const _0x1690a=SceneManager[_0x5c86cd(0xc1b)][_0x5c86cd(0xa85)];if(!_0x1690a)return;if(VisuMZ[_0x5c86cd(0x826)][_0x5c86cd(0x738)]<=1.05){alert(_0x5c86cd(0xb94)),SceneManager['exit']();return;}VisuMZ[_0x5c86cd(0x4f4)](_0xf33251,_0xf33251);const _0x59c8=VisuMZ[_0x5c86cd(0x5bd)](_0xf33251[_0x5c86cd(0x83d)]),_0x2a7d9f=_0xf33251[_0x5c86cd(0x942)];for(const _0x21acd7 of _0x59c8){if(_0x5c86cd(0x9fe)===_0x5c86cd(0xd3b)){const _0x2fdd40=_0xedecae[_0x5c86cd(0x6c4)];if(_0x2fdd40[_0x5c86cd(0x7fc)](_0xb7a500['BattleCore'][_0x5c86cd(0x7b1)][_0x119593])){const _0x430d5c=_0x4b3d0c['$1'],_0x3c826d='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20obj\x20=\x20arguments[2];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20value\x20=\x20arguments[3]\x20||\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalValue\x20=\x20value;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Constants\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20action\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this\x20:\x20user.currentAction();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20attacker\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20defender\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20healer\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20receiver\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20actor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20currentClass\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20item\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20weapon\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20armor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20enemy\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20obj;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Create\x20Compatibility\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20origin\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(Imported.VisuMZ_1_SkillsStatesCore\x20&&\x20$dataStates.includes(obj))\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20origin\x20=\x20target.getStateOrigin(obj.id);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(value)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20value\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20value\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20value\x20=\x20originalValue;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20value;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'['format'](_0x430d5c),_0x278a9a=_0x54fe12[_0x5c86cd(0x759)]['createKeyJS'](_0xd62424,_0x5eee23);_0x25f572[_0x5c86cd(0x759)]['JS'][_0x278a9a]=new _0x413879(_0x3c826d);}}else{if(!_0x21acd7)continue;if(!_0x21acd7[_0x5c86cd(0xd08)]())continue;_0x21acd7[_0x5c86cd(0xd08)]()['pauseInjectAnimation'](_0x2a7d9f);}}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x2bf),_0x2f7c39=>{const _0x356919=_0x208a24;if(!SceneManager[_0x356919(0x8c3)]())return;const _0x33a32a=$gameTemp[_0x356919(0xcc)]();if(!_0x33a32a)return;_0x33a32a[_0x356919(0x3dc)](_0x356919(0x20d));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Mechanics_ActionEffect',_0x4bea57=>{const _0x1a30b1=_0x208a24;if(!SceneManager[_0x1a30b1(0x8c3)]())return;VisuMZ['ConvertParams'](_0x4bea57,_0x4bea57);const _0x1702ef=$gameTemp[_0x1a30b1(0xcc)](),_0x5b83c2=BattleManager[_0x1a30b1(0x8fb)],_0x388844=BattleManager[_0x1a30b1(0x64d)],_0x562917=BattleManager[_0x1a30b1(0x46b)];if(!_0x1702ef||!_0x5b83c2||!_0x388844)return;if(!_0x5b83c2[_0x1a30b1(0x8bb)]())return;const _0x6d5f86=VisuMZ[_0x1a30b1(0x5bd)](_0x4bea57['Targets']);for(const _0x52b1ab of _0x6d5f86){if(_0x1a30b1(0x7c0)!==_0x1a30b1(0xb74)){if(!_0x52b1ab)continue;_0x562917[_0x1a30b1(0x7c3)](_0x1a30b1(0x29e),_0x388844,_0x52b1ab);}else _0x3a586d[_0x1a30b1(0x245)]=_0x1b1a1a(_0x282868['$1'])['toLowerCase']()[_0x1a30b1(0x446)]();}_0x1702ef[_0x1a30b1(0x3dc)](_0x1a30b1(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xcbc),_0x2b95fc=>{const _0x432a3a=_0x208a24;if(!SceneManager[_0x432a3a(0x8c3)]())return;if(!Imported[_0x432a3a(0xa2a)])return;$gameTemp[_0x432a3a(0x1e1)]=!![];}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xcaa),_0x3989b0=>{const _0x2bc1a5=_0x208a24;if(!SceneManager[_0x2bc1a5(0x8c3)]())return;VisuMZ[_0x2bc1a5(0x4f4)](_0x3989b0,_0x3989b0);const _0x39a262=[_0x2bc1a5(0xbef),_0x2bc1a5(0xbf5),_0x2bc1a5(0x999),_0x2bc1a5(0xb52),_0x2bc1a5(0xd1c),_0x2bc1a5(0x1a0),_0x2bc1a5(0x544),_0x2bc1a5(0x210)],_0x2f1e50=_0x3989b0[_0x2bc1a5(0x919)],_0x33ef03=_0x3989b0['Debuffs'],_0x130350=_0x3989b0[_0x2bc1a5(0xcc5)],_0x4135f7=VisuMZ[_0x2bc1a5(0x5bd)](_0x3989b0[_0x2bc1a5(0x83d)]);for(const _0x837944 of _0x4135f7){if(!_0x837944)continue;for(const _0x3ffa62 of _0x2f1e50){const _0x43ae48=_0x39a262[_0x2bc1a5(0x6d1)](_0x3ffa62[_0x2bc1a5(0x4d6)]()[_0x2bc1a5(0x446)]());_0x43ae48>=0x0&&_0x43ae48<=0x7&&_0x837944['addBuff'](_0x43ae48,_0x130350);}for(const _0x1bcdd9 of _0x33ef03){if(_0x2bc1a5(0x935)===_0x2bc1a5(0xd01))_0x2a4a98=_0xbeb4bf(_0x3175e5['$1']);else{const _0x940488=_0x39a262['indexOf'](_0x1bcdd9[_0x2bc1a5(0x4d6)]()[_0x2bc1a5(0x446)]());_0x940488>=0x0&&_0x940488<=0x7&&_0x837944['addDebuff'](_0x940488,_0x130350);}}}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0xcc4),_0x4bd835=>{const _0x2fb15f=_0x208a24;if(!SceneManager[_0x2fb15f(0x8c3)]())return;VisuMZ[_0x2fb15f(0x4f4)](_0x4bd835,_0x4bd835);const _0x1a41a6=_0x4bd835[_0x2fb15f(0xcf7)],_0x5f02a3=VisuMZ[_0x2fb15f(0x5bd)](_0x4bd835[_0x2fb15f(0x83d)]);for(const _0x4f46c0 of _0x5f02a3){if(_0x2fb15f(0x360)!==_0x2fb15f(0x360)){_0x432871['playReflection']();let _0x357bda=_0x40c9bd['BattleCore'][_0x2fb15f(0xc39)]['ActionSequence'][_0x2fb15f(0x3a5)];_0x357bda>0x0&&(_0x15f40e['VisuMZ_0_CoreEngine']?_0x46a0ca[_0x2fb15f(0xcae)]([this],_0x357bda):_0x5b03ee[_0x2fb15f(0x2d8)]([this],_0x357bda));}else{if(!_0x4f46c0)continue;for(const _0x1d1dc9 of _0x1a41a6){_0x4f46c0[_0x2fb15f(0x3e9)](_0x1d1dc9);}}}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x71d),_0x2065af=>{const _0xa01c1e=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x2065af,_0x2065af);const _0x2c5d02=BattleManager[_0xa01c1e(0x8fb)],_0x410779={'arPenRate':_0x2065af[_0xa01c1e(0x31a)],'arPenFlat':_0x2065af[_0xa01c1e(0x612)],'arRedRate':_0x2065af[_0xa01c1e(0x11c)],'arRedFlat':_0x2065af[_0xa01c1e(0x89a)]};_0x2c5d02[_0xa01c1e(0x56b)]=_0x410779;}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x349),_0x542b3c=>{const _0x3ccc50=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x3ccc50(0x1be)])return;VisuMZ['ConvertParams'](_0x542b3c,_0x542b3c);const _0xf102bb=VisuMZ[_0x3ccc50(0x5bd)](_0x542b3c[_0x3ccc50(0x83d)]),_0x5e7935=_0x542b3c[_0x3ccc50(0x3a9)]||0x1;for(const _0x39d992 of _0xf102bb){if(!_0x39d992)continue;if(!_0x39d992[_0x3ccc50(0x27a)]())continue;_0x39d992[_0x3ccc50(0x90f)](_0x5e7935);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_AtbGauge',_0x3a32ff=>{const _0x295060=_0x208a24;if(!SceneManager[_0x295060(0x8c3)]())return;if(!Imported['VisuMZ_2_BattleSystemATB'])return;if(!BattleManager[_0x295060(0x62d)]())return;VisuMZ['ConvertParams'](_0x3a32ff,_0x3a32ff);const _0x8ba399=VisuMZ[_0x295060(0x5bd)](_0x3a32ff[_0x295060(0x83d)]),_0x5e396f=_0x3a32ff[_0x295060(0x64c)],_0x401f9f=_0x3a32ff[_0x295060(0x64c)],_0xf5529d=_0x3a32ff[_0x295060(0xa5a)];for(const _0x4dd04f of _0x8ba399){if(!_0x4dd04f)continue;if(_0x4dd04f[_0x295060(0xa1f)]())'mCzem'!==_0x295060(0x324)?(_0x22a86c+=_0x19b94a[_0x295060(0x9bf)]()?-_0x5463cc:_0x1fa02c,_0x2d74b6+=_0x471ca8['isActor']()?-_0x55e6f3:_0x59fb6a):_0x4dd04f[_0x295060(0x8eb)](_0x5e396f);else{if(_0x4dd04f[_0x295060(0x120)]()){_0x4dd04f[_0x295060(0x379)](_0x401f9f);if(_0xf5529d)_0x4dd04f['atbInterrupt']();}}}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_BoostPointsChange',_0x5afb36=>{const _0x241383=_0x208a24;if(!SceneManager[_0x241383(0x8c3)]())return;if(!Imported[_0x241383(0x8b6)])return;VisuMZ['ConvertParams'](_0x5afb36,_0x5afb36);const _0x157b7c=VisuMZ[_0x241383(0x5bd)](_0x5afb36['Targets']),_0x20f273=_0x5afb36[_0x241383(0x4b0)];for(const _0x457e46 of _0x157b7c){if(!_0x457e46)continue;_0x457e46[_0x241383(0x64b)](_0x20f273);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_BoostPointsStoreData',_0x5bf1be=>{const _0x1f8e32=_0x208a24;if(!SceneManager[_0x1f8e32(0x8c3)]())return;if(!Imported['VisuMZ_3_BoostAction'])return;if(!BattleManager[_0x1f8e32(0x64d)])return;VisuMZ['ConvertParams'](_0x5bf1be,_0x5bf1be);const _0x3fc957=_0x5bf1be[_0x1f8e32(0x1f5)];$gameVariables[_0x1f8e32(0x7e1)](_0x3fc957,BattleManager[_0x1f8e32(0x64d)][_0x1f8e32(0x40b)]());}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0x95d),_0x1505b0=>{const _0x4bb3e7=_0x208a24;if(!SceneManager[_0x4bb3e7(0x8c3)]())return;if(!Imported[_0x4bb3e7(0x5a7)])return;VisuMZ[_0x4bb3e7(0x4f4)](_0x1505b0,_0x1505b0);const _0x43ee5f=VisuMZ['CreateActionSequenceTargets'](_0x1505b0[_0x4bb3e7(0x83d)]),_0x3b3810=_0x1505b0['BreakShields'];for(const _0x1bf0f9 of _0x43ee5f){if(_0x4bb3e7(0x1d0)==='dTjwb')this[_0x4bb3e7(0x714)]=_0xc8de33(_0x3f0535['$1']);else{if(!_0x1bf0f9)continue;if(_0x1bf0f9[_0x4bb3e7(0x4fd)]())continue;if(!_0x1bf0f9[_0x4bb3e7(0x733)]())continue;_0x1bf0f9[_0x4bb3e7(0x9d5)](_0x3b3810);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x72b),_0x34cafc=>{const _0x10268c=_0x208a24;if(!SceneManager[_0x10268c(0x8c3)]())return;if(!Imported['VisuMZ_4_BreakShields'])return;VisuMZ[_0x10268c(0x4f4)](_0x34cafc,_0x34cafc);const _0x1039e4=VisuMZ['CreateActionSequenceTargets'](_0x34cafc[_0x10268c(0x83d)]);for(const _0x1e2880 of _0x1039e4){if(!_0x1e2880)continue;if(_0x1e2880[_0x10268c(0x4fd)]())continue;if(!_0x1e2880[_0x10268c(0x733)]())continue;_0x1e2880[_0x10268c(0xb1d)]();}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_BtbGain',_0x2599e1=>{const _0x5c0e1d=_0x208a24;if(!SceneManager[_0x5c0e1d(0x8c3)]())return;if(!Imported[_0x5c0e1d(0x686)])return;if(!BattleManager[_0x5c0e1d(0x700)]())return;VisuMZ['ConvertParams'](_0x2599e1,_0x2599e1);const _0x2828e0=VisuMZ[_0x5c0e1d(0x5bd)](_0x2599e1[_0x5c0e1d(0x83d)]),_0x296938=_0x2599e1[_0x5c0e1d(0x7c2)];for(const _0x48cf62 of _0x2828e0){if(_0x5c0e1d(0x886)!==_0x5c0e1d(0x886))this[_0x5c0e1d(0x83a)]++,_0x1a0aa8[_0x5c0e1d(0x9ba)]%0x1e<0xf?_0x5e2a04[_0x5c0e1d(0x606)]([0xff,0xff,0xff,0x40]):_0x3176f9[_0x5c0e1d(0x606)]([0x0,0x0,0x0,0x0]);else{if(!_0x48cf62)continue;_0x48cf62[_0x5c0e1d(0xc52)](_0x296938);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_Collapse',_0x601e99=>{const _0x209857=_0x208a24;if(!SceneManager[_0x209857(0x8c3)]())return;VisuMZ[_0x209857(0x4f4)](_0x601e99,_0x601e99);const _0x5b5dca=$gameTemp[_0x209857(0xcc)](),_0x1aafd3=BattleManager['_action'],_0x49846d=BattleManager[_0x209857(0x64d)];if(!_0x5b5dca||!_0x1aafd3||!_0x49846d)return;if(!_0x1aafd3[_0x209857(0x8bb)]())return;const _0x154e5d=VisuMZ[_0x209857(0x5bd)](_0x601e99[_0x209857(0x83d)]);for(const _0x572595 of _0x154e5d){if(!_0x572595)continue;_0x601e99[_0x209857(0xa83)]&&(_0x572595[_0x209857(0xd3)](),_0x572595[_0x209857(0x3e9)](_0x572595[_0x209857(0xcb5)]())),_0x572595[_0x209857(0xc47)]()&&_0x572595[_0x209857(0x352)]();}_0x5b5dca[_0x209857(0x3dc)](_0x209857(0x5cf));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x1ee),_0x2e409d=>{const _0x1a1ab7=_0x208a24;if(!SceneManager[_0x1a1ab7(0x8c3)]())return;if(!Imported[_0x1a1ab7(0x57c)])return;if(!BattleManager[_0x1a1ab7(0x9ca)]())return;VisuMZ[_0x1a1ab7(0x4f4)](_0x2e409d,_0x2e409d);const _0x1d546f=VisuMZ[_0x1a1ab7(0x5bd)](_0x2e409d[_0x1a1ab7(0x83d)]),_0x3ec1a1=_0x2e409d[_0x1a1ab7(0x727)];for(const _0x3aadac of _0x1d546f){if(!_0x3aadac)continue;_0x3aadac['changeTurnOrderByCTB'](_0x3ec1a1);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x696),_0x5ab797=>{const _0x416c9b=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_2_BattleSystemCTB'])return;if(!BattleManager['isCTB']())return;VisuMZ[_0x416c9b(0x4f4)](_0x5ab797,_0x5ab797);const _0x496589=VisuMZ[_0x416c9b(0x5bd)](_0x5ab797[_0x416c9b(0x83d)]),_0x599e7f=_0x5ab797[_0x416c9b(0x64c)],_0x307aa0=_0x5ab797[_0x416c9b(0x64c)];for(const _0x1c2c46 of _0x496589){if(!_0x1c2c46)continue;if(_0x1c2c46[_0x416c9b(0x329)]===_0x416c9b(0x337)){if(_0x416c9b(0x142)!==_0x416c9b(0x142)){_0x10275e('Action\x20Sequence\x20Impact\x20needs\x20an\x20update!'),_0x4a22ad[_0x416c9b(0x1b1)]();return;}else _0x1c2c46[_0x416c9b(0x537)](_0x599e7f);}else _0x1c2c46[_0x416c9b(0x329)]==='casting'&&_0x1c2c46[_0x416c9b(0x6f0)](_0x307aa0);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_CustomDmgFormula',_0x4309bb=>{const _0x26f22a=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x26f22a(0x4f4)](_0x4309bb,_0x4309bb);const _0x47ebd0=BattleManager['_action'];if(!_0x47ebd0)return;let _0x3bc932=_0x4309bb[_0x26f22a(0xbc0)];_0x47ebd0['setCustomDamageFormula'](_0x3bc932);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Mechanics_DamagePopup',_0x47e253=>{const _0x5d7dcb=_0x208a24;if(!SceneManager[_0x5d7dcb(0x8c3)]())return;VisuMZ[_0x5d7dcb(0x4f4)](_0x47e253,_0x47e253);const _0x44c32a=VisuMZ[_0x5d7dcb(0x5bd)](_0x47e253[_0x5d7dcb(0x83d)]);for(const _0x248cb0 of _0x44c32a){if(!_0x248cb0)continue;if(_0x248cb0['shouldPopupDamage']())_0x248cb0[_0x5d7dcb(0xbd5)]();}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_DeathBreak',_0x231f5d=>{const _0x1cbf6b=_0x208a24;if(!SceneManager[_0x1cbf6b(0x8c3)]())return;VisuMZ['ConvertParams'](_0x231f5d,_0x231f5d);const _0x5f25ce=$gameTemp[_0x1cbf6b(0xcc)](),_0x5a9ec5=BattleManager[_0x1cbf6b(0x64d)],_0x1a88e0=_0x231f5d[_0x1cbf6b(0xc98)];if(!_0x5f25ce)return;if(!_0x5a9ec5)return;_0x5a9ec5&&_0x5a9ec5[_0x1cbf6b(0x248)]()&&_0x1a88e0[_0x1cbf6b(0x4d6)]()[_0x1cbf6b(0x446)]()!==_0x1cbf6b(0x873)&&_0x5f25ce[_0x1cbf6b(0x2f3)]([_0x1a88e0]);}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x824),_0x525740=>{const _0x5f0fa2=_0x208a24;if(!SceneManager[_0x5f0fa2(0x8c3)]())return;VisuMZ[_0x5f0fa2(0x4f4)](_0x525740,_0x525740);const _0x3afb0b=$gameTemp['getLastPluginCommandInterpreter'](),_0x1fe4ae=BattleManager[_0x5f0fa2(0x46b)];if(!_0x3afb0b)return;const _0x2573d7=VisuMZ['CreateActionSequenceTargets'](_0x525740[_0x5f0fa2(0x60f)]),_0x140cb0=VisuMZ[_0x5f0fa2(0x5bd)](_0x525740[_0x5f0fa2(0x83d)]);for(const _0x404817 of _0x2573d7){for(const _0x57053b of _0x140cb0){if(!_0x57053b)continue;const _0x160078=$dataSkills[_0x404817['attackSkillId']()];_0x1fe4ae[_0x5f0fa2(0x7c3)](_0x5f0fa2(0x3b6),_0x404817,_0x57053b,_0x160078);}}_0x3afb0b['setWaitMode'](_0x5f0fa2(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0xc0d),_0x10e8c0=>{const _0x4d178a=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x4d178a(0x4f4)](_0x10e8c0,_0x10e8c0);const _0x56fc71=$gameTemp['getLastPluginCommandInterpreter'](),_0x3662e3=BattleManager[_0x4d178a(0x46b)];if(!_0x56fc71)return;const _0x2b2aeb=VisuMZ[_0x4d178a(0x5bd)](_0x10e8c0[_0x4d178a(0x60f)]),_0x2de6ce=VisuMZ[_0x4d178a(0x5bd)](_0x10e8c0[_0x4d178a(0x83d)]);for(const _0x216b2c of _0x2b2aeb){for(const _0x4d26ea of _0x2de6ce){if(!_0x4d26ea)continue;const _0x48b868=$dataSkills[_0x216b2c['guardSkillId']()];_0x3662e3[_0x4d178a(0x7c3)](_0x4d178a(0x3b6),_0x216b2c,_0x4d26ea,_0x48b868);}}_0x56fc71[_0x4d178a(0x3dc)](_0x4d178a(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xcd6),_0x5953a1=>{const _0x1266d6=_0x208a24;if(!SceneManager[_0x1266d6(0x8c3)]())return;VisuMZ[_0x1266d6(0x4f4)](_0x5953a1,_0x5953a1);const _0x29b42d=$gameTemp[_0x1266d6(0xcc)](),_0x3fe3b7=BattleManager[_0x1266d6(0x46b)],_0x2feb61=Number(_0x5953a1[_0x1266d6(0xc68)]||0x1),_0x40cf7e=$dataItems[_0x2feb61];if(!_0x29b42d)return;if(!_0x40cf7e)return;const _0x2c6620=VisuMZ[_0x1266d6(0x5bd)](_0x5953a1['Users']),_0x11bce1=VisuMZ['CreateActionSequenceTargets'](_0x5953a1['Targets']);for(const _0x343f8d of _0x2c6620){for(const _0x4e83d5 of _0x11bce1){if(!_0x4e83d5)continue;_0x3fe3b7[_0x1266d6(0x7c3)](_0x1266d6(0x3b6),_0x343f8d,_0x4e83d5,_0x40cf7e);}}_0x29b42d['setWaitMode'](_0x1266d6(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xb78),_0x49d349=>{const _0x58fd08=_0x208a24;if(!SceneManager[_0x58fd08(0x8c3)]())return;VisuMZ[_0x58fd08(0x4f4)](_0x49d349,_0x49d349);let _0xafe3fe=Number(_0x49d349[_0x58fd08(0x82c)]||0x0);if(_0xafe3fe<=0x0){const _0x255be5=BattleManager[_0x58fd08(0x8fb)];if(_0x255be5&&_0x255be5[_0x58fd08(0x269)]())_0x58fd08(0x9ea)===_0x58fd08(0x9ea)?_0xafe3fe=_0x255be5[_0x58fd08(0x8bb)]()['id']:this['setup'](_0x58872e[_0x58fd08(0x38d)],0x0);else return;}const _0x4780d7=$dataSkills[_0xafe3fe];if(!_0x4780d7)return;const _0x1cacae=VisuMZ[_0x58fd08(0x5bd)](_0x49d349[_0x58fd08(0x60f)]);for(const _0x16b9cb of _0x1cacae){_0x16b9cb[_0x58fd08(0x853)](_0x4780d7);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x30c),_0x492050=>{const _0x76ebb0=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x492050,_0x492050);const _0x55329d=$gameTemp[_0x76ebb0(0xcc)](),_0x12f8aa=BattleManager[_0x76ebb0(0x46b)],_0x2254fc=Number(_0x492050['SkillID']||0x1),_0x384667=$dataSkills[_0x2254fc];if(!_0x55329d)return;if(!_0x384667)return;const _0x42f102=VisuMZ['CreateActionSequenceTargets'](_0x492050['Users']),_0x11b3ae=VisuMZ[_0x76ebb0(0x5bd)](_0x492050[_0x76ebb0(0x83d)]);for(const _0x1be6bb of _0x42f102){if(_0x76ebb0(0x8a6)===_0x76ebb0(0x8a6))for(const _0x26a8a1 of _0x11b3ae){if(!_0x26a8a1)continue;_0x12f8aa[_0x76ebb0(0x7c3)](_0x76ebb0(0x3b6),_0x1be6bb,_0x26a8a1,_0x384667);}else{if([0x6c,0x198][_0x76ebb0(0xcaf)](_0x41a865[_0x76ebb0(0x762)])){const _0x29a277=_0x1ebd87[_0x76ebb0(0x378)][0x0];if(_0x29a277['match'](/<ONCE PARALLEL WHEN START BATTLE>/i))return!![];}}}_0x55329d[_0x76ebb0(0x3dc)](_0x76ebb0(0x4c6));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x4e5),_0x3024a8=>{const _0x5b1554=_0x208a24;if(!SceneManager[_0x5b1554(0x8c3)]())return;VisuMZ[_0x5b1554(0x4f4)](_0x3024a8,_0x3024a8);const _0x1b137d=VisuMZ[_0x5b1554(0x5bd)](_0x3024a8[_0x5b1554(0x83d)]);for(const _0x306e18 of _0x1b137d){if(!_0x306e18)continue;if(!_0x306e18[_0x5b1554(0x27a)]())continue;_0x306e18[_0x5b1554(0x2dc)]();}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x7bd),_0x26521d=>{const _0x2ed625=_0x208a24;if(!SceneManager[_0x2ed625(0x8c3)]())return;if(!Imported[_0x2ed625(0x719)])return;if(!BattleManager[_0x2ed625(0x549)]())return;VisuMZ[_0x2ed625(0x4f4)](_0x26521d,_0x26521d);const _0x49d565=_0x26521d[_0x2ed625(0x265)];if(BattleManager[_0x2ed625(0x64d)]){if('hCTyu'===_0x2ed625(0x81d))BattleManager['_subject']['friendsUnit']()['gainCurrentActionsETB'](_0x49d565);else{if(!this[_0x2ed625(0x586)]()&&this!==_0x3de0c3[_0x2ed625(0x64d)]){if(this[_0x2ed625(0xd08)]())this['battler']()['refreshMotion']();}this[_0x2ed625(0x519)]();return;}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_FtbAction',_0x300e17=>{const _0x2671a6=_0x208a24;if(!SceneManager[_0x2671a6(0x8c3)]())return;if(!Imported[_0x2671a6(0x707)])return;if(!BattleManager['isFTB']())return;VisuMZ[_0x2671a6(0x4f4)](_0x300e17,_0x300e17);const _0x66a933=_0x300e17['ActionCount'];BattleManager[_0x2671a6(0x64d)]&&BattleManager[_0x2671a6(0x64d)][_0x2671a6(0x281)]()[_0x2671a6(0x38c)](_0x66a933);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x31b),_0x29f65e=>{const _0x380ab1=_0x208a24;if(!SceneManager[_0x380ab1(0x8c3)]())return;VisuMZ['ConvertParams'](_0x29f65e,_0x29f65e);const _0x515674=VisuMZ[_0x380ab1(0x5bd)](_0x29f65e['Targets']),_0x7071b2=_0x29f65e[_0x380ab1(0x8ae)],_0x5ad7d3=_0x29f65e['HP_Flat'],_0x525089=_0x29f65e[_0x380ab1(0x1ed)],_0x30298a=_0x29f65e[_0x380ab1(0x619)],_0x92c49=_0x29f65e['TP_Rate'],_0x3b035d=_0x29f65e['TP_Flat'],_0x4dbfb7=_0x29f65e[_0x380ab1(0x9a9)];for(const _0x50b22f of _0x515674){if(!_0x50b22f)continue;const _0x23bf13=_0x50b22f[_0x380ab1(0x97c)](),_0x130173=Math[_0x380ab1(0xd50)](_0x7071b2*_0x50b22f[_0x380ab1(0x94f)]+_0x5ad7d3),_0x40f80a=Math[_0x380ab1(0xd50)](_0x525089*_0x50b22f['mmp']+_0x30298a),_0x18ecb3=Math[_0x380ab1(0xd50)](_0x92c49*_0x50b22f['maxTp']()+_0x3b035d);if(_0x130173!==0x0)_0x50b22f['gainHp'](_0x130173);if(_0x40f80a!==0x0)_0x50b22f[_0x380ab1(0x753)](_0x40f80a);if(_0x18ecb3!==0x0)_0x50b22f[_0x380ab1(0x2ca)](_0x18ecb3);if(_0x4dbfb7)_0x50b22f['startDamagePopup']();_0x23bf13&&_0x50b22f['isDead']()&&_0x50b22f[_0x380ab1(0x352)]();}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Mechanics_Immortal',_0x2543ca=>{const _0x5f21d4=_0x208a24;if(!SceneManager[_0x5f21d4(0x8c3)]())return;VisuMZ[_0x5f21d4(0x4f4)](_0x2543ca,_0x2543ca);const _0x5a5661=VisuMZ[_0x5f21d4(0x5bd)](_0x2543ca[_0x5f21d4(0x83d)]);for(const _0x2672de of _0x5a5661){if(_0x5f21d4(0x5f8)===_0x5f21d4(0x10f))this[_0x5f21d4(0x11b)]=0x8;else{if(!_0x2672de)continue;_0x2672de['setImmortal'](_0x2543ca[_0x5f21d4(0x721)]);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x5ea),_0x59a3da=>{const _0x4eac3e=_0x208a24;if(!SceneManager[_0x4eac3e(0x8c3)]())return;VisuMZ[_0x4eac3e(0x4f4)](_0x59a3da,_0x59a3da);const _0x425713=BattleManager['_action'],_0x721fd4={'criticalHitRate':_0x59a3da[_0x4eac3e(0x7c4)],'criticalHitFlat':_0x59a3da['CriticalHitFlat'],'criticalDmgRate':_0x59a3da[_0x4eac3e(0xa77)],'criticalDmgFlat':_0x59a3da[_0x4eac3e(0x23c)],'damageRate':_0x59a3da[_0x4eac3e(0x9b6)],'damageFlat':_0x59a3da['DamageFlat'],'hitRate':_0x59a3da['HitRate'],'hitFlat':_0x59a3da[_0x4eac3e(0x9e7)]};_0x425713[_0x4eac3e(0x27b)]=_0x721fd4;}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_OnceParallel',_0x2df28b=>{const _0x133144=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x133144(0x4f4)](_0x2df28b,_0x2df28b);const _0x507118=_0x2df28b[_0x133144(0xce3)];SceneManager[_0x133144(0xc1b)][_0x133144(0x547)](_0x507118);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x4b1),_0x241d3a=>{const _0x1ad5bd=_0x208a24;if(!SceneManager[_0x1ad5bd(0x8c3)]())return;if(!Imported[_0x1ad5bd(0x607)])return;if(!BattleManager[_0x1ad5bd(0x716)]())return;VisuMZ[_0x1ad5bd(0x4f4)](_0x241d3a,_0x241d3a);const _0x3f0c75=VisuMZ[_0x1ad5bd(0x5bd)](_0x241d3a[_0x1ad5bd(0x83d)]);for(const _0x12f902 of _0x3f0c75){if(_0x1ad5bd(0x37d)===_0x1ad5bd(0x37d)){if(!_0x12f902)continue;let _0x48e838=_0x241d3a['CurrentTurn'],_0x42f0f3=_0x241d3a[_0x1ad5bd(0x6f7)],_0xf84d95=_0x241d3a[_0x1ad5bd(0xb1a)];BattleManager[_0x1ad5bd(0x8ab)]['includes'](_0x12f902)?_0x48e838+=_0xf84d95:_0x42f0f3+=_0xf84d95,BattleManager[_0x1ad5bd(0x683)](_0x12f902,-_0x48e838,![]),BattleManager[_0x1ad5bd(0x683)](_0x12f902,-_0x42f0f3,!![]);}else this['removeBuffsAuto']();}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_PtbAlterCost',_0x5bdada=>{const _0x1724bf=_0x208a24;if(!SceneManager[_0x1724bf(0x8c3)]())return;if(!Imported[_0x1724bf(0xbc9)])return;if(!BattleManager[_0x1724bf(0xa49)]())return;VisuMZ['ConvertParams'](_0x5bdada,_0x5bdada);const _0x1ad872=BattleManager['_subject']['friendsUnit'](),_0x56c33d=_0x5bdada[_0x1724bf(0xbd9)],_0x4fd71c=_0x5bdada[_0x1724bf(0xce0)]||_0x1724bf(0xa58),_0x9be92f=_0x5bdada[_0x1724bf(0x61f)]||_0x1724bf(0xa58),_0x51d37c=_0x5bdada[_0x1724bf(0x1f7)]||0x0,_0xb00610=_0x5bdada[_0x1724bf(0x29d)]||0x0;(_0x1ad872[_0x1724bf(0x442)]()||_0x56c33d)&&(_0x1724bf(0xa2b)!==_0x1724bf(0xccd)?(_0x56c33d&&(_0x1ad872[_0x1724bf(0xb19)]=_0x1ad872[_0x1724bf(0xb19)]||{},_0x1ad872[_0x1724bf(0xb19)][_0x1724bf(0xad9)]=0x0),_0x1ad872[_0x1724bf(0xb06)](_0x4fd71c,_0x9be92f,_0x51d37c,_0xb00610)):this[_0x1724bf(0x6a9)]()['canGuard']()&&_0x132b7f['BattleCore'][_0x1724bf(0x7d5)][_0x1724bf(0x783)](this));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x596),_0x2e2964=>{const _0x3f91c6=_0x208a24;if(!SceneManager[_0x3f91c6(0x8c3)]())return;if(!Imported[_0x3f91c6(0xbc9)])return;if(!BattleManager[_0x3f91c6(0xa49)]())return;VisuMZ['ConvertParams'](_0x2e2964,_0x2e2964);const _0x12902c=BattleManager[_0x3f91c6(0x64d)][_0x3f91c6(0x281)]();let _0x1f770b=Math[_0x3f91c6(0x6db)](_0x2e2964[_0x3f91c6(0x5ec)],0x0),_0x2faeb2=_0x12902c[_0x3f91c6(0xb26)](),_0x270a81=_0x12902c[_0x3f91c6(0x7da)]();while(_0x1f770b--){if(_0x2faeb2<=0x0&&_0x270a81<=0x0){if(_0x3f91c6(0x98e)==='fjZHI')_0x35f24e[_0x3f91c6(0xbd8)][_0x3f91c6(0x3c1)][_0x3f91c6(0x783)](this),this[_0x3f91c6(0x449)]()&&this['enemy']()[_0x3f91c6(0x278)]()!==this['_text']&&(this[_0x3f91c6(0xb11)]=this['enemy']()[_0x3f91c6(0x278)](),this[_0x3f91c6(0xa22)]()),this[_0x3f91c6(0x90b)](),this[_0x3f91c6(0x295)]();else break;}else _0x2faeb2>0x0?(_0x2faeb2--,_0x270a81++):_0x270a81--;}_0x12902c[_0x3f91c6(0x3f8)](_0x2faeb2),_0x12902c[_0x3f91c6(0x84a)](_0x270a81);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0xa2c),_0x185038=>{const _0x4d736f=_0x208a24;if(!SceneManager[_0x4d736f(0x8c3)]())return;if(!Imported[_0x4d736f(0xbc9)])return;if(!BattleManager[_0x4d736f(0xa49)]())return;VisuMZ['ConvertParams'](_0x185038,_0x185038);const _0x428c34=BattleManager[_0x4d736f(0x64d)][_0x4d736f(0x281)]();let _0x27e953=_0x185038[_0x4d736f(0xa09)],_0x276c41=_0x185038[_0x4d736f(0x788)];_0x428c34[_0x4d736f(0xd10)](_0x27e953),_0x428c34[_0x4d736f(0x4df)](_0x276c41);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xe9),_0x94991f=>{const _0x367449=_0x208a24;if(!SceneManager[_0x367449(0x8c3)]())return;VisuMZ['ConvertParams'](_0x94991f,_0x94991f);const _0x5cfe9b=[_0x367449(0xbef),_0x367449(0xbf5),'ATK','DEF',_0x367449(0xd1c),_0x367449(0x1a0),'AGI','LUK'],_0x4f62a5=_0x94991f[_0x367449(0x919)],_0x3061fd=_0x94991f['Debuffs'],_0x31e67c=VisuMZ[_0x367449(0x5bd)](_0x94991f[_0x367449(0x83d)]);for(const _0x280ad1 of _0x31e67c){if(!_0x280ad1)continue;for(const _0x4e0a69 of _0x4f62a5){const _0x421300=_0x5cfe9b['indexOf'](_0x4e0a69[_0x367449(0x4d6)]()[_0x367449(0x446)]());_0x421300>=0x0&&_0x421300<=0x7&&_0x280ad1['isBuffAffected'](_0x421300)&&_0x280ad1[_0x367449(0x6b9)](_0x421300);}for(const _0x3b8322 of _0x3061fd){const _0x54179f=_0x5cfe9b[_0x367449(0x6d1)](_0x3b8322[_0x367449(0x4d6)]()[_0x367449(0x446)]());_0x54179f>=0x0&&_0x54179f<=0x7&&_0x280ad1[_0x367449(0x822)](_0x54179f)&&(_0x367449(0x89b)===_0x367449(0x37c)?(this['_damageContainer']=new _0x59c04a(),this[_0x367449(0x2e1)]['x']=this['_battleField']['x'],this[_0x367449(0x2e1)]['y']=this['_battleField']['y'],this[_0x367449(0x739)](this[_0x367449(0x2e1)])):_0x280ad1['removeBuff'](_0x54179f));}}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Mechanics_RemoveState',_0x3528ae=>{const _0x4f9b04=_0x208a24;if(!SceneManager[_0x4f9b04(0x8c3)]())return;VisuMZ[_0x4f9b04(0x4f4)](_0x3528ae,_0x3528ae);const _0x38c9f1=_0x3528ae[_0x4f9b04(0xcf7)],_0x868100=VisuMZ[_0x4f9b04(0x5bd)](_0x3528ae[_0x4f9b04(0x83d)]);for(const _0x4beac3 of _0x868100){if(!_0x4beac3)continue;for(const _0x5e9cf7 of _0x38c9f1){_0x4beac3[_0x4f9b04(0x6ed)](_0x5e9cf7);}}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x456),_0x1e9bbb=>{const _0x4b85e=_0x208a24;if(!SceneManager[_0x4b85e(0x8c3)]())return;if(!Imported[_0x4b85e(0x813)])return;VisuMZ[_0x4b85e(0x4f4)](_0x1e9bbb,_0x1e9bbb);const _0xba6b12=VisuMZ[_0x4b85e(0x5bd)](_0x1e9bbb[_0x4b85e(0x83d)]),_0x2eaaa6=Number(_0x1e9bbb[_0x4b85e(0x401)]),_0x518258=Number(_0x1e9bbb[_0x4b85e(0xcc5)]),_0xb03e50=_0x1e9bbb[_0x4b85e(0x5a3)];for(const _0x201d0c of _0xba6b12){if(!_0x201d0c)continue;if(_0xb03e50&&!_0x201d0c['isStateAffected'](_0x2eaaa6))_0x201d0c[_0x4b85e(0x3e9)](_0x2eaaa6),_0x201d0c[_0x4b85e(0x2f8)](_0x2eaaa6,_0x518258);else{if(_0x4b85e(0xaa3)!=='pqmLI')_0x201d0c[_0x4b85e(0x525)](_0x2eaaa6,_0x518258);else{if(_0x119bb0>_0x3bbf04[_0x4b85e(0x169)])_0x40cd39=![];if(_0x56aa57<_0x50b75f[_0x4b85e(0x169)])_0x14d367=!![];}}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_StateTurnsChangeTo',_0x21928e=>{const _0x5bfe14=_0x208a24;if(!SceneManager[_0x5bfe14(0x8c3)]())return;if(!Imported[_0x5bfe14(0x813)])return;VisuMZ['ConvertParams'](_0x21928e,_0x21928e);const _0x5a5587=VisuMZ[_0x5bfe14(0x5bd)](_0x21928e['Targets']),_0x4ae3a9=Number(_0x21928e[_0x5bfe14(0x401)]),_0xb31a1e=Math[_0x5bfe14(0x6db)](Number(_0x21928e[_0x5bfe14(0xcc5)]),0x0),_0x2226e7=_0x21928e[_0x5bfe14(0x5a3)];for(const _0x54c0d2 of _0x5a5587){if('UZtas'===_0x5bfe14(0x712)){if(!_0x54c0d2)continue;_0x2226e7&&!_0x54c0d2[_0x5bfe14(0x7b3)](_0x4ae3a9)&&('hBjDl'===_0x5bfe14(0x4f3)?this['push']('clearActiveWeaponSet',_0x3a8516):_0x54c0d2[_0x5bfe14(0x3e9)](_0x4ae3a9)),_0x54c0d2[_0x5bfe14(0x2f8)](_0x4ae3a9,_0xb31a1e);}else{if(!this[_0x5bfe14(0x8bb)]())return![];if(this[_0x5bfe14(0xa42)]())return![];return(this[_0x5bfe14(0x8bb)]()['note']||'')[_0x5bfe14(0x7fc)](/<SINGLE OR MULTIPLE SELECT>/i);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x25e),_0x1f99d7=>{const _0x13f152=_0x208a24;if(!SceneManager[_0x13f152(0x8c3)]())return;if(!Imported[_0x13f152(0xb6a)])return;if(!BattleManager[_0x13f152(0x3bc)]())return;VisuMZ[_0x13f152(0x4f4)](_0x1f99d7,_0x1f99d7);const _0x39f7db=_0x1f99d7[_0x13f152(0x63b)],_0x560157=VisuMZ['CreateActionSequenceTargets'](_0x1f99d7[_0x13f152(0x83d)]),_0x380887=_0x1f99d7[_0x13f152(0x144)],_0xbb0e9d=_0x1f99d7['Exploiter'],_0x1fd3c1=_0x1f99d7[_0x13f152(0x490)],_0x1fcc01=BattleManager['_action'];if(_0x39f7db)for(const _0x164089 of _0x560157){if('Dpkjb'===_0x13f152(0x782)){if(!_0x164089)continue;if(_0x164089===user)continue;if(_0x380887)_0x164089[_0x13f152(0x77a)](![]);_0x164089['becomeSTBExploited'](BattleManager[_0x13f152(0x64d)],_0x1fcc01);}else{if(!_0x2e6119[_0x13f152(0x620)]())return;const _0x286895=this[_0x13f152(0xd08)](),_0x122657=_0x11f450[_0x13f152(0xd08)]();if(!_0x286895||!_0x122657)return;const _0x425f75=_0x122657[_0x13f152(0x169)],_0x22fe4a=_0x122657['_baseY'];this['moveBattlerToPoint'](_0x425f75,_0x22fe4a,0x0,![],_0x13f152(0xc0e),-0x1),_0x286895['updatePosition']();const _0x90a1f6=_0x4982f8[_0x13f152(0x759)][_0x13f152(0xc39)][_0x13f152(0x9b7)];let _0x3464ee=(_0x122657[_0x13f152(0x4fe)]+_0x286895[_0x13f152(0x4fe)])/0x2;_0x3464ee*=this['isActor']()?0x1:-0x1;let _0x20753d=_0x90a1f6['StepDistanceY']*(this['isActor']()?0x1:-0x1);_0x499b33[_0x13f152(0xb88)](_0x3464ee,_0x20753d,0x0,![],_0x13f152(0xc0e)),_0x122657[_0x13f152(0x295)]();}}if(_0xbb0e9d&&BattleManager[_0x13f152(0x64d)]){if(_0x1fd3c1)BattleManager[_0x13f152(0x64d)][_0x13f152(0x77a)](![]);const _0x1c9859=_0x560157[0x0];BattleManager[_0x13f152(0xb04)](_0x1c9859,_0x1fcc01);}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Mechanics_StbExtraAction',_0x2c028e=>{const _0x268700=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x268700(0xb6a)])return;if(!BattleManager[_0x268700(0x3bc)]())return;VisuMZ['ConvertParams'](_0x2c028e,_0x2c028e);const _0x4f30aa=_0x2c028e[_0x268700(0x45c)];BattleManager['_subject']&&BattleManager[_0x268700(0x64d)][_0x268700(0xbd3)](_0x4f30aa);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_StbRemoveExcessActions',_0x1bb060=>{const _0xde5685=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0xde5685(0xb6a)])return;if(!BattleManager[_0xde5685(0x3bc)]())return;VisuMZ[_0xde5685(0x4f4)](_0x1bb060,_0x1bb060);let _0x46e437=_0x1bb060[_0xde5685(0x45c)];if(BattleManager[_0xde5685(0x64d)]){BattleManager[_0xde5685(0x64d)]['_actions']=BattleManager[_0xde5685(0x64d)][_0xde5685(0x569)]||[];while(_0x46e437--){if('hZcMT'===_0xde5685(0x1b6))_0x185911[_0xde5685(0x759)][_0xde5685(0x555)][_0xde5685(0x783)](this,_0xbd270c),this[_0xde5685(0x1f0)](_0x5e64b4);else{if(BattleManager['_subject'][_0xde5685(0x569)][_0xde5685(0x1ba)]<=0x0)break;BattleManager[_0xde5685(0x64d)][_0xde5685(0x569)]['shift']();}}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Mechanics_SwapWeapon',_0x5c4e85=>{const _0x1ebafa=_0x208a24;if(!SceneManager[_0x1ebafa(0x8c3)]())return;if(!Imported['VisuMZ_2_WeaponSwapSystem'])return;VisuMZ[_0x1ebafa(0x4f4)](_0x5c4e85,_0x5c4e85);const _0x3f7306=VisuMZ[_0x1ebafa(0x5bd)](_0x5c4e85['Targets']),_0x22e554=_0x5c4e85[_0x1ebafa(0xdc)];for(const _0x2aef74 of _0x3f7306){if(!_0x2aef74)continue;if(!_0x2aef74[_0x1ebafa(0x9bf)]())continue;_0x2aef74[_0x1ebafa(0x72d)](_0x22e554);}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0xc8e),_0x4ec3d2=>{const _0x2c054e=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x2c054e(0x4f4)](_0x4ec3d2,_0x4ec3d2);const _0xe6fd3c=VisuMZ[_0x2c054e(0x5bd)](_0x4ec3d2['Targets']),_0x2dbec7=_0x4ec3d2[_0x2c054e(0x2bd)],_0x43287b={'textColor':ColorManager[_0x2c054e(0x33d)](_0x4ec3d2[_0x2c054e(0x57f)]),'flashColor':_0x4ec3d2[_0x2c054e(0x306)],'flashDuration':_0x4ec3d2[_0x2c054e(0xc07)]};for(const _0x4e255e of _0xe6fd3c){if(_0x2c054e(0x4bc)!==_0x2c054e(0x4bc)){const _0x3cec04=_0x2e93b0['isActor']()?_0x371b15[_0x2c054e(0x9e5)]:_0x3b2cf7['message2'];_0x3cec04&&_0x58692c[_0x2c054e(0x759)][_0x2c054e(0xc39)][_0x2c054e(0x98d)]['ShowAddedState']&&(this[_0x2c054e(0x7c3)](_0x2c054e(0xcf5)),this[_0x2c054e(0x7c3)](_0x2c054e(0x7c9)),this[_0x2c054e(0x7c3)]('pushBaseLine'),this['push']('addText',_0x3cec04[_0x2c054e(0x75a)](_0xd007b0['name']())),this[_0x2c054e(0x7c3)](_0x2c054e(0xac0))),_0xe39d3f['id']===_0xb85c42['deathStateId']()&&this['push'](_0x2c054e(0x352),_0x228295);}else{if(!_0x4e255e)continue;_0x4e255e[_0x2c054e(0x98c)](_0x2dbec7,_0x43287b);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x183),_0x2646b9=>{const _0x356833=_0x208a24;if(!SceneManager[_0x356833(0x8c3)]())return;VisuMZ['ConvertParams'](_0x2646b9,_0x2646b9);const _0xba5f98=VisuMZ['CreateActionSequenceTargets'](_0x2646b9[_0x356833(0x83d)]);let _0x8e82ec=$gameVariables[_0x356833(0x905)](_0x2646b9[_0x356833(0x13b)]);Imported[_0x356833(0x496)]&&_0x2646b9[_0x356833(0x834)]&&(_0x8e82ec=VisuMZ['GroupDigits'](_0x8e82ec));const _0x5c0bf6=String(_0x8e82ec),_0x595fc7={'textColor':ColorManager[_0x356833(0x33d)](_0x2646b9[_0x356833(0x57f)]),'flashColor':_0x2646b9[_0x356833(0x306)],'flashDuration':_0x2646b9[_0x356833(0xc07)]};for(const _0x83e925 of _0xba5f98){if(!_0x83e925)continue;_0x83e925[_0x356833(0x98c)](_0x5c0bf6,_0x595fc7);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x6cc),_0x5aab16=>{const _0x3b4dad=_0x208a24;if(!SceneManager['isSceneBattle']())return;const _0x1ec7b5=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x1ec7b5)return;_0x1ec7b5[_0x3b4dad(0x3dc)](_0x3b4dad(0x5cf));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xc2a),_0x164b18=>{const _0x55bfda=_0x208a24;if(!SceneManager[_0x55bfda(0x8c3)]())return;VisuMZ[_0x55bfda(0x4f4)](_0x164b18,_0x164b18);const _0x331861=VisuMZ['CreateActionSequenceTargets'](_0x164b18[_0x55bfda(0x83d)]);for(const _0x4f19c1 of _0x331861){if(_0x55bfda(0x454)===_0x55bfda(0xc6e)){if(_0x4abc7c['BTestBypass']&&_0x12d712[_0x55bfda(0x902)]())return!![];if(this[_0x55bfda(0xa4c)][_0x55bfda(0x2ce)])return![];return this[_0x55bfda(0xa4c)][_0x55bfda(0xae1)]();}else{if(!_0x4f19c1)continue;_0x4f19c1[_0x55bfda(0x519)]();}}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x149),_0x637d1=>{const _0x2df0a6=_0x208a24;if(!SceneManager[_0x2df0a6(0x8c3)]())return;VisuMZ[_0x2df0a6(0x4f4)](_0x637d1,_0x637d1);const _0x3ba87d=VisuMZ[_0x2df0a6(0x5bd)](_0x637d1[_0x2df0a6(0x83d)]),_0x6c60ce=_0x637d1['MotionType'][_0x2df0a6(0x717)]()['trim']();let _0x37467b=_0x637d1[_0x2df0a6(0x3ae)];const _0x65bf04=_0x637d1[_0x2df0a6(0xc45)];![_0x2df0a6(0x2b9),'thrust',_0x2df0a6(0xb89),_0x2df0a6(0xb67)][_0x2df0a6(0xcaf)](_0x6c60ce)&&(_0x37467b=![]);for(const _0x31b029 of _0x3ba87d){if(_0x2df0a6(0xb4a)!==_0x2df0a6(0xc12)){if(!_0x31b029)continue;_0x31b029[_0x2df0a6(0x7a2)](_0x6c60ce,_0x37467b,_0x65bf04);}else{if(!this[_0x2df0a6(0x7d2)]())return;if(this[_0x2df0a6(0xd00)]===_0x50b1e4)return;this['_targetFloatHeight']=_0x3ff5a8,this[_0x2df0a6(0x831)]=_0x236322,this[_0x2df0a6(0x1ac)]=_0xa7db3c,this[_0x2df0a6(0xa15)]=_0x4bef5a||_0x2df0a6(0xc0e);if(_0x4ab642<=0x0)this[_0x2df0a6(0x1e0)]=_0x2b8a1d;}}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Motion_MotionType',_0x64295=>{const _0x4ab08d=_0x208a24;if(!SceneManager[_0x4ab08d(0x8c3)]())return;VisuMZ[_0x4ab08d(0x4f4)](_0x64295,_0x64295);const _0x5f3cdf=VisuMZ[_0x4ab08d(0x5bd)](_0x64295['Targets']),_0x5c3829=_0x64295['MotionType'][_0x4ab08d(0x717)]()[_0x4ab08d(0x446)](),_0x15d0d0=_0x64295[_0x4ab08d(0x3ae)];for(const _0x389606 of _0x5f3cdf){if(_0x4ab08d(0xd0b)==='OGKEu'){const _0xe26e66=_0x158866[_0x4ab08d(0xab3)](_0x14f580['x'],_0x43a4fe['y']);if(this[_0x4ab08d(0x9fb)]&&this['_regionBattleback2'][_0xe26e66])return this[_0x4ab08d(0xb7d)][_0xe26e66];}else{if(!_0x389606)continue;_0x389606['_showWeapon']=_0x15d0d0;if(_0x5c3829[_0x4ab08d(0x7fc)](/ATTACK[ ](\d+)/i))_0x389606['performAttackSlot'](Number(RegExp['$1']));else _0x5c3829===_0x4ab08d(0x2b9)?_0x4ab08d(0xb6c)==='SJNAp'?_0x4b98eb+=_0xbe1764:_0x389606[_0x4ab08d(0x5e0)]():'lDjES'!==_0x4ab08d(0x7d0)?_0x389606[_0x4ab08d(0x90c)](_0x5c3829):this[_0x4ab08d(0x7c3)](_0x4ab08d(0xc8c),_0x2228c9);if(!_0x15d0d0)_0x389606['startWeaponAnimation'](0x0);else{if(_0x15d0d0&&[_0x4ab08d(0xd3e),_0x4ab08d(0xb89),_0x4ab08d(0x545)][_0x4ab08d(0xcaf)](_0x5c3829)){}}_0x389606[_0x4ab08d(0x510)]=undefined;}}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Motion_PerformAction',_0x6b3222=>{const _0x454937=_0x208a24;if(!SceneManager[_0x454937(0x8c3)]())return;VisuMZ[_0x454937(0x4f4)](_0x6b3222,_0x6b3222);const _0x2de304=BattleManager['_action'];if(!_0x2de304)return;if(!_0x2de304[_0x454937(0x8bb)]())return;const _0x563b8a=VisuMZ[_0x454937(0x5bd)](_0x6b3222[_0x454937(0x83d)]);for(const _0x260d47 of _0x563b8a){if(_0x454937(0x3ab)!==_0x454937(0x3ab)){if(_0x2e64e9>_0x4ab7f8['_baseX'])_0x33d0b7=!![];if(_0x1902e2<_0x2bdaab[_0x454937(0x169)])_0x2d5ced=![];}else{if(!_0x260d47)continue;_0x260d47[_0x454937(0x3f6)](_0x2de304);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x322),_0x4c0761=>{const _0x4074b7=_0x208a24;if(!SceneManager[_0x4074b7(0x8c3)]())return;VisuMZ[_0x4074b7(0x4f4)](_0x4c0761,_0x4c0761);const _0x203ab4=VisuMZ['CreateActionSequenceTargets'](_0x4c0761[_0x4074b7(0x83d)]);for(const _0x32b487 of _0x203ab4){if(_0x4074b7(0x9ad)===_0x4074b7(0xa41)){const _0x19f8be=_0x98437b[_0x4074b7(0x759)][_0x4074b7(0xc39)][_0x4074b7(0x148)],_0x30cebf=_0x19f8be['CommandWidth']||0xc0,_0x5f4a26=this[_0x4074b7(0x74f)](),_0x390f1b=this[_0x4074b7(0x171)]()?_0x1fc238[_0x4074b7(0xa53)]-_0x30cebf:0x0,_0x42e13b=_0x51afcc[_0x4074b7(0x833)]-_0x5f4a26;return new _0x5ddb07(_0x390f1b,_0x42e13b,_0x30cebf,_0x5f4a26);}else{if(!_0x32b487)continue;if(!_0x32b487[_0x4074b7(0xd08)]())continue;_0x32b487[_0x4074b7(0xd08)]()['refreshMotion']();}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Motion_WaitMotionFrame',_0x41ab6a=>{const _0x34ef9f=_0x208a24;if(!SceneManager[_0x34ef9f(0x8c3)]())return;VisuMZ['ConvertParams'](_0x41ab6a,_0x41ab6a);const _0x7cadd=$gameTemp['getLastPluginCommandInterpreter'](),_0x3651df=_0x41ab6a['MotionFrameWait']*Sprite_Battler[_0x34ef9f(0xa73)];_0x7cadd[_0x34ef9f(0xac0)](_0x3651df);}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x944),_0x30b631=>{const _0x213e36=_0x208a24;if(!SceneManager[_0x213e36(0x8c3)]())return;VisuMZ[_0x213e36(0x4f4)](_0x30b631,_0x30b631);const _0x5923a2=$gameTemp[_0x213e36(0xcc)](),_0xf1e928=BattleManager['_action'];if(!_0x5923a2||!_0xf1e928)return;if(!_0xf1e928['item']())return;const _0x2d347c=VisuMZ['CreateActionSequenceTargets'](_0x30b631[_0x213e36(0x83d)]);for(const _0x1f8567 of _0x2d347c){if(_0x213e36(0xfc)!==_0x213e36(0xfc)){const _0x1428a2=this[_0x213e36(0x9bf)]()?this[_0x213e36(0x178)]():this[_0x213e36(0x449)]();if(_0x1428a2){const _0x12a678=_0x1428a2[_0x213e36(0x6c4)];if(_0x12a678[_0x213e36(0x7fc)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](\d+)([%％])>/i))return _0xa5dd30(_0x4b6b7d['$1'])*0.01;else{if(_0x12a678[_0x213e36(0x7fc)](/<SIDEVIEW SHADOW (?:SCALE|SCALE X):[ ](.*)>/i))return _0x18e101(_0x36dad5['$1'])||0x0;}}return 0x1;}else{if(!_0x1f8567)continue;_0x1f8567[_0x213e36(0x997)](_0xf1e928);}}if(_0x30b631[_0x213e36(0x2ba)])_0x5923a2['setWaitMode'](_0x213e36(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x936),_0x29dba5=>{const _0x20d34e=_0x208a24;if(!SceneManager[_0x20d34e(0x8c3)]())return;if(!$gameSystem[_0x20d34e(0x620)]())return;VisuMZ[_0x20d34e(0x4f4)](_0x29dba5,_0x29dba5);const _0x56023f=$gameTemp['getLastPluginCommandInterpreter'](),_0x24bb7a=VisuMZ['CreateActionSequenceTargets'](_0x29dba5[_0x20d34e(0x83d)]),_0x1d8f59=_0x29dba5['DistanceAdjust'],_0x2f6cff=_0x29dba5['DistanceX'],_0x4de542=_0x29dba5[_0x20d34e(0x7db)],_0x1a509f=_0x29dba5['Duration'],_0x2c4f5d=_0x29dba5['FaceDirection'],_0x1d902e=_0x29dba5[_0x20d34e(0x99b)],_0x403ccd=_0x29dba5[_0x20d34e(0xc9e)],_0x788aad=_0x29dba5[_0x20d34e(0x2ba)];if(!_0x56023f)return;for(const _0x5eb006 of _0x24bb7a){if(_0x20d34e(0x4d2)===_0x20d34e(0x4d2)){if(!_0x5eb006)continue;let _0xc39ca1=_0x2f6cff,_0x3c04dd=_0x4de542;if(_0x1d8f59[_0x20d34e(0x7fc)](/horz/i))_0xc39ca1*=_0x5eb006[_0x20d34e(0x9bf)]()?-0x1:0x1;if(_0x1d8f59['match'](/vert/i))_0x3c04dd*=_0x5eb006[_0x20d34e(0x9bf)]()?-0x1:0x1;_0x5eb006[_0x20d34e(0xa0a)](_0xc39ca1,_0x3c04dd,_0x1a509f,_0x2c4f5d,_0x1d902e),_0x5eb006['requestMotion'](_0x403ccd);}else _0x1bfca6['addState'](_0x90ed4);}if(_0x788aad)_0x56023f[_0x20d34e(0x3dc)](_0x20d34e(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x92e),_0x127924=>{const _0x436f59=_0x208a24;if(!SceneManager[_0x436f59(0x8c3)]())return;if(!$gameSystem[_0x436f59(0x620)]())return;VisuMZ[_0x436f59(0x4f4)](_0x127924,_0x127924);const _0x2b9e32=$gameTemp[_0x436f59(0xcc)](),_0x1a80a5=VisuMZ['CreateActionSequenceTargets'](_0x127924[_0x436f59(0x83d)]),_0x5e8a39=_0x127924[_0x436f59(0x1da)],_0x5a3f83=_0x127924[_0x436f59(0x7ae)],_0x35c7f6=_0x127924['OffsetY'],_0x11e307=_0x127924[_0x436f59(0x2c6)],_0x64f51d=_0x127924['FaceDirection'],_0x160163=_0x127924[_0x436f59(0x99b)],_0x113d9d=_0x127924[_0x436f59(0xc9e)],_0x42598d=_0x127924[_0x436f59(0x2ba)];if(!_0x2b9e32)return;for(const _0x58ba12 of _0x1a80a5){if(_0x436f59(0xce6)===_0x436f59(0x9cb))this[_0x436f59(0x778)](_0x436f59(0x1b2));else{if(!_0x58ba12)continue;const _0x1ec358=_0x127924[_0x436f59(0x219)](_0x58ba12)||{'x':0x0,'y':0x0};let _0x5fa36e=_0x1ec358['x'],_0x5264b1=_0x1ec358['y'];if(_0x5e8a39[_0x436f59(0x7fc)](/none/i))_0x5fa36e+=_0x5a3f83,_0x5264b1+=_0x35c7f6;else{if(_0x5e8a39[_0x436f59(0x7fc)](/horz/i)&&_0x5e8a39[_0x436f59(0x7fc)](/vert/i)){if('YBDdx'===_0x436f59(0xb73))return _0xb24125[_0x436f59(0x759)][_0x436f59(0xc39)][_0x436f59(0x5a5)][_0x436f59(0x377)];else _0x5fa36e+=_0x58ba12['isActor']()?-_0x5a3f83:_0x5a3f83,_0x5264b1+=_0x58ba12[_0x436f59(0x9bf)]()?-_0x35c7f6:_0x35c7f6;}else{if(_0x5e8a39[_0x436f59(0x7fc)](/horz/i))_0x5fa36e+=_0x58ba12[_0x436f59(0x9bf)]()?-_0x5a3f83:_0x5a3f83,_0x5264b1+=_0x35c7f6;else _0x5e8a39['match'](/vert/i)&&(_0x5fa36e+=_0x5a3f83,_0x5264b1+=_0x58ba12[_0x436f59(0x9bf)]()?-_0x35c7f6:_0x35c7f6);}}_0x58ba12['moveBattlerHomeToPoint'](_0x5fa36e,_0x5264b1,_0x11e307,_0x64f51d,_0x160163,-0x1),_0x58ba12[_0x436f59(0x90c)](_0x113d9d);}}if(_0x42598d)_0x2b9e32[_0x436f59(0x3dc)](_0x436f59(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Movement_HomeMoveToPoint',_0x1c804e=>{const _0x537939=_0x208a24;if(!SceneManager[_0x537939(0x8c3)]())return;if(!$gameSystem[_0x537939(0x620)]())return;VisuMZ['ConvertParams'](_0x1c804e,_0x1c804e);const _0x40e906=$gameTemp[_0x537939(0xcc)](),_0x37f9f6=VisuMZ[_0x537939(0x5bd)](_0x1c804e['Targets']),_0x23fe9c=_0x1c804e[_0x537939(0x45f)],_0x4fdb71=_0x1c804e[_0x537939(0x1da)],_0x5aa672=_0x1c804e[_0x537939(0x7ae)],_0x2fbab2=_0x1c804e[_0x537939(0x153)],_0x15e113=_0x1c804e[_0x537939(0x2c6)],_0x2a44ca=_0x1c804e[_0x537939(0xbfa)],_0x27d7c8=_0x1c804e[_0x537939(0x99b)],_0x200054=_0x1c804e[_0x537939(0xc9e)],_0x3d408f=_0x1c804e[_0x537939(0x2ba)];if(!_0x40e906)return;for(const _0x2f84d1 of _0x37f9f6){if(_0x537939(0x2b6)===_0x537939(0x2b6)){if(!_0x2f84d1)continue;let _0x56b565=_0x2f84d1['battler']()['_baseX'],_0x2a1437=_0x2f84d1[_0x537939(0xd08)]()['_baseY'];if(_0x23fe9c[_0x537939(0x7fc)](/home/i)){if('WADaL'!==_0x537939(0x8bc))_0x56b565=_0x2f84d1[_0x537939(0xd08)]()['_homeX'],_0x2a1437=_0x2f84d1[_0x537939(0xd08)]()[_0x537939(0x66c)];else{const _0x222b70=_0x380ff5[_0x537939(0x759)][_0x537939(0xc39)];if(this[_0x537939(0x594)]===_0x751766)_0x4fb6ea+=_0x222b70['Actor']['OffsetX']||0x0,_0x39d12a+=_0x222b70[_0x537939(0x5a5)]['OffsetY']||0x0;else this[_0x537939(0x594)]===_0xdc6b94&&(_0x14dbce+=_0x222b70[_0x537939(0x6bd)]['OffsetX']||0x0,_0x56a90f+=_0x222b70[_0x537939(0x6bd)]['OffsetY']||0x0);const _0x1284e8=_0x4b0d09-this[_0x537939(0xd02)],_0x31365b=_0x3cfa9c-this[_0x537939(0x66c)];this[_0x537939(0xd02)]=_0x2e641a,this['_homeY']=_0xcf7650,this[_0x537939(0xb71)]-=_0x1284e8,this[_0x537939(0x3a2)]-=_0x31365b,this[_0x537939(0x6ee)]-=_0x1284e8,this[_0x537939(0x7f8)]-=_0x31365b,this[_0x537939(0x295)]();}}else{if(_0x23fe9c[_0x537939(0x7fc)](/center/i)){if(_0x537939(0xb6f)!==_0x537939(0x425))_0x56b565=Graphics[_0x537939(0xa53)]/0x2,_0x2a1437=Graphics[_0x537939(0x833)]/0x2;else{const _0xb7785c=_0x3a85ae[_0x537939(0xc1b)]['partyCommandWindowRectBorderStyle']();this[_0x537939(0x760)](_0xb7785c['x'],_0xb7785c['y'],_0xb7785c[_0x537939(0x4fe)],_0xb7785c[_0x537939(0x1fa)]),this[_0x537939(0x785)](),this[_0x537939(0xc79)](0x0);}}else{if(_0x23fe9c[_0x537939(0x7fc)](/point (\d+), (\d+)/i)){if('UZgOv'!=='UZgOv'){if(!_0x65bde3[_0x537939(0x759)][_0x537939(0xc39)]['Damage'][_0x537939(0xc44)])return _0x525cc7;const _0x3fcf7c=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x537939(0x8bb)]()['note'][_0x537939(0x7fc)](_0x3fcf7c))return _0x498528;if(this[_0x537939(0x6a9)]()['traitObjects']()['some'](_0x449281=>_0x449281&&_0x449281[_0x537939(0x6c4)][_0x537939(0x7fc)](_0x3fcf7c)))return _0x49948d;const _0x37d235=_0x23a6f9<0x0?-0x1:0x1;_0x446a5e=_0x531b56[_0x537939(0x7ac)](_0x5a6149);let _0x264cea=this[_0x537939(0x6a9)]()[_0x537939(0xc6d)]();this[_0x537939(0x8bb)]()[_0x537939(0x6c4)][_0x537939(0x7fc)](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0x264cea+=_0x117ebf(_0x25e7fd['$1'])/0x64);_0x264cea=_0x264cea[_0x537939(0x345)](0.01,0x1);const _0x3e5b06=this[_0x537939(0x495)](),_0x30295b=_0x264cea*_0x3e5b06;if(_0x478dd5>_0x30295b&&_0x3e5b06>_0x30295b){_0x34a5fa-=_0x30295b;const _0x5bcfee=_0x1e16d6[_0x537939(0x759)][_0x537939(0xc39)][_0x537939(0x7a9)]['DefaultSoftScaler'],_0x21c552=_0x251139[_0x537939(0x6db)](0x1-_0x137d69/((_0x3e5b06-_0x30295b)*_0x5bcfee+_0x41d287),0.01);_0x16af0c*=_0x21c552,_0x1c2097+=_0x30295b;}return _0x37d7d4*_0x37d235;}else _0x56b565=Number(RegExp['$1']),_0x2a1437=Number(RegExp['$2']);}}}if(_0x4fdb71[_0x537939(0x7fc)](/none/i))_0x56b565+=_0x5aa672,_0x2a1437+=_0x2fbab2;else{if(_0x4fdb71[_0x537939(0x7fc)](/horz/i)&&_0x4fdb71[_0x537939(0x7fc)](/vert/i))'TMSGH'!=='TMSGH'?(_0x2e0ee1[_0x537939(0xac0)](0x1),_0x4498f5[_0x537939(0x3dc)](_0x537939(0xa89))):(_0x56b565+=_0x2f84d1['isActor']()?-_0x5aa672:_0x5aa672,_0x2a1437+=_0x2f84d1[_0x537939(0x9bf)]()?-_0x2fbab2:_0x2fbab2);else{if(_0x4fdb71[_0x537939(0x7fc)](/horz/i)){if(_0x537939(0xaa9)===_0x537939(0xaa9))_0x56b565+=_0x2f84d1[_0x537939(0x9bf)]()?-_0x5aa672:_0x5aa672,_0x2a1437+=_0x2fbab2;else{if(!this[_0x537939(0xc3a)])return;this[_0x537939(0xa4c)]!==this[_0x537939(0xc3a)]['_battler']&&this[_0x537939(0x876)](this[_0x537939(0xc3a)][_0x537939(0xa4c)]);}}else{if(_0x4fdb71['match'](/vert/i)){if('FYQHQ'===_0x537939(0x8e6)){if(_0x4a0fbc[_0x537939(0x158)][_0x537939(0xd1a)]!==0x0)return![];}else _0x56b565+=_0x5aa672,_0x2a1437+=_0x2f84d1['isActor']()?-_0x2fbab2:_0x2fbab2;}}}}_0x2f84d1['moveBattlerHomeToPoint'](_0x56b565,_0x2a1437,_0x15e113,_0x2a44ca,_0x27d7c8,-0x1),_0x2f84d1['requestMotion'](_0x200054);}else this[_0x537939(0xaa0)]()?delete _0x36064f[_0x537939(0x527)]['cancel']:_0x58bd76[_0x537939(0x39c)](_0x537939(0x5c5),this[_0x537939(0x2fc)]['bind'](this));}if(_0x3d408f)_0x40e906[_0x537939(0x3dc)](_0x537939(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x891),_0x421adc=>{const _0x234239=_0x208a24;if(!SceneManager[_0x234239(0x8c3)]())return;if(!$gameSystem[_0x234239(0x620)]())return;VisuMZ[_0x234239(0x4f4)](_0x421adc,_0x421adc);const _0x22d7fe=$gameTemp[_0x234239(0xcc)](),_0x2f6288=VisuMZ[_0x234239(0x5bd)](_0x421adc[_0x234239(0x6ac)]),_0x5f317f=VisuMZ[_0x234239(0x5bd)](_0x421adc[_0x234239(0x8b2)]),_0x2c6f0b=_0x421adc['TargetLocation'];let _0x13c607=_0x421adc[_0x234239(0xa81)];const _0x3b44b0=_0x421adc['OffsetAdjust'],_0x162c7c=_0x421adc[_0x234239(0x7ae)],_0x1c062e=_0x421adc[_0x234239(0x153)],_0x57f8d9=_0x421adc[_0x234239(0x2c6)],_0x2cb78f=_0x421adc[_0x234239(0xbfa)],_0x362337=_0x421adc[_0x234239(0x99b)],_0x38332c=_0x421adc['MotionType'],_0x98fb8d=_0x421adc[_0x234239(0x2ba)],_0x4c50b1=Math['min'](..._0x5f317f[_0x234239(0x58e)](_0x3022a0=>_0x3022a0['battler']()[_0x234239(0x169)]-_0x3022a0['battler']()[_0x234239(0x68b)]()/0x2)),_0x1dceb7=Math['max'](..._0x5f317f[_0x234239(0x58e)](_0x4e0b1e=>_0x4e0b1e[_0x234239(0xd08)]()['_baseX']+_0x4e0b1e[_0x234239(0xd08)]()[_0x234239(0x68b)]()/0x2)),_0x53c21d=Math[_0x234239(0x618)](..._0x5f317f[_0x234239(0x58e)](_0x3a2a97=>_0x3a2a97[_0x234239(0xd08)]()[_0x234239(0x832)]-_0x3a2a97[_0x234239(0xd08)]()[_0x234239(0x536)]())),_0x2bfb78=Math['max'](..._0x5f317f[_0x234239(0x58e)](_0xbc0149=>_0xbc0149[_0x234239(0xd08)]()[_0x234239(0x832)])),_0x5b28af=_0x5f317f[_0x234239(0x5a8)](_0x2e5f32=>_0x2e5f32[_0x234239(0x9bf)]())[_0x234239(0x1ba)],_0x23bdb2=_0x5f317f[_0x234239(0x5a8)](_0x49ef1f=>_0x49ef1f[_0x234239(0x27a)]())[_0x234239(0x1ba)];let _0x49a16d=0x0,_0x308736=0x0;if(_0x2c6f0b[_0x234239(0x7fc)](/front/i))_0x49a16d=_0x5b28af>=_0x23bdb2?_0x4c50b1:_0x1dceb7;else{if(_0x2c6f0b[_0x234239(0x7fc)](/middle/i)){if(_0x234239(0x2a8)===_0x234239(0x2a8))_0x49a16d=(_0x4c50b1+_0x1dceb7)/0x2,_0x13c607=-0x1;else{if(!this['_mainSprite'])return;if(!this[_0x234239(0x1c2)])return;this[_0x234239(0x32b)](),this[_0x234239(0xa97)]();}}else _0x2c6f0b['match'](/back/i)&&(_0x234239(0xb2)!=='UDLqo'?this[_0x234239(0x7ff)]():_0x49a16d=_0x5b28af>=_0x23bdb2?_0x1dceb7:_0x4c50b1);}if(_0x2c6f0b[_0x234239(0x7fc)](/head/i))_0x308736=_0x53c21d;else{if(_0x2c6f0b[_0x234239(0x7fc)](/center/i))_0x234239(0x205)!=='bZVdS'?_0x308736=(_0x53c21d+_0x2bfb78)/0x2:_0x1716bd=_0x2d684d[_0x234239(0x655)](_0x19a0ea[_0x234239(0xe0)](_0x3b5f70));else _0x2c6f0b[_0x234239(0x7fc)](/base/i)&&(_0x308736=_0x2bfb78);}if(!_0x22d7fe)return;for(const _0x202617 of _0x2f6288){if(!_0x202617)continue;let _0x263015=_0x49a16d,_0x573cb3=_0x308736;if(_0x3b44b0[_0x234239(0x7fc)](/none/i))_0x263015+=_0x162c7c,_0x573cb3+=_0x1c062e;else{if(_0x3b44b0['match'](/horz/i)&&_0x3b44b0[_0x234239(0x7fc)](/vert/i))_0x263015+=_0x202617[_0x234239(0x9bf)]()?-_0x162c7c:_0x162c7c,_0x573cb3+=_0x202617[_0x234239(0x9bf)]()?-_0x1c062e:_0x1c062e;else{if(_0x3b44b0[_0x234239(0x7fc)](/horz/i))_0x263015+=_0x202617[_0x234239(0x9bf)]()?-_0x162c7c:_0x162c7c,_0x573cb3+=_0x1c062e;else _0x3b44b0[_0x234239(0x7fc)](/vert/i)&&(_0x263015+=_0x162c7c,_0x573cb3+=_0x202617[_0x234239(0x9bf)]()?-_0x1c062e:_0x1c062e);}}_0x202617[_0x234239(0xcc3)](_0x263015,_0x573cb3,_0x57f8d9,_0x2cb78f,_0x362337,_0x13c607),_0x202617[_0x234239(0x90c)](_0x38332c);}if(_0x98fb8d)_0x22d7fe[_0x234239(0x3dc)]('battleMove');}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Movement_FaceDirection',_0x299f53=>{const _0x36f6ea=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x36f6ea(0x620)]())return;VisuMZ[_0x36f6ea(0x4f4)](_0x299f53,_0x299f53);const _0x5691dc=VisuMZ[_0x36f6ea(0x5bd)](_0x299f53[_0x36f6ea(0x83d)]);let _0x1f945b=_0x299f53[_0x36f6ea(0x802)][_0x36f6ea(0x7fc)](/back/i);for(const _0x5cd362 of _0x5691dc){if(!_0x5cd362)continue;if(_0x299f53[_0x36f6ea(0x802)]['match'](/rand/i))_0x1f945b=Math[_0x36f6ea(0xd15)](0x2);_0x5cd362[_0x36f6ea(0xbde)](!!_0x1f945b);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],'ActSeq_Movement_FaceJsPoint',_0xeb2dde=>{const _0x4039c3=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem[_0x4039c3(0x620)]())return;VisuMZ[_0x4039c3(0x4f4)](_0xeb2dde,_0xeb2dde);const _0x4d9c25=VisuMZ[_0x4039c3(0x5bd)](_0xeb2dde['Targets']),_0x4587e5=_0xeb2dde[_0x4039c3(0xa1)];for(const _0x3b5c78 of _0x4d9c25){if(_0x4039c3(0x45a)===_0x4039c3(0x45a)){if(!_0x3b5c78)continue;const _0xc6bc89=_0xeb2dde[_0x4039c3(0x987)](_0x3b5c78)||{'x':0x0,'y':0x0};let _0x25d62a=_0xc6bc89['x'],_0x2569ce=_0xc6bc89['y'];_0x3b5c78[_0x4039c3(0xce)](Math['round'](_0x25d62a),Math['round'](_0x2569ce),!!_0x4587e5);}else{const _0xd9b872=_0x31c957[_0x5f6e2b];if(_0xd9b872)_0x269f05=this[_0x4039c3(0x2b7)]()[_0x4039c3(0x6d1)](_0xd9b872);}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x463),_0x68d7fe=>{const _0x662d8c=_0x208a24;if(!SceneManager[_0x662d8c(0x8c3)]())return;if(!$gameSystem[_0x662d8c(0x620)]())return;VisuMZ[_0x662d8c(0x4f4)](_0x68d7fe,_0x68d7fe);const _0x5cce14=VisuMZ[_0x662d8c(0x5bd)](_0x68d7fe['Targets']);let _0x52320e=_0x68d7fe['Point'];const _0x235242=_0x68d7fe['FaceAway'];for(const _0x51984d of _0x5cce14){if(!_0x51984d)continue;let _0x11d291=_0x51984d[_0x662d8c(0xd08)]()['_baseX'],_0xa28df3=_0x51984d['battler']()[_0x662d8c(0x832)];if(_0x52320e[_0x662d8c(0x7fc)](/home/i)){if(_0x662d8c(0x86e)!=='IwriZ')_0x11d291=_0x51984d['battler']()[_0x662d8c(0xd02)],_0xa28df3=_0x51984d['battler']()['_homeY'];else return!![];}else{if(_0x52320e['match'](/center/i))_0x11d291=Graphics[_0x662d8c(0xa53)]/0x2,_0xa28df3=Graphics['boxHeight']/0x2;else _0x52320e['match'](/point (\d+), (\d+)/i)&&(_0x11d291=Number(RegExp['$1']),_0xa28df3=Number(RegExp['$2']));}_0x51984d['setBattlerFacePoint'](Math[_0x662d8c(0xd50)](_0x11d291),Math['round'](_0xa28df3),!!_0x235242);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x8f6),_0x3fcf12=>{const _0x38431e=_0x208a24;if(!SceneManager[_0x38431e(0x8c3)]())return;if(!$gameSystem[_0x38431e(0x620)]())return;VisuMZ['ConvertParams'](_0x3fcf12,_0x3fcf12);const _0x447f09=VisuMZ['CreateActionSequenceTargets'](_0x3fcf12[_0x38431e(0x6ac)]),_0x28481e=VisuMZ['CreateActionSequenceTargets'](_0x3fcf12[_0x38431e(0x8b2)]),_0x5c786e=_0x28481e[_0x38431e(0x58e)](_0x8b107c=>_0x8b107c&&_0x8b107c['battler']()?_0x8b107c[_0x38431e(0xd08)]()[_0x38431e(0x169)]:0x0)/(_0x28481e['length']||0x1),_0x42f073=_0x28481e[_0x38431e(0x58e)](_0x20ba55=>_0x20ba55&&_0x20ba55[_0x38431e(0xd08)]()?_0x20ba55['battler']()[_0x38431e(0x832)]:0x0)/(_0x28481e['length']||0x1),_0x5d5c5c=_0x3fcf12[_0x38431e(0xa1)];for(const _0x59f9b1 of _0x447f09){if(_0x38431e(0x1ad)!=='EYqDH'){if(!_0x59f9b1)continue;_0x59f9b1[_0x38431e(0xce)](Math['round'](_0x5c786e),Math[_0x38431e(0xd50)](_0x42f073),!!_0x5d5c5c);}else{const _0x52b0fa=this[_0x38431e(0x617)](_0x166ad1),_0x2039b8=this[_0x38431e(0x6e4)](_0x1296e3),_0x124bfb=this[_0x38431e(0x23d)](_0x2039b8)[_0x38431e(0x4fe)];this[_0x38431e(0x8cd)](this[_0x38431e(0xb4f)](_0x504218));const _0x131938=this[_0x38431e(0x6a2)]();if(_0x131938===_0x38431e(0x5d3))this[_0x38431e(0x49e)](_0x2039b8,_0x52b0fa['x']+_0x52b0fa[_0x38431e(0x4fe)]-_0x124bfb,_0x52b0fa['y'],_0x124bfb);else{if(_0x131938===_0x38431e(0x1c0)){const _0x18290a=_0x52b0fa['x']+_0x534a23[_0x38431e(0x479)]((_0x52b0fa[_0x38431e(0x4fe)]-_0x124bfb)/0x2);this['drawTextEx'](_0x2039b8,_0x18290a,_0x52b0fa['y'],_0x124bfb);}else this[_0x38431e(0x49e)](_0x2039b8,_0x52b0fa['x'],_0x52b0fa['y'],_0x124bfb);}}}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x3f4),_0x479861=>{const _0x54a9bd=_0x208a24;if(!SceneManager[_0x54a9bd(0x8c3)]())return;VisuMZ[_0x54a9bd(0x4f4)](_0x479861,_0x479861);const _0x42436e=$gameTemp[_0x54a9bd(0xcc)](),_0xcaffdf=VisuMZ['CreateActionSequenceTargets'](_0x479861[_0x54a9bd(0x83d)]),_0x18777a=_0x479861[_0x54a9bd(0x604)],_0xbdf40b=_0x479861['Duration'],_0x3f9733=_0x479861[_0x54a9bd(0x99b)],_0x29dfbe=_0x479861[_0x54a9bd(0xbb8)];if(!_0x42436e)return;for(const _0x1a775c of _0xcaffdf){if('DMAhk'!==_0x54a9bd(0xa35))this[_0x54a9bd(0x93c)]()?this[_0x54a9bd(0xbcd)]():(this[_0x54a9bd(0x7d8)](),_0x150efd[_0x54a9bd(0x759)]['Sprite_Actor_updateFrame'][_0x54a9bd(0x783)](this));else{if(!_0x1a775c)continue;_0x1a775c[_0x54a9bd(0xa6c)](_0x18777a,_0xbdf40b,_0x3f9733);}}if(_0x29dfbe)_0x42436e[_0x54a9bd(0x3dc)](_0x54a9bd(0x399));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x2a3),_0x586c20=>{const _0x3acd5c=_0x208a24;if(!SceneManager[_0x3acd5c(0x8c3)]())return;VisuMZ[_0x3acd5c(0x4f4)](_0x586c20,_0x586c20);const _0x4b4bb3=$gameTemp[_0x3acd5c(0xcc)]();if(!_0x4b4bb3)return;const _0x12095a=VisuMZ[_0x3acd5c(0x5bd)](_0x586c20[_0x3acd5c(0x83d)]);for(const _0x226ed2 of _0x12095a){if(!_0x226ed2)continue;_0x226ed2[_0x3acd5c(0x18a)]();}BattleManager[_0x3acd5c(0x64d)]&&BattleManager['_subject'][_0x3acd5c(0x749)]();if(_0x586c20[_0x3acd5c(0x2ba)])_0x4b4bb3['setWaitMode'](_0x3acd5c(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x6da),_0x3614c9=>{const _0x4875db=_0x208a24;if(!SceneManager[_0x4875db(0x8c3)]())return;VisuMZ['ConvertParams'](_0x3614c9,_0x3614c9);const _0xa47a2c=$gameTemp[_0x4875db(0xcc)](),_0x1b103a=VisuMZ['CreateActionSequenceTargets'](_0x3614c9[_0x4875db(0x83d)]),_0x560d43=_0x3614c9[_0x4875db(0x604)],_0x2242e2=_0x3614c9['Duration'],_0x190fb1=_0x3614c9[_0x4875db(0xccf)];if(!_0xa47a2c)return;for(const _0x280f6d of _0x1b103a){if(!_0x280f6d)continue;_0x280f6d[_0x4875db(0x126)](_0x560d43,_0x2242e2);}if(_0x190fb1)_0xa47a2c[_0x4875db(0x3dc)]('battleJump');}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x2d1),_0x30246f=>{const _0x267350=_0x208a24;if(!SceneManager[_0x267350(0x8c3)]())return;if(!$gameSystem[_0x267350(0x620)]())return;VisuMZ['ConvertParams'](_0x30246f,_0x30246f);const _0x234a2e=$gameTemp[_0x267350(0xcc)](),_0x37d859=VisuMZ[_0x267350(0x5bd)](_0x30246f[_0x267350(0x83d)]),_0x352f98=_0x30246f[_0x267350(0xc91)],_0x41ed86=_0x30246f[_0x267350(0x5bf)],_0x1a4d36=_0x30246f['DistanceY'],_0x48370f=_0x30246f['Duration'],_0xfadd0d=_0x30246f[_0x267350(0xbfa)],_0x359ebc=_0x30246f['EasingType'],_0x3fa7ac=_0x30246f[_0x267350(0xc9e)],_0x1ab31c=_0x30246f['WaitForMovement'];if(!_0x234a2e)return;for(const _0x88b27 of _0x37d859){if(_0x267350(0x985)!==_0x267350(0x985)){if(!_0x36522b['isSceneBattle']())return;if(!_0x2fab5a[_0x267350(0x598)])return;const _0xb0a28a=_0x1ea1c4[_0x267350(0xcc)]();_0xb0a28a['setWaitMode'](_0x267350(0x8b0));}else{if(!_0x88b27)continue;let _0x496708=_0x41ed86,_0xde8dfa=_0x1a4d36;if(_0x352f98['match'](/horz/i))_0x496708*=_0x88b27[_0x267350(0x9bf)]()?-0x1:0x1;if(_0x352f98[_0x267350(0x7fc)](/vert/i))_0xde8dfa*=_0x88b27[_0x267350(0x9bf)]()?-0x1:0x1;_0x88b27[_0x267350(0xb88)](_0x496708,_0xde8dfa,_0x48370f,_0xfadd0d,_0x359ebc),_0x88b27[_0x267350(0x90c)](_0x3fa7ac);}}if(_0x1ab31c)_0x234a2e[_0x267350(0x3dc)](_0x267350(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x8e8),_0x46f6e3=>{const _0x408f97=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x408f97(0x4f4)](_0x46f6e3,_0x46f6e3);const _0x343787=$gameTemp[_0x408f97(0xcc)](),_0x12f389=VisuMZ[_0x408f97(0x5bd)](_0x46f6e3[_0x408f97(0x83d)]),_0xebc31a=_0x46f6e3[_0x408f97(0x1da)],_0x2ac84e=_0x46f6e3['OffsetX'],_0x28811f=_0x46f6e3['OffsetY'],_0x7117fb=_0x46f6e3[_0x408f97(0x2c6)],_0x49e205=_0x46f6e3[_0x408f97(0xbfa)],_0x27771c=_0x46f6e3['EasingType'],_0x18b50f=_0x46f6e3[_0x408f97(0xc9e)],_0x41c47a=_0x46f6e3[_0x408f97(0x2ba)];if(!_0x343787)return;for(const _0x4f2b5b of _0x12f389){if(!_0x4f2b5b)continue;const _0x18b44d=_0x46f6e3[_0x408f97(0x219)](_0x4f2b5b)||{'x':0x0,'y':0x0};let _0x2277c8=_0x18b44d['x'],_0x3bdc3f=_0x18b44d['y'];if(_0xebc31a['match'](/none/i))_0x2277c8+=_0x2ac84e,_0x3bdc3f+=_0x28811f;else{if(_0xebc31a[_0x408f97(0x7fc)](/horz/i)&&_0xebc31a[_0x408f97(0x7fc)](/vert/i))_0x2277c8+=_0x4f2b5b['isActor']()?-_0x2ac84e:_0x2ac84e,_0x3bdc3f+=_0x4f2b5b[_0x408f97(0x9bf)]()?-_0x28811f:_0x28811f;else{if(_0xebc31a[_0x408f97(0x7fc)](/horz/i))_0x2277c8+=_0x4f2b5b[_0x408f97(0x9bf)]()?-_0x2ac84e:_0x2ac84e,_0x3bdc3f+=_0x28811f;else _0xebc31a[_0x408f97(0x7fc)](/vert/i)&&(_0x2277c8+=_0x2ac84e,_0x3bdc3f+=_0x4f2b5b[_0x408f97(0x9bf)]()?-_0x28811f:_0x28811f);}}_0x4f2b5b[_0x408f97(0x70e)](_0x2277c8,_0x3bdc3f,_0x7117fb,_0x49e205,_0x27771c,-0x1),_0x4f2b5b[_0x408f97(0x90c)](_0x18b50f);}if(_0x41c47a)_0x343787['setWaitMode'](_0x408f97(0xbb9));}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Movement_MoveToPoint',_0x272e47=>{const _0x675d09=_0x208a24;if(!SceneManager[_0x675d09(0x8c3)]())return;if(!$gameSystem['isSideView']())return;VisuMZ[_0x675d09(0x4f4)](_0x272e47,_0x272e47);const _0x60af73=$gameTemp[_0x675d09(0xcc)](),_0x1e2903=VisuMZ[_0x675d09(0x5bd)](_0x272e47[_0x675d09(0x83d)]),_0x40cd35=_0x272e47[_0x675d09(0x45f)],_0x5357f6=_0x272e47[_0x675d09(0x1da)],_0x4a0c02=_0x272e47[_0x675d09(0x7ae)],_0xe355a3=_0x272e47[_0x675d09(0x153)],_0x4394b0=_0x272e47['Duration'],_0xf2611b=_0x272e47[_0x675d09(0xbfa)],_0x4d43de=_0x272e47[_0x675d09(0x99b)],_0x2caea9=_0x272e47[_0x675d09(0xc9e)],_0x14f779=_0x272e47[_0x675d09(0x2ba)];if(!_0x60af73)return;for(const _0x48aded of _0x1e2903){if(!_0x48aded)continue;let _0x381894=_0x48aded[_0x675d09(0xd08)]()[_0x675d09(0x169)],_0x2d409d=_0x48aded['battler']()[_0x675d09(0x832)];if(_0x40cd35['match'](/home/i))_0x381894=_0x48aded[_0x675d09(0xd08)]()[_0x675d09(0xd02)],_0x2d409d=_0x48aded[_0x675d09(0xd08)]()[_0x675d09(0x66c)];else{if(_0x40cd35[_0x675d09(0x7fc)](/center/i))_0x381894=Graphics[_0x675d09(0xa53)]/0x2,_0x2d409d=Graphics[_0x675d09(0x833)]/0x2;else _0x40cd35[_0x675d09(0x7fc)](/point (\d+), (\d+)/i)&&(_0x675d09(0x675)===_0x675d09(0xa44)?(_0x4386c[_0x675d09(0x759)]['Game_Actor_setup'][_0x675d09(0x783)](this,_0x656417),this[_0x675d09(0x6e5)]()):(_0x381894=Number(RegExp['$1']),_0x2d409d=Number(RegExp['$2'])));}if(_0x5357f6['match'](/none/i))'DXfnP'!==_0x675d09(0x959)?(this[_0x675d09(0x5c4)](),this[_0x675d09(0xe2)](),this[_0x675d09(0x542)](),this[_0x675d09(0xbdb)](),this[_0x675d09(0x491)]()):(_0x381894+=_0x4a0c02,_0x2d409d+=_0xe355a3);else{if(_0x5357f6[_0x675d09(0x7fc)](/horz/i)&&_0x5357f6[_0x675d09(0x7fc)](/vert/i))_0x381894+=_0x48aded[_0x675d09(0x9bf)]()?-_0x4a0c02:_0x4a0c02,_0x2d409d+=_0x48aded[_0x675d09(0x9bf)]()?-_0xe355a3:_0xe355a3;else{if(_0x5357f6['match'](/horz/i))_0x381894+=_0x48aded[_0x675d09(0x9bf)]()?-_0x4a0c02:_0x4a0c02,_0x2d409d+=_0xe355a3;else{if(_0x5357f6['match'](/vert/i)){if(_0x675d09(0x49d)!==_0x675d09(0x82b))_0x381894+=_0x4a0c02,_0x2d409d+=_0x48aded[_0x675d09(0x9bf)]()?-_0xe355a3:_0xe355a3;else{const _0x582fa4=_0x52efee(_0xa1e568['$1']);return _0x1dff37[_0x675d09(0x49a)]()[_0x675d09(0x5a8)](_0x264d42=>_0x264d42[_0x675d09(0xb09)]()===_0x582fa4);}}}}}_0x48aded[_0x675d09(0x70e)](_0x381894,_0x2d409d,_0x4394b0,_0xf2611b,_0x4d43de,-0x1),_0x48aded[_0x675d09(0x90c)](_0x2caea9);}if(_0x14f779)_0x60af73[_0x675d09(0x3dc)](_0x675d09(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x2b3),_0x704888=>{const _0x39b17b=_0x208a24;if(!SceneManager[_0x39b17b(0x8c3)]())return;if(!$gameSystem[_0x39b17b(0x620)]())return;VisuMZ[_0x39b17b(0x4f4)](_0x704888,_0x704888);const _0x35de21=$gameTemp[_0x39b17b(0xcc)](),_0xd3fe88=VisuMZ[_0x39b17b(0x5bd)](_0x704888['Targets1']),_0x4cb598=VisuMZ[_0x39b17b(0x5bd)](_0x704888[_0x39b17b(0x8b2)]),_0x2f3fb8=_0x704888['TargetLocation'];let _0x384ec5=_0x704888[_0x39b17b(0xa81)];const _0x595096=_0x704888['OffsetAdjust'],_0x3ee216=_0x704888[_0x39b17b(0x7ae)],_0x2d9193=_0x704888['OffsetY'],_0x598d4a=_0x704888['Duration'],_0x4d2b3b=_0x704888[_0x39b17b(0xbfa)],_0x2e748d=_0x704888[_0x39b17b(0x99b)],_0x565db8=_0x704888[_0x39b17b(0xc9e)],_0x436d0e=_0x704888[_0x39b17b(0x2ba)],_0x298039=Math['min'](..._0x4cb598['map'](_0xa6692d=>_0xa6692d[_0x39b17b(0xd08)]()['_baseX']-_0xa6692d[_0x39b17b(0xd08)]()[_0x39b17b(0x68b)]()/0x2)),_0x4b076f=Math[_0x39b17b(0x6db)](..._0x4cb598['map'](_0x1ec1a6=>_0x1ec1a6[_0x39b17b(0xd08)]()[_0x39b17b(0x169)]+_0x1ec1a6[_0x39b17b(0xd08)]()['mainSpriteWidth']()/0x2)),_0x871921=Math['min'](..._0x4cb598['map'](_0xf60f7b=>_0xf60f7b[_0x39b17b(0xd08)]()[_0x39b17b(0x832)]-_0xf60f7b['battler']()[_0x39b17b(0x536)]())),_0x1b3950=Math[_0x39b17b(0x6db)](..._0x4cb598[_0x39b17b(0x58e)](_0x5b1db5=>_0x5b1db5[_0x39b17b(0xd08)]()[_0x39b17b(0x832)])),_0x12f3f7=_0x4cb598['filter'](_0x135209=>_0x135209[_0x39b17b(0x9bf)]())[_0x39b17b(0x1ba)],_0x46fc9e=_0x4cb598[_0x39b17b(0x5a8)](_0x4ad544=>_0x4ad544['isEnemy']())[_0x39b17b(0x1ba)];let _0x4734f9=0x0,_0x276255=0x0;if(_0x2f3fb8[_0x39b17b(0x7fc)](/front/i))_0x4734f9=_0x12f3f7>=_0x46fc9e?_0x298039:_0x4b076f;else{if(_0x2f3fb8[_0x39b17b(0x7fc)](/middle/i))_0x4734f9=(_0x298039+_0x4b076f)/0x2,_0x384ec5=-0x1;else _0x2f3fb8[_0x39b17b(0x7fc)](/back/i)&&(_0x4734f9=_0x12f3f7>=_0x46fc9e?_0x4b076f:_0x298039);}if(_0x2f3fb8[_0x39b17b(0x7fc)](/head/i))_0x276255=_0x871921;else{if(_0x2f3fb8[_0x39b17b(0x7fc)](/center/i))_0x276255=(_0x871921+_0x1b3950)/0x2;else{if(_0x2f3fb8[_0x39b17b(0x7fc)](/base/i)){if(_0x39b17b(0x965)!==_0x39b17b(0x965))return _0x5d080f[_0x39b17b(0x29a)];else _0x276255=_0x1b3950;}}}if(!_0x35de21)return;for(const _0x1adfc1 of _0xd3fe88){if(_0x39b17b(0x45e)!==_0x39b17b(0x2b8)){if(!_0x1adfc1)continue;let _0xab3b3c=_0x4734f9,_0x113a93=_0x276255;if(_0x595096[_0x39b17b(0x7fc)](/none/i))_0xab3b3c+=_0x3ee216,_0x113a93+=_0x2d9193;else{if(_0x595096[_0x39b17b(0x7fc)](/horz/i)&&_0x595096[_0x39b17b(0x7fc)](/vert/i))_0xab3b3c+=_0x1adfc1[_0x39b17b(0x9bf)]()?-_0x3ee216:_0x3ee216,_0x113a93+=_0x1adfc1[_0x39b17b(0x9bf)]()?-_0x2d9193:_0x2d9193;else{if(_0x595096['match'](/horz/i))_0xab3b3c+=_0x1adfc1[_0x39b17b(0x9bf)]()?-_0x3ee216:_0x3ee216,_0x113a93+=_0x2d9193;else _0x595096['match'](/vert/i)&&(_0xab3b3c+=_0x3ee216,_0x113a93+=_0x1adfc1[_0x39b17b(0x9bf)]()?-_0x2d9193:_0x2d9193);}}_0x1adfc1['moveBattlerToPoint'](_0xab3b3c,_0x113a93,_0x598d4a,_0x4d2b3b,_0x2e748d,_0x384ec5),_0x1adfc1[_0x39b17b(0x90c)](_0x565db8);}else this[_0x39b17b(0x701)]()?_0x27a1aa['BattleCore']['Sprite_Enemy_initVisibility'][_0x39b17b(0x783)](this):(this[_0x39b17b(0xd09)]=!this['_enemy']['isHidden'](),!this[_0x39b17b(0xd09)]&&(this['opacity']=0x0));}if(_0x436d0e)_0x35de21[_0x39b17b(0x3dc)](_0x39b17b(0xbb9));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x134),_0x73d3b5=>{const _0x40d189=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ['ConvertParams'](_0x73d3b5,_0x73d3b5);const _0x1d75e7=$gameTemp['getLastPluginCommandInterpreter'](),_0x2521a4=VisuMZ[_0x40d189(0x5bd)](_0x73d3b5[_0x40d189(0x83d)]),_0x181b25=_0x73d3b5['Opacity'],_0x3d38c6=_0x73d3b5[_0x40d189(0x2c6)],_0x367e08=_0x73d3b5[_0x40d189(0x99b)],_0x3cdf93=_0x73d3b5['WaitForOpacity'];if(!_0x1d75e7)return;for(const _0x56eb5a of _0x2521a4){if(!_0x56eb5a)continue;_0x56eb5a[_0x40d189(0x92d)](_0x181b25,_0x3d38c6,_0x367e08);}if(_0x3cdf93)_0x1d75e7[_0x40d189(0x3dc)]('battleOpacity');}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x2e7),_0x2429eb=>{const _0x57db0c=_0x208a24;if(!SceneManager[_0x57db0c(0x8c3)]())return;VisuMZ[_0x57db0c(0x4f4)](_0x2429eb,_0x2429eb);const _0x3473fe=$gameTemp[_0x57db0c(0xcc)](),_0x617094=VisuMZ['CreateActionSequenceTargets'](_0x2429eb[_0x57db0c(0x83d)]),_0x1888be=_0x2429eb[_0x57db0c(0xbb0)],_0x324e22=_0x2429eb[_0x57db0c(0xc1e)],_0x198417=_0x2429eb[_0x57db0c(0x2c6)],_0x355449=_0x2429eb[_0x57db0c(0x99b)],_0x2fae7b=_0x2429eb['WaitForScale'];if(!_0x3473fe)return;for(const _0x21b02f of _0x617094){if(!_0x21b02f)continue;_0x21b02f[_0x57db0c(0x518)](_0x1888be,_0x324e22,_0x198417,_0x355449);}if(_0x2fae7b)_0x3473fe['setWaitMode'](_0x57db0c(0x9e3));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x419),_0x438583=>{const _0x4ce288=_0x208a24;if(!SceneManager[_0x4ce288(0x8c3)]())return;VisuMZ[_0x4ce288(0x4f4)](_0x438583,_0x438583);const _0x139663=$gameTemp[_0x4ce288(0xcc)](),_0x20ddfe=VisuMZ[_0x4ce288(0x5bd)](_0x438583['Targets']),_0x6d2a58=_0x438583[_0x4ce288(0xb9b)],_0xe22b74=_0x438583['SkewY'],_0x544fbc=_0x438583[_0x4ce288(0x2c6)],_0x1f4ba8=_0x438583[_0x4ce288(0x99b)],_0x544db9=_0x438583[_0x4ce288(0x81f)];if(!_0x139663)return;for(const _0x2d859d of _0x20ddfe){if(!_0x2d859d)continue;_0x2d859d[_0x4ce288(0x323)](_0x6d2a58,_0xe22b74,_0x544fbc,_0x1f4ba8);}if(_0x544db9)_0x139663[_0x4ce288(0x3dc)](_0x4ce288(0x634));}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Movement_Spin',_0x3e1dc4=>{const _0xbebc7e=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0xbebc7e(0x4f4)](_0x3e1dc4,_0x3e1dc4);const _0x191d70=$gameTemp[_0xbebc7e(0xcc)](),_0x25cad5=VisuMZ[_0xbebc7e(0x5bd)](_0x3e1dc4['Targets']),_0x586572=_0x3e1dc4[_0xbebc7e(0xbe2)],_0x3883fe=_0x3e1dc4[_0xbebc7e(0x2c6)],_0x351a93=_0x3e1dc4[_0xbebc7e(0x99b)],_0x16b8f2=_0x3e1dc4[_0xbebc7e(0xbb4)],_0x233ca9=_0x3e1dc4[_0xbebc7e(0x8fa)];if(!_0x191d70)return;for(const _0x716cea of _0x25cad5){if(!_0x716cea)continue;_0x716cea[_0xbebc7e(0x745)](_0x586572,_0x3883fe,_0x351a93,_0x16b8f2);}if(_0x233ca9)_0x191d70[_0xbebc7e(0x3dc)](_0xbebc7e(0x8a9));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x85e),_0x49ab2f=>{const _0x224f14=_0x208a24;if(!SceneManager[_0x224f14(0x8c3)]())return;const _0x7035d0=$gameTemp[_0x224f14(0xcc)]();if(!_0x7035d0)return;_0x7035d0['setWaitMode']('battleFloat');}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0xc82),_0x59cc7f=>{const _0x11d87a=_0x208a24;if(!SceneManager[_0x11d87a(0x8c3)]())return;const _0x528453=$gameTemp[_0x11d87a(0xcc)]();if(!_0x528453)return;_0x528453[_0x11d87a(0x3dc)](_0x11d87a(0x6b4));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x256),_0x96f51c=>{const _0x2d0f4d=_0x208a24;if(!SceneManager[_0x2d0f4d(0x8c3)]())return;const _0xb172dd=$gameTemp[_0x2d0f4d(0xcc)]();if(!_0xb172dd)return;_0xb172dd[_0x2d0f4d(0x3dc)](_0x2d0f4d(0xbb9));}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0xb5c),_0x348fa5=>{const _0x29fd53=_0x208a24;if(!SceneManager['isSceneBattle']())return;const _0x46c9e8=$gameTemp[_0x29fd53(0xcc)]();if(!_0x46c9e8)return;_0x46c9e8[_0x29fd53(0x3dc)](_0x29fd53(0xbc7));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0xa1d),_0x39e219=>{const _0x2500ed=_0x208a24;if(!SceneManager[_0x2500ed(0x8c3)]())return;const _0x2751cd=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x2751cd)return;_0x2751cd[_0x2500ed(0x3dc)](_0x2500ed(0x9e3));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xb3a),_0x42c453=>{const _0x208bb5=_0x208a24;if(!SceneManager[_0x208bb5(0x8c3)]())return;const _0x365218=$gameTemp['getLastPluginCommandInterpreter']();if(!_0x365218)return;_0x365218[_0x208bb5(0x3dc)](_0x208bb5(0x634));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x9ec),_0x1a9a4c=>{const _0x3852d0=_0x208a24;if(!SceneManager[_0x3852d0(0x8c3)]())return;const _0x36fe8a=$gameTemp[_0x3852d0(0xcc)]();if(!_0x36fe8a)return;_0x36fe8a[_0x3852d0(0x3dc)](_0x3852d0(0x8a9));}),VisuMZ[_0x208a24(0x759)][_0x208a24(0x40f)]=function(){const _0x8debd1=_0x208a24;if(!Imported[_0x8debd1(0x74d)])return;if(VisuMZ[_0x8debd1(0x327)][_0x8debd1(0x738)]<1.08){let _0x4ec188='';_0x4ec188+=_0x8debd1(0x8f9),_0x4ec188+=_0x8debd1(0x284),alert(_0x4ec188),SceneManager['exit']();}},PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xa3c),_0x225dcc=>{const _0x312302=_0x208a24;if(!SceneManager[_0x312302(0x8c3)]())return;if(!Imported[_0x312302(0x74d)])return;VisuMZ[_0x312302(0x4f4)](_0x225dcc,_0x225dcc),VisuMZ[_0x312302(0x759)]['CheckActSeqProjectileVersion']();const _0x1a7a8f=$gameTemp[_0x312302(0xcc)](),_0x51e84c=_0x225dcc[_0x312302(0xae0)];if(!_0x1a7a8f)return;const _0x3f9b91=BattleManager[_0x312302(0xa85)];if(!_0x3f9b91)return;_0x3f9b91[_0x312302(0x348)](_0x225dcc);if(_0x51e84c)_0x1a7a8f[_0x312302(0x3dc)](_0x312302(0x482));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x862),_0x381615=>{const _0x937bd5=_0x208a24;if(!SceneManager[_0x937bd5(0x8c3)]())return;if(!Imported[_0x937bd5(0x74d)])return;VisuMZ[_0x937bd5(0x4f4)](_0x381615,_0x381615),VisuMZ['BattleCore'][_0x937bd5(0x40f)]();const _0x437651=$gameTemp[_0x937bd5(0xcc)](),_0x1f55df=_0x381615['WaitForProjectile'];if(!_0x437651)return;const _0x2c9096=BattleManager[_0x937bd5(0xa85)];if(!_0x2c9096)return;_0x2c9096['createActionSequenceProjectile'](_0x381615);if(_0x1f55df)_0x437651[_0x937bd5(0x3dc)](_0x937bd5(0x482));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Projectile_Picture',_0x2b546d=>{const _0x394512=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported['VisuMZ_3_ActSeqProjectiles'])return;VisuMZ['ConvertParams'](_0x2b546d,_0x2b546d),VisuMZ[_0x394512(0x759)]['CheckActSeqProjectileVersion']();const _0x20a442=$gameTemp[_0x394512(0xcc)](),_0x2f94b2=_0x2b546d[_0x394512(0xae0)];if(!_0x20a442)return;const _0x584d6e=BattleManager['_spriteset'];if(!_0x584d6e)return;_0x584d6e[_0x394512(0x348)](_0x2b546d);if(_0x2f94b2)_0x20a442[_0x394512(0x3dc)](_0x394512(0x482));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x8a2),_0x86ee47=>{const _0x4064d2=_0x208a24;if(!SceneManager[_0x4064d2(0x8c3)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x4064d2(0x4f4)](_0x86ee47,_0x86ee47);const _0x2732ab=$gameTemp[_0x4064d2(0xcc)](),_0x39b7bb=_0x86ee47[_0x4064d2(0x81f)];if(!_0x2732ab)return;$gameScreen['setBattleSkew'](_0x86ee47[_0x4064d2(0xb9b)],_0x86ee47['SkewY'],_0x86ee47[_0x4064d2(0x2c6)],_0x86ee47[_0x4064d2(0x99b)]);if(_0x39b7bb)_0x2732ab['setWaitMode'](_0x4064d2(0xa3));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x387),_0x4b5a7f=>{const _0x4ccb98=_0x208a24;if(!SceneManager[_0x4ccb98(0x8c3)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x4ccb98(0x4f4)](_0x4b5a7f,_0x4b5a7f);const _0x329954=$gameTemp[_0x4ccb98(0xcc)](),_0x5003c1=_0x4b5a7f[_0x4ccb98(0x81f)];if(!_0x329954)return;$gameScreen[_0x4ccb98(0x1c8)](0x0,0x0,_0x4b5a7f[_0x4ccb98(0x2c6)],_0x4b5a7f[_0x4ccb98(0x99b)]);if(_0x5003c1)_0x329954[_0x4ccb98(0x3dc)](_0x4ccb98(0xa3));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Skew_WaitForSkew',_0x3cd3b1=>{const _0xa87d86=_0x208a24;if(!SceneManager[_0xa87d86(0x8c3)]())return;if(!Imported[_0xa87d86(0x355)])return;const _0x525471=$gameTemp[_0xa87d86(0xcc)]();if(!_0x525471)return;_0x525471[_0xa87d86(0x3dc)](_0xa87d86(0xa3));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x8d7),_0x2184e7=>{const _0x346d9b=_0x208a24;if(!SceneManager[_0x346d9b(0x8c3)]())return;VisuMZ[_0x346d9b(0x4f4)](_0x2184e7,_0x2184e7);const _0x563503=$gameTemp[_0x346d9b(0xcc)](),_0x3252a5=_0x2184e7[_0x346d9b(0xc15)],_0x3345de=_0x2184e7[_0x346d9b(0xc98)];if(!_0x563503)return;BattleManager[_0x346d9b(0x580)]=_0x3252a5,BattleManager[_0x346d9b(0x29a)]=BattleManager[_0x346d9b(0xaea)]?BattleManager['_allTargets'][BattleManager[_0x346d9b(0x580)]]||null:null,BattleManager['_target']&&_0x3345de[_0x346d9b(0x4d6)]()[_0x346d9b(0x446)]()!=='UNTITLED'&&_0x563503[_0x346d9b(0x2f3)]([_0x3345de]);}),PluginManager[_0x208a24(0xbb)](pluginData['name'],_0x208a24(0x64e),_0xfc447c=>{const _0x459989=_0x208a24;if(!SceneManager['isSceneBattle']())return;VisuMZ[_0x459989(0x4f4)](_0xfc447c,_0xfc447c);const _0x430fce=$gameTemp[_0x459989(0xcc)](),_0x44c852=_0xfc447c['JumpToLabel'];if(!_0x430fce)return;BattleManager[_0x459989(0x580)]++,BattleManager['_target']=BattleManager[_0x459989(0xaea)][BattleManager[_0x459989(0x580)]]||null,BattleManager[_0x459989(0x29a)]&&_0x44c852['toUpperCase']()[_0x459989(0x446)]()!==_0x459989(0x873)&&_0x430fce[_0x459989(0x2f3)]([_0x44c852]);}),PluginManager['registerCommand'](pluginData['name'],'ActSeq_Target_PrevTarget',_0x1b4bf1=>{const _0x245d03=_0x208a24;if(!SceneManager[_0x245d03(0x8c3)]())return;VisuMZ['ConvertParams'](_0x1b4bf1,_0x1b4bf1);const _0x4ee1cd=$gameTemp[_0x245d03(0xcc)](),_0x4d3ee4=_0x1b4bf1[_0x245d03(0xc98)];if(!_0x4ee1cd)return;BattleManager[_0x245d03(0x580)]--,BattleManager[_0x245d03(0x29a)]=BattleManager[_0x245d03(0xaea)][BattleManager[_0x245d03(0x580)]]||null;if(BattleManager[_0x245d03(0x29a)]&&_0x4d3ee4[_0x245d03(0x4d6)]()[_0x245d03(0x446)]()!==_0x245d03(0x873)){if(_0x245d03(0x535)!==_0x245d03(0x99a))_0x4ee1cd[_0x245d03(0x2f3)]([_0x4d3ee4]);else{const _0x3fbe25=_0x1697f7(_0xaaab0b['$1'])[_0x245d03(0xc85)](/[\r\n]+/)[_0x245d03(0x44b)]('');_0x347d02['name']=_0x53d097[_0x245d03(0x382)](_0x3fbe25);}}}),PluginManager['registerCommand'](pluginData['name'],_0x208a24(0xbd7),_0x2af34c=>{const _0x8a7e37=_0x208a24;if(!SceneManager[_0x8a7e37(0x8c3)]())return;VisuMZ[_0x8a7e37(0x4f4)](_0x2af34c,_0x2af34c);const _0xe9987d=$gameTemp['getLastPluginCommandInterpreter'](),_0x3da817=_0x2af34c[_0x8a7e37(0xb45)],_0x3ab8aa=_0x2af34c[_0x8a7e37(0xc98)];if(!_0xe9987d)return;const _0x41a2ff=BattleManager[_0x8a7e37(0x580)];for(;;){if('lDKZI'==='lDKZI'){BattleManager['_targetIndex']=Math[_0x8a7e37(0xd15)](BattleManager[_0x8a7e37(0xaea)]['length']);if(!_0x3da817)break;if(BattleManager[_0x8a7e37(0x580)]!==_0x41a2ff)break;if(BattleManager[_0x8a7e37(0xaea)]['length']<=0x1){BattleManager[_0x8a7e37(0x580)]=0x0;break;}}else{if(!this[_0x8a7e37(0xa4c)])return![];if(this[_0x8a7e37(0x7ce)]>0x0)return!![];return _0x495247[_0x8a7e37(0x759)]['Sprite_Battler_isMoving'][_0x8a7e37(0x783)](this);}}BattleManager[_0x8a7e37(0x29a)]=BattleManager['_allTargets'][BattleManager['_targetIndex']]||null,BattleManager[_0x8a7e37(0x29a)]&&_0x3ab8aa[_0x8a7e37(0x4d6)]()[_0x8a7e37(0x446)]()!==_0x8a7e37(0x873)&&(_0x8a7e37(0xa7)!==_0x8a7e37(0xa7)?(_0x23add3[_0x8a7e37(0x759)][_0x8a7e37(0x61e)]&&_0x2a85cc[_0x8a7e37(0x759)]['ParseItemNotetags'][_0x8a7e37(0x783)](this,_0x4d365b),_0xc4e256[_0x8a7e37(0x759)][_0x8a7e37(0x3f1)](_0x3cf60e),_0x13edf1[_0x8a7e37(0x759)][_0x8a7e37(0x85a)](_0xdbe8e5)):_0xe9987d['command119']([_0x3ab8aa]));}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],_0x208a24(0x63a),_0x323d14=>{const _0x33b0f4=_0x208a24;if(!SceneManager['isSceneBattle']())return;if(!Imported[_0x33b0f4(0xab5)])return;if(!ConfigManager[_0x33b0f4(0x515)])return;VisuMZ[_0x33b0f4(0x4f4)](_0x323d14,_0x323d14);const _0x3bc754=VisuMZ[_0x33b0f4(0x5bd)](_0x323d14[_0x33b0f4(0x83d)]);let _0x414b1c=_0x323d14[_0x33b0f4(0xc3d)]||'';for(const _0x3f8820 of _0x3bc754){if('JtMPZ'!==_0x33b0f4(0x483)){if(!_0x3f8820)continue;_0x3f8820['playBattleVoice'](_0x414b1c);}else return this[_0x33b0f4(0x678)]();}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x320),_0x4a3077=>{const _0xbeafb8=_0x208a24;if(!SceneManager[_0xbeafb8(0x8c3)]())return;if(!Imported[_0xbeafb8(0xab5)])return;if(!ConfigManager[_0xbeafb8(0x515)])return;VisuMZ[_0xbeafb8(0x4f4)](_0x4a3077,_0x4a3077);const _0xcc7332=VisuMZ[_0xbeafb8(0x5bd)](_0x4a3077[_0xbeafb8(0x83d)]);let _0x2451f1=(_0x4a3077[_0xbeafb8(0x2c3)]||'')+(_0x4a3077[_0xbeafb8(0x466)]||'');for(const _0x440dee of _0xcc7332){if(_0xbeafb8(0x895)!==_0xbeafb8(0x6ea)){if(!_0x440dee)continue;_0x440dee[_0xbeafb8(0xd2)](_0x2451f1);}else{if(this[_0xbeafb8(0x570)]===_0xbeafb8(0x330))return![];if(this[_0xbeafb8(0x570)]==='all\x20enemies')return![];if(!this[_0xbeafb8(0x8bb)]())return![];return this[_0xbeafb8(0x8bb)]()[_0xbeafb8(0x6c4)]['match'](/<JS TARGETS>/i);}}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Weapon_ClearActiveWeapon',_0x472627=>{const _0x4c83a1=_0x208a24;if(!SceneManager[_0x4c83a1(0x8c3)]())return;VisuMZ[_0x4c83a1(0x4f4)](_0x472627,_0x472627);const _0x270b33=VisuMZ[_0x4c83a1(0x5bd)](_0x472627[_0x4c83a1(0x83d)]);for(const _0x145e04 of _0x270b33){if(!_0x145e04)continue;if(!_0x145e04[_0x4c83a1(0x9bf)]())continue;_0x145e04[_0x4c83a1(0x13d)]();}}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Weapon_NextActiveWeapon',_0x3addda=>{const _0x3ef9af=_0x208a24;if(!SceneManager[_0x3ef9af(0x8c3)]())return;VisuMZ[_0x3ef9af(0x4f4)](_0x3addda,_0x3addda);const _0x158b6=$gameTemp[_0x3ef9af(0xcc)]();let _0x574c3a=![];const _0x323106=_0x3addda[_0x3ef9af(0xc98)],_0x51cca7=VisuMZ[_0x3ef9af(0x5bd)](_0x3addda[_0x3ef9af(0x83d)]);for(const _0x4b980f of _0x51cca7){if('GGGGf'!==_0x3ef9af(0xcda)){if(!_0x4a8e42[_0x3ef9af(0x8c3)]())return;if(!_0x55ee0e[_0x3ef9af(0x598)])return;_0x4ce2ed[_0x3ef9af(0x4f4)](_0x29b904,_0x4adb34),_0x35444a['_scene'][_0x3ef9af(0x4a0)]();const _0x5e65b3=_0x4be314[_0x3ef9af(0xcc)]();_0x5e65b3&&_0x19691a[_0x3ef9af(0x147)]&&_0x5e65b3[_0x3ef9af(0x3dc)](_0x3ef9af(0x8b0));}else{if(!_0x4b980f)continue;if(!_0x4b980f[_0x3ef9af(0x9bf)]())continue;_0x4b980f[_0x3ef9af(0x43f)](),_0x4b980f[_0x3ef9af(0x202)]()['length']>0x0?_0x574c3a=!![]:_0x4b980f['clearActiveWeaponSlot']();}}if(_0x574c3a&&_0x323106[_0x3ef9af(0x4d6)]()[_0x3ef9af(0x446)]()!=='UNTITLED'){if(_0x3ef9af(0x1e2)===_0x3ef9af(0x333)){this[_0x3ef9af(0x5eb)](_0x187c57);for(const _0x2797ad of _0x3987b6[_0x3ef9af(0x55a)]){_0x2797ad[_0x3ef9af(0xa4e)]&&_0x2797ad[_0x3ef9af(0xa4e)]();}_0x46f7f5['destroy']();}else _0x158b6[_0x3ef9af(0x2f3)]([_0x323106]);}}),PluginManager['registerCommand'](pluginData[_0x208a24(0x278)],'ActSeq_Weapon_SetActiveWeapon',_0xd9424b=>{const _0x324cf5=_0x208a24;if(!SceneManager[_0x324cf5(0x8c3)]())return;VisuMZ['ConvertParams'](_0xd9424b,_0xd9424b);let _0x51ef45=_0xd9424b['SlotID'];_0x51ef45--,_0x51ef45=Math[_0x324cf5(0x6db)](_0x51ef45,0x0);const _0xb523c=VisuMZ[_0x324cf5(0x5bd)](_0xd9424b[_0x324cf5(0x83d)]);for(const _0x36a798 of _0xb523c){if('GJyxz'===_0x324cf5(0x35c)){if(!_0x36a798)continue;if(!_0x36a798[_0x324cf5(0x9bf)]())continue;_0x36a798[_0x324cf5(0xad2)](_0x51ef45);}else return _0x2eb6ab[_0x324cf5(0x8c3)]()?(_0x46f2b1[_0x324cf5(0xc1b)][_0x324cf5(0xa85)][_0x324cf5(0xadd)](_0x2a5337[0x0],_0x45826a[0x1]),!![]):_0x4ccc8e[_0x324cf5(0x759)]['Game_Interpreter_command283'][_0x324cf5(0x783)](this,_0x35a1cf);}}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0x361),_0x145978=>{const _0x1cb0bf=_0x208a24;if(!SceneManager[_0x1cb0bf(0x8c3)]())return;if(!Imported[_0x1cb0bf(0x355)])return;VisuMZ[_0x1cb0bf(0x4f4)](_0x145978,_0x145978);const _0x1de84f=$gameTemp['getLastPluginCommandInterpreter'](),_0xce4a87=_0x145978[_0x1cb0bf(0x319)];if(!_0x1de84f)return;$gameScreen[_0x1cb0bf(0xab0)](_0x145978['Scale'],_0x145978['Duration'],_0x145978[_0x1cb0bf(0x99b)]);if(_0xce4a87)_0x1de84f[_0x1cb0bf(0x3dc)](_0x1cb0bf(0x7a8));}),PluginManager[_0x208a24(0xbb)](pluginData[_0x208a24(0x278)],_0x208a24(0xa6d),_0x28bd71=>{const _0x194e48=_0x208a24;if(!SceneManager[_0x194e48(0x8c3)]())return;if(!Imported['VisuMZ_3_ActSeqCamera'])return;VisuMZ[_0x194e48(0x4f4)](_0x28bd71,_0x28bd71);const _0x504fd1=$gameTemp['getLastPluginCommandInterpreter'](),_0x3338b8=_0x28bd71[_0x194e48(0x319)];if(!_0x504fd1)return;$gameScreen[_0x194e48(0xab0)](0x1,_0x28bd71['Duration'],_0x28bd71[_0x194e48(0x99b)]);if(_0x3338b8)_0x504fd1[_0x194e48(0x3dc)](_0x194e48(0x7a8));}),PluginManager[_0x208a24(0xbb)](pluginData['name'],'ActSeq_Zoom_WaitForZoom',_0x1ad902=>{const _0x1d051d=_0x208a24;if(!SceneManager[_0x1d051d(0x8c3)]())return;if(!Imported[_0x1d051d(0x355)])return;const _0x2d8c79=$gameTemp[_0x1d051d(0xcc)]();if(!_0x2d8c79)return;_0x2d8c79[_0x1d051d(0x3dc)]('battleZoom');}),VisuMZ[_0x208a24(0x759)][_0x208a24(0xbd)]=Scene_Boot[_0x208a24(0xbd8)][_0x208a24(0xca1)],Scene_Boot[_0x208a24(0xbd8)][_0x208a24(0xca1)]=function(){const _0x529b4e=_0x208a24;this[_0x529b4e(0x7d7)](),this[_0x529b4e(0x6f2)](),this[_0x529b4e(0x3fe)](),this['process_VisuMZ_BattleCore_CreateRegExp'](),VisuMZ['BattleCore'][_0x529b4e(0xbd)][_0x529b4e(0x783)](this),this[_0x529b4e(0x4dc)](),this[_0x529b4e(0x9a3)](),this[_0x529b4e(0xafe)](),this['process_VisuMZ_BattleCore_CommonEventKeys']();},Scene_Boot['prototype'][_0x208a24(0x4dc)]=function(){const _0x398c01=_0x208a24;if(VisuMZ['ParseAllNotetags'])return;this[_0x398c01(0x331)](),this['process_VisuMZ_BattleCore_TraitObject_Notetags'](),this['process_VisuMZ_BattleCore_jsFunctions']();},Scene_Boot['prototype'][_0x208a24(0x7d7)]=function(){const _0x178865=_0x208a24,_0xf3e1ce=$dataSystem[_0x178865(0xae)][_0x178865(0x1ba)];for(let _0x37d28e=0x0;_0x37d28e<_0xf3e1ce;_0x37d28e++){const _0x3dc1d3=$dataSystem['attackMotions'][_0x37d28e];if(_0x3dc1d3)continue;$dataSystem[_0x178865(0xba)][_0x37d28e]={'type':0x1,'weaponImageId':0x1};}},Scene_Boot['prototype'][_0x208a24(0x6f2)]=function(){const _0x30ffb8=_0x208a24,_0x3ca2b3=VisuMZ[_0x30ffb8(0x759)][_0x30ffb8(0xc39)];_0x3ca2b3[_0x30ffb8(0x7a9)]['PopupPosition']===undefined&&(_0x30ffb8(0xc09)===_0x30ffb8(0x396)?(_0x588d31=_0x173339[_0x30ffb8(0x51f)](/\x1I\[(\d+)\]/gi,''),_0x58861f=_0x12b51b[_0x30ffb8(0x51f)](/\\I\[(\d+)\]/gi,'')):_0x3ca2b3[_0x30ffb8(0x7a9)]['PopupPosition']=_0x30ffb8(0xd7));if(_0x3ca2b3[_0x30ffb8(0x5a5)][_0x30ffb8(0x2eb)]===undefined){if('rushE'!==_0x30ffb8(0x115))return _0x51a1e9;else _0x3ca2b3['Actor']['SmoothImage']=![];}_0x3ca2b3[_0x30ffb8(0x6bd)][_0x30ffb8(0x2eb)]===undefined&&(_0x3ca2b3[_0x30ffb8(0x6bd)][_0x30ffb8(0x2eb)]=!![]),_0x3ca2b3[_0x30ffb8(0x5a5)]['PrioritySortActive']===undefined&&(_0x3ca2b3[_0x30ffb8(0x5a5)][_0x30ffb8(0x849)]=![]),_0x3ca2b3['Actor'][_0x30ffb8(0x9c4)]===undefined&&(_0x3ca2b3[_0x30ffb8(0x5a5)][_0x30ffb8(0x9c4)]=!![]);},VisuMZ[_0x208a24(0x4a8)]={},Scene_Boot['prototype']['process_VisuMZ_BattleCore_DamageStyles']=function(){const _0x41b628=_0x208a24;for(const _0x2a709d of VisuMZ[_0x41b628(0x759)][_0x41b628(0xc39)][_0x41b628(0x7a9)][_0x41b628(0x1c7)]){if(_0x41b628(0xa08)===_0x41b628(0xa08)){if(!_0x2a709d)continue;const _0x29c675=_0x2a709d[_0x41b628(0x2c7)][_0x41b628(0x4d6)]()[_0x41b628(0x446)]();VisuMZ[_0x41b628(0x4a8)][_0x29c675]=_0x2a709d;}else{if(_0x5e5e24[_0x41b628(0x957)])return;this[_0x41b628(0x331)](),this['process_VisuMZ_BattleCore_TraitObject_Notetags'](),this[_0x41b628(0xca5)]();}}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x7b1)]={},Scene_Boot[_0x208a24(0xbd8)]['process_VisuMZ_BattleCore_CreateRegExp']=function(){const _0x40836a=_0x208a24,_0x49f164=VisuMZ[_0x40836a(0x759)][_0x40836a(0x7b1)],_0x265087=_0x40836a(0x6d8),_0x5de3d6=[['Pre',_0x40836a(0x80a)],[_0x40836a(0xd46),_0x40836a(0xc42)]],_0x55fe2f=[[_0x40836a(0xa4f),_0x40836a(0x2da)],[_0x40836a(0xbf8),'JS\x20%1DAMAGE\x20%2']],_0xeb4822=[['',''],[_0x40836a(0x476),_0x40836a(0x57b)],['AsTarget',_0x40836a(0xc1f)]];for(const _0xe33385 of _0x55fe2f){if(_0x40836a(0xb28)!==_0x40836a(0x41e))for(const _0x153775 of _0xeb4822){if(_0x40836a(0x168)==='WfZVp'){if(!_0x1c179c[_0x40836a(0x496)])return;this[_0x40836a(0x56e)]!==_0x41f969[_0x40836a(0x122)](this[_0x40836a(0x983)])&&this[_0x40836a(0xa22)]();}else for(const _0x509ffb of _0x5de3d6){const _0x1353d6=_0xe33385[0x0][_0x40836a(0x75a)](_0x509ffb[0x0],_0x153775[0x0]),_0xbec8=_0xe33385[0x1][_0x40836a(0x75a)](_0x509ffb[0x1],_0x153775[0x1])[_0x40836a(0x446)](),_0x283b0c=new RegExp(_0x265087[_0x40836a(0x75a)](_0xbec8),'i');_0x49f164[_0x1353d6]=_0x283b0c;}}else{if(!_0x11f846[_0x40836a(0x8c3)]())return;_0x572d96[_0x40836a(0x4f4)](_0x33c321,_0x3d2151);const _0x118f6d=_0x1c92a2['getLastPluginCommandInterpreter'](),_0x3e957e=_0x1e1568[_0x40836a(0x5bd)](_0x264a8a[_0x40836a(0x83d)]),_0x299359=_0x1710d2[_0x40836a(0x100)],_0x3488d8=_0x46af7b[_0x40836a(0x6f6)];if(!_0x118f6d)return;_0x5ec1e3[_0x40836a(0x2d8)](_0x3e957e,_0x299359,_0x3488d8);if(_0x41cb18[_0x40836a(0x610)])_0x118f6d[_0x40836a(0x3dc)]('battleAnimation');}}const _0x451309=[['%1StartActionJS','JS\x20%1START\x20ACTION'],[_0x40836a(0x673),_0x40836a(0x298)]];for(const _0x7a6822 of _0x451309){for(const _0x28b388 of _0x5de3d6){const _0x1d204d=_0x7a6822[0x0][_0x40836a(0x75a)](_0x28b388[0x0]),_0x3f185a=_0x7a6822[0x1][_0x40836a(0x75a)](_0x28b388[0x1]),_0x100777=new RegExp(_0x265087[_0x40836a(0x75a)](_0x3f185a),'i');_0x49f164[_0x1d204d]=_0x100777;}}const _0xe79ff3=[[_0x40836a(0x139),'JS\x20%1START\x20BATTLE'],['%1EndBattleJS',_0x40836a(0xaf8)],[_0x40836a(0x5af),_0x40836a(0x694)],[_0x40836a(0x4aa),_0x40836a(0x31c)],[_0x40836a(0x93b),'JS\x20ESCAPE\x20SUCCESS'],[_0x40836a(0x19a),_0x40836a(0x297)],[_0x40836a(0x75f),_0x40836a(0xac9)],[_0x40836a(0x199),_0x40836a(0x711)],[_0x40836a(0x720),_0x40836a(0x11f)]];for(const _0x10ac2d of _0xe79ff3){for(const _0x210ae2 of _0x5de3d6){if(_0x40836a(0x3b8)==='Muewq'){const _0xc51e81=_0x10ac2d[0x0][_0x40836a(0x75a)](_0x210ae2[0x0]),_0x49beec=_0x10ac2d[0x1][_0x40836a(0x75a)](_0x210ae2[0x1]),_0x3a53c5=new RegExp(_0x265087[_0x40836a(0x75a)](_0x49beec),'i');_0x49f164[_0xc51e81]=_0x3a53c5;}else _0x3fed83[_0x40836a(0x64d)]['friendsUnit']()[_0x40836a(0x38c)](_0x13536b);}}},Scene_Boot['prototype'][_0x208a24(0x331)]=function(){const _0x5cf1be=_0x208a24,_0x5b6f99=$dataSkills[_0x5cf1be(0x655)]($dataItems);for(const _0x4ee15c of _0x5b6f99){if(!_0x4ee15c)continue;VisuMZ[_0x5cf1be(0x759)][_0x5cf1be(0x3f1)](_0x4ee15c);}},Scene_Boot[_0x208a24(0xbd8)][_0x208a24(0x8b4)]=function(){const _0x11fdf0=_0x208a24,_0x337d24=$dataActors[_0x11fdf0(0x655)]($dataClasses,$dataWeapons,$dataArmors,$dataEnemies,$dataStates);for(const _0x78f6ad of _0x337d24){if(!_0x78f6ad)continue;VisuMZ[_0x11fdf0(0x759)][_0x11fdf0(0x391)](_0x78f6ad);}},Scene_Boot[_0x208a24(0xbd8)]['process_VisuMZ_BattleCore_BaseTroops']=function(){const _0x4b33b2=_0x208a24,_0x4a997d=VisuMZ[_0x4b33b2(0x759)]['Settings'][_0x4b33b2(0x79c)][_0x4b33b2(0x75d)],_0x3c4009=[];for(const _0xc56dd2 of _0x4a997d){if(_0x4b33b2(0xb4e)!==_0x4b33b2(0xb4e))this[_0x4b33b2(0x169)]=this['x'],this[_0x4b33b2(0x832)]=this['y'],this[_0x4b33b2(0x487)](),this[_0x4b33b2(0x20e)](),this['x']+=this[_0x4b33b2(0xc3)](),this['y']+=this[_0x4b33b2(0xbcc)](),this['y']+=this[_0x4b33b2(0x4e2)](),this['x']=_0x2bb698[_0x4b33b2(0x479)](this['x']),this['y']=_0x1681c7[_0x4b33b2(0x479)](this['y']);else{const _0x1f3fef=$dataTroops[_0xc56dd2];if(_0x1f3fef)_0x3c4009['push'](JsonEx[_0x4b33b2(0x2bb)](_0x1f3fef));}}for(const _0x5be263 of $dataTroops){if(!_0x5be263)continue;for(const _0x2bda6a of _0x3c4009){if(_0x4b33b2(0x975)!=='lGioc'){if(this['hasSvBattler']())this[_0x4b33b2(0x73b)][_0x4b33b2(0xc0)](_0x11f941);}else{if(_0x2bda6a['id']===_0x5be263['id'])continue;_0x5be263[_0x4b33b2(0xcea)]=_0x5be263[_0x4b33b2(0xcea)][_0x4b33b2(0x655)](_0x2bda6a[_0x4b33b2(0xcea)]);}}}},Scene_Boot[_0x208a24(0xbd8)]['process_VisuMZ_BattleCore_PreBattleCommonEvent']=function(){const _0x5f0791=_0x208a24,_0x19bc48=VisuMZ[_0x5f0791(0x759)][_0x5f0791(0xc39)]['Mechanics'];if(_0x19bc48[_0x5f0791(0xb33)]>0x0&&$dataCommonEvents[_0x19bc48[_0x5f0791(0xb33)]]){if(_0x5f0791(0xb47)!==_0x5f0791(0x4d1)){const _0x426631=$dataCommonEvents[_0x19bc48[_0x5f0791(0xb33)]],_0x2ced96=_0x426631[_0x5f0791(0x38d)][_0x5f0791(0x1ba)]-0x2,_0x662213=_0x426631[_0x5f0791(0x38d)][_0x2ced96];if(_0x662213&&_0x662213[_0x5f0791(0x762)]!==0xe6){if(_0x5f0791(0xb8c)!==_0x5f0791(0xb8c)){if(_0x203299['isTpb']()){if(this[_0x5f0791(0x1ef)]()<=0x0)return;}else{if(_0x52c8c6['turnCount']()<=0x0)return;}}else{const _0x1ee26f={'code':0xe6,'indent':0x0,'parameters':[0x1]},_0x28fd34=_0x426631[_0x5f0791(0x38d)][_0x5f0791(0x6ce)]();_0x426631[_0x5f0791(0x38d)][_0x5f0791(0x6fc)](_0x1ee26f),_0x426631[_0x5f0791(0x38d)][_0x5f0791(0x6fc)](_0x28fd34);}}}else{if(_0xb06a95[_0x5f0791(0x7fc)](/(.*):[ ](\d+)/i)){const _0x26de4=_0x90e2a(_0x20ea46['$1'])[_0x5f0791(0x446)](),_0x411d0b=_0x3be7a9(_0x1b6c2b['$2']);_0x15fa5c[_0x26de4]=_0x411d0b,_0x15c413+=_0x411d0b;}else{if(_0x286c45['match'](/(.*):[ ](\d+\.?\d+)/i)){const _0x3045e8=_0xbfe36c(_0x25bb7c['$1'])[_0x5f0791(0x446)](),_0x3c240c=_0x9921d(_0x373db7['$2']);_0x393428[_0x3045e8]=_0x3c240c,_0x44849f+=_0x3c240c;}else _0x41e191!==''&&(_0xf7665d[_0x39577d]=0x1,_0xd55109++);}}}},Scene_Boot['prototype'][_0x208a24(0x1b3)]=function(){const _0x199cfe=_0x208a24;VisuMZ[_0x199cfe(0x759)][_0x199cfe(0xac5)](),VisuMZ[_0x199cfe(0x759)]['BindCommonEventKeysForGroup']($dataSkills),VisuMZ['BattleCore'][_0x199cfe(0x97a)]($dataItems);},VisuMZ[_0x208a24(0x759)][_0x208a24(0xac5)]=function(){const _0x2911bd=_0x208a24;VisuMZ[_0x2911bd(0x759)]['_commonEventKey']={};for(const _0x5e2cfa of $dataCommonEvents){if(!_0x5e2cfa)continue;if(_0x5e2cfa[_0x2911bd(0x278)][_0x2911bd(0x7fc)](/\[(.*)\]/i)){if(_0x2911bd(0xb6d)!==_0x2911bd(0xb6d)){const _0x2c4a1a=this[_0x2911bd(0x6e4)](_0x5b5c98);if(_0x2c4a1a[_0x2911bd(0x7fc)](/\\I\[(\d+)\]/i)){const _0x5afbb3=this['itemLineRect'](_0x25ed53),_0x2a9ec6=this['textSizeEx'](_0x2c4a1a)['width'];return _0x2a9ec6<=_0x5afbb3[_0x2911bd(0x4fe)]?_0x2911bd(0x3e2):_0x2911bd(0xa86);}}else{let _0x2247f5=String(RegExp['$1'])[_0x2911bd(0x51f)](/,/g,'')[_0x2911bd(0x4d6)]()[_0x2911bd(0x446)]();VisuMZ[_0x2911bd(0x759)][_0x2911bd(0x3ba)][_0x2247f5]=_0x5e2cfa['id'];}}}},VisuMZ['BattleCore'][_0x208a24(0x97a)]=function(_0x94777e){const _0x2f214f=_0x208a24;for(const _0x1f2570 of _0x94777e){if(!_0x1f2570)continue;VisuMZ[_0x2f214f(0x759)][_0x2f214f(0x2ed)](_0x1f2570);}},VisuMZ['BattleCore'][_0x208a24(0x2ed)]=function(_0x2ae2bb){const _0x357b66=_0x208a24;if(!_0x2ae2bb)return;if(!_0x2ae2bb[_0x357b66(0x60a)])return;VisuMZ[_0x357b66(0x759)]['_commonEventKey']=VisuMZ[_0x357b66(0x759)][_0x357b66(0x3ba)]||{};const _0x514554=/<COMMON EVENT (?:KEY|KEYS):[ ](.*)>/gi,_0x1ef32f=/<COMMON EVENT (?:KEY|KEYS)>\s*([\s\S]*)\s*<\/COMMON EVENT (?:KEY|KEYS)>/i;let _0x12e39e=[];const _0x5e4bfd=_0x2ae2bb['note'][_0x357b66(0x7fc)](_0x514554);if(_0x5e4bfd){for(const _0x500442 of _0x5e4bfd){_0x500442[_0x357b66(0x7fc)](_0x514554);const _0x2ead59=String(RegExp['$1'])['split'](',')[_0x357b66(0x58e)](_0x16ea9b=>String(_0x16ea9b)['toUpperCase']()['trim']());_0x12e39e=_0x12e39e[_0x357b66(0x655)](_0x2ead59);}!_0x2ae2bb[_0x357b66(0x6c4)][_0x357b66(0x7fc)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x2ae2bb[_0x357b66(0x6c4)]+=_0x357b66(0x97f));;}if(_0x2ae2bb[_0x357b66(0x6c4)][_0x357b66(0x7fc)](_0x1ef32f)){if('TKBpz'!=='TKBpz')_0x2c4283['stepForward']();else{const _0x130ed5=String(RegExp['$1'])[_0x357b66(0xc85)](/[\r\n]+/)[_0x357b66(0x58e)](_0x5dd206=>String(_0x5dd206)[_0x357b66(0x4d6)]()[_0x357b66(0x446)]());_0x12e39e=_0x12e39e[_0x357b66(0x655)](_0x130ed5);!_0x2ae2bb[_0x357b66(0x6c4)][_0x357b66(0x7fc)](/<CUSTOM ACTION SEQUENCE>/i)&&(_0x2ae2bb['note']+=_0x357b66(0x97f));;}}for(const _0x5cde05 of _0x12e39e){if(VisuMZ['BattleCore']['_commonEventKey'][_0x5cde05]){const _0xfd354c=VisuMZ[_0x357b66(0x759)][_0x357b66(0x3ba)][_0x5cde05],_0x1c23c2={'code':0x2c,'dataId':_0xfd354c,'value1':0x1,'value2':0x0};_0x2ae2bb[_0x357b66(0x60a)][_0x357b66(0x7c3)](_0x1c23c2);}}},Scene_Boot[_0x208a24(0xbd8)][_0x208a24(0xca5)]=function(){const _0x253e61=_0x208a24,_0x590706=$dataSkills[_0x253e61(0x655)]($dataItems);for(const _0x2560fe of _0x590706){if(!_0x2560fe)continue;VisuMZ[_0x253e61(0x759)][_0x253e61(0x85a)](_0x2560fe);}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x9f8)]=VisuMZ[_0x208a24(0x9f8)],VisuMZ[_0x208a24(0x9f8)]=function(_0x46638a){const _0x26bfd1=_0x208a24;if(VisuMZ[_0x26bfd1(0x759)]['ParseActorNotetags']){if(_0x26bfd1(0x5ae)===_0x26bfd1(0x313))return![];else VisuMZ[_0x26bfd1(0x759)][_0x26bfd1(0x9f8)][_0x26bfd1(0x783)](this,_0x46638a);}VisuMZ[_0x26bfd1(0x759)][_0x26bfd1(0x391)](_0x46638a);},VisuMZ[_0x208a24(0x759)]['ParseClassNotetags']=VisuMZ['ParseClassNotetags'],VisuMZ[_0x208a24(0x44d)]=function(_0x26521b){const _0x311ae7=_0x208a24;if(VisuMZ['BattleCore'][_0x311ae7(0x44d)]){if(_0x311ae7(0xac2)!==_0x311ae7(0x7e0))VisuMZ[_0x311ae7(0x759)][_0x311ae7(0x44d)][_0x311ae7(0x783)](this,_0x26521b);else{if(this[_0x311ae7(0x594)]!==_0x59431a)return![];if(!_0x2a4782[_0x311ae7(0x8c3)]())return![];return _0x8175f3[_0x311ae7(0x759)][_0x311ae7(0xc39)][_0x311ae7(0x148)]['ShowPortraitsBorderStyle'];}}VisuMZ['BattleCore']['Parse_Notetags_TraitObjects'](_0x26521b);},VisuMZ[_0x208a24(0x759)]['ParseSkillNotetags']=VisuMZ[_0x208a24(0x728)],VisuMZ[_0x208a24(0x728)]=function(_0x338cb5){const _0x4e8214=_0x208a24;VisuMZ[_0x4e8214(0x759)]['ParseSkillNotetags']&&VisuMZ[_0x4e8214(0x759)][_0x4e8214(0x728)]['call'](this,_0x338cb5),VisuMZ[_0x4e8214(0x759)][_0x4e8214(0x3f1)](_0x338cb5),VisuMZ[_0x4e8214(0x759)][_0x4e8214(0x85a)](_0x338cb5);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x61e)]=VisuMZ['ParseItemNotetags'],VisuMZ[_0x208a24(0x61e)]=function(_0x1384e6){const _0x51935a=_0x208a24;if(VisuMZ[_0x51935a(0x759)][_0x51935a(0x61e)]){if('DtXLN'===_0x51935a(0x3c6))VisuMZ[_0x51935a(0x759)]['ParseItemNotetags'][_0x51935a(0x783)](this,_0x1384e6);else{let _0x163451=_0x56b666['createTroopNote'](_0x57182e['id']);this[_0x51935a(0x92f)](_0x163451);}}VisuMZ[_0x51935a(0x759)][_0x51935a(0x3f1)](_0x1384e6),VisuMZ[_0x51935a(0x759)]['Parse_Notetags_Targets'](_0x1384e6);},VisuMZ[_0x208a24(0x759)][_0x208a24(0xbc6)]=VisuMZ['ParseWeaponNotetags'],VisuMZ[_0x208a24(0xbc6)]=function(_0x594b52){const _0x2fecf5=_0x208a24;VisuMZ[_0x2fecf5(0x759)]['ParseWeaponNotetags']&&VisuMZ[_0x2fecf5(0x759)]['ParseWeaponNotetags'][_0x2fecf5(0x783)](this,_0x594b52),VisuMZ[_0x2fecf5(0x759)][_0x2fecf5(0x391)](_0x594b52);},VisuMZ[_0x208a24(0x759)]['ParseArmorNotetags']=VisuMZ['ParseArmorNotetags'],VisuMZ[_0x208a24(0x60d)]=function(_0x234e2d){const _0x3be656=_0x208a24;VisuMZ[_0x3be656(0x759)][_0x3be656(0x60d)]&&(_0x3be656(0x866)!==_0x3be656(0x267)?VisuMZ['BattleCore'][_0x3be656(0x60d)][_0x3be656(0x783)](this,_0x234e2d):_0x4a2f26[_0x3be656(0x63f)]=_0x265c82[_0x3be656(0xd06)]),VisuMZ[_0x3be656(0x759)][_0x3be656(0x391)](_0x234e2d);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x67c)]=VisuMZ[_0x208a24(0x67c)],VisuMZ['ParseEnemyNotetags']=function(_0x2384b1){const _0x4fb36c=_0x208a24;VisuMZ['BattleCore'][_0x4fb36c(0x67c)]&&VisuMZ[_0x4fb36c(0x759)][_0x4fb36c(0x67c)][_0x4fb36c(0x783)](this,_0x2384b1),VisuMZ[_0x4fb36c(0x759)][_0x4fb36c(0x391)](_0x2384b1);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x54a)]=VisuMZ[_0x208a24(0x54a)],VisuMZ[_0x208a24(0x54a)]=function(_0x567a91){const _0x4f6cdd=_0x208a24;VisuMZ['BattleCore'][_0x4f6cdd(0x54a)]&&VisuMZ['BattleCore'][_0x4f6cdd(0x54a)][_0x4f6cdd(0x783)](this,_0x567a91),VisuMZ['BattleCore'][_0x4f6cdd(0x391)](_0x567a91);},VisuMZ['BattleCore'][_0x208a24(0x3f1)]=function(_0x22fdfe){const _0x32c184=_0x208a24,_0x58a236=['PreApplyJS',_0x32c184(0xc23),_0x32c184(0x1e3),_0x32c184(0x890),'PreStartActionJS',_0x32c184(0xba3),_0x32c184(0x374),_0x32c184(0x69f)];for(const _0x16c00a of _0x58a236){VisuMZ['BattleCore'][_0x32c184(0xb81)](_0x22fdfe,_0x16c00a);}const _0x563a0a=_0x22fdfe[_0x32c184(0x6c4)];_0x563a0a['match'](/<ALWAYS CRITICAL/i)&&(_0x22fdfe[_0x32c184(0xae4)][_0x32c184(0x57d)]=!![]),_0x563a0a[_0x32c184(0x7fc)](/<(?:REPEAT|REPEATS|REPEAT HITS):[ ](\d+)/i)&&(_0x22fdfe[_0x32c184(0xcd0)]=Math[_0x32c184(0x6db)](0x1,Number(RegExp['$1']))),_0x563a0a[_0x32c184(0x7fc)](/<TARGET:[ ](.*)>/i)&&(_0x22fdfe[_0x32c184(0x9ab)]=String(RegExp['$1'])['toUpperCase']()['trim']());},VisuMZ['BattleCore'][_0x208a24(0x391)]=function(_0xd36eea){const _0x53e90e=_0x208a24,_0x2bd616=[_0x53e90e(0xbdf),_0x53e90e(0x143),_0x53e90e(0x10a),'PostDamageAsUserJS',_0x53e90e(0x486),_0x53e90e(0xb39),_0x53e90e(0xa4d),_0x53e90e(0x7b7),'PreStartActionJS',_0x53e90e(0xba3),_0x53e90e(0x374),_0x53e90e(0x69f),_0x53e90e(0xb76),_0x53e90e(0xb69),_0x53e90e(0x8a4),_0x53e90e(0xc4d),'BattleVictoryJS',_0x53e90e(0x4aa),_0x53e90e(0x93b),_0x53e90e(0x19a),'PreStartTurnJS','PostStartTurnJS','PreEndTurnJS',_0x53e90e(0xc22),_0x53e90e(0x8f1),_0x53e90e(0x974)];for(const _0x495f38 of _0x2bd616){if('McfCq'===_0x53e90e(0x285))return this[_0x53e90e(0x814)]()?_0x48a515[_0x53e90e(0x759)][_0x53e90e(0xc39)][_0x53e90e(0x5a5)][_0x53e90e(0x2eb)]:_0x1acd75[_0x53e90e(0x759)][_0x53e90e(0xc39)][_0x53e90e(0x6bd)]['SmoothImage'];else VisuMZ[_0x53e90e(0x759)][_0x53e90e(0xb81)](_0xd36eea,_0x495f38);}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x85a)]=function(_0x49bbaf){const _0x3c624e=_0x208a24,_0x25cbaf=_0x49bbaf['note'];if(_0x25cbaf[_0x3c624e(0x7fc)](/<JS TARGETS>\s*([\s\S]*)\s*<\/JS TARGETS>/i)){if(_0x3c624e(0x4e3)!==_0x3c624e(0x72c)){const _0x5811ea=String(RegExp['$1']),_0x3b150c=VisuMZ[_0x3c624e(0x759)]['createKeyJS'](_0x49bbaf,'Targets');VisuMZ[_0x3c624e(0x759)][_0x3c624e(0x7ca)](_0x5811ea,_0x3b150c);}else{const _0x61095e=_0x26a88e[_0x3c624e(0xc1b)][_0x3c624e(0xb92)];_0x61095e[_0x3c624e(0xb3e)](),_0x61095e[_0x3c624e(0x84f)](!![]),_0x61095e[_0x3c624e(0xa22)](),_0x61095e['deselect']();const _0x208331=_0x496450[_0x3c624e(0xc1b)][_0x3c624e(0x71c)](),_0x233fad=['xp',_0x3c624e(0x372),_0x3c624e(0x4f5)];if(_0x233fad[_0x3c624e(0xcaf)](_0x208331)){const _0x4c54e=_0x51a0e1[_0x3c624e(0xc1b)]['_statusWindow'];_0x4c54e['scale']['y']=0x0;}}}if(_0x25cbaf[_0x3c624e(0x7fc)](/<JS COMMAND (?:VISIBLE|SHOW|HIDE)>\s*([\s\S]*)\s*<\/JS COMMAND (?:VISIBLE|SHOW|HIDE)>/i)){if(_0x3c624e(0xb32)!=='KjmqK'){const _0x7d4d5f=String(RegExp['$1']),_0x2aaa76=VisuMZ[_0x3c624e(0x759)][_0x3c624e(0x362)](_0x49bbaf,_0x3c624e(0xa63));VisuMZ[_0x3c624e(0x759)]['createCommandVisibleJS'](_0x7d4d5f,_0x2aaa76);}else this[_0x3c624e(0x8fb)][_0x3c624e(0x6b6)]=_0x12742c,this[_0x3c624e(0x46b)][_0x3c624e(0x6c5)](_0x147e5e),this['_logWindow']['displayReflectionPlayBack'](_0x2d06ab,this[_0x3c624e(0x8fb)]),this['_action']['apply'](_0x34c2fd),this['_logWindow'][_0x3c624e(0x338)](_0xa11b6d,_0x992295);}},VisuMZ[_0x208a24(0x759)]['JS']={},VisuMZ[_0x208a24(0x759)]['createJS']=function(_0x4af4e1,_0xa483d0){const _0x24e436=_0x208a24,_0x335ab2=_0x4af4e1['note'];if(_0x335ab2['match'](VisuMZ[_0x24e436(0x759)]['RegExp'][_0xa483d0])){const _0x2d9a8d=RegExp['$1'],_0x225f0b='\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Arguments\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20user\x20=\x20arguments[0];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20target\x20=\x20arguments[1];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20obj\x20=\x20arguments[2];\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20value\x20=\x20arguments[3]\x20||\x200;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20originalValue\x20=\x20value;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Declare\x20Constants\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20action\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this\x20:\x20user.currentAction();\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20a\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20b\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20attacker\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20defender\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20healer\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20receiver\x20=\x20target;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20actor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20currentClass\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20skill\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20item\x20=\x20(this.constructor\x20===\x20Game_Action)\x20?\x20this.item()\x20:\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20weapon\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20armor\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20enemy\x20=\x20obj;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20const\x20state\x20=\x20obj;\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Create\x20Compatibility\x20Variables\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20let\x20origin\x20=\x20user;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(Imported.VisuMZ_1_SkillsStatesCore\x20&&\x20$dataStates.includes(obj))\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20origin\x20=\x20target.getStateOrigin(obj.id);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Process\x20Code\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20try\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20%1\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x20catch\x20(e)\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20console.log(e);\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20NaN\x20Check\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20(isNaN(value)){\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20if\x20($gameTemp.isPlaytest())\x20{\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27NaN\x20value\x20created\x20by\x20%2\x27.format(\x27\x27,obj.name));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20console.log(\x27Restoring\x20value\x20to\x20%2\x27.format(\x27\x27,originalValue));\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20value\x20=\x20originalValue;\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20}\x0a\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20//\x20Return\x20Value\x0a\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20return\x20value;\x0a\x20\x20\x20\x20\x20\x20\x20\x20'[_0x24e436(0x75a)](_0x2d9a8d),_0x204b4f=VisuMZ[_0x24e436(0x759)][_0x24e436(0x362)](_0x4af4e1,_0xa483d0);VisuMZ[_0x24e436(0x759)]['JS'][_0x204b4f]=new Function(_0x225f0b);}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x362)]=function(_0x2199e9,_0x258f92){const _0x47a893=_0x208a24;if(VisuMZ[_0x47a893(0x362)])return VisuMZ[_0x47a893(0x362)](_0x2199e9,_0x258f92);let _0x32f46b='';if($dataActors[_0x47a893(0xcaf)](_0x2199e9))_0x32f46b=_0x47a893(0xc65)[_0x47a893(0x75a)](_0x2199e9['id'],_0x258f92);if($dataClasses[_0x47a893(0xcaf)](_0x2199e9))_0x32f46b=_0x47a893(0x829)[_0x47a893(0x75a)](_0x2199e9['id'],_0x258f92);if($dataSkills['includes'](_0x2199e9))_0x32f46b=_0x47a893(0x3db)['format'](_0x2199e9['id'],_0x258f92);if($dataItems[_0x47a893(0xcaf)](_0x2199e9))_0x32f46b=_0x47a893(0xa3e)[_0x47a893(0x75a)](_0x2199e9['id'],_0x258f92);if($dataWeapons[_0x47a893(0xcaf)](_0x2199e9))_0x32f46b=_0x47a893(0xa00)[_0x47a893(0x75a)](_0x2199e9['id'],_0x258f92);if($dataArmors[_0x47a893(0xcaf)](_0x2199e9))_0x32f46b=_0x47a893(0xacd)[_0x47a893(0x75a)](_0x2199e9['id'],_0x258f92);if($dataEnemies['includes'](_0x2199e9))_0x32f46b='Enemy-%1-%2'['format'](_0x2199e9['id'],_0x258f92);if($dataStates['includes'](_0x2199e9))_0x32f46b=_0x47a893(0x7b8)[_0x47a893(0x75a)](_0x2199e9['id'],_0x258f92);return _0x32f46b;},VisuMZ['BattleCore']['createTargetsJS']=function(_0x27a26e,_0x56c833){const _0x37c236=_0x208a24,_0x495b98=_0x37c236(0xc2f)[_0x37c236(0x75a)](_0x27a26e);VisuMZ['BattleCore']['JS'][_0x56c833]=new Function(_0x495b98);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x63c)]=function(_0x132fe0,_0x340692){const _0x50ff82=_0x208a24,_0x4b6c1a=_0x50ff82(0x8e3)[_0x50ff82(0x75a)](_0x132fe0);VisuMZ['BattleCore']['JS'][_0x340692]=new Function(_0x4b6c1a);},TextManager[_0x208a24(0x402)]=VisuMZ['BattleCore'][_0x208a24(0xc39)]['PartyCmd'][_0x208a24(0x415)],TextManager[_0x208a24(0x4a7)]=VisuMZ[_0x208a24(0x759)]['Settings']['AutoBattle']['StartName'],TextManager[_0x208a24(0x22d)]=VisuMZ[_0x208a24(0x759)][_0x208a24(0xc39)][_0x208a24(0x2a2)]['StyleName'],TextManager[_0x208a24(0x17a)]=VisuMZ[_0x208a24(0x759)]['Settings']['HpGauge'][_0x208a24(0x2c7)],ColorManager[_0x208a24(0x33d)]=function(_0x52dabe){const _0x3b9dc3=_0x208a24;return _0x52dabe=String(_0x52dabe),_0x52dabe['match'](/#(.*)/i)?_0x3b9dc3(0x296)['format'](String(RegExp['$1'])):this[_0x3b9dc3(0x119)](Number(_0x52dabe));},DataManager['getDamageStyle']=function(_0x4f854d){const _0x1d87d1=_0x208a24;if(_0x4f854d[_0x1d87d1(0x6c4)][_0x1d87d1(0x7fc)](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x781f67=String(RegExp['$1'])[_0x1d87d1(0x4d6)]()[_0x1d87d1(0x446)]();if(_0x781f67===_0x1d87d1(0xac7))return'MANUAL';if(VisuMZ[_0x1d87d1(0x4a8)][_0x781f67])return _0x781f67;}const _0x215281=VisuMZ[_0x1d87d1(0x759)][_0x1d87d1(0xc39)][_0x1d87d1(0x7a9)][_0x1d87d1(0x559)][_0x1d87d1(0x4d6)]()['trim']();if(VisuMZ[_0x1d87d1(0x4a8)][_0x215281])return _0x215281;return _0x1d87d1(0xac7);},DataManager['getStypeIdWithName']=function(_0x7e8871){const _0xca8348=_0x208a24;_0x7e8871=_0x7e8871['toUpperCase']()[_0xca8348(0x446)](),this[_0xca8348(0xa32)]=this[_0xca8348(0xa32)]||{};if(this['_stypeIDs'][_0x7e8871])return this[_0xca8348(0xa32)][_0x7e8871];for(let _0x455afd=0x1;_0x455afd<0x64;_0x455afd++){if(!$dataSystem[_0xca8348(0x389)][_0x455afd])continue;let _0x118a4d=$dataSystem['skillTypes'][_0x455afd][_0xca8348(0x4d6)]()['trim']();_0x118a4d=_0x118a4d[_0xca8348(0x51f)](/\x1I\[(\d+)\]/gi,''),_0x118a4d=_0x118a4d[_0xca8348(0x51f)](/\\I\[(\d+)\]/gi,''),this['_stypeIDs'][_0x118a4d]=_0x455afd;}return this[_0xca8348(0xa32)][_0x7e8871]||0x0;},DataManager[_0x208a24(0x51c)]=function(_0x39390c){const _0x2c3edc=_0x208a24;_0x39390c=_0x39390c[_0x2c3edc(0x4d6)]()[_0x2c3edc(0x446)](),this[_0x2c3edc(0x492)]=this['_skillIDs']||{};if(this[_0x2c3edc(0x492)][_0x39390c])return this[_0x2c3edc(0x492)][_0x39390c];for(const _0x34fcf7 of $dataSkills){if(_0x2c3edc(0x409)!==_0x2c3edc(0x5b0)){if(!_0x34fcf7)continue;this[_0x2c3edc(0x492)][_0x34fcf7[_0x2c3edc(0x278)][_0x2c3edc(0x4d6)]()[_0x2c3edc(0x446)]()]=_0x34fcf7['id'];}else{if(!_0x1a1f7f[_0x2c3edc(0x8c3)]())return;_0x4167f1[_0x2c3edc(0x4f4)](_0x32facb,_0xd70567);const _0x5270d4=_0x385fb6[_0x2c3edc(0x8fb)],_0x53ae77={'arPenRate':_0x4abee7[_0x2c3edc(0x31a)],'arPenFlat':_0x543675['ArPenFlat'],'arRedRate':_0xff2a51[_0x2c3edc(0x11c)],'arRedFlat':_0x4ab0f1[_0x2c3edc(0x89a)]};_0x5270d4['_armorPenetration']=_0x53ae77;}}return this[_0x2c3edc(0x492)][_0x39390c]||0x0;},DataManager[_0x208a24(0xbbb)]=function(_0x554e6d){const _0x3b4076=_0x208a24;_0x554e6d=_0x554e6d[_0x3b4076(0x4d6)]()[_0x3b4076(0x446)](),this['_enemyIDs']=this[_0x3b4076(0xa7d)]||{};if(this[_0x3b4076(0xa7d)][_0x554e6d])return this[_0x3b4076(0xa7d)][_0x554e6d];for(const _0x1d39e2 of $dataEnemies){if(_0x3b4076(0x924)!==_0x3b4076(0xbce)){if(!_0x1d39e2)continue;this[_0x3b4076(0xa7d)][_0x1d39e2[_0x3b4076(0x278)][_0x3b4076(0x4d6)]()[_0x3b4076(0x446)]()]=_0x1d39e2['id'];}else _0x2e1f03['prototype'][_0x3b4076(0x18e)][_0x3b4076(0x783)](this);}return this[_0x3b4076(0xa7d)][_0x554e6d]||0x0;},DataManager[_0x208a24(0x75b)]=function(_0x463afa){const _0x1869a6=_0x208a24;_0x463afa=_0x463afa[_0x1869a6(0x4d6)]()[_0x1869a6(0x446)](),this[_0x1869a6(0x699)]=this[_0x1869a6(0x699)]||{};if(this[_0x1869a6(0x699)][_0x463afa])return this[_0x1869a6(0x699)][_0x463afa];for(let _0x5ced8a=0x1;_0x5ced8a<0x64;_0x5ced8a++){if(!$dataSystem['weaponTypes'][_0x5ced8a])continue;let _0x5ee329=$dataSystem[_0x1869a6(0xae)][_0x5ced8a][_0x1869a6(0x4d6)]()['trim']();_0x5ee329=_0x5ee329[_0x1869a6(0x51f)](/\x1I\[(\d+)\]/gi,''),_0x5ee329=_0x5ee329[_0x1869a6(0x51f)](/\\I\[(\d+)\]/gi,''),this[_0x1869a6(0x699)][_0x5ee329]=_0x5ced8a;}return this[_0x1869a6(0x699)][_0x1869a6(0x591)]=0x0,this[_0x1869a6(0x699)][_0x463afa]||0x0;},DataManager[_0x208a24(0x7bb)]=function(_0x1ff487){const _0xabb5cf=_0x208a24,_0x3beeda=_0xabb5cf(0x98a);let _0x18a678=_0x1ff487[_0xabb5cf(0x16f)],_0x4b5480=_0x1ff487['name'];const _0x3e41d9=_0x1ff487[_0xabb5cf(0x6c4)];return _0x3e41d9[_0xabb5cf(0x7fc)](/<DISPLAY ICON: (\d+)>/i)&&(_0x18a678=Number(RegExp['$1'])),_0x3e41d9[_0xabb5cf(0x7fc)](/<DISPLAY TEXT: (.*)>/i)&&(_0x4b5480=String(RegExp['$1'])),_0x3beeda[_0xabb5cf(0x75a)](_0x18a678,_0x4b5480);},DataManager[_0x208a24(0x157)]=function(_0xce3b23){const _0x3acc10=_0x208a24;if(_0xce3b23['note']['match'](/<COMMAND TEXT: (.*)>/i)){if(_0x3acc10(0xa7c)!==_0x3acc10(0x39b))return String(RegExp['$1']);else{const _0x52a52e=this[_0x3acc10(0xd08)]();if(_0x52a52e&&_0xdebe0c)_0x52a52e['stepForward']();return;}}else{if(_0x3acc10(0x3e6)!==_0x3acc10(0x3e6))_0xa859b2+=_0x1b3f25,_0x162281+=_0x553573;else return _0xce3b23[_0x3acc10(0x278)];}},DataManager['battleCommandIcon']=function(_0x4210e8){const _0x205291=_0x208a24;if(_0x4210e8['note']['match'](/<COMMAND ICON: (\d+)>/i))return Number(RegExp['$1']);else{if(_0x205291(0x26a)!==_0x205291(0x26a)){this[_0x205291(0xce2)]=this[_0x205291(0xce2)]||{};const _0x3b8f1c=_0x30797b[_0x205291(0x3a6)]();this[_0x205291(0xce2)][_0x3b8f1c]=_0x9dcc3e;}else return _0x4210e8[_0x205291(0x16f)];}},DataManager[_0x208a24(0x2f2)]=function(_0x1ab05f){const _0x24b89e=_0x208a24,_0x184474=$dataEnemies[_0x1ab05f];if(_0x184474){if(_0x184474[_0x24b89e(0x6c4)]['match'](/<SWAP ENEMIES>\s*([\s\S]*)\s*<\/SWAP ENEMIES>/i)){if('eSZUD'===_0x24b89e(0xd13)){const _0x2cdada=_0x577c97[_0x24b89e(0x759)][_0x24b89e(0xc39)][_0x24b89e(0x2a2)],_0x71bfa8=this[_0x24b89e(0x225)]('autoBattleUseSkills');return _0x71bfa8?_0x2cdada[_0x24b89e(0x371)]:_0x2cdada[_0x24b89e(0x509)];}else{const _0x3dd888=String(RegExp['$1'])[_0x24b89e(0xc85)](/[\r\n]+/)[_0x24b89e(0x44b)](''),_0x1b9e00=this[_0x24b89e(0x382)](_0x3dd888);_0x1ab05f=this[_0x24b89e(0xbbb)](_0x1b9e00)||_0x1ab05f,_0x1ab05f=DataManager[_0x24b89e(0x2f2)](_0x1ab05f);}}}return _0x1ab05f;},DataManager['processRandomizedData']=function(_0x4d4cd1){const _0x4aa78d=_0x208a24;let _0x3a34ae=0x0;const _0x34ff76={};for(const _0x4d6f78 of _0x4d4cd1){if(_0x4d6f78[_0x4aa78d(0x7fc)](/(.*):[ ](\d+)/i)){if(_0x4aa78d(0x65d)!==_0x4aa78d(0xc24)){const _0xfdaef0=String(RegExp['$1'])[_0x4aa78d(0x446)](),_0xc46b52=Number(RegExp['$2']);_0x34ff76[_0xfdaef0]=_0xc46b52,_0x3a34ae+=_0xc46b52;}else _0x3879b2+=_0x1eeb60['Actor'][_0x4aa78d(0x7ae)]||0x0,_0x726785+=_0x2aa34c[_0x4aa78d(0x5a5)][_0x4aa78d(0x153)]||0x0;}else{if(_0x4d6f78['match'](/(.*):[ ](\d+\.?\d+)/i)){const _0x5522cf=String(RegExp['$1'])['trim'](),_0xd56013=Number(RegExp['$2']);_0x34ff76[_0x5522cf]=_0xd56013,_0x3a34ae+=_0xd56013;}else _0x4d6f78!==''&&(_0x34ff76[_0x4d6f78]=0x1,_0x3a34ae++);}}if(_0x3a34ae<=0x0)return'';let _0x3ebfa5=Math[_0x4aa78d(0x39f)]()*_0x3a34ae;for(const _0xc5d2d3 in _0x34ff76){_0x3ebfa5-=_0x34ff76[_0xc5d2d3];if(_0x3ebfa5<=0x0)return _0xc5d2d3;}return'';},DataManager[_0x208a24(0x595)]=function(_0x2ea13a){const _0x57a954=_0x208a24;if(!_0x2ea13a)return![];if(!VisuMZ[_0x57a954(0x759)][_0x57a954(0xc39)][_0x57a954(0x9b7)][_0x57a954(0xa50)])return![];if(_0x2ea13a[_0x57a954(0x6c4)][_0x57a954(0x7fc)](/<AUTO ACTION SEQUENCE>/i))return![];if(_0x2ea13a[_0x57a954(0x6c4)][_0x57a954(0x7fc)](/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi))return!![];for(const _0x2de0b8 of _0x2ea13a[_0x57a954(0x60a)]){if('AOWqw'==='ZjIMy')_0x3ebb59[_0x57a954(0x9e8)][_0x57a954(0x738)]<1.15&&(_0x117f12(_0x185069[_0x57a954(0x75a)]('STB')),_0x3ddfe1[_0x57a954(0x1b1)]());else{if(!_0x2de0b8)continue;if(_0x2de0b8[_0x57a954(0x762)]===Game_Action['EFFECT_COMMON_EVENT'])return!![];}}return![];},DataManager[_0x208a24(0x582)]=function(_0x4bb563){const _0x5df20c=_0x208a24,_0x127887=$dataTroops[_0x4bb563];if(!_0x127887)return'';let _0x5c8a34='';_0x5c8a34+=_0x127887[_0x5df20c(0x278)];for(const _0x51222e of _0x127887[_0x5df20c(0xcea)]){if(_0x5df20c(0x578)!==_0x5df20c(0x578))_0x2a32b7[_0x5df20c(0x7f9)](_0x536b59(_0x107166['$1']));else for(const _0x1d1087 of _0x51222e[_0x5df20c(0x38d)]){if([0x6c,0x198][_0x5df20c(0xcaf)](_0x1d1087[_0x5df20c(0x762)])){if(_0x5df20c(0x747)==='KHjur')return _0x4fecfe(_0x32677b['$1']);else _0x5c8a34+='\x0a',_0x5c8a34+=_0x1d1087[_0x5df20c(0x378)][0x0];}}}return _0x5c8a34;},ConfigManager['autoBattleAtStart']=ConfigManager[_0x208a24(0xc99)]??![],ConfigManager['autoBattleUseSkills']=ConfigManager[_0x208a24(0xca8)]??![],ConfigManager[_0x208a24(0x17a)]=ConfigManager[_0x208a24(0x17a)]??!![],VisuMZ[_0x208a24(0x759)][_0x208a24(0x16b)]=ConfigManager[_0x208a24(0x571)],ConfigManager[_0x208a24(0x571)]=function(){const _0x3418df=_0x208a24,_0x4e7006=VisuMZ[_0x3418df(0x759)]['ConfigManager_makeData'][_0x3418df(0x783)](this);return _0x4e7006[_0x3418df(0xc99)]=this[_0x3418df(0xc99)],_0x4e7006[_0x3418df(0xca8)]=this[_0x3418df(0xca8)],_0x4e7006[_0x3418df(0x17a)]=this[_0x3418df(0x17a)],_0x4e7006;},VisuMZ[_0x208a24(0x759)][_0x208a24(0x3b1)]=ConfigManager[_0x208a24(0x897)],ConfigManager['applyData']=function(_0xc6b177){const _0x28e5ad=_0x208a24;VisuMZ[_0x28e5ad(0x759)][_0x28e5ad(0x3b1)][_0x28e5ad(0x783)](this,_0xc6b177);_0x28e5ad(0xc99)in _0xc6b177?'qBrQM'!==_0x28e5ad(0x455)?this[_0x28e5ad(0xc99)]=_0xc6b177[_0x28e5ad(0xc99)]:!this[_0x28e5ad(0x166)]()&&!this[_0x28e5ad(0x46b)][_0x28e5ad(0x7ee)]()&&(this[_0x28e5ad(0x558)]=_0x28e5ad(0x590)):this['autoBattleAtStart']=![];if('autoBattleUseSkills'in _0xc6b177)this['autoBattleUseSkills']=_0xc6b177[_0x28e5ad(0xca8)];else{if('ZzpaY'!==_0x28e5ad(0x38f))this[_0x28e5ad(0xca8)]=![];else{_0x282d86[_0x28e5ad(0x759)][_0x28e5ad(0x441)][_0x28e5ad(0x783)](this);if(!_0x49dc35['isTpb']())_0xb144b7[_0x28e5ad(0x21e)]=null;}}'visualHpGauge'in _0xc6b177?_0x28e5ad(0x87c)!=='gAFFw'?_0x48ac22[_0x28e5ad(0x2f3)]([_0x403b3a]):this[_0x28e5ad(0x17a)]=_0xc6b177[_0x28e5ad(0x17a)]:this['visualHpGauge']=!![];},ImageManager[_0x208a24(0x46e)]=ImageManager[_0x208a24(0x46e)]||0x9,ImageManager[_0x208a24(0x9c9)]=ImageManager[_0x208a24(0x9c9)]||0x6,VisuMZ[_0x208a24(0x759)][_0x208a24(0xab4)]=BattleManager[_0x208a24(0x876)],BattleManager[_0x208a24(0x876)]=function(_0x152f16,_0x1a9566,_0x20be5f){const _0x198c83=_0x208a24;VisuMZ['BattleCore'][_0x198c83(0xab4)][_0x198c83(0x783)](this,_0x152f16,_0x1a9566,_0x20be5f),this[_0x198c83(0x4db)]={};},VisuMZ[_0x208a24(0x759)][_0x208a24(0x2ec)]=BattleManager[_0x208a24(0xa17)],BattleManager['initMembers']=function(){const _0x134726=_0x208a24;VisuMZ[_0x134726(0x759)][_0x134726(0x2ec)][_0x134726(0x783)](this),this[_0x134726(0xb9)]=[];},BattleManager[_0x208a24(0x761)]=function(){const _0xef05a8=_0x208a24;if(!SceneManager[_0xef05a8(0x8c3)]())return;const _0x3514ec=SceneManager[_0xef05a8(0xc1b)][_0xef05a8(0xb91)];if(_0x3514ec)_0x3514ec[_0xef05a8(0x180)]();},BattleManager['battleSys']=function(){const _0xa5c448=_0x208a24;if(BattleManager[_0xa5c448(0xd25)]())return'TPB';return'DTB';},BattleManager['isBattleSys']=function(_0x35bd99){const _0x4fb1e7=_0x208a24;return _0x35bd99=_0x35bd99[_0x4fb1e7(0x4d6)]()[_0x4fb1e7(0x446)](),this['battleSys']()===_0x35bd99;},BattleManager[_0x208a24(0xb99)]=function(){const _0x3ffb92=_0x208a24;return this[_0x3ffb92(0x743)](_0x3ffb92(0x602));},BattleManager[_0x208a24(0x270)]=function(){const _0x351786=_0x208a24;return this[_0x351786(0xb99)]();},BattleManager[_0x208a24(0xff)]=function(){const _0x327454=_0x208a24;return!this[_0x327454(0x270)]();},BattleManager['isTeamBased']=function(){const _0x2ec01b=_0x208a24;return!this[_0x2ec01b(0x270)]()&&!this[_0x2ec01b(0xff)]();},BattleManager['getBattlerFromKey']=function(_0x2e82b7){const _0xbf9dbe=_0x208a24;this['_battlerKeyCache']=this[_0xbf9dbe(0x4db)]||{};if(this[_0xbf9dbe(0x4db)][_0x2e82b7]!==undefined)return this[_0xbf9dbe(0x4db)][_0x2e82b7];this[_0xbf9dbe(0x4db)][_0x2e82b7]=null;const _0x1ac583=this[_0xbf9dbe(0xbc8)](),_0x35fc9d=_0x1ac583[_0xbf9dbe(0x44c)](_0x33f08d=>_0x33f08d['battlerKey']()===_0x2e82b7);if(_0x35fc9d)this[_0xbf9dbe(0x4db)][_0x2e82b7]=_0x35fc9d;return this['_battlerKeyCache'][_0x2e82b7];},Game_BattlerBase['prototype'][_0x208a24(0x3a6)]=function(){const _0x478d3b=_0x208a24;return _0x478d3b(0xcc7)[_0x478d3b(0x75a)](this[_0x478d3b(0x9bf)]()?'actor':_0x478d3b(0x449),this[_0x478d3b(0x278)]());},Game_Action['prototype']['setTargetBattlerKey']=function(_0x3c7345){const _0x4c51fd=_0x208a24;if(this[_0x4c51fd(0x570)]!=='')return;typeof _0x3c7345===_0x4c51fd(0x32d)?this[_0x4c51fd(0x570)]=_0x3c7345[_0x4c51fd(0x717)]()['trim']():this['_targetBattlerKey']=_0x3c7345[_0x4c51fd(0x3a6)]();},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x6f5)]=function(){const _0x52c5de=_0x208a24;return[this[_0x52c5de(0xb96)]()];},Game_Action[_0x208a24(0xbd8)][_0x208a24(0xb96)]=function(){const _0x201e87=_0x208a24,_0x451c8a=this[_0x201e87(0x570)]||'',_0x3429e6=BattleManager[_0x201e87(0x18c)](_0x451c8a);if(!_0x3429e6)return this[_0x201e87(0x871)]();if(!_0x3429e6[_0x201e87(0x97c)]())return this[_0x201e87(0x871)]();return _0x3429e6;},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x871)]=function(){const _0x41cad3=_0x208a24,_0x1cf14a=this[_0x41cad3(0x570)];return _0x1cf14a[_0x41cad3(0x7fc)](/ACTOR/i)?this['friendsUnit']()[_0x41cad3(0xc9a)]():this[_0x41cad3(0x505)]()[_0x41cad3(0xc9a)]();},BattleManager[_0x208a24(0x6fd)]=function(){const _0x4031f9=_0x208a24;return this[_0x4031f9(0xbc8)]()[_0x4031f9(0x5a8)](_0x2ba3d8=>_0x2ba3d8[_0x4031f9(0xacb)]());},BattleManager['processBattleCoreJS']=function(_0x1aa8f9){const _0x316b71=_0x208a24;_0x1aa8f9===_0x316b71(0x5af)&&(this[_0x316b71(0x8f0)]=!![]),$gameParty['processBattleCoreJS'](_0x1aa8f9),$gameTroop[_0x316b71(0x192)](_0x1aa8f9);},VisuMZ[_0x208a24(0x759)]['BattleManager_startBattle']=BattleManager[_0x208a24(0x81a)],BattleManager[_0x208a24(0x81a)]=function(){const _0x1db3ff=_0x208a24;this['_endBattle']=![],this[_0x1db3ff(0x29c)]=ConfigManager['autoBattleAtStart'],this[_0x1db3ff(0x8f0)]=![],this[_0x1db3ff(0x192)](_0x1db3ff(0xb76)),VisuMZ[_0x1db3ff(0x759)][_0x1db3ff(0xc3c)][_0x1db3ff(0x783)](this),this['processBattleCoreJS']('PostStartBattleJS');},BattleManager[_0x208a24(0x4e7)]=function(_0x2a1214){const _0x2ecb20=_0x208a24,_0xd7a54c=VisuMZ[_0x2ecb20(0x759)]['Settings']['Mechanics'];_0x2a1214!==_0x2ecb20(0x243)&&_0xd7a54c[_0x2ecb20(0x2fe)]&&VisuMZ[_0x2ecb20(0x759)][_0x2ecb20(0xc73)](_0xd7a54c[_0x2ecb20(0x2fe)])&&(_0x2ecb20(0x286)===_0x2ecb20(0x6d7)?this['push'](_0x2ecb20(0x9a1),this[_0x2ecb20(0x12b)](_0x40c7ac)):$gameTemp[_0x2ecb20(0x436)](_0xd7a54c[_0x2ecb20(0x2fe)]));const _0x357766=_0x2ecb20(0xb63)[_0x2ecb20(0x75a)](_0x2a1214);_0xd7a54c[_0x357766]&&VisuMZ['BattleCore'][_0x2ecb20(0xc73)](_0xd7a54c[_0x357766])&&$gameTemp['reserveCommonEvent'](_0xd7a54c[_0x357766]);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x682)]=BattleManager['abort'],BattleManager[_0x208a24(0x4f6)]=function(){const _0x217167=_0x208a24;VisuMZ[_0x217167(0x759)][_0x217167(0x682)][_0x217167(0x783)](this);if(SceneManager[_0x217167(0x8c3)]()){if('pUFof'!==_0x217167(0x5ad)){if(!this['enemy']())return;_0x21fc7b[_0x217167(0x76f)]()?this['x']=_0x43100c[_0x217167(0xa53)]-this['enemy']()[_0x217167(0xd08)]()[_0x217167(0x169)]:this['x']=this[_0x217167(0x449)]()[_0x217167(0xd08)]()[_0x217167(0x169)];this['x']-=_0x3cc6c6['round'](this[_0x217167(0x4fe)]/0x2),this['y']=this[_0x217167(0x449)]()['battler']()[_0x217167(0x832)]-_0xcea1c8[_0x217167(0xd50)](this[_0x217167(0x146)]()*1.5);const _0xa4aef4=_0x43c38d[_0x217167(0x759)][_0x217167(0xc39)][_0x217167(0x6bd)];this['x']+=_0xa4aef4[_0x217167(0xc30)]||0x0,this['y']+=_0xa4aef4[_0x217167(0xb46)]||0x0;}else BattleManager[_0x217167(0x89f)]();}},VisuMZ[_0x208a24(0x759)][_0x208a24(0xacc)]=BattleManager['checkBattleEnd'],BattleManager[_0x208a24(0x820)]=function(){const _0x24d4ac=_0x208a24;if(this[_0x24d4ac(0x558)]===_0x24d4ac(0x6d6)){if($gameTemp[_0x24d4ac(0x290)]())return![];}return VisuMZ[_0x24d4ac(0x759)][_0x24d4ac(0xacc)]['call'](this);},VisuMZ['BattleCore']['BattleManager_processVictory']=BattleManager['processVictory'],BattleManager[_0x208a24(0x7b2)]=function(){const _0x10107d=_0x208a24;this['_endingBattle']=!![],this['processBattleCoreJS'](_0x10107d(0x5af)),VisuMZ[_0x10107d(0x759)][_0x10107d(0x16d)][_0x10107d(0x783)](this),this[_0x10107d(0x4e7)](_0x10107d(0x4e1));},VisuMZ[_0x208a24(0x759)]['BattleManager_processAbort']=BattleManager['processAbort'],BattleManager[_0x208a24(0xb0f)]=function(){const _0x2fa924=_0x208a24;this[_0x2fa924(0x8f0)]=!![],VisuMZ[_0x2fa924(0x759)][_0x2fa924(0x930)]['call'](this);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x359)]=BattleManager['processDefeat'],BattleManager['processDefeat']=function(){const _0xe50eed=_0x208a24;this['_endingBattle']=!![],this[_0xe50eed(0x192)]('BattleDefeatJS'),VisuMZ[_0xe50eed(0x759)]['BattleManager_processDefeat'][_0xe50eed(0x783)](this),this['processPostBattleCommonEvents'](_0xe50eed(0xba9));},VisuMZ[_0x208a24(0x759)][_0x208a24(0x31d)]=BattleManager[_0x208a24(0x209)],BattleManager[_0x208a24(0x209)]=function(_0x185964){const _0x2799f6=_0x208a24;this[_0x2799f6(0x478)]=!![],this[_0x2799f6(0x29c)]=![],this[_0x2799f6(0x192)](_0x2799f6(0x8a4)),VisuMZ[_0x2799f6(0x759)][_0x2799f6(0x31d)][_0x2799f6(0x783)](this,_0x185964),this[_0x2799f6(0x192)](_0x2799f6(0xc4d));},VisuMZ[_0x208a24(0x759)][_0x208a24(0x8ea)]=BattleManager['startTurn'],BattleManager[_0x208a24(0x7cd)]=function(){const _0x786c4f=_0x208a24;if(this[_0x786c4f(0x270)]())this[_0x786c4f(0x192)]('PreStartTurnJS');VisuMZ[_0x786c4f(0x759)][_0x786c4f(0x8ea)][_0x786c4f(0x783)](this);if(this[_0x786c4f(0x270)]())this['processBattleCoreJS']('PostStartTurnJS');},BattleManager[_0x208a24(0xc28)]=function(){const _0x3d2116=_0x208a24,_0x346bbc=this[_0x3d2116(0x64d)],_0x4d1417=_0x346bbc[_0x3d2116(0xa7b)]();if(_0x4d1417){if(_0x3d2116(0xbbf)!==_0x3d2116(0x4e8))_0x4d1417[_0x3d2116(0x1bd)](),_0x4d1417[_0x3d2116(0x461)]()?_0x3d2116(0x5fe)!==_0x3d2116(0x3d4)?(this[_0x3d2116(0xb00)](),_0x346bbc[_0x3d2116(0x6b0)]()):_0x484def['Actor'][_0x3d2116(0x2eb)]=![]:(_0x346bbc[_0x3d2116(0x6b0)](),this[_0x3d2116(0x5df)]());else{let _0x2ebe61=-0x10,_0x341b02=this[_0x3d2116(0x1fa)]*0.5;const _0x3a3c8b=/<SIDEVIEW WEAPON OFFSET:[ ]([\+\-]\d+),[ ]([\+\-]\d+)>/i,_0x278ac1=this[_0x3d2116(0xa4c)][_0x3d2116(0x8ce)]()[_0x3d2116(0x58e)](_0x2bd193=>_0x2bd193&&_0x2bd193[_0x3d2116(0x6c4)][_0x3d2116(0x7fc)](_0x3a3c8b)?_0x248a15(_0xd67b09['$1']):0x0),_0x2389c1=this[_0x3d2116(0xa4c)][_0x3d2116(0x8ce)]()[_0x3d2116(0x58e)](_0x2ec3c0=>_0x2ec3c0&&_0x2ec3c0['note'][_0x3d2116(0x7fc)](_0x3a3c8b)?_0x523cf8(_0x3d23c6['$2']):0x0);_0x2ebe61=_0x278ac1[_0x3d2116(0x5dd)]((_0x4d8ae8,_0x1892a7)=>_0x4d8ae8+_0x1892a7,_0x2ebe61),_0x341b02=_0x2389c1[_0x3d2116(0x5dd)]((_0x42c88f,_0x3d2b5f)=>_0x42c88f+_0x3d2b5f,_0x341b02),this[_0x3d2116(0x799)]['x']=_0x2ebe61,this[_0x3d2116(0x799)]['y']=_0x341b02,this['_weaponSprite'][_0x3d2116(0x3c1)]();}}else _0x3d2116(0x36d)!==_0x3d2116(0xbe3)?(this['endAction'](),this[_0x3d2116(0x64d)]=null):_0xfafdb7[_0x3d2116(0x3dc)]('cutinEnter');},VisuMZ['BattleCore']['BattleManager_startAction']=BattleManager[_0x208a24(0xb00)],BattleManager[_0x208a24(0xb00)]=function(){const _0x391b58=_0x208a24,_0x24c55a=this[_0x391b58(0x64d)][_0x391b58(0xa7b)](),_0x109d4f=this[_0x391b58(0x64d)];_0x24c55a&&_0x24c55a[_0x391b58(0x6a9)]()===_0x109d4f&&_0x24c55a[_0x391b58(0x84e)](_0x391b58(0xd5a)),VisuMZ[_0x391b58(0x759)]['BattleManager_startAction']['call'](this),_0x24c55a&&_0x24c55a[_0x391b58(0x6a9)]()===_0x109d4f&&_0x24c55a['actionBattleCoreJS'](_0x391b58(0xba3));},VisuMZ[_0x208a24(0x759)][_0x208a24(0xa46)]=BattleManager[_0x208a24(0x5df)],BattleManager['endAction']=function(){const _0x220f77=_0x208a24,_0x46a186=this[_0x220f77(0x8fb)],_0x1f65f9=this['_subject'];_0x46a186&&_0x46a186!==this[_0x220f77(0xbb7)]&&_0x46a186[_0x220f77(0x6a9)]()===_0x1f65f9&&(_0x220f77(0x79d)!=='zcbSG'?_0x46a186[_0x220f77(0x84e)](_0x220f77(0x374)):this[_0x220f77(0xca)][_0x220f77(0x3b3)]=this['isOpen']());if(this['_subject']){if('AdrUN'===_0x220f77(0x9a4)){if(_0x3e3671[_0x220f77(0x394)]())return;if(!_0x100a82)return;if(!_0x5a2708[_0x220f77(0x7d2)]())return;_0x19ed36[_0x220f77(0x759)][_0x220f77(0x839)][_0x220f77(0x783)](this);}else VisuMZ[_0x220f77(0x759)][_0x220f77(0xa46)][_0x220f77(0x783)](this);}else this[_0x220f77(0x558)]=_0x220f77(0x6d6);_0x46a186&&_0x46a186!==this['_lastAction']&&_0x46a186['subject']()===_0x1f65f9&&_0x46a186[_0x220f77(0x84e)](_0x220f77(0x69f)),this[_0x220f77(0x440)](this[_0x220f77(0xbc8)]()),this[_0x220f77(0xbb7)]=this['_action'];},BattleManager[_0x208a24(0x440)]=function(_0x1ae0ab){const _0x17befa=_0x208a24;for(const _0xeef823 of _0x1ae0ab){if(!_0xeef823)continue;if(!_0xeef823[_0x17befa(0xd08)]())continue;_0xeef823[_0x17befa(0xd08)]()[_0x17befa(0x4a2)]();}},BattleManager[_0x208a24(0x767)]=function(){const _0x549c9b=_0x208a24;!this[_0x549c9b(0x46b)][_0x549c9b(0x7ee)]()&&this[_0x549c9b(0x5df)]();},Game_Battler[_0x208a24(0xbd8)]['onAllActionsEnd']=function(){const _0x389726=_0x208a24;this['clearResult']();if(Imported['VisuMZ_1_SkillsStatesCore']){const _0x312b6e=VisuMZ[_0x389726(0x17e)]['Settings'][_0x389726(0xcf7)];_0x312b6e&&_0x312b6e[_0x389726(0xd14)]===![]&&this[_0x389726(0x13f)](0x1);}else this[_0x389726(0x13f)](0x1);this[_0x389726(0xa03)]();},BattleManager[_0x208a24(0xa76)]=function(){const _0x27ddff=_0x208a24;this[_0x27ddff(0x600)]=VisuMZ[_0x27ddff(0x759)][_0x27ddff(0xc39)]['Mechanics']['CalcEscapeRatioJS'][_0x27ddff(0x783)](this);},VisuMZ[_0x208a24(0x759)]['BattleManager_onEscapeSuccess']=BattleManager[_0x208a24(0x27e)],BattleManager[_0x208a24(0x27e)]=function(){const _0x235fc8=_0x208a24;this[_0x235fc8(0x192)](_0x235fc8(0x93b)),BattleManager[_0x235fc8(0xa85)][_0x235fc8(0xf7)](),VisuMZ[_0x235fc8(0x759)][_0x235fc8(0x3b5)][_0x235fc8(0x783)](this),this['processPostBattleCommonEvents'](_0x235fc8(0x4ef));},VisuMZ[_0x208a24(0x759)][_0x208a24(0x259)]=BattleManager[_0x208a24(0xb30)],BattleManager[_0x208a24(0xb30)]=function(){const _0x439d70=_0x208a24;this[_0x439d70(0x192)](_0x439d70(0x19a));const _0x218a2a=this[_0x439d70(0x600)];VisuMZ[_0x439d70(0x759)][_0x439d70(0x259)][_0x439d70(0x783)](this),this[_0x439d70(0x600)]=_0x218a2a+VisuMZ[_0x439d70(0x759)]['Settings'][_0x439d70(0x79c)]['CalcEscapeRaiseJS'][_0x439d70(0x783)](this),this[_0x439d70(0x4bf)]=![],this[_0x439d70(0x4e7)]('EscapeFail');},BattleManager[_0x208a24(0x7ed)]=function(){const _0x1eabcf=_0x208a24;let _0xf61015=![];if(this[_0x1eabcf(0xa5e)]())for(const _0x4ad80b of $gameTroop['enemyNames']()){this[_0x1eabcf(0x46b)][_0x1eabcf(0x7c3)](_0x1eabcf(0x9a1),TextManager[_0x1eabcf(0x53a)][_0x1eabcf(0x75a)](_0x4ad80b)),this[_0x1eabcf(0x46b)][_0x1eabcf(0x7c3)](_0x1eabcf(0xac0)),_0xf61015=!![];}if(this['_preemptive'])_0x1eabcf(0x42f)!==_0x1eabcf(0x42f)?this[_0x1eabcf(0xbd6)]='default':(this[_0x1eabcf(0x46b)][_0x1eabcf(0x7c3)](_0x1eabcf(0x9a1),TextManager[_0x1eabcf(0xc3e)]['format']($gameParty[_0x1eabcf(0x278)]())),this[_0x1eabcf(0x46b)]['push']('wait'));else this[_0x1eabcf(0xd4c)]&&(this['_logWindow'][_0x1eabcf(0x7c3)](_0x1eabcf(0x9a1),TextManager[_0x1eabcf(0x311)][_0x1eabcf(0x75a)]($gameParty[_0x1eabcf(0x278)]())),this[_0x1eabcf(0x46b)][_0x1eabcf(0x7c3)](_0x1eabcf(0xac0)));_0xf61015&&(this[_0x1eabcf(0x46b)][_0x1eabcf(0x7c3)](_0x1eabcf(0xac0)),this[_0x1eabcf(0x46b)]['push'](_0x1eabcf(0xb03)));if(this['isTpb']()&&this[_0x1eabcf(0x38a)]()){if(_0x1eabcf(0x2f6)===_0x1eabcf(0xc04)){_0x5fcba8['prototype'][_0x1eabcf(0xef)][_0x1eabcf(0x783)](this);const _0x3c509f=this['_actor'][_0x1eabcf(0xb1b)]();this[_0x1eabcf(0x50d)]!==_0x3c509f&&(this[_0x1eabcf(0x50d)]=_0x3c509f,this[_0x1eabcf(0x666)]['bitmap']=_0x5ab85c['loadSvActor'](_0x3c509f)),this[_0x1eabcf(0x666)]&&this[_0x1eabcf(0x666)]['bitmap']&&this[_0x1eabcf(0xa4c)]&&(this[_0x1eabcf(0x666)][_0x1eabcf(0x63f)][_0x1eabcf(0xfe)]!==this['_battler'][_0x1eabcf(0xb2f)]()&&(this['_mainSprite'][_0x1eabcf(0x63f)][_0x1eabcf(0xfe)]=this[_0x1eabcf(0xa4c)][_0x1eabcf(0xb2f)]()));}else this['_tpbNeedsPartyCommand']=![];}},BattleManager[_0x208a24(0xa5e)]=function(){const _0x31a912=_0x208a24;if(BattleManager[_0x31a912(0x29c)])return![];return VisuMZ[_0x31a912(0x759)][_0x31a912(0xc39)][_0x31a912(0x6bd)][_0x31a912(0x541)];},VisuMZ[_0x208a24(0x759)][_0x208a24(0x1e8)]=BattleManager[_0x208a24(0xb4b)],BattleManager[_0x208a24(0xb4b)]=function(){const _0x435803=_0x208a24;VisuMZ[_0x435803(0x759)][_0x435803(0x1e8)][_0x435803(0x783)](this),this[_0x435803(0xb99)]()&&this['isSkipPartyCommandWindow']()&&!this[_0x435803(0xd4c)]&&$gameParty[_0x435803(0x154)]()&&this[_0x435803(0xcf2)]();},BattleManager['isSkipPartyCommandWindow']=function(){const _0x45a179=_0x208a24;return VisuMZ[_0x45a179(0x759)][_0x45a179(0xc39)]['PartyCmd']['SkipPartyCmd'];},BattleManager[_0x208a24(0x931)]=function(){const _0x34308d=_0x208a24;this[_0x34308d(0x1ea)]()&&this[_0x34308d(0xcf2)]();},VisuMZ[_0x208a24(0x759)][_0x208a24(0xb02)]=Scene_Battle[_0x208a24(0xbd8)][_0x208a24(0x5f9)],Scene_Battle[_0x208a24(0xbd8)][_0x208a24(0x5f9)]=function(){const _0x4ee33c=_0x208a24;VisuMZ[_0x4ee33c(0x759)]['Scene_Battle_startActorCommandSelection'][_0x4ee33c(0x783)](this),BattleManager[_0x4ee33c(0xd25)]()&&BattleManager['_tpbNeedsPartyCommand']&&(_0x4ee33c(0x943)!=='GLGfr'?_0x48a588[_0x4ee33c(0x759)][_0x4ee33c(0x1b7)][_0x4ee33c(0x783)](this):(BattleManager[_0x4ee33c(0xc8b)]=![],this[_0x4ee33c(0x2fc)]()));},BattleManager[_0x208a24(0x9ae)]=function(_0x5d561f,_0x1940a9,_0x534c63){const _0x5c81ab=_0x208a24;if(!_0x534c63)return;if(!_0x5d561f)return;if(!_0x1940a9)return;const _0x10a236=this['_action'];this[_0x5c81ab(0x8fb)]=new Game_Action(_0x5d561f);if(DataManager[_0x5c81ab(0x6f3)](_0x534c63))this[_0x5c81ab(0x8fb)][_0x5c81ab(0x5ca)](_0x534c63['id']);if(DataManager[_0x5c81ab(0x269)](_0x534c63))this[_0x5c81ab(0x8fb)][_0x5c81ab(0x3f2)](_0x534c63['id']);if(this['_action'][_0x5c81ab(0x8bb)]())BattleManager[_0x5c81ab(0x9d7)](_0x5d561f,_0x1940a9);this[_0x5c81ab(0x8fb)]=_0x10a236;},BattleManager[_0x208a24(0xd0)]=function(_0x8e3652,_0xb44414){const _0x226d67=_0x208a24;this[_0x226d67(0x8fb)]['_reflectionTarget']=_0xb44414,this[_0x226d67(0x46b)][_0x226d67(0x6c5)](_0xb44414),this['_logWindow'][_0x226d67(0x73e)](_0x8e3652,this[_0x226d67(0x8fb)]),this['_action'][_0x226d67(0xa56)](_0x8e3652),this[_0x226d67(0x46b)]['displayActionResults'](_0x8e3652,_0x8e3652);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x877)]=BattleManager[_0x208a24(0x627)],BattleManager[_0x208a24(0x627)]=function(){const _0x3eb67c=_0x208a24;VisuMZ['BattleCore']['BattleManager_makeActionOrders']['call'](this),this[_0x3eb67c(0x8ab)]=this[_0x3eb67c(0x8ab)][_0x3eb67c(0x5a8)](_0x5bc26c=>_0x5bc26c&&_0x5bc26c[_0x3eb67c(0x937)]());},VisuMZ[_0x208a24(0x759)][_0x208a24(0x729)]=BattleManager[_0x208a24(0xbd2)],BattleManager[_0x208a24(0xbd2)]=function(_0x4614f0){const _0x2b68d2=_0x208a24;if(this[_0x2b68d2(0x558)]==='custom')this[_0x2b68d2(0x416)]();else{if(this['_phase']===_0x2b68d2(0x2be)){if(_0x2b68d2(0xaa6)!==_0x2b68d2(0x2ef))this[_0x2b68d2(0xd33)]();else{if(this[_0x2b68d2(0x569)][_0x2b68d2(0x92b)](_0x461b67=>_0x461b67[_0x2b68d2(0x8bb)]()&&_0x461b67[_0x2b68d2(0x4d5)]()))return!![];}}else VisuMZ['BattleCore'][_0x2b68d2(0x729)]['call'](this,_0x4614f0);}},BattleManager[_0x208a24(0x91e)]=function(){const _0x281521=_0x208a24;this[_0x281521(0xaea)]=this[_0x281521(0x3e1)][_0x281521(0xa3f)](0x0),this['_targetIndex']=0x0,this[_0x281521(0x29a)]=this[_0x281521(0xaea)][0x0]||null,this[_0x281521(0x558)]=_0x281521(0x6ef);},BattleManager[_0x208a24(0x416)]=function(){const _0x211cff=_0x208a24;if(!this[_0x211cff(0x166)]()&&!this['_logWindow']['isBusy']()){if('brbCt'===_0x211cff(0xcb8))this[_0x211cff(0x558)]=_0x211cff(0x590);else return this[_0x211cff(0xa7b)]()&&this[_0x211cff(0xa7b)]()[_0x211cff(0x8bb)]()&&this[_0x211cff(0xa7b)]()[_0x211cff(0xcd9)]();}},BattleManager[_0x208a24(0x2be)]=function(_0x550e98){const _0x441856=_0x208a24;this[_0x441856(0x8ab)][_0x441856(0x44b)](_0x550e98);if(_0x550e98===this['_subject'])return;const _0x58ea71=JsonEx[_0x441856(0x2bb)](_0x550e98[_0x441856(0xa7b)]());this[_0x441856(0xb9)][_0x441856(0x7c3)]([_0x550e98,_0x58ea71]);},BattleManager[_0x208a24(0x53f)]=function(){},BattleManager[_0x208a24(0x1b9)]=function(){const _0x3d707f=_0x208a24;if(this[_0x3d707f(0xd25)]())this[_0x3d707f(0x558)]='turn';else{if(this[_0x3d707f(0xb9)][_0x3d707f(0x1ba)]>0x0)_0x3d707f(0x7aa)!==_0x3d707f(0x669)?this[_0x3d707f(0x558)]=_0x3d707f(0x6d6):this[_0x3d707f(0x3b3)]=this[_0x3d707f(0x80b)]();else{if('hSYoM'!==_0x3d707f(0xb0e)){const _0x49dc25=this[_0x3d707f(0xa1e)],_0x266d52=_0x5787cb['windowPadding'](),_0x47ad54=_0xfd4c3c['x']+_0xd05ec1[_0x3d707f(0x479)](_0x1e5fcb[_0x3d707f(0x4fe)]/0x2)+_0x266d52;_0x49dc25['x']=_0x49dc25[_0x3d707f(0x4fe)]/-0x2+_0x47ad54,_0x49dc25['y']=_0x3f973d[_0x3d707f(0x479)](_0x4e91f2[_0x3d707f(0x1fa)]/0x2);}else this[_0x3d707f(0xb4b)]();}}},BattleManager['getNextSubject']=function(){const _0x1f6007=_0x208a24,_0x10fdf0=this[_0x1f6007(0x64d)];_0x10fdf0&&this['isTpb']()&&_0x10fdf0[_0x1f6007(0xc5b)]('undecided');for(;;){const _0x28a252=this[_0x1f6007(0x990)]();if(!_0x28a252){if('SQWyC'!=='SQWyC')this['opacity']=0x0;else return null;}if(_0x28a252[_0x1f6007(0xa87)]()&&_0x28a252[_0x1f6007(0x97c)]()){if('lUbqs'===_0x1f6007(0xa31))return _0x28a252;else _0x45dc29=_0x34f85b>=_0x321e55?_0x16be45:_0x5e8a5e;}}},BattleManager['getNextSubjectFromPool']=function(){const _0x3c1452=_0x208a24;if(this[_0x3c1452(0xb9)]['length']>0x0){if(_0x3c1452(0xc26)!==_0x3c1452(0x258)){const _0xbb9742=this[_0x3c1452(0xb9)][_0x3c1452(0xd23)](),_0x6774c6=_0xbb9742[0x0];return _0x6774c6['_actions']=_0x6774c6[_0x3c1452(0x569)]||[],_0x6774c6['_actions'][0x0]=_0xbb9742[0x1],_0x6774c6;}else _0x521901[_0x3c1452(0x759)][_0x3c1452(0xaf)][_0x3c1452(0x783)](this),this[_0x3c1452(0x41c)]();}else{if(_0x3c1452(0xc57)!=='UbqMC')return this[_0x3c1452(0x8ab)][_0x3c1452(0xd23)]();else _0x4439a2+=_0x39a86b[_0x3c1452(0x9bf)]()?-_0x233fc8:_0x54e9b2,_0x44a5da+=_0x82b1c5;}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x2c1)]=Game_Battler['prototype']['forceAction'],Game_Battler[_0x208a24(0xbd8)][_0x208a24(0x2be)]=function(_0x1c70b2,_0x347c61){const _0x3f6914=_0x208a24;VisuMZ[_0x3f6914(0x759)][_0x3f6914(0x2c1)][_0x3f6914(0x783)](this,_0x1c70b2,_0x347c61),this[_0x3f6914(0x569)][this[_0x3f6914(0x569)][_0x3f6914(0x1ba)]-0x1][_0x3f6914(0x2c4)]=!![];},Game_Interpreter['prototype'][_0x208a24(0xcc9)]=function(_0x17e57e){const _0x57328b=_0x208a24;return this[_0x57328b(0xb41)](_0x17e57e[0x0],_0x17e57e[0x1],_0x335104=>{const _0x229451=_0x57328b;_0x229451(0x5d6)===_0x229451(0x5d6)?!_0x335104[_0x229451(0xc47)]()&&(_0x335104[_0x229451(0x2be)](_0x17e57e[0x2],_0x17e57e[0x3]),BattleManager[_0x229451(0x2be)](_0x335104)):(this[_0x229451(0x7c3)](_0x229451(0x3f6),_0x5b0107,_0x2ea611),this[_0x229451(0x7c3)](_0x229451(0xd59),_0x480991[_0x229451(0xa73)]),this[_0x229451(0x7c3)]('showAnimation',_0x1108f1,_0x50e696['clone'](),_0x51bcbc[_0x229451(0x465)]),this[_0x229451(0x7c3)]('waitForAnimation'));}),!![];},VisuMZ[_0x208a24(0x759)][_0x208a24(0x22a)]=Game_Battler['prototype'][_0x208a24(0x2dd)],Game_Battler[_0x208a24(0xbd8)][_0x208a24(0x2dd)]=function(){const _0x854d5c=_0x208a24;VisuMZ[_0x854d5c(0x759)][_0x854d5c(0x22a)][_0x854d5c(0x783)](this),this[_0x854d5c(0x569)][_0x854d5c(0x1ba)]<=0x0&&(this['_speed']=Number['MIN_SAFE_INTEGER']);},BattleManager[_0x208a24(0xb05)]=function(){const _0xee05d2=_0x208a24;if(VisuMZ[_0xee05d2(0x759)][_0xee05d2(0xc39)][_0xee05d2(0x7a9)]['EndBattlePopups']??!![])return![];return SceneManager[_0xee05d2(0x8c3)]()&&this[_0xee05d2(0x8f0)];},VisuMZ[_0x208a24(0x759)][_0x208a24(0x113)]=BattleManager[_0x208a24(0xcf2)],BattleManager[_0x208a24(0xcf2)]=function(){const _0x253dbe=_0x208a24;if(this[_0x253dbe(0xd25)]())this[_0x253dbe(0x376)]();else{if(_0x253dbe(0x587)!==_0x253dbe(0x587))return this[_0x253dbe(0x54d)];else VisuMZ[_0x253dbe(0x759)][_0x253dbe(0x113)][_0x253dbe(0x783)](this);}},BattleManager[_0x208a24(0x376)]=function(){const _0x3c301f=_0x208a24;if(this[_0x3c301f(0x21e)]){if(_0x3c301f(0x43d)!=='oDaSb'){const _0x4e044c=_0x102ed4[_0x3c301f(0xd08)]();this[_0x3c301f(0x7c3)](_0x3c301f(0x718),[_0x58eaa9],_0x45bf35,_0xefcb6b),this[_0x3c301f(0x7c3)](_0x3c301f(0x5c8),_0x583989,_0x4e044c[_0x3c301f(0xd02)],_0x4e044c[_0x3c301f(0x66c)],_0x17d439,![],_0x3c301f(0xc0e)),this[_0x3c301f(0x7c3)](_0x3c301f(0x90c),[_0x2a1a90],_0x3c301f(0x8a1)),this['push']('waitForMovement'),this['push'](_0x3c301f(0x90c),[_0x1b6132],'walk');}else{if(this['_currentActor']['selectNextCommand']()){if(_0x3c301f(0x8c8)===_0x3c301f(0xa4a))return _0x55bc50['name'];else return;}this['finishActorInput'](),this[_0x3c301f(0x932)](),!this[_0x3c301f(0x64d)]&&!this['_currentActor']&&SceneManager[_0x3c301f(0xc1b)][_0x3c301f(0x59c)]();}}else!this[_0x3c301f(0x64d)]&&this['selectNextActor']();},BattleManager[_0x208a24(0x932)]=function(){const _0x191835=_0x208a24;if(!this[_0x191835(0x1ea)]()||this['needsActorInputCancel']()){if(_0x191835(0x54c)===_0x191835(0x54c))this[_0x191835(0x789)]&&(!$gameParty[_0x191835(0x3d9)]()['includes'](this[_0x191835(0x789)])&&(this[_0x191835(0x789)]=null)),!this[_0x191835(0x789)]?(this['cancelActorInput'](),this['_currentActor']=null,this[_0x191835(0x4bf)]=![]):this[_0x191835(0x9bd)]();else{if(!_0x17c2fb[_0x191835(0x620)]())return![];return![];}}},BattleManager[_0x208a24(0x9bd)]=function(){const _0x217d88=_0x208a24;!$gameParty[_0x217d88(0x3d9)]()[_0x217d88(0xcaf)](this['_tpbSceneChangeCacheActor'])&&(_0x217d88(0x93e)!==_0x217d88(0x77d)?this['_tpbSceneChangeCacheActor']=null:this[_0x217d88(0xbc4)]=_0x217d88(0x914)),this[_0x217d88(0x789)]?(this[_0x217d88(0x21e)]=this[_0x217d88(0x789)],this[_0x217d88(0x21e)]['_tpbState']=_0x217d88(0xafb),this[_0x217d88(0x4bf)]=!![],this[_0x217d88(0x789)]=null):(this['cancelActorInput'](),this[_0x217d88(0x21e)]=null,this['_inputting']=![]);},VisuMZ['BattleCore'][_0x208a24(0xa90)]=BattleManager[_0x208a24(0xc40)],BattleManager[_0x208a24(0xc40)]=function(){const _0x491c43=_0x208a24;return this[_0x491c43(0x558)]===_0x491c43(0x6ef)?this[_0x491c43(0x21a)]():VisuMZ[_0x491c43(0x759)][_0x491c43(0xa90)][_0x491c43(0x783)](this);},BattleManager[_0x208a24(0x21a)]=function(){const _0x357e50=_0x208a24;return this[_0x357e50(0x3c0)]();},VisuMZ[_0x208a24(0x759)][_0x208a24(0x812)]=BattleManager[_0x208a24(0xc01)],BattleManager[_0x208a24(0xc01)]=function(){const _0x598824=_0x208a24;if(this[_0x598824(0xd25)]()&&this[_0x598824(0x558)]==='battleEnd'){if('smCZJ'===_0x598824(0x20b)){const _0x775891=this['item'](),_0x37376e=_0x775891[_0x598824(0xae4)][_0x598824(0x2f1)];_0x775891[_0x598824(0xae4)][_0x598824(0x2f1)]=this[_0x598824(0xa21)];let _0x21f0b4=_0x27d2b9[_0x598824(0x759)][_0x598824(0xb37)]['call'](this,_0x233edb);return _0x775891['damage']['formula']=_0x37376e,_0x21f0b4;}else this[_0x598824(0x21e)]=null;}VisuMZ[_0x598824(0x759)][_0x598824(0x812)]['call'](this);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x475)]=BattleManager['inputtingAction'],BattleManager[_0x208a24(0x53e)]=function(){const _0xf6dc03=_0x208a24,_0x3bb18b=this[_0xf6dc03(0x21e)];if(_0x3bb18b&&!_0x3bb18b['inputtingAction']()){const _0x40f130=_0x3bb18b[_0xf6dc03(0xb80)];_0x3bb18b[_0xf6dc03(0x569)][_0x40f130]=new Game_Action(_0x3bb18b);}return VisuMZ[_0xf6dc03(0x759)][_0xf6dc03(0x475)]['call'](this);},VisuMZ[_0x208a24(0x759)]['BattleManager_checkSubstitute']=BattleManager[_0x208a24(0x212)],BattleManager[_0x208a24(0x212)]=function(_0x56f6a8){const _0x55e5e2=_0x208a24;if(this[_0x55e5e2(0x8fb)][_0x55e5e2(0x121)]())return![];return VisuMZ[_0x55e5e2(0x759)][_0x55e5e2(0x8a5)]['call'](this,_0x56f6a8);},SceneManager[_0x208a24(0x8c3)]=function(){const _0x7713ed=_0x208a24;return this[_0x7713ed(0xc1b)]&&this[_0x7713ed(0xc1b)]['constructor']===Scene_Battle;},SceneManager[_0x208a24(0x76f)]=function(){const _0x387413=_0x208a24;return Spriteset_Battle[_0x387413(0xbd8)][_0x387413(0x1db)]();},SceneManager[_0x208a24(0x394)]=function(){const _0x14502d=_0x208a24;if(SceneManager[_0x14502d(0x159)](Scene_Options))return!![];return![];},SceneManager[_0x208a24(0x8b7)]=function(){if(SceneManager['isNextScene'](Scene_Options))return!![];return![];},SceneManager[_0x208a24(0x2c0)]=function(_0x1d1ab3){const _0x234fb8=_0x208a24;if(!SceneManager[_0x234fb8(0x8c3)]())return!![];const _0x2166f0=[_0x234fb8(0x4ae),'Scene_Party'];return _0x2166f0[_0x234fb8(0xcaf)](_0x1d1ab3[_0x234fb8(0x278)]);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x1d1)]=SceneManager[_0x208a24(0x7c3)],SceneManager[_0x208a24(0x7c3)]=function(_0x235b56){const _0x4e6eb5=_0x208a24;if(!SceneManager[_0x4e6eb5(0x2c0)](_0x235b56))return this[_0x4e6eb5(0xca2)](_0x235b56);VisuMZ[_0x4e6eb5(0x759)]['SceneManager_push'][_0x4e6eb5(0x783)](this,_0x235b56);},SceneManager['displayBattleCoreTransitionErrorMsg']=function(_0x36dbe9){const _0x427b87=_0x208a24;if(!$gameTemp['isPlaytest']())return;if(this[_0x427b87(0x66f)])return;this[_0x427b87(0x66f)]=!![];let _0x521409='';_0x521409+=_0x427b87(0x613),_0x521409+='\x20to\x20%1\x20midbattle.'[_0x427b87(0x75a)](_0x36dbe9[_0x427b87(0x278)]),alert(_0x521409);},VisuMZ['BattleCore'][_0x208a24(0xa93)]=Game_Temp['prototype'][_0x208a24(0x3bf)],Game_Temp[_0x208a24(0xbd8)][_0x208a24(0x3bf)]=function(){const _0xe14527=_0x208a24;VisuMZ['BattleCore']['Game_Temp_initialize'][_0xe14527(0x783)](this),this['_battleBalloonQueue']=[];},VisuMZ['BattleCore'][_0x208a24(0x10b)]=Game_Temp[_0x208a24(0xbd8)][_0x208a24(0x2d8)],Game_Temp[_0x208a24(0xbd8)][_0x208a24(0x2d8)]=function(_0x150310,_0x8d6503,_0x2a976c){const _0x4ba818=_0x208a24;_0x150310=_0x150310[_0x4ba818(0x5a8)]((_0x2cef2d,_0x4148b8,_0x1dedd0)=>_0x1dedd0[_0x4ba818(0x6d1)](_0x2cef2d)===_0x4148b8),SceneManager[_0x4ba818(0x8c3)]()&&SceneManager['isBattleFlipped']()&&(_0x2a976c=!_0x2a976c),VisuMZ[_0x4ba818(0x759)]['Game_Temp_requestAnimation'][_0x4ba818(0x783)](this,_0x150310,_0x8d6503,_0x2a976c),SceneManager['isSceneBattle']()&&BattleManager[_0x4ba818(0xa85)][_0x4ba818(0x93d)]();},Game_Temp[_0x208a24(0xbd8)][_0x208a24(0xbe0)]=function(_0x2afb2b){const _0x45af4f=_0x208a24;this[_0x45af4f(0xab7)]=_0x2afb2b;},Game_Temp[_0x208a24(0xbd8)][_0x208a24(0xcc)]=function(){const _0xf19d50=_0x208a24;return this[_0xf19d50(0xab7)];},Game_Temp[_0x208a24(0xbd8)][_0x208a24(0x4f0)]=function(){const _0x449211=_0x208a24;this[_0x449211(0xbc4)]=undefined;},Game_Temp['prototype'][_0x208a24(0x2e4)]=function(_0x90d398){const _0x7f801a=_0x208a24;if($gameMap&&$dataMap&&$dataMap[_0x7f801a(0x6c4)]){if(_0x7f801a(0x9aa)===_0x7f801a(0x9aa))this['parseForcedGameTroopSettingsBattleCore']($dataMap['note']);else{const _0x1e6a65=_0xd4b34c[_0x7f801a(0x178)]();_0x2f4bed[_0x7f801a(0x759)][_0x7f801a(0x637)][_0x7f801a(0x783)](this);if(_0x1e6a65){if(_0x1e6a65===_0x5ce7a5[_0x7f801a(0x178)]())return;if(_0x1e6a65===_0x23f799[_0x7f801a(0x64d)])return;if(_0x1e6a65['battler']())_0x1e6a65['battler']()[_0x7f801a(0x642)]();}}}const _0x4129c8=$dataTroops[_0x90d398];if(_0x4129c8){if(_0x7f801a(0x77e)!=='ZsxOV'){let _0x3b042d=DataManager[_0x7f801a(0x582)](_0x4129c8['id']);this[_0x7f801a(0x92f)](_0x3b042d);}else _0x5b5ff0[_0x7f801a(0x436)](_0x11b5dd[_0x7f801a(0x2fe)]);}},Game_Temp['prototype'][_0x208a24(0x92f)]=function(_0x4e10e4){const _0x1e9443=_0x208a24;if(!_0x4e10e4)return;if(_0x4e10e4[_0x1e9443(0x7fc)](/<(?:BATTLELAYOUT|BATTLE LAYOUT|LAYOUT):[ ](.*?)>/i)){if(_0x1e9443(0xba1)!==_0x1e9443(0x79b)){const _0x2a475b=String(RegExp['$1']);if(_0x2a475b[_0x1e9443(0x7fc)](/DEFAULT/i))_0x1e9443(0xa40)!==_0x1e9443(0xa40)?(_0x575f5e['BattleCore'][_0x1e9443(0x3da)][_0x1e9443(0x783)](this),this[_0x1e9443(0x666)]&&this['_mainSprite']['bitmap']&&this[_0x1e9443(0xa4c)]&&(this[_0x1e9443(0x666)][_0x1e9443(0x63f)]['smooth']!==this[_0x1e9443(0xa4c)][_0x1e9443(0xb2f)]()&&(this['_mainSprite'][_0x1e9443(0x63f)][_0x1e9443(0xfe)]=this['_battler'][_0x1e9443(0xb2f)]()))):this[_0x1e9443(0xbc4)]=_0x1e9443(0x914);else{if(_0x2a475b['match'](/LIST/i))_0x1e9443(0x9f7)!==_0x1e9443(0x9f7)?this[_0x1e9443(0x8d9)]=(this[_0x1e9443(0x8d9)]*(_0x23072f-0x1)+this[_0x1e9443(0xbad)])/_0xca9ac1:this[_0x1e9443(0xbc4)]=_0x1e9443(0x38d);else{if(_0x2a475b[_0x1e9443(0x7fc)](/XP/i))_0x1e9443(0x680)===_0x1e9443(0x680)?this[_0x1e9443(0xbc4)]='xp':(_0x56d11c[_0x1e9443(0x759)][_0x1e9443(0xa33)][_0x1e9443(0x783)](this),this[_0x1e9443(0x519)]());else{if(_0x2a475b[_0x1e9443(0x7fc)](/PORTRAIT/i))this['_forcedBattleLayout']=_0x1e9443(0x372);else{if(_0x2a475b[_0x1e9443(0x7fc)](/BORDER/i))this[_0x1e9443(0xbc4)]='border';else{if(_0x2a475b[_0x1e9443(0x7fc)](/(?:SIDEVIEW UI|SIDEVIEW)/i)){if(Imported['VisuMZ_3_SideviewBattleUI'])this[_0x1e9443(0xbc4)]=_0x1e9443(0x66d);else{if(_0x1e9443(0x76b)!==_0x1e9443(0x366))this[_0x1e9443(0xbc4)]=_0x1e9443(0x914);else{const _0x23a1af=_0x4bfbe9[0x0][_0x1e9443(0x75a)](_0x44c57a[0x0]),_0x3ee564=_0x122da3[0x1][_0x1e9443(0x75a)](_0x1bd3f[0x1]),_0xe6fac3=new _0x1afc05(_0x19e29e[_0x1e9443(0x75a)](_0x3ee564),'i');_0x2725da[_0x23a1af]=_0xe6fac3;}}}else _0x2a475b[_0x1e9443(0x7fc)](/(?:FRONTVIEW UI|FRONTVIEW)/i)&&(Imported['VisuMZ_3_FrontviewBattleUI']?this[_0x1e9443(0xbc4)]=_0x1e9443(0xa5f):this[_0x1e9443(0xbc4)]='default');}}}}}}else _0x336d6c=_0x414be3['BattleCore'][_0x1e9443(0x3b4)]['call'](this);}},VisuMZ[_0x208a24(0x759)][_0x208a24(0xa80)]=Game_Temp[_0x208a24(0xbd8)][_0x208a24(0xc32)],Game_Temp['prototype'][_0x208a24(0xc32)]=function(_0x1ad3f6,_0x34c887){const _0x16d934=_0x208a24;SceneManager[_0x16d934(0x8c3)]()?this[_0x16d934(0x752)](_0x1ad3f6,_0x34c887):VisuMZ[_0x16d934(0x759)]['Game_Temp_requestBalloon'][_0x16d934(0x783)](this,_0x1ad3f6,_0x34c887);},Game_Temp['prototype'][_0x208a24(0x752)]=function(_0x25a6b7,_0x2f2caa){const _0x4ccaa5=_0x208a24,_0x57fd5b={'target':_0x25a6b7,'balloonId':_0x2f2caa};this[_0x4ccaa5(0x1e4)]=this[_0x4ccaa5(0x1e4)]||[],this[_0x4ccaa5(0x1e4)][_0x4ccaa5(0x7c3)](_0x57fd5b);},Game_Temp['prototype'][_0x208a24(0x946)]=function(){const _0x4c37ea=_0x208a24;return this[_0x4c37ea(0x1e4)]=this[_0x4c37ea(0x1e4)]||[],this[_0x4c37ea(0x1e4)][_0x4c37ea(0xd23)]();},Game_Temp[_0x208a24(0xbd8)][_0x208a24(0x691)]=function(){const _0x5e417e=_0x208a24;this[_0x5e417e(0x1e4)]=[];},Spriteset_Battle['prototype']['updateBattleBalloons']=function(){const _0x52c1b7=_0x208a24;this[_0x52c1b7(0x277)]===undefined&&(this[_0x52c1b7(0x277)]=[]);for(const _0x2aa721 of this[_0x52c1b7(0x277)]){!_0x2aa721['isPlaying']()&&this['removeBattleBalloon'](_0x2aa721);}this['processBattleBalloonRequests']();},Spriteset_Battle[_0x208a24(0xbd8)]['processBattleBalloonRequests']=function(){const _0xfff239=_0x208a24;for(;;){const _0x58a62a=$gameTemp[_0xfff239(0x946)]();if(_0x58a62a){if(_0xfff239(0x44f)!==_0xfff239(0x44f)){if(!_0x2080a4[_0xfff239(0x8c3)]())return;if(!_0x4d6ecd[_0xfff239(0xa2a)])return;_0x26c444[_0xfff239(0x1e1)]=!![];}else this[_0xfff239(0x161)](_0x58a62a);}else break;}},Spriteset_Battle[_0x208a24(0xbd8)]['createBattleBalloon']=function(_0x362a81){const _0x28f934=_0x208a24,_0x4a4935=this['findTargetSprite'](_0x362a81[_0x28f934(0x6b3)]);if(_0x4a4935){if('tefWb'!==_0x28f934(0x798)){let _0x24c2d8=null;if(Imported['VisuMZ_4_IconBalloons']&&Array['isArray'](_0x362a81[_0x28f934(0x8fc)])){if(_0x28f934(0xb8)!==_0x28f934(0x5e6))_0x24c2d8=new Sprite_IconBalloon();else{if(!this[_0x28f934(0x7d2)]())return;if(!this['_distortionSprite'])return;if(this[_0x28f934(0xd3a)]===_0x1efed4&&this[_0x28f934(0xaed)]===_0x5e8bd9)return;this['_targetGrowX']=_0x1e6835,this[_0x28f934(0xaed)]=_0x4b4fc6,this['_growDuration']=_0x549e74,this[_0x28f934(0x494)]=_0x4ece75,this[_0x28f934(0x83c)]=_0x581e7b||_0x28f934(0xc0e),_0x186051<=0x0&&(this[_0x28f934(0x765)]=this[_0x28f934(0xd3a)],this['_growY']=this[_0x28f934(0xaed)]);}}else{if(_0x28f934(0x341)!=='KugJm'){if(_0x3ee7b7['createKeyJS'])return _0x433ff8[_0x28f934(0x362)](_0xd95231,_0x4b9854);let _0x5a2f04='';if(_0x24d347[_0x28f934(0xcaf)](_0x19733e))_0x5a2f04='Actor-%1-%2'['format'](_0x3ccd22['id'],_0x4b1f53);if(_0x3f4762['includes'](_0x53b6ec))_0x5a2f04='Class-%1-%2'['format'](_0x419061['id'],_0x5306a8);if(_0x1ace16['includes'](_0x24cdb6))_0x5a2f04=_0x28f934(0x3db)[_0x28f934(0x75a)](_0x4bbe4d['id'],_0x52ed6b);if(_0x2b4f4b[_0x28f934(0xcaf)](_0x31afca))_0x5a2f04=_0x28f934(0xa3e)[_0x28f934(0x75a)](_0x2cef41['id'],_0x2547f9);if(_0x2eaa7d[_0x28f934(0xcaf)](_0x5a8976))_0x5a2f04='Weapon-%1-%2'[_0x28f934(0x75a)](_0x5f385b['id'],_0xc5fac0);if(_0x52f3fa[_0x28f934(0xcaf)](_0x5575ff))_0x5a2f04=_0x28f934(0xacd)['format'](_0x1d858f['id'],_0x57d882);if(_0x2a864b['includes'](_0x403ad8))_0x5a2f04=_0x28f934(0xa06)[_0x28f934(0x75a)](_0x2d2b67['id'],_0x14df08);if(_0x2f6ff0['includes'](_0x28d77d))_0x5a2f04=_0x28f934(0x7b8)[_0x28f934(0x75a)](_0x250a2b['id'],_0x33e4a8);return _0x5a2f04;}else _0x24c2d8=new Sprite_Balloon();}_0x24c2d8[_0x28f934(0x801)]=_0x362a81[_0x28f934(0x6b3)],_0x24c2d8['_target']=_0x4a4935,_0x24c2d8[_0x28f934(0x29a)][_0x28f934(0x855)]=_0x4a4935,_0x24c2d8[_0x28f934(0x876)](_0x4a4935,_0x362a81[_0x28f934(0x8fc)]),BattleManager[_0x28f934(0x1ff)](_0x24c2d8),this[_0x28f934(0x277)]['push'](_0x24c2d8);}else _0x303a82=_0x47b233[_0x28f934(0x8bb)]()['id'];}},Spriteset_Battle[_0x208a24(0xbd8)][_0x208a24(0x8ff)]=function(_0x5c37f2){const _0x52213d=_0x208a24;this['_battleBalloonSprites'][_0x52213d(0x44b)](_0x5c37f2),BattleManager[_0x52213d(0xbf0)](_0x5c37f2),_0x5c37f2['destroy']();},Sprite_Battler[_0x208a24(0xbd8)]['setBalloonPose']=function(_0x2658a1,_0x2932a8){},Sprite_Battler[_0x208a24(0xbd8)][_0x208a24(0x25f)]=function(){return![];},Spriteset_Battle[_0x208a24(0xbd8)][_0x208a24(0x63d)]=function(){const _0x292c3a=_0x208a24;return this[_0x292c3a(0x277)]=this[_0x292c3a(0x277)]||[],this[_0x292c3a(0x277)][_0x292c3a(0x1ba)]>0x0;},VisuMZ[_0x208a24(0x759)][_0x208a24(0xb49)]=Game_System[_0x208a24(0xbd8)][_0x208a24(0x3bf)],Game_System['prototype']['initialize']=function(){const _0x2db272=_0x208a24;VisuMZ[_0x2db272(0x759)][_0x2db272(0xb49)][_0x2db272(0x783)](this),this[_0x2db272(0x17f)]();},Game_System[_0x208a24(0xbd8)][_0x208a24(0x17f)]=function(){const _0x391110=_0x208a24;this[_0x391110(0x737)]=this[_0x391110(0x737)]||[];},Game_System[_0x208a24(0xbd8)][_0x208a24(0x173)]=function(){const _0x24ce77=_0x208a24;if(this[_0x24ce77(0x737)]===undefined)this[_0x24ce77(0x17f)]();return this[_0x24ce77(0x737)];},Game_System[_0x208a24(0xbd8)][_0x208a24(0x52b)]=function(_0x499b27){const _0x46cb0c=_0x208a24;if(this[_0x46cb0c(0x737)]===undefined)this[_0x46cb0c(0x17f)]();if(!_0x499b27)return;if(this[_0x46cb0c(0x737)]['includes'](_0x499b27))return;this['_defeatedEnemies'][_0x46cb0c(0x7c3)](_0x499b27),this['_defeatedEnemies'][_0x46cb0c(0xc80)]((_0x4a551a,_0x5317ea)=>_0x4a551a-_0x5317ea);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x632)]=Game_BattlerBase['prototype'][_0x208a24(0x3c2)],Game_BattlerBase[_0x208a24(0xbd8)]['addNewState']=function(_0x55673e){const _0x5c5ebe=_0x208a24,_0x1b2d8d=this['isAlive'](),_0x131e3e=this[_0x5c5ebe(0xa6a)]();VisuMZ[_0x5c5ebe(0x759)]['Game_BattlerBase_addNewState']['call'](this,_0x55673e),this[_0x5c5ebe(0x27a)]()&&_0x1b2d8d&&this[_0x5c5ebe(0x248)]()&&(this[_0x5c5ebe(0x2ce)]=!this[_0x5c5ebe(0xae1)](),$gameSystem['registerDefeatedEnemy'](this[_0x5c5ebe(0xb09)]())),SceneManager[_0x5c5ebe(0x8c3)]()&&_0x131e3e!==this['stateMotionIndex']()&&(this['battler']()&&this[_0x5c5ebe(0xd08)]()[_0x5c5ebe(0x4a2)]());},Game_Enemy[_0x208a24(0xbd8)][_0x208a24(0xae1)]=function(){const _0xf37624=_0x208a24;return $gameSystem[_0xf37624(0x173)]()[_0xf37624(0xcaf)](this[_0xf37624(0xc2b)]);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x52a)]=Game_BattlerBase[_0x208a24(0xbd8)][_0x208a24(0x4fa)],Game_BattlerBase[_0x208a24(0xbd8)][_0x208a24(0x4fa)]=function(_0x27aa9e){const _0x346936=_0x208a24;VisuMZ[_0x346936(0x759)][_0x346936(0x52a)][_0x346936(0x783)](this,_0x27aa9e),this[_0x346936(0x27a)]()&&_0x27aa9e===this[_0x346936(0xcb5)]()&&this['isAlive']()&&(this[_0x346936(0x2ce)]=![]),!this['_tempActor']&&!this['_tempBattler']&&SceneManager[_0x346936(0x8c3)]()&&(_0x346936(0x9be)===_0x346936(0x2b5)?(_0x42f672+=_0xf738d7[_0x346936(0x9bf)]()?-_0x52e266:_0x4d517c,_0x25bdab+=_0x97d7ec):this['requestMotionRefresh']());},VisuMZ[_0x208a24(0x759)][_0x208a24(0x109)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0xb03)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0xb03)]=function(){const _0x2fd0c3=_0x208a24;VisuMZ[_0x2fd0c3(0x759)][_0x2fd0c3(0x109)][_0x2fd0c3(0x783)](this),this[_0x2fd0c3(0x56b)]={'arPenRate':0x0,'arPenFlat':0x0,'arRedRate':0x0,'arRedFlat':0x0},this[_0x2fd0c3(0x27b)]={'criticalHitRate':0x1,'criticalHitFlat':0x0,'criticalDmgRate':0x1,'criticalDmgFlat':0x0,'damageRate':0x1,'damageFlat':0x0,'hitRate':0x1,'hitFlat':0x0},this[_0x2fd0c3(0xa21)]='default',this[_0x2fd0c3(0x79f)]();},Game_Action[_0x208a24(0xbd8)]['clearTargetBattlerKey']=function(){const _0x5a9003=_0x208a24;this[_0x5a9003(0x570)]='';},VisuMZ[_0x208a24(0x759)][_0x208a24(0xd05)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x865)],Game_Action['prototype'][_0x208a24(0x865)]=function(_0x3c76a0){const _0x4b9db1=_0x208a24;VisuMZ[_0x4b9db1(0x759)][_0x4b9db1(0xd05)][_0x4b9db1(0x783)](this,_0x3c76a0),this[_0x4b9db1(0x79f)]();},VisuMZ[_0x208a24(0x759)][_0x208a24(0xd04)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x3f2)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x3f2)]=function(_0x3cc099){const _0x114338=_0x208a24;VisuMZ[_0x114338(0x759)][_0x114338(0xd04)]['call'](this,_0x3cc099),this[_0x114338(0x79f)]();},VisuMZ[_0x208a24(0x759)][_0x208a24(0x48a)]=Game_Action['prototype'][_0x208a24(0x5ca)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x5ca)]=function(_0x23893f){const _0x43c6d5=_0x208a24;VisuMZ[_0x43c6d5(0x759)][_0x43c6d5(0x48a)][_0x43c6d5(0x783)](this,_0x23893f),this[_0x43c6d5(0x79f)]();},Game_Action[_0x208a24(0xbd8)][_0x208a24(0xd2f)]=function(_0x109c17,_0x45f004){const _0x140365=_0x208a24;return VisuMZ[_0x140365(0x759)]['Settings'][_0x140365(0x7a9)]['OverallFormulaJS'][_0x140365(0x783)](this,_0x109c17,_0x45f004);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0xcbf)]=function(_0x36728e,_0x2e7829){const _0xe2e5c6=_0x208a24;return VisuMZ[_0xe2e5c6(0x759)][_0xe2e5c6(0xc39)][_0xe2e5c6(0x7a9)][_0xe2e5c6(0x6ae)]['call'](this,_0x36728e,_0x2e7829);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x568)]=function(_0x533368,_0x4e2dd8){const _0x61d3ce=_0x208a24;return VisuMZ['BattleCore'][_0x61d3ce(0xc39)][_0x61d3ce(0x7a9)][_0x61d3ce(0x5d5)][_0x61d3ce(0x783)](this,_0x533368,_0x4e2dd8);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x74a)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0xc77)],Game_Action[_0x208a24(0xbd8)]['itemHit']=function(_0x1a9acd){const _0x4153cb=_0x208a24,_0x25d2f5=this[_0x4153cb(0x8bb)]()['note'];if(_0x25d2f5[_0x4153cb(0x7fc)](/<ALWAYS HIT>/i))return 0x1;else{if(_0x25d2f5[_0x4153cb(0x7fc)](/<ALWAYS HIT RATE: (\d+)([%％])>/i))return Number(RegExp['$1'])/0x64;else{let _0x19825b=VisuMZ['BattleCore']['Game_Action_itemHit'][_0x4153cb(0x783)](this,_0x1a9acd);return _0x19825b=this['_multipliers'][_0x4153cb(0xa8f)]*_0x19825b+this[_0x4153cb(0x27b)][_0x4153cb(0x2e5)],_0x19825b;}}},Game_Action[_0x208a24(0xbd8)]['itemCri']=function(_0x7f3de6){const _0x185037=_0x208a24;if(!this[_0x185037(0x8bb)]()['damage'][_0x185037(0x57d)])return 0x0;let _0x13b87f=VisuMZ[_0x185037(0x759)][_0x185037(0xc39)]['Damage']['CriticalHitRateJS'][_0x185037(0x783)](this,_0x7f3de6);return _0x13b87f=this['_multipliers'][_0x185037(0x49b)]*_0x13b87f+this[_0x185037(0x27b)][_0x185037(0x255)],_0x13b87f;},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x69b)]=function(_0x58fa5a){const _0x5b33ff=_0x208a24;return _0x58fa5a=VisuMZ[_0x5b33ff(0x759)][_0x5b33ff(0xc39)]['Damage'][_0x5b33ff(0xce7)][_0x5b33ff(0x783)](this,_0x58fa5a),_0x58fa5a=this['_multipliers'][_0x5b33ff(0x5d7)]*_0x58fa5a+this[_0x5b33ff(0x27b)][_0x5b33ff(0x4cd)],_0x58fa5a;},VisuMZ[_0x208a24(0x759)][_0x208a24(0xb37)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x852)],Game_Action['prototype'][_0x208a24(0x852)]=function(_0xf47900){const _0x1459ad=_0x208a24;if(this[_0x1459ad(0xa21)]!==_0x1459ad(0x914))return this['customDamageFormula'](_0xf47900);else{if(DataManager['getDamageStyle'](this[_0x1459ad(0x8bb)]())===_0x1459ad(0xac7)){if('MqjCj'!=='gWjsN')return VisuMZ[_0x1459ad(0x759)][_0x1459ad(0xb37)]['call'](this,_0xf47900);else{if(!this[_0x1459ad(0xc3a)])return;this[_0x1459ad(0x4de)]=this[_0x1459ad(0x4de)]||_0x303426[_0x1459ad(0xbd8)][_0x1459ad(0x146)](),this['x']=_0x27979d[_0x1459ad(0xd50)](this[_0x1459ad(0xc3a)][_0x1459ad(0x169)]),this['y']=_0x2afc48['round'](this[_0x1459ad(0xc3a)][_0x1459ad(0x832)]-this[_0x1459ad(0x4de)]*0.5);const _0x245f7b=_0x4b0359[_0x1459ad(0x759)][_0x1459ad(0xc39)]['Enemy'];this['x']+=_0x2bf88e[_0x1459ad(0xd50)](_0x245f7b[_0x1459ad(0xc30)]||0x0),this['y']+=_0x140d3e['round'](_0x245f7b['NameOffsetY']||0x0);}}else return this[_0x1459ad(0xc0f)](_0xf47900);}},Game_Action[_0x208a24(0xbd8)]['setCustomDamageFormula']=function(_0x3f5e6d){const _0x58d7f0=_0x208a24;this[_0x58d7f0(0xa21)]=_0x3f5e6d;},Game_Action[_0x208a24(0xbd8)]['customDamageFormula']=function(_0x2d26eb){const _0x38a5f7=_0x208a24,_0x23b10f=this[_0x38a5f7(0x8bb)](),_0x492e59=_0x23b10f[_0x38a5f7(0xae4)][_0x38a5f7(0x2f1)];_0x23b10f['damage'][_0x38a5f7(0x2f1)]=this[_0x38a5f7(0xa21)];let _0xb29410=VisuMZ['BattleCore'][_0x38a5f7(0xb37)][_0x38a5f7(0x783)](this,_0x2d26eb);return _0x23b10f[_0x38a5f7(0xae4)][_0x38a5f7(0x2f1)]=_0x492e59,_0xb29410;},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x141)]=function(){const _0x4edc6a=_0x208a24;if(this[_0x4edc6a(0x8bb)]()[_0x4edc6a(0x6c4)]['match'](/<DAMAGE STYLE:[ ](.*)>/i)){const _0x40030e=String(RegExp['$1'])[_0x4edc6a(0x4d6)]()[_0x4edc6a(0x446)]();return _0x40030e;}return _0x4edc6a(0xac7);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0xc0f)]=function(_0x48b405){const _0x101011=_0x208a24,_0x41c21f=DataManager['getDamageStyle'](this[_0x101011(0x8bb)]()),_0x1d6b89=VisuMZ[_0x101011(0x4a8)][_0x41c21f];try{return _0x1d6b89['Formula']['call'](this,_0x48b405);}catch(_0x5de074){if($gameTemp['isPlaytest']())console[_0x101011(0x9d3)](_0x5de074);return VisuMZ[_0x101011(0x759)][_0x101011(0xb37)][_0x101011(0x783)](this);}},Game_Action['prototype'][_0x208a24(0x5a9)]=function(_0x1c6b95,_0x3f5678){const _0x1fb1a7=_0x208a24;if(this[_0x1fb1a7(0x58d)]())return _0x3f5678;const _0x40694a=this[_0x1fb1a7(0x6a9)](),_0x35504c=_0x1c6b95;let _0x191ce4=[],_0x44fa56=[];_0x191ce4['push'](this[_0x1fb1a7(0x56b)][_0x1fb1a7(0x56f)],this[_0x1fb1a7(0x56b)]['arRedFlat']),_0x44fa56['push'](this['_armorPenetration']['arPenRate'],this[_0x1fb1a7(0x56b)]['arRedRate']);const _0xb5ebd3=this[_0x1fb1a7(0xbcf)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)>/i,_0x115e85=this[_0x1fb1a7(0xbcf)]()?/<ARMOR REDUCTION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC REDUCTION:[ ](\d+\.?\d*)([%％])>/i,_0xe9f036=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)>/i,_0x3dac74=this['isPhysical']()?/<ARMOR PENETRATION:[ ](\d+\.?\d*)([%％])>/i:/<MAGIC PENETRATION:[ ](\d+\.?\d*)([%％])>/i;_0x191ce4=_0x191ce4[_0x1fb1a7(0x655)](_0x35504c[_0x1fb1a7(0x8ce)]()[_0x1fb1a7(0x58e)](_0x2c47a6=>_0x2c47a6&&_0x2c47a6[_0x1fb1a7(0x6c4)][_0x1fb1a7(0x7fc)](_0xb5ebd3)?Number(RegExp['$1']):0x0)),_0x44fa56=_0x44fa56['concat'](_0x35504c[_0x1fb1a7(0x8ce)]()['map'](_0x2b16b5=>_0x2b16b5&&_0x2b16b5[_0x1fb1a7(0x6c4)][_0x1fb1a7(0x7fc)](_0x115e85)?Number(RegExp['$1'])/0x64:0x0)),_0x191ce4=_0x191ce4[_0x1fb1a7(0x655)](_0x40694a[_0x1fb1a7(0x8ce)]()['map'](_0xc371a8=>_0xc371a8&&_0xc371a8[_0x1fb1a7(0x6c4)]['match'](_0xe9f036)?Number(RegExp['$1']):0x0)),_0x44fa56=_0x44fa56[_0x1fb1a7(0x655)](_0x40694a[_0x1fb1a7(0x8ce)]()['map'](_0x301dcd=>_0x301dcd&&_0x301dcd[_0x1fb1a7(0x6c4)][_0x1fb1a7(0x7fc)](_0x3dac74)?Number(RegExp['$1'])/0x64:0x0));if(this[_0x1fb1a7(0x8bb)]()[_0x1fb1a7(0x6c4)][_0x1fb1a7(0x7fc)](_0xe9f036)){if('Tbwlx'==='NcCFl'){if(_0x2ceec1===this[_0x1fb1a7(0xcb5)]()&&this[_0x1fb1a7(0x9cd)]())return!![];return _0x5c696d[_0x1fb1a7(0x759)][_0x1fb1a7(0x268)]['call'](this,_0x18fb2c);}else _0x191ce4['push'](Number(RegExp['$1']));}this[_0x1fb1a7(0x8bb)]()[_0x1fb1a7(0x6c4)][_0x1fb1a7(0x7fc)](_0x3dac74)&&_0x44fa56['push'](Number(RegExp['$1']));_0x3f5678=_0x191ce4['reduce']((_0x36e266,_0x4fc73f)=>_0x36e266-_0x4fc73f,_0x3f5678);if(_0x3f5678>0x0){if(_0x1fb1a7(0x695)!==_0x1fb1a7(0x695))return _0x5820e8[_0x1fb1a7(0x759)][_0x1fb1a7(0x523)][_0x1fb1a7(0x783)](this);else _0x3f5678=_0x44fa56['reduce']((_0xc83b21,_0xeee806)=>_0xc83b21*(0x1-_0xeee806),_0x3f5678);}return _0x3f5678;},VisuMZ[_0x208a24(0x759)]['Game_Action_executeDamage']=Game_Action['prototype'][_0x208a24(0x8b3)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x8b3)]=function(_0x4d66b6,_0x331a0c){const _0x47f46a=_0x208a24;_0x331a0c=_0x331a0c*this[_0x47f46a(0x27b)][_0x47f46a(0xa16)],_0x331a0c+=this[_0x47f46a(0x27b)][_0x47f46a(0xfa)]*(_0x331a0c>=0x0?0x1:-0x1),_0x331a0c=this[_0x47f46a(0xb10)](_0x47f46a(0xb4),_0x4d66b6,_0x331a0c,![]),_0x331a0c=this[_0x47f46a(0xd39)](_0x331a0c),_0x331a0c=Math['round'](_0x331a0c),this['_executedValue']=_0x331a0c,this[_0x47f46a(0xd0a)]=this['_totalValue']||0x0,this['_totalValue']+=_0x331a0c,VisuMZ[_0x47f46a(0x759)][_0x47f46a(0xc87)][_0x47f46a(0x783)](this,_0x4d66b6,_0x331a0c),this[_0x47f46a(0xb10)](_0x47f46a(0x1c3),_0x4d66b6,_0x331a0c,!![]);},Game_Action['prototype']['applyDamageCaps']=function(_0x5cc66d){const _0x2503d8=_0x208a24;if(this['isBypassDamageCap']())return _0x5cc66d;return _0x5cc66d=this['applySoftDamageCap'](_0x5cc66d),_0x5cc66d=this[_0x2503d8(0x272)](_0x5cc66d),_0x5cc66d;},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x3e8)]=function(){const _0x238ff5=_0x208a24,_0x14e48f=/<BYPASS DAMAGE CAP>/i;if(this[_0x238ff5(0x8bb)]()['note'][_0x238ff5(0x7fc)](_0x14e48f))return!![];if(this['subject']()[_0x238ff5(0x8ce)]()[_0x238ff5(0x92b)](_0x34c3c1=>_0x34c3c1&&_0x34c3c1[_0x238ff5(0x6c4)][_0x238ff5(0x7fc)](_0x14e48f)))return!![];return!VisuMZ[_0x238ff5(0x759)]['Settings'][_0x238ff5(0x7a9)][_0x238ff5(0xc50)];},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x1dd)]=function(_0x5db58c){const _0x54b62f=_0x208a24;if(!VisuMZ[_0x54b62f(0x759)]['Settings'][_0x54b62f(0x7a9)][_0x54b62f(0xc44)])return _0x5db58c;const _0x34fbea=/<BYPASS SOFT DAMAGE CAP>/i;if(this[_0x54b62f(0x8bb)]()[_0x54b62f(0x6c4)][_0x54b62f(0x7fc)](_0x34fbea))return _0x5db58c;if(this[_0x54b62f(0x6a9)]()[_0x54b62f(0x8ce)]()['some'](_0x2e302c=>_0x2e302c&&_0x2e302c[_0x54b62f(0x6c4)][_0x54b62f(0x7fc)](_0x34fbea)))return _0x54b62f(0x540)===_0x54b62f(0x540)?_0x5db58c:_0x150292[_0x54b62f(0xba)][0x0];const _0x25a2db=_0x5db58c<0x0?-0x1:0x1;_0x5db58c=Math[_0x54b62f(0x7ac)](_0x5db58c);let _0x48ad90=this[_0x54b62f(0x6a9)]()[_0x54b62f(0xc6d)]();this[_0x54b62f(0x8bb)]()[_0x54b62f(0x6c4)]['match'](/<SOFT DAMAGE CAP:[ ]([\+\-]\d+)([%％])>/i)&&(_0x48ad90+=Number(RegExp['$1'])/0x64);_0x48ad90=_0x48ad90[_0x54b62f(0x345)](0.01,0x1);const _0x187d45=this['getHardDamageCap'](),_0x899f65=_0x48ad90*_0x187d45;if(_0x5db58c>_0x899f65&&_0x187d45>_0x899f65){_0x5db58c-=_0x899f65;const _0xa1395c=VisuMZ['BattleCore']['Settings'][_0x54b62f(0x7a9)][_0x54b62f(0x23a)],_0x104ce1=Math[_0x54b62f(0x6db)](0x1-_0x5db58c/((_0x187d45-_0x899f65)*_0xa1395c+_0x5db58c),0.01);_0x5db58c*=_0x104ce1,_0x5db58c+=_0x899f65;}return _0x5db58c*_0x25a2db;},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x495)]=function(){const _0x5896a9=_0x208a24;if(this['item']()['note'][_0x5896a9(0x7fc)](/<DAMAGE CAP:[ ](\d+)>/i)){if('BSdNv'!==_0x5896a9(0x908)){const _0xc3b9ff=this[_0x5896a9(0x202)]();_0x17bed0=_0xc3b9ff[_0x4bfb8d]?_0xc3b9ff[_0x268f48][_0x5896a9(0x7ea)]:0x0;}else return Number(RegExp['$1']);}else return this[_0x5896a9(0x6a9)]()[_0x5896a9(0x6f4)]();},Game_Action['prototype'][_0x208a24(0x272)]=function(_0x3b42e4){const _0x32f1e6=_0x208a24;let _0x1013da=this['getHardDamageCap']();return _0x3b42e4[_0x32f1e6(0x345)](-_0x1013da,_0x1013da);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x874)]=function(){const _0x3b5505=_0x208a24;if(!this[_0x3b5505(0x8bb)]())return![];if(!$gameParty[_0x3b5505(0x776)]())return![];return(this[_0x3b5505(0x8bb)]()[_0x3b5505(0x6c4)]||'')['match'](/<DISPERSE DAMAGE>/i);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x194)]=function(_0x4c3797){const _0x35a61c=_0x208a24;if(this[_0x35a61c(0x874)]()){let _0x5ef636=BattleManager[_0x35a61c(0x3e1)];_0x4c3797/=_0x5ef636[_0x35a61c(0x1ba)],this[_0x35a61c(0x67d)]()&&(_0x35a61c(0x473)==='nqDBe'?_0x4c3797*=this[_0x35a61c(0x6a9)]()['attackTimesAdd']()+0x1:this['_defeatedEnemies']=this[_0x35a61c(0x737)]||[]),_0x4c3797=_0x4c3797>0x0?Math['ceil'](_0x4c3797):Math[_0x35a61c(0x479)](_0x4c3797);}return _0x4c3797;},VisuMZ[_0x208a24(0x759)]['Game_Action_makeDamageValueDisperse']=Game_Action['prototype'][_0x208a24(0xd2f)],Game_Action['prototype'][_0x208a24(0xd2f)]=function(_0x3a2cfd,_0x5d27cd){const _0xcbd896=_0x208a24;let _0x5ea997=VisuMZ[_0xcbd896(0x759)][_0xcbd896(0x823)][_0xcbd896(0x783)](this,_0x3a2cfd,_0x5d27cd);return this[_0xcbd896(0x194)](_0x5ea997);},Game_Action[_0x208a24(0xbd8)]['itemEffectRecoverHp']=function(_0x5641af,_0x44fbc3){const _0x41d4d7=_0x208a24;let _0x510912=(_0x5641af[_0x41d4d7(0x94f)]*_0x44fbc3[_0x41d4d7(0x615)]+_0x44fbc3[_0x41d4d7(0x9b8)])*_0x5641af[_0x41d4d7(0x5f3)];_0x510912=this['disperseDamage'](_0x510912),this['isItem']()&&(_0x510912*=this['subject']()[_0x41d4d7(0x203)]),_0x510912=Math[_0x41d4d7(0x479)](_0x510912),_0x510912!==0x0&&(_0x5641af[_0x41d4d7(0x488)](_0x510912),this[_0x41d4d7(0x899)](_0x5641af));},Game_Action[_0x208a24(0xbd8)]['itemEffectRecoverMp']=function(_0x5e7f1a,_0x4246fa){const _0x423ee7=_0x208a24;let _0xfa7160=(_0x5e7f1a[_0x423ee7(0xbab)]*_0x4246fa[_0x423ee7(0x615)]+_0x4246fa['value2'])*_0x5e7f1a['rec'];_0xfa7160=this['disperseDamage'](_0xfa7160);this['isItem']()&&(_0x423ee7(0x34a)!==_0x423ee7(0x34a)?this[_0x423ee7(0x73a)]=_0x3607f4:_0xfa7160*=this[_0x423ee7(0x6a9)]()[_0x423ee7(0x203)]);_0xfa7160=Math[_0x423ee7(0x479)](_0xfa7160);if(_0xfa7160!==0x0){if(_0x423ee7(0x5ab)===_0x423ee7(0x5ab))_0x5e7f1a[_0x423ee7(0x753)](_0xfa7160),this[_0x423ee7(0x899)](_0x5e7f1a);else{const _0x18fdf2=_0x47f6cc[_0x423ee7(0x2bb)](_0x51e6e3);_0x18fdf2[_0x423ee7(0x91d)]=![],_0x18fdf2['evaded']=![],_0x18fdf2[_0x423ee7(0x969)]=![],this[_0x423ee7(0x55c)][_0x423ee7(0x7c3)](_0x18fdf2);}}},Game_Action['prototype']['itemEffectGainTp']=function(_0x1368bd,_0x5b452f){const _0x1960f2=_0x208a24;let _0x5c3186=Math['floor'](_0x5b452f[_0x1960f2(0x615)]);_0x5c3186=this[_0x1960f2(0x194)](_0x5c3186),_0x5c3186!==0x0&&(_0x1368bd['gainTp'](_0x5c3186),this[_0x1960f2(0x899)](_0x1368bd));},VisuMZ[_0x208a24(0x759)]['Game_Action_apply']=Game_Action[_0x208a24(0xbd8)][_0x208a24(0xa56)],Game_Action[_0x208a24(0xbd8)]['apply']=function(_0x12ead4){const _0x541167=_0x208a24;this[_0x541167(0xb10)](_0x541167(0xc54),_0x12ead4,0x0,!![]),VisuMZ['BattleCore'][_0x541167(0xcd1)][_0x541167(0x783)](this,_0x12ead4),this[_0x541167(0xb10)](_0x541167(0x179),_0x12ead4,this[_0x541167(0xb4c)]||0x0,!![]),this['applyResultSwitches'](_0x12ead4);},Game_Action['prototype']['applyBattleCoreJS']=function(_0x52fa0a,_0x308d4d,_0x38171c,_0x340317){const _0x2333d5=_0x208a24;if(this[_0x2333d5(0x635)]||this['_tempActor'])return;_0x38171c=_0x38171c||0x0;const _0x1c574a=_0x38171c,_0x1551bf=VisuMZ[_0x2333d5(0x759)][_0x2333d5(0xc39)]['Mechanics'],_0x25a7b5=_0x52fa0a[_0x2333d5(0x75a)]('');if(_0x1551bf[_0x25a7b5]){if(_0x2333d5(0xa4)!==_0x2333d5(0x530)){_0x38171c=_0x1551bf[_0x25a7b5][_0x2333d5(0x783)](this,_0x38171c,_0x308d4d);if(_0x340317)_0x38171c=_0x1c574a;}else this[_0x2333d5(0xa85)][_0x2333d5(0x3c1)]();}let _0x175586=VisuMZ[_0x2333d5(0x759)][_0x2333d5(0x362)](this['item'](),_0x52fa0a['format'](''));if(VisuMZ[_0x2333d5(0x759)]['JS'][_0x175586]){if(_0x2333d5(0xd38)===_0x2333d5(0xd38)){_0x38171c=VisuMZ['BattleCore']['JS'][_0x175586][_0x2333d5(0x783)](this,this[_0x2333d5(0x6a9)](),_0x308d4d,this[_0x2333d5(0x8bb)](),_0x38171c);if(_0x340317)_0x38171c=_0x1c574a;}else _0x17b8ad+=_0x3ae511[_0x2333d5(0x9bf)]()?-_0x37e8be:_0xc8f0f3,_0x39395d+=_0x3e20a1;}for(const _0x149620 of this[_0x2333d5(0x6a9)]()[_0x2333d5(0x8ce)]()){if(!_0x149620)continue;_0x175586=VisuMZ[_0x2333d5(0x759)][_0x2333d5(0x362)](_0x149620,_0x52fa0a[_0x2333d5(0x75a)](_0x2333d5(0x476)));if(VisuMZ['BattleCore']['JS'][_0x175586]){_0x38171c=VisuMZ[_0x2333d5(0x759)]['JS'][_0x175586][_0x2333d5(0x783)](this,this[_0x2333d5(0x6a9)](),_0x308d4d,_0x149620,_0x38171c);if(_0x340317)_0x38171c=_0x1c574a;}}for(const _0x52fef0 of _0x308d4d[_0x2333d5(0x8ce)]()){if(!_0x52fef0)continue;_0x175586=VisuMZ[_0x2333d5(0x759)][_0x2333d5(0x362)](_0x52fef0,_0x52fa0a[_0x2333d5(0x75a)](_0x2333d5(0x406)));if(VisuMZ[_0x2333d5(0x759)]['JS'][_0x175586]){_0x38171c=VisuMZ[_0x2333d5(0x759)]['JS'][_0x175586][_0x2333d5(0x783)](this,this[_0x2333d5(0x6a9)](),_0x308d4d,_0x52fef0,_0x38171c);if(_0x340317)_0x38171c=_0x1c574a;}}return _0x38171c;},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x84e)]=function(_0x4698de){const _0x4c7fe4=_0x208a24,_0x2b887c=this[_0x4c7fe4(0xd0a)]||0x0,_0x183f81=VisuMZ['BattleCore']['Settings'][_0x4c7fe4(0x79c)],_0x4af188=_0x4698de[_0x4c7fe4(0x75a)]('');_0x183f81[_0x4af188]&&_0x183f81[_0x4af188][_0x4c7fe4(0x783)](this,_0x2b887c);let _0x3cdaf5=VisuMZ[_0x4c7fe4(0x759)][_0x4c7fe4(0x362)](this['item'](),_0x4698de);if(VisuMZ[_0x4c7fe4(0x759)]['JS'][_0x3cdaf5]){if(_0x4c7fe4(0x2ad)!==_0x4c7fe4(0x5f0))VisuMZ[_0x4c7fe4(0x759)]['JS'][_0x3cdaf5][_0x4c7fe4(0x783)](this,this[_0x4c7fe4(0x6a9)](),this[_0x4c7fe4(0x6a9)](),this['item'](),_0x2b887c);else for(const _0x3aa772 of _0x434de9){for(const _0x19cab7 of _0x8a6a60){const _0x48916e=_0x50708f[0x0]['format'](_0x19cab7[0x0],_0x3aa772[0x0]),_0xc09bda=_0x364045[0x1][_0x4c7fe4(0x75a)](_0x19cab7[0x1],_0x3aa772[0x1])[_0x4c7fe4(0x446)](),_0x3a7a48=new _0x29d11d(_0x5ae468[_0x4c7fe4(0x75a)](_0xc09bda),'i');_0x31709a[_0x48916e]=_0x3a7a48;}}}for(const _0x533408 of this[_0x4c7fe4(0x6a9)]()[_0x4c7fe4(0x8ce)]()){if(_0x4c7fe4(0x6a0)!=='iqfSI'){if(!_0x533408)continue;_0x3cdaf5=VisuMZ['BattleCore'][_0x4c7fe4(0x362)](_0x533408,_0x4698de),VisuMZ[_0x4c7fe4(0x759)]['JS'][_0x3cdaf5]&&('yfUYY'==='yfUYY'?VisuMZ[_0x4c7fe4(0x759)]['JS'][_0x3cdaf5][_0x4c7fe4(0x783)](this,this['subject'](),this['subject'](),_0x533408,_0x2b887c):(_0x45e73e[_0x4c7fe4(0x759)][_0x4c7fe4(0x994)]['call'](this),this[_0x4c7fe4(0x2d2)](),this['createEnemyNames']()));}else this[_0x4c7fe4(0x3ad)](_0x54fb92)?_0x340f69[_0x4c7fe4(0x91e)]():this[_0x4c7fe4(0x131)](_0x34655f,_0x11b9fb,_0x5ab021);}},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x417)]=function(){const _0x1204b2=_0x208a24;return VisuMZ[_0x1204b2(0x759)][_0x1204b2(0xc39)]['Mechanics'][_0x1204b2(0x14d)][_0x1204b2(0x783)](this);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x2e8)]=function(){const _0x27d6fe=_0x208a24;return VisuMZ[_0x27d6fe(0x759)][_0x27d6fe(0xc39)][_0x27d6fe(0x79c)]['AllowRandomSpeed'];},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x8cb)]=function(){const _0x4492d4=_0x208a24;if(this[_0x4492d4(0x570)]===_0x4492d4(0x330))return![];if(this[_0x4492d4(0x570)]===_0x4492d4(0x4da))return![];if(!this[_0x4492d4(0x8bb)]())return![];return this[_0x4492d4(0x8bb)]()['note'][_0x4492d4(0x7fc)](/<JS TARGETS>/i);},Game_Action['prototype'][_0x208a24(0x282)]=function(){const _0x14d26d=_0x208a24;if(this[_0x14d26d(0x570)]===_0x14d26d(0x330))return![];if(this[_0x14d26d(0x570)]===_0x14d26d(0x4da))return![];if(!this[_0x14d26d(0x81b)]&&this['subject']()[_0x14d26d(0x82a)]())return![];if(this[_0x14d26d(0x8cb)]())return!![];if(!this[_0x14d26d(0x8bb)]())return![];return typeof this[_0x14d26d(0x8bb)]()[_0x14d26d(0x9ab)]===_0x14d26d(0x32d);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x973)]=Game_Action[_0x208a24(0xbd8)]['isForOpponent'],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x8e2)]=function(){const _0x42c671=_0x208a24;if(this['_targetBattlerKey']===_0x42c671(0x330))return![];if(this[_0x42c671(0x570)]==='all\x20enemies')return!![];if(this[_0x42c671(0x282)]()&&!this[_0x42c671(0x8cb)]())return this[_0x42c671(0xb98)]();else{if('iuLjY'!==_0x42c671(0xbbd))this[_0x42c671(0x9bd)]();else return VisuMZ[_0x42c671(0x759)]['Game_Action_isForOpponent'][_0x42c671(0x783)](this);}},Game_Action[_0x208a24(0xbd8)][_0x208a24(0xb98)]=function(){const _0x2974b2=_0x208a24,_0x3189eb=this[_0x2974b2(0x8bb)]()['scope'];if(_0x3189eb[_0x2974b2(0x7fc)](/ANY/i))return!![];return _0x3189eb['match'](/(?:ENEMY|ENEMIES|FOE|FOES)/i);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x66b)]=Game_Action['prototype'][_0x208a24(0x121)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x121)]=function(){const _0x4374a1=_0x208a24;if(this[_0x4374a1(0x570)]==='all\x20actors')return!![];if(this['_targetBattlerKey']===_0x4374a1(0x4da))return![];if(this['isBattleCoreTargetScope']()&&!this[_0x4374a1(0x8cb)]())return _0x4374a1(0x261)!==_0x4374a1(0x261)?_0x20856d[_0x4374a1(0x759)]['Game_Interpreter_command301'][_0x4374a1(0x783)](this,_0x222f85):this[_0x4374a1(0x3fa)]();else{if('IxjbT'===_0x4374a1(0x9f5)){if(_0x574d36)_0xc96d2d[_0x4374a1(0x192)](_0x248ab1);}else return VisuMZ['BattleCore'][_0x4374a1(0x66b)][_0x4374a1(0x783)](this);}},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x3fa)]=function(){const _0x31d151=_0x208a24,_0x2299b=this[_0x31d151(0x8bb)]()[_0x31d151(0x9ab)];return _0x2299b['match'](/(?:ALLY|ALLIES|FRIEND|FRIENDS)/i);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x9c2)]=function(){const _0x19e617=_0x208a24;if(this[_0x19e617(0x282)]()&&!this['isCustomBattleScope']()){if(_0x19e617(0x422)!==_0x19e617(0x422))_0x5384f7=this[_0x19e617(0x411)][this[_0x19e617(0x411)][_0x19e617(0x1ba)]-0x1];else{const _0xde38d4=this[_0x19e617(0x8bb)]()[_0x19e617(0x9ab)];return _0xde38d4[_0x19e617(0x7fc)](/(?:ENEMY|FOE)/i)&&_0xde38d4[_0x19e617(0x7fc)](/OR/i)&&_0xde38d4['match'](/(?:ALLY|FRIEND)/i);}}else{if(_0x19e617(0x94a)===_0x19e617(0x250)){if(!_0x4097f['isSideView']())return;const _0x4a2ec6=this[_0x19e617(0xd08)]();if(!_0x4a2ec6)return;_0x4a2ec6['startJump'](_0x405a86,_0x54596e);}else return![];}},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x768)]=function(){const _0x46eb8a=_0x208a24;if(this[_0x46eb8a(0x9c2)]()){const _0x39ba04=this[_0x46eb8a(0x8bb)]()['scope'];if(_0x39ba04[_0x46eb8a(0x7fc)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];}return![];},Game_Action[_0x208a24(0xbd8)]['isForAnyoneFocusOpponents']=function(){const _0x17e97c=_0x208a24;if(this['isForAnyone']()){if('qISwC'===_0x17e97c(0xc2c)){const _0x4096f1=this['item']()['scope'];if(_0x4096f1[_0x17e97c(0x7fc)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];}else{if(!_0x46a35e['value'](_0x199dba))return![];}}return![];},VisuMZ[_0x208a24(0x759)][_0x208a24(0xb8a)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x253)],Game_Action['prototype'][_0x208a24(0x253)]=function(){const _0x5a4ca0=_0x208a24;if(this[_0x5a4ca0(0x570)]===_0x5a4ca0(0x330))return!![];if(this[_0x5a4ca0(0x282)]()&&!this[_0x5a4ca0(0x8cb)]())return this[_0x5a4ca0(0x1a6)]();else{if('hTmxD'===_0x5a4ca0(0x524))return VisuMZ['BattleCore']['Game_Action_isForAliveFriend'][_0x5a4ca0(0x783)](this);else{if(_0x3d0289[_0x5a4ca0(0x905)](_0x5bbe0b))return!![];}}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x709)]=Game_Action[_0x208a24(0xbd8)]['isForDeadFriend'],Game_Action[_0x208a24(0xbd8)][_0x208a24(0xa42)]=function(){const _0x4c1a6c=_0x208a24;if(this[_0x4c1a6c(0x570)]==='all\x20actors'){if(_0x4c1a6c(0x44a)!==_0x4c1a6c(0x3be))return VisuMZ[_0x4c1a6c(0x759)][_0x4c1a6c(0x709)][_0x4c1a6c(0x783)](this);else{const _0xcfb37=_0x2c9cf2[_0x4c1a6c(0x4fe)],_0x2f1928=_0x134f7c['round']((_0x4ed4cf[_0x4c1a6c(0xa53)]-_0xcfb37)/0x2),_0x5ed820=this['helpAreaHeight'](),_0x599c77=(_0x3189[_0x4c1a6c(0x1fa)]-_0x72bd4[_0x4c1a6c(0x833)])/-0x2;return new _0x136f4d(_0x2f1928,_0x599c77,_0xcfb37,_0x5ed820);}}return VisuMZ[_0x4c1a6c(0x759)]['Game_Action_isForDeadFriend'][_0x4c1a6c(0x783)](this);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x1a6)]=function(){if(this['isForAnyone']())return!![];return![];},Game_Action[_0x208a24(0xbd8)][_0x208a24(0xc5d)]=function(){const _0x2bafda=_0x208a24;return this[_0x2bafda(0x8bb)]()&&this[_0x2bafda(0x8bb)]()[_0x2bafda(0x6c4)][_0x2bafda(0x7fc)](/<CANNOT TARGET (?:USER|SELF)>/i);},VisuMZ[_0x208a24(0x759)][_0x208a24(0x25c)]=Game_Action[_0x208a24(0xbd8)]['isForOne'],Game_Action[_0x208a24(0xbd8)]['isForOne']=function(){const _0x1733e0=_0x208a24;if(this[_0x1733e0(0x570)]==='all\x20actors')return![];if(this[_0x1733e0(0x570)]===_0x1733e0(0x4da))return![];if(this[_0x1733e0(0x282)]()&&!this[_0x1733e0(0x8cb)]()){if(_0x1733e0(0x735)==='gazSQ')return this[_0x1733e0(0x672)]();else{if(this['_actions'][_0x1733e0(0x92b)](_0x1a0cb1=>_0x1a0cb1[_0x1733e0(0x8bb)]()&&_0x1a0cb1[_0x1733e0(0xcd9)]()))return!![];}}else{if(_0x1733e0(0x61c)===_0x1733e0(0x2b1))!this[_0x1733e0(0x46b)]['isBusy']()&&this['endAction']();else return VisuMZ[_0x1733e0(0x759)][_0x1733e0(0x25c)]['call'](this);}},Game_Action['prototype']['isForOneBattleCore']=function(){const _0x490277=_0x208a24;if(this[_0x490277(0x9c2)]())return!![];return![];},VisuMZ['BattleCore'][_0x208a24(0x9e0)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x8f2)],Game_Action['prototype'][_0x208a24(0x8f2)]=function(){const _0x7d7119=_0x208a24;if(this['_targetBattlerKey']===_0x7d7119(0x330))return![];if(this[_0x7d7119(0x570)]===_0x7d7119(0x4da))return![];if(this[_0x7d7119(0x282)]()&&!this[_0x7d7119(0x8cb)]())return'XNXKY'==='zuztd'?this[_0x7d7119(0x531)]():this['isForRandomBattleCore']();else{if(_0x7d7119(0x4dd)===_0x7d7119(0x856)){let _0xc73a94=_0x29357a(_0x33bf3f['$1']);while(_0xc73a94--){const _0x4c517b=_0x3f4be2[_0x7d7119(0xd15)](0x2)===0x0?this['opponentsUnit']():this[_0x7d7119(0x281)]();_0x11d180[_0x7d7119(0x7c3)](_0x4c517b[_0x7d7119(0xc9a)]());}return this['repeatTargets'](_0xc4ba44);}else return VisuMZ['BattleCore'][_0x7d7119(0x9e0)][_0x7d7119(0x783)](this);}},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x1cf)]=function(){const _0x5549de=_0x208a24,_0x29b442=this[_0x5549de(0x8bb)]()[_0x5549de(0x9ab)];return _0x29b442[_0x5549de(0x7fc)](/(?:RAND|RANDOM)/i);},VisuMZ[_0x208a24(0x759)][_0x208a24(0xa7a)]=Game_Action[_0x208a24(0xbd8)]['isForAll'],Game_Action['prototype'][_0x208a24(0x8b9)]=function(){const _0x1315e4=_0x208a24;if(this[_0x1315e4(0x570)]===_0x1315e4(0x330))return!![];if(this[_0x1315e4(0x570)]===_0x1315e4(0x4da))return!![];return VisuMZ[_0x1315e4(0x759)][_0x1315e4(0xa7a)][_0x1315e4(0x783)](this);},Game_Action['prototype'][_0x208a24(0x59d)]=function(){const _0x2e201d=_0x208a24;if(!this[_0x2e201d(0x8bb)]())return![];if(this[_0x2e201d(0xa42)]())return![];return(this[_0x2e201d(0x8bb)]()[_0x2e201d(0x6c4)]||'')[_0x2e201d(0x7fc)](/<SINGLE OR MULTIPLE SELECT>/i);},VisuMZ[_0x208a24(0x759)]['Game_Action_testApply']=Game_Action[_0x208a24(0xbd8)][_0x208a24(0xa1b)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0xa1b)]=function(_0x3917d5){const _0x2ada9d=_0x208a24;if(this['isForNotUser']()&&_0x3917d5===this[_0x2ada9d(0x6a9)]())return![];return VisuMZ[_0x2ada9d(0x759)][_0x2ada9d(0xa62)][_0x2ada9d(0x783)](this,_0x3917d5);},VisuMZ[_0x208a24(0x759)][_0x208a24(0xa18)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x693)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x693)]=function(){const _0x4ac74d=_0x208a24,_0x239038=VisuMZ[_0x4ac74d(0x759)][_0x4ac74d(0xa18)]['call'](this);if(this[_0x4ac74d(0xc5d)]())_0x239038[_0x4ac74d(0x44b)](this[_0x4ac74d(0x6a9)]());return _0x239038;},VisuMZ['BattleCore']['Game_Action_needsSelection']=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x197)],Game_Action[_0x208a24(0xbd8)]['needsSelection']=function(){const _0x596437=_0x208a24;if(this['isBattleCoreTargetScope']()&&!this[_0x596437(0x8cb)]()){if(_0x596437(0xc48)===_0x596437(0xb14)){if(!_0xd90eb8[_0x596437(0x8c3)]())return;const _0x191ca6=_0x1c1f87['getLastPluginCommandInterpreter'](),_0x3420f1=_0x399916[_0x596437(0x8fb)],_0x3cc7a9=_0x46645a[_0x596437(0x64d)],_0x394e95=_0x16f49b[_0x596437(0x46b)];if(!_0x191ca6||!_0x3420f1||!_0x3cc7a9)return;if(!_0x3420f1[_0x596437(0x8bb)]())return;_0x394e95[_0x596437(0x734)](_0x3cc7a9,_0x3420f1[_0x596437(0x8bb)]()),_0x191ca6[_0x596437(0x3dc)]('battlelog');}else return this[_0x596437(0x508)]();}else{if(_0x596437(0x23f)===_0x596437(0x23f))return VisuMZ[_0x596437(0x759)]['Game_Action_needsSelection']['call'](this);else{const _0x2c5eb8=_0x393643[_0x596437(0x794)]('['+_0x969c10['$1']['match'](/\d+/g)+']');for(const _0x5bf70e of _0x2c5eb8){if(!_0x41477d['value'](_0x5bf70e))return!![];}return![];}}},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x508)]=function(){const _0x4a7ab1=_0x208a24,_0x2ca76d=this[_0x4a7ab1(0x8bb)]()[_0x4a7ab1(0x9ab)];if(_0x2ca76d[_0x4a7ab1(0x7fc)](/RANDOM/i))return![];if(_0x2ca76d[_0x4a7ab1(0x7fc)](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS)/i))return![];if(_0x2ca76d[_0x4a7ab1(0x7fc)](/ALL (?:ENEMY|ENEMIES|FOE|FOES)/i))return![];if(_0x2ca76d[_0x4a7ab1(0x7fc)](/(?:ENEMY|FOE) OR (?:ALLY|FRIEND)/i))return!![];if(_0x2ca76d[_0x4a7ab1(0x7fc)](/(?:ALLY|FRIEND) OR (?:ENEMY|FOE)/i))return!![];return VisuMZ[_0x4a7ab1(0x759)][_0x4a7ab1(0x6dc)][_0x4a7ab1(0x783)](this);},VisuMZ['BattleCore'][_0x208a24(0x3b4)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0xaf1)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0xaf1)]=function(){const _0x5b2882=_0x208a24;let _0x368143=[];if(this[_0x5b2882(0x282)]()){if(this[_0x5b2882(0x8cb)]()){if('YclRK'===_0x5b2882(0x89d))return[_0x40862f['GetActionSequenceSpecialTarget']()];else _0x368143=this[_0x5b2882(0x39d)]();}else _0x368143=this['makeTargetsBattleCore']();}else _0x368143=VisuMZ[_0x5b2882(0x759)][_0x5b2882(0x3b4)][_0x5b2882(0x783)](this);return _0x368143=this[_0x5b2882(0x357)](_0x368143),_0x368143;},Game_Action['prototype'][_0x208a24(0x803)]=function(){const _0x3a8ee8=_0x208a24;return this[_0x3a8ee8(0x6a9)]()[_0x3a8ee8(0x9bf)]()&&!this[_0x3a8ee8(0x6a9)]()['isAutoBattle']();},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x39d)]=function(){const _0x120e91=_0x208a24,_0x4e08a5=VisuMZ[_0x120e91(0x759)]['createKeyJS'](this[_0x120e91(0x8bb)](),'Targets');if(VisuMZ[_0x120e91(0x759)]['JS'][_0x4e08a5]){if('RAQiM'===_0x120e91(0x3a8)){targets=VisuMZ[_0x120e91(0x759)][_0x120e91(0x3b4)]['call'](this);const _0x29769d=VisuMZ[_0x120e91(0x759)][_0x120e91(0x362)](this[_0x120e91(0x8bb)](),_0x120e91(0x83d));return targets=VisuMZ['BattleCore']['JS'][_0x29769d][_0x120e91(0x783)](this,this[_0x120e91(0x6a9)](),targets),this[_0x120e91(0xc25)](targets);}else return null;}return this[_0x120e91(0x8ef)]();},Game_Action['prototype'][_0x208a24(0x8ef)]=function(){const _0x1fdc81=_0x208a24;let _0x25196f=[];const _0x25a2b7=String(this['item']()[_0x1fdc81(0x9ab)]);if(this['isForAnyoneFocusOpponents']())return this[_0x1fdc81(0x803)]()?(_0x25196f=this[_0x1fdc81(0x6f5)](),this[_0x1fdc81(0xc25)](_0x25196f)):(this[_0x1fdc81(0x580)]=-0x1,_0x25196f['push'](...this[_0x1fdc81(0x383)]()),this[_0x1fdc81(0xc25)](_0x25196f));if(this[_0x1fdc81(0x768)]()){if(_0x1fdc81(0x9d2)===_0x1fdc81(0x4bd))_0x314b9e[_0x1fdc81(0x759)][_0x1fdc81(0x529)][_0x1fdc81(0x783)](this,_0x4bf040);else{if(this[_0x1fdc81(0x803)]()){if(_0x1fdc81(0xa84)===_0x1fdc81(0xc4e))_0xfad1c0+=_0x485897[_0x1fdc81(0x9bf)]()?-_0x3a349d:_0x437395,_0x2ab38c+=_0x483f44[_0x1fdc81(0x9bf)]()?-_0x14a974:_0x451ae9;else return _0x25196f=this[_0x1fdc81(0x6f5)](),this[_0x1fdc81(0xc25)](_0x25196f);}else{if(Imported[_0x1fdc81(0xb8d)]){if(_0x1fdc81(0x5fa)!==_0x1fdc81(0x5fa))return this[_0x1fdc81(0x505)]()[_0x1fdc81(0xc9a)]();else{if(VisuMZ[_0x1fdc81(0x9a8)][_0x1fdc81(0x738)]<1.19){if(_0x1fdc81(0x928)!==_0x1fdc81(0x928)){if(_0x4d0744[_0x1fdc81(0x182)](_0x408db5))return!![];return![];}else{let _0x2d3893='';_0x2d3893+=_0x1fdc81(0xa43),_0x2d3893+=_0x1fdc81(0xcec),_0x2d3893+=_0x1fdc81(0x513),alert(_0x2d3893),SceneManager[_0x1fdc81(0x1b1)]();}}}}return this['_targetIndex']=-0x1,_0x25196f['push'](...this['targetsForFriends']()),this[_0x1fdc81(0xc25)](_0x25196f);}}}if(_0x25a2b7[_0x1fdc81(0x7fc)](/(\d+) RANDOM ANY/i)){let _0x2719b5=Number(RegExp['$1']);while(_0x2719b5--){if('abioL'==='PbzMG')this[_0x1fdc81(0xb2e)]=_0x3400b6['mpDamage']>=0x0?0x2:0x3,this[_0x1fdc81(0xcac)](_0x37d164[_0x1fdc81(0x522)]);else{const _0x91b075=Math[_0x1fdc81(0xd15)](0x2)===0x0?this[_0x1fdc81(0x505)]():this['friendsUnit']();_0x25196f[_0x1fdc81(0x7c3)](_0x91b075[_0x1fdc81(0xc9a)]());}}return this[_0x1fdc81(0xc25)](_0x25196f);}if(_0x25a2b7[_0x1fdc81(0x7fc)](/(\d+) RANDOM (?:ENEMY|ENEMIES|FOE|FOES)/i)){let _0x21c2ef=Number(RegExp['$1']);while(_0x21c2ef--){if(_0x1fdc81(0x2a5)!==_0x1fdc81(0x2a5))return _0x5b3b4f[_0x1fdc81(0x759)][_0x1fdc81(0xc39)][_0x1fdc81(0x2a2)][_0x1fdc81(0x702)][_0x1fdc81(0x783)](this);else _0x25196f[_0x1fdc81(0x7c3)](this[_0x1fdc81(0x505)]()[_0x1fdc81(0xc9a)]());}return this[_0x1fdc81(0xc25)](_0x25196f);}if(_0x25a2b7[_0x1fdc81(0x7fc)](/(\d+) RANDOM (?:ALLY|ALLIES|FRIEND|FRIENDS)/i)){if('HbnOW'===_0x1fdc81(0x1eb)){let _0x2736ad=Number(RegExp['$1']);while(_0x2736ad--){_0x25196f[_0x1fdc81(0x7c3)](this['friendsUnit']()[_0x1fdc81(0xc9a)]());}return this[_0x1fdc81(0xc25)](_0x25196f);}else _0x3257c7[_0x1fdc81(0x759)][_0x1fdc81(0xca9)][_0x1fdc81(0x783)](this);}if(_0x25a2b7['match'](/ALL (?:ALLY|ALLIES|FRIEND|FRIENDS) (?:BUT|EXCEPT) (?:USER|SELF)/i)){if('uijPF'===_0x1fdc81(0x971))_0x325340[_0x1fdc81(0xd48)]=!![];else return _0x25196f[_0x1fdc81(0x7c3)](...this[_0x1fdc81(0x281)]()[_0x1fdc81(0x49a)]()[_0x1fdc81(0x5a8)](_0x27b85d=>_0x27b85d!==this[_0x1fdc81(0x6a9)]())),this[_0x1fdc81(0xc25)](_0x25196f);}return VisuMZ[_0x1fdc81(0x759)]['Game_Action_makeTargets']['call'](this);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x1aa)]=function(_0x209a55){const _0x23673b=_0x208a24,_0x4416cb=[];for(let _0x4c6685=0x0;_0x4c6685<this[_0x23673b(0xb4d)]();_0x4c6685++){if(_0x23673b(0x972)!==_0x23673b(0x6b5))_0x4416cb['push'](_0x209a55['trueRandomTarget']());else{if(_0x65c0ad[_0x23673b(0x8c3)]()){const _0x38dedf=this['getAttackWeaponAnimationId']();this[_0x23673b(0x138)](_0x38dedf);}}}return _0x4416cb;},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x357)]=function(_0x57554e){const _0x1757b6=_0x208a24;if(!this[_0x1757b6(0x8bb)]())return _0x57554e;const _0x4a8fed=this[_0x1757b6(0x8bb)]()[_0x1757b6(0x6c4)];if(this[_0x1757b6(0xc5d)]()){if(_0x1757b6(0xcba)!==_0x1757b6(0xad5)){if(this[_0x1757b6(0x8b9)]()){if('zaqWi'!==_0x1757b6(0xd31))_0x57554e[_0x1757b6(0x44b)](this[_0x1757b6(0x6a9)]());else{if(!this[_0x1757b6(0x5b7)]())return;const _0x21009b=this[_0x1757b6(0xbb1)](),_0x2161ea=_0x40da1d[_0x1757b6(0x759)][_0x1757b6(0xc39)]['PartyCmd'][_0x1757b6(0x451)],_0x3b8f01=_0x21009b===_0x1757b6(0xa9c)?_0x4ff2e9[_0x1757b6(0x6fb)]:_0x1757b6(0x98a)['format'](_0x2161ea,_0x272447[_0x1757b6(0x6fb)]),_0x3c358b=this[_0x1757b6(0x468)]();this[_0x1757b6(0xb83)](_0x3b8f01,_0x1757b6(0x6fb),_0x3c358b);}}if(_0x57554e[_0x1757b6(0xcaf)](this[_0x1757b6(0x6a9)]())){const _0x441264=this['friendsUnit']()[_0x1757b6(0x49a)]()['remove'](this['subject']());if(_0x441264['length']>0x0){_0x441264[_0x1757b6(0xc80)]((_0x3fb3d8,_0x505540)=>_0x3fb3d8[_0x1757b6(0x8dc)]()-_0x505540['hpRate']());while(_0x57554e[_0x1757b6(0xcaf)](this[_0x1757b6(0x6a9)]())){const _0x1efe78=_0x57554e[_0x1757b6(0x6d1)](this[_0x1757b6(0x6a9)]());_0x57554e[_0x1efe78]=_0x441264[Math['randomInt'](_0x441264[_0x1757b6(0x1ba)])];}}else _0x57554e[_0x1757b6(0x44b)](this['subject']());}}else{if(!_0x18dc21[_0x1757b6(0x8c3)]())return;const _0x69d9a=_0x26928f[_0x1757b6(0x46b)];_0x69d9a[_0x1757b6(0xa22)]();}}return _0x57554e;},VisuMZ[_0x208a24(0x759)][_0x208a24(0xc71)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x626)],Game_Action['prototype'][_0x208a24(0x626)]=function(_0x383793,_0x27c5d6){const _0x11add6=_0x208a24;VisuMZ[_0x11add6(0x759)][_0x11add6(0xc71)]['call'](this,_0x383793,_0x27c5d6);if(!_0x383793[_0x11add6(0x9cd)]())return;for(const _0x1c829c of this[_0x11add6(0x6a9)]()[_0x11add6(0x608)]()){if(_0x1c829c===_0x383793[_0x11add6(0xcb5)]()){if(_0x11add6(0x3af)!==_0x11add6(0xc58)){let _0x22a2a3=_0x27c5d6[_0x11add6(0x615)];_0x22a2a3*=_0x383793['stateRate'](_0x1c829c),_0x22a2a3*=this[_0x11add6(0x6a9)]()[_0x11add6(0x68c)](_0x1c829c),_0x22a2a3*=this[_0x11add6(0x763)](_0x383793);if(Math[_0x11add6(0x39f)]()<_0x22a2a3){if(_0x11add6(0x1f1)!==_0x11add6(0x5f6))_0x383793[_0x11add6(0xd28)]=!![],this['makeSuccess'](_0x383793);else return;}}else return 0x1;}}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x214)]=Game_Action['prototype']['itemEffectAddNormalState'],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x8c4)]=function(_0x570e36,_0x17816b){const _0x2ccd1c=_0x208a24;VisuMZ['BattleCore'][_0x2ccd1c(0x214)][_0x2ccd1c(0x783)](this,_0x570e36,_0x17816b);if(!_0x570e36[_0x2ccd1c(0x9cd)]())return;if(_0x17816b[_0x2ccd1c(0x28e)]!==_0x570e36[_0x2ccd1c(0xcb5)]())return;let _0x438603=_0x17816b['value1'];if(!this[_0x2ccd1c(0x58d)]()){if(_0x2ccd1c(0x31e)!==_0x2ccd1c(0x70c))_0x438603*=_0x570e36['stateRate'](_0x17816b[_0x2ccd1c(0x28e)]),_0x438603*=this[_0x2ccd1c(0x763)](_0x570e36);else return this[_0x2ccd1c(0x8ac)]()[_0x2ccd1c(0x92b)](_0x28289b=>_0x28289b['isSpinning']());}Math['random']()<_0x438603&&(_0x570e36['_deathStateApplied']=!![],this[_0x2ccd1c(0x899)](_0x570e36));},VisuMZ[_0x208a24(0x759)][_0x208a24(0xa74)]=Game_Action[_0x208a24(0xbd8)][_0x208a24(0x640)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0x640)]=function(){const _0x4a733a=_0x208a24;VisuMZ[_0x4a733a(0x759)][_0x4a733a(0xa74)]['call'](this),this[_0x4a733a(0x4bb)](),this['resetResultSwitches']();},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x4bb)]=function(){const _0x41ff4b=_0x208a24;if(!SceneManager['isSceneBattle']())return;const _0x9fb8bc=/<COMMON (?:EVENT|EVENTS):[ ](.*)>/gi,_0x3ea1b9=this[_0x41ff4b(0x8bb)]()[_0x41ff4b(0x6c4)][_0x41ff4b(0x7fc)](_0x9fb8bc);if(_0x3ea1b9){if(_0x41ff4b(0x37a)!==_0x41ff4b(0x196))for(const _0x2404ef of _0x3ea1b9){if(!_0x2404ef)continue;_0x2404ef[_0x41ff4b(0x7fc)](_0x9fb8bc);const _0x5dd881=String(RegExp['$1'])[_0x41ff4b(0xc85)](',')[_0x41ff4b(0x58e)](_0x9553b6=>String(_0x9553b6)[_0x41ff4b(0x446)]()),_0x5d93df=_0x5dd881[_0x41ff4b(0x58e)](_0x572753=>DataManager[_0x41ff4b(0x99f)](_0x572753));for(const _0x1faba0 of _0x5d93df){const _0x1554de=$dataCommonEvents[_0x1faba0];_0x1554de&&(_0x41ff4b(0x489)===_0x41ff4b(0x489)?$gameTemp[_0x41ff4b(0x436)](_0x1faba0):(_0x142ee8=(_0x40b926+_0xa35d5e)/0x2,_0x4e6b35=-0x1));}}else _0x4a7770[_0x41ff4b(0x759)]['Game_Party_addActor'][_0x41ff4b(0x783)](this,_0x20977b),_0x618890['refreshStatusWindow']();}},DataManager[_0x208a24(0x99f)]=function(_0x5e1002){const _0x577ba6=_0x208a24;_0x5e1002=_0x5e1002['toUpperCase']()[_0x577ba6(0x446)](),this[_0x577ba6(0xc1)]=this[_0x577ba6(0xc1)]||{};if(this[_0x577ba6(0xc1)][_0x5e1002])return this['_commonEventIDs'][_0x5e1002];for(const _0x450492 of $dataCommonEvents){if(!_0x450492)continue;let _0x534d59=_0x450492['name'];_0x534d59=_0x534d59[_0x577ba6(0x51f)](/\x1I\[(\d+)\]/gi,''),_0x534d59=_0x534d59['replace'](/\\I\[(\d+)\]/gi,''),this[_0x577ba6(0xc1)][_0x534d59['toUpperCase']()[_0x577ba6(0x446)]()]=_0x450492['id'];}return this[_0x577ba6(0xc1)][_0x5e1002]||0x0;},Game_Action['prototype']['resetResultSwitches']=function(){const _0x44e3ac=_0x208a24;if(!SceneManager[_0x44e3ac(0x8c3)]())return;const _0x58602f=VisuMZ[_0x44e3ac(0x759)][_0x44e3ac(0xc39)][_0x44e3ac(0x79c)];_0x58602f['SwitchCritical']&&$gameSwitches['setValue'](_0x58602f[_0x44e3ac(0xaad)],![]);_0x58602f['SwitchMissEvade']&&('WsfhR'===_0x44e3ac(0xd30)?$gameSwitches['setValue'](_0x58602f[_0x44e3ac(0xac3)],![]):(_0x3f6499['forceMotion'](_0x265934),[_0x44e3ac(0xb89),_0x44e3ac(0xd3e),'missile'][_0x44e3ac(0xcaf)](_0x390a49)&&this[_0x44e3ac(0xd12)]()));if(_0x58602f[_0x44e3ac(0x4d4)]){if(_0x44e3ac(0x1fc)===_0x44e3ac(0x1fc))$gameVariables[_0x44e3ac(0x7e1)](_0x58602f[_0x44e3ac(0x4d4)],0x0);else{if(!_0x25963f[_0x44e3ac(0x2c0)](_0x2ac0b2))return this['displayBattleCoreTransitionErrorMsg'](_0x4433a9);_0x5eb1da[_0x44e3ac(0x759)][_0x44e3ac(0x1d1)][_0x44e3ac(0x783)](this,_0x9c31f7);}}_0x58602f[_0x44e3ac(0x400)]&&$gameVariables[_0x44e3ac(0x7e1)](_0x58602f[_0x44e3ac(0x400)],0x0);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x50c)]=function(_0x315976){const _0x470f51=_0x208a24;if(!SceneManager[_0x470f51(0x8c3)]())return;if(!_0x315976)return;const _0x69fe64=_0x315976[_0x470f51(0xa19)](),_0x6dc9b8=VisuMZ['BattleCore']['Settings']['Mechanics'];_0x6dc9b8[_0x470f51(0xaad)]&&_0x69fe64['critical']&&$gameSwitches['setValue'](_0x6dc9b8['SwitchCritical'],!![]);if(_0x6dc9b8[_0x470f51(0xac3)]&&(_0x69fe64['missed']||_0x69fe64[_0x470f51(0x5b4)])){if(_0x470f51(0x275)!==_0x470f51(0xc66))$gameSwitches[_0x470f51(0x7e1)](_0x6dc9b8['SwitchMissEvade'],!![]);else{if(!this[_0x470f51(0xa4c)])return;this[_0x470f51(0x34e)]=this[_0x470f51(0xa4c)][_0x470f51(0x670)](),this[_0x470f51(0xeb)]=this[_0x470f51(0xa4c)][_0x470f51(0x3ac)]();}}if(_0x6dc9b8[_0x470f51(0x4d4)]){if(_0x470f51(0x59b)!==_0x470f51(0x59b)){const _0x86b3db=this[_0x470f51(0xb1f)]()?this[_0x470f51(0xd17)]:0x0,_0x385d9c=_0x57fa39[_0x470f51(0x38d)];this[_0x470f51(0x4d0)](_0x385d9c,_0x86b3db),this[_0x470f51(0xb8f)]=_0x269ea4[_0x470f51(0x2bb)](this['_list']);const _0xfff9f3={'code':0xbc3,'indent':this[_0x470f51(0x317)],'parameters':_0x654f32[_0x470f51(0x2bb)](_0x3280af)};return this[_0x470f51(0xb8f)][_0x470f51(0xd36)](this[_0x470f51(0x424)]+0x1,0x0,_0xfff9f3),!![];}else{let _0x5e4683=$gameVariables[_0x470f51(0x905)](_0x6dc9b8[_0x470f51(0x4d4)]);_0x69fe64[_0x470f51(0x364)]>0x0&&(_0x5e4683+=Math[_0x470f51(0x7ac)](_0x69fe64['hpDamage'])),$gameVariables[_0x470f51(0x7e1)](_0x6dc9b8[_0x470f51(0x4d4)],_0x5e4683);}}if(_0x6dc9b8[_0x470f51(0x400)]){if('KCogN'!==_0x470f51(0xcb2)){let _0x45ccda=$gameVariables[_0x470f51(0x905)](_0x6dc9b8[_0x470f51(0x400)]);_0x69fe64[_0x470f51(0x364)]<0x0&&('jRnQi'===_0x470f51(0xabe)?_0x45ccda+=Math[_0x470f51(0x7ac)](_0x69fe64[_0x470f51(0x364)]):(_0x361d7e+=_0x17b4ee,_0x1fe54e+=_0x11cfa4['isActor']()?-_0x3ddc7e:_0x281487)),$gameVariables['setValue'](_0x6dc9b8['VariableHeal'],_0x45ccda);}else{const _0x4148dc=this['weapons']();if(_0x4148dc[_0x470f51(0x1ba)]>0x0){const _0x15d846=_0x4148dc[_0x33fe08];if(_0x15d846)_0x18d929=this[_0x470f51(0x2b7)]()[_0x470f51(0x6d1)](_0x15d846);}}}},VisuMZ[_0x208a24(0x759)][_0x208a24(0x780)]={'lifeSteaItem':/<(.*?) (?:LIFE|MANA) STEAL:[ ](\d+)([%％])>/gi,'lifeStealTrait':/<(.*?) (?:LIFE|MANA) STEAL (.*?):[ ]([\+\-]\d+)([%％])>/gi,'cancelLifeSteal':/<CANCEL LIFE STEAL>/i,'cancelHpLifeSteal':/<CANCEL HP LIFE STEAL>/i,'cancelMpLifeSteal':/<CANCEL MP LIFE STEAL>/i,'guardLifeSteal':/<GUARD LIFE STEAL>/i,'guardHpLifeSteal':/<GUARD HP LIFE STEAL>/i,'guardMpLifeSteal':/<GUARD MP LIFE STEAL>/i,'disarmLifeSteal':/<DISARM LIFE STEAL>/i,'disarmHpLifeSteal':/<DISARM HP LIFE STEAL>/i,'disarmMpLifeSteal':/<DISARM MP LIFE STEAL>/i,'negativeLifeSteal':/<REVERSE LIFE STEAL>/i,'negativeHpLifeSteal':/<REVERSE HP LIFE STEAL>/i,'negativeMpLifeSteal':/<REVERSE MP LIFE STEAL>/i},VisuMZ[_0x208a24(0x759)][_0x208a24(0x6d9)]=Game_Action['prototype'][_0x208a24(0xb5d)],Game_Action[_0x208a24(0xbd8)][_0x208a24(0xb5d)]=function(_0x3520ac,_0x18cf5a){const _0x9e05ea=_0x208a24;VisuMZ[_0x9e05ea(0x759)][_0x9e05ea(0x6d9)][_0x9e05ea(0x783)](this,_0x3520ac,_0x18cf5a);if(!this['isDrain']()&&_0x3520ac&&_0x3520ac['result']()[_0x9e05ea(0x364)]>0x0){if(_0x9e05ea(0x6b8)==='iahpe'){_0x10c4e4(_0x9e05ea(0xb94)),_0x1d48d8[_0x9e05ea(0x1b1)]();return;}else this['performLifeSteal']('HP',_0x3520ac,_0x3520ac[_0x9e05ea(0xa19)]()['hpDamage']);}if(_0x3520ac){if(_0x9e05ea(0x3a3)==='HzmwX'){const _0x47bc8e=_0x511ad4[_0x9e05ea(0x759)][_0x9e05ea(0xc39)][_0x9e05ea(0x148)];if(_0x47bc8e['StatusWindowSelectableBackHide'])return;_0x1292c8[_0x9e05ea(0xbd8)][_0x9e05ea(0x9fd)][_0x9e05ea(0x783)](this,_0x5e883c);}else{this[_0x9e05ea(0xce2)]=this[_0x9e05ea(0xce2)]||{};const _0x58e618=_0x3520ac[_0x9e05ea(0x3a6)]();this[_0x9e05ea(0xce2)][_0x58e618]=_0x18cf5a;}}},Game_Action[_0x208a24(0xbd8)]['getLastHpDamage']=function(_0x1bc026){const _0x4c49ee=_0x208a24;this[_0x4c49ee(0xce2)]=this['_executeHpDamage']||{};const _0x5ed52d=_0x1bc026[_0x4c49ee(0x3a6)]();return this['_executeHpDamage'][_0x5ed52d]||0x0;},VisuMZ['BattleCore'][_0x208a24(0xc49)]=Game_Action[_0x208a24(0xbd8)]['executeMpDamage'],Game_Action['prototype'][_0x208a24(0x3d7)]=function(_0x25a5b3,_0x40a21a){const _0x511d27=_0x208a24;VisuMZ[_0x511d27(0x759)]['Game_Action_executeMpDamage'][_0x511d27(0x783)](this,_0x25a5b3,_0x40a21a);if(!this[_0x511d27(0x900)]()&&_0x25a5b3&&_0x25a5b3[_0x511d27(0xa19)]()['mpDamage']>0x0){if(_0x511d27(0x26f)==='NrzDH')return this['skillItemWindowRectBorderStyle']();else this[_0x511d27(0x467)]('MP',_0x25a5b3,_0x25a5b3[_0x511d27(0xa19)]()[_0x511d27(0x522)]);}},Game_Action[_0x208a24(0xbd8)][_0x208a24(0x467)]=function(_0x798b08,_0x5f5c37,_0xb003ee){const _0xd3e607=_0x208a24;_0x798b08=_0x798b08[_0xd3e607(0x4d6)]()[_0xd3e607(0x446)]();const _0x59a7d6=this['lifeStealRate'](_0x798b08,_0x5f5c37);if(_0x59a7d6<=0x0)return;const _0x1f8113=Math[_0xd3e607(0xd50)](_0xb003ee*_0x59a7d6);if(_0x1f8113<=0x0)return;let _0x2efc32=this[_0xd3e607(0x6a9)]();if(this[_0xd3e607(0x6b6)])_0x2efc32=this[_0xd3e607(0x6b6)];const _0x427806=_0x5f5c37[_0xd3e607(0xb21)](_0x798b08)?-0x1:0x1;if(_0x798b08==='HP')_0x2efc32[_0xd3e607(0x488)](_0x427806*_0x1f8113);if(_0x798b08==='MP')_0x2efc32[_0xd3e607(0x753)](_0x427806*_0x1f8113);},Game_Action[_0x208a24(0xbd8)]['lifeStealRate']=function(_0xc22953,_0x35f985){const _0x1d1bf7=_0x208a24;if(this[_0x1d1bf7(0xa55)](_0xc22953))return 0x0;if(this[_0x1d1bf7(0x6a9)]()[_0x1d1bf7(0x7cf)](_0xc22953))return 0x0;if(_0x35f985[_0x1d1bf7(0xade)](_0xc22953))return 0x0;let _0x5bb05a=0x0;return _0x5bb05a+=this[_0x1d1bf7(0x155)](_0xc22953),_0x5bb05a+=this[_0x1d1bf7(0x6a9)]()['lifeStealRate'](_0xc22953,this[_0x1d1bf7(0x8bb)]()[_0x1d1bf7(0x502)]),_0x5bb05a['clamp'](0x0,0x1);},Game_Action[_0x208a24(0xbd8)][_0x208a24(0xa55)]=function(_0x37dfe1){const _0x43fda4=_0x208a24;_0x37dfe1=_0x37dfe1['toUpperCase']()[_0x43fda4(0x446)]();const _0x69319a=VisuMZ[_0x43fda4(0x759)][_0x43fda4(0x780)],_0x5421c9=this['item']()['note']||'';if(_0x5421c9[_0x43fda4(0x7fc)](_0x69319a[_0x43fda4(0x770)]))return!![];if(_0x37dfe1==='HP'&&_0x5421c9['match'](_0x69319a[_0x43fda4(0x894)]))return!![];if(_0x37dfe1==='MP'&&_0x5421c9['match'](_0x69319a[_0x43fda4(0x5c2)]))return!![];return![];},Game_Action[_0x208a24(0xbd8)]['itemLifeStealRate']=function(_0x578b90){const _0x58fb74=_0x208a24,_0x4bff81=VisuMZ[_0x58fb74(0x759)][_0x58fb74(0x780)],_0x5204f1=this[_0x58fb74(0x8bb)]()['note']||'';_0x578b90=_0x578b90[_0x58fb74(0x4d6)]()['trim']();const _0x3782e7=_0x5204f1[_0x58fb74(0x7fc)](_0x4bff81['lifeSteaItem']);if(_0x3782e7)for(const _0x3fe4df of _0x3782e7){if(_0x58fb74(0x7e7)!==_0x58fb74(0x7e7))return this[_0x58fb74(0x9ce)]();else{_0x3fe4df[_0x58fb74(0x7fc)](_0x4bff81[_0x58fb74(0xbe6)]);const _0x2c9b89=String(RegExp['$1'])[_0x58fb74(0x4d6)]()[_0x58fb74(0x446)](),_0x54d614=Number(RegExp['$2'])*0.01;if(_0x2c9b89!==_0x578b90)continue;return _0x54d614;}}return 0x0;},Game_BattlerBase[_0x208a24(0xbd8)][_0x208a24(0xb24)]=function(_0x337ce3,_0x4e1428){const _0x5c2058=_0x208a24,_0x4dc6f2=VisuMZ[_0x5c2058(0x759)]['LifeStealRegExp'];let _0x390e77=0x0;_0x337ce3=_0x337ce3['toUpperCase']()['trim']();for(const _0x2fb0f6 of this[_0x5c2058(0x8ce)]()){if(!_0x2fb0f6)continue;const _0x9e35b7=_0x2fb0f6[_0x5c2058(0x6c4)]||'',_0x348fe8=_0x9e35b7[_0x5c2058(0x7fc)](_0x4dc6f2[_0x5c2058(0xa5b)]);if(_0x348fe8){if(_0x5c2058(0xb66)!==_0x5c2058(0x9df))for(const _0x9c1bbf of _0x348fe8){_0x9c1bbf['match'](_0x4dc6f2[_0x5c2058(0xa5b)]);const _0x29b8fb=String(RegExp['$1'])[_0x5c2058(0x4d6)]()[_0x5c2058(0x446)](),_0x294e3e=String(RegExp['$2']),_0x57ef6c=Number(RegExp['$3'])*0.01;if(_0x29b8fb!==_0x337ce3)continue;if(_0x4e1428===Game_Action['HITTYPE_CERTAIN']&&_0x294e3e[_0x5c2058(0x7fc)](/CERTAIN/i)){if(_0x5c2058(0xa70)==='CSQpZ')_0x390e77+=_0x57ef6c;else{if(_0x3a443f[_0x5c2058(0x905)](_0x1853ae))return![];}}else{if(_0x4e1428===Game_Action['HITTYPE_PHYSICAL']&&_0x294e3e['match'](/PHYS/i))'wcJOa'===_0x5c2058(0x5c9)?_0x390e77+=_0x57ef6c:this[_0x5c2058(0x277)]=[];else _0x4e1428===Game_Action[_0x5c2058(0xf0)]&&_0x294e3e['match'](/MAGIC/i)&&(_0x390e77+=_0x57ef6c);}}else _0x5b54ee['addState'](_0x552355);}}return _0x390e77;},Game_BattlerBase[_0x208a24(0xbd8)][_0x208a24(0x7cf)]=function(_0x5bc183){const _0x1566d1=_0x208a24;_0x5bc183=_0x5bc183[_0x1566d1(0x4d6)]()[_0x1566d1(0x446)]();const _0x3e16a0=VisuMZ[_0x1566d1(0x759)]['LifeStealRegExp'];for(const _0x1bf3a4 of this['traitObjects']()){if(!_0x1bf3a4)continue;const _0x251208=_0x1bf3a4['note']||'';if(_0x251208[_0x1566d1(0x7fc)](_0x3e16a0[_0x1566d1(0x2d4)]))return!![];if(_0x5bc183==='HP'&&_0x251208['match'](_0x3e16a0[_0x1566d1(0x5d4)]))return!![];if(_0x5bc183==='MP'&&_0x251208[_0x1566d1(0x7fc)](_0x3e16a0[_0x1566d1(0xc1a)]))return!![];}return![];},Game_BattlerBase[_0x208a24(0xbd8)]['isNegativeLifeSteal']=function(_0x47c145){const _0x43a6fa=_0x208a24;_0x47c145=_0x47c145[_0x43a6fa(0x4d6)]()[_0x43a6fa(0x446)]();const _0x12f4a2=VisuMZ['BattleCore'][_0x43a6fa(0x780)];for(const _0x44b6fc of this[_0x43a6fa(0x8ce)]()){if(!_0x44b6fc)continue;const _0x195253=_0x44b6fc['note']||'';if(_0x195253['match'](_0x12f4a2[_0x43a6fa(0xc95)]))return _0x43a6fa(0xec)===_0x43a6fa(0xec)?!![]:this['_distortionSprite']||this[_0x43a6fa(0x666)]||this;if(_0x47c145==='HP'&&_0x195253[_0x43a6fa(0x7fc)](_0x12f4a2[_0x43a6fa(0xc33)]))return!![];if(_0x47c145==='MP'&&_0x195253[_0x43a6fa(0x7fc)](_0x12f4a2['negativeMpLifeSteal']))return!![];}return![];},Game_BattlerBase[_0x208a24(0xbd8)][_0x208a24(0xade)]=function(_0x213230){const _0x177432=_0x208a24;_0x213230=_0x213230[_0x177432(0x4d6)]()[_0x177432(0x446)]();const _0x3f85bd=VisuMZ[_0x177432(0x759)][_0x177432(0x780)];for(const _0x384df3 of this[_0x177432(0x8ce)]()){if(_0x177432(0x321)===_0x177432(0x321)){if(!_0x384df3)continue;const _0x154d07=_0x384df3[_0x177432(0x6c4)]||'';if(_0x154d07[_0x177432(0x7fc)](_0x3f85bd[_0x177432(0x6ff)]))return!![];if(_0x213230==='HP'&&_0x154d07[_0x177432(0x7fc)](_0x3f85bd[_0x177432(0xd2b)]))return!![];if(_0x213230==='MP'&&_0x154d07[_0x177432(0x7fc)](_0x3f85bd[_0x177432(0x5ee)]))return!![];}else{const _0x5b7d68=_0xffb5ec['inputtingAction']();if(_0x5b7d68)_0x5b7d68[_0x177432(0x8e9)](_0x177432(0x330));this[_0x177432(0x651)]();}}return![];},VisuMZ[_0x208a24(0x759)][_0x208a24(0xaf)]=Game_BattlerBase[_0x208a24(0xbd8)]['initMembers'],Game_BattlerBase[_0x208a24(0xbd8)][_0x208a24(0xa17)]=function(){const _0x343c81=_0x208a24;VisuMZ[_0x343c81(0x759)][_0x343c81(0xaf)]['call'](this),this[_0x343c81(0x41c)]();},Game_BattlerBase[_0x208a24(0xbd8)][_0x208a24(0x41c)]=function(){const _0x578bec=_0x208a24;this[_0x578bec(0x2bc)]=![];},VisuMZ[_0x208a24(0x759)]['Game_BattlerBase_refresh']=Game_BattlerBase[_0x208a24(0xbd8)]['refresh'],Game_BattlerBase['prototype'][_0x208a24(0xa22)]=function(){const _0x21d5f0=_0x208a24;this[_0x21d5f0(0x3b0)]={},VisuMZ['BattleCore'][_0x21d5f0(0x7e5)][_0x21d5f0(0x783)](this);},Game_BattlerBase[_0x208a24(0xbd8)]['checkCacheKey']=function(_0x377cc5){const _0x344571=_0x208a24;return this[_0x344571(0x3b0)]=this[_0x344571(0x3b0)]||{},this[_0x344571(0x3b0)][_0x377cc5]!==undefined;},Game_Bat